﻿Imports System.IO
Imports System.Xml.Serialization
Public Class frmPieu_Terrain_Pressio
    Dim Fichier_NotedeCalcul As String = String.Empty
    Private Sub Tc1_SelectedIndexChanged(sender As Object, e As EventArgs) Handles TC1.SelectedIndexChanged
        Select Case TC1.SelectedIndex
            Case 0 'Onglet caractéristique du pieu
                TxtPieuNom.Focus()
            Case 1 ' onglet sondages pressiométriques
                Select Case Aff.ModeleCalcul
                    Case 1 'Procédure Modèle terrain + valeurs caractéristiques

                    Case 2 'Procédure Modèle terrain +  sondage 5 m

                    Case 3 'Procédure Pieu Modèle

                        If SondagesPressio.Count = 0 Then
                            CbSondages.Items.Clear()
                            CbSondages.Items.Insert(0, "Sondage n°1")
                            CbSondages.Text = CbSondages.Items(0).ToString()
                        Else
                            CbSondages.Text = CbSondages.Items(0).ToString()

                        End If

                        CbSondages.Focus()
                End Select


        End Select
    End Sub

    Private Sub TC1_Enter(sender As Object, e As EventArgs) Handles TC1.Enter
        TxtPieuNom.Focus()
    End Sub

    Private Sub Tc1_Deselecting(sender As Object, e As TabControlCancelEventArgs) Handles TC1.Deselecting

        Select Case e.TabPageIndex
            Case 0 'Onglet 1 caractéristiques du pieu

            Case 1 'Onglet 2 Procédure Pieu Modèle

            Case 2 'Onglet 3 Procédure Modèle terrain

        End Select
    End Sub

    Private Sub BtnCalcul_Click(sender As Object, e As EventArgs) Handles BtnCalcul.Click
        Dim Verif As Boolean = True
        Dim Note_de_Calcul As String = String.Empty
        'writer de sortie du RTF
        Dim sw As New System.IO.StringWriter
        'crée un writer de RTF avec une police par défaut
        Dim rtf As New To_Rtf.RtfAnsiTextWriter(sw, New Font(FontFamily.GenericSerif, 12, FontStyle.Regular))
        Dim rtff As String
        Fichier_NotedeCalcul = String.Empty
        Try
            Call Lecture_Donnees(Verif)
            If Verif = False Then MessageBox.Show("Erreur dans les données. La séquence de calcul ne peut être lancée." & Environment.NewLine & "Merci de bien vouloir apporter les corrections nécessaires.", Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Error, MessageBoxDefaultButton.Button1) : Exit Sub
        Catch ex As Exception
            MessageBox.Show("Erreur inattendue lors de la lecture des données de calcul " & Environment.NewLine & ex.Message & Environment.NewLine & ex.StackTrace, Me.Text,
                                    MessageBoxButtons.OK, MessageBoxIcon.Error, MessageBoxDefaultButton.Button1)
        End Try
        Try
            Call Coherence_donnees(Verif)
            If Verif = False Then Exit Sub
            '  Aff.msg_Avertiss.Clear() 'remise à zéro de tous les avertissements qui figurent dans la note de calcul
            Call General.Pieux_Ecriture_Hypothese_Note_de_calcul(rtf)
            Select Case Aff.ModeleCalcul
                Case 1, 2 'Procédure Modèle terrain
                    Call Calcul_Pieu_Portance_ModeleTerrain_Pressiometrique(rtf, Verif)
                Case 3 'Procédure Pieu Modèle
                    Call Calcul_Pieu_Portance_PieuModele_Pressiometrique(rtf, Verif)
            End Select
            'si erreur sur note de calcul, pas d'affichage de cette dernière
            If Verif = False Then Exit Sub
        Catch ex As Exception
            MessageBox.Show("Erreur inattendue lors du calcul de la portance par le modèle de terrain et essais pressiométrique" & Environment.NewLine & ex.Message & Environment.NewLine & ex.StackTrace, Me.Text,
                                    MessageBoxButtons.OK, MessageBoxIcon.Error, MessageBoxDefaultButton.Button1)
        End Try
        Try
            'génère le RTF complet
            Note_de_Calcul = "Pieux_" & Mise_en_Forme_date(CStr(DateTime.Now)) & ".rtf"
            Fichier_NotedeCalcul = Aff.msgResult & "\" & Note_de_Calcul
            rtf.Generate() : rtff = sw.ToString : File.WriteAllText(Fichier_NotedeCalcul, rtff)
            If Aff.msg_Avertiss.Count = 0 Then
                MessageBox.Show("Calcul terminé !", "Logiciel Mecasol : Calcul de portance de pieux par la méthode pressiométrique", MessageBoxButtons.OK, MessageBoxIcon.Information)
            Else
                MessageBox.Show("Calcul terminé !" & Environment.NewLine & "Attention: voir les avertissements.", "Logiciel Mecasol : Calcul de portance de pieux par la méthode pressiométrique", MessageBoxButtons.OK, MessageBoxIcon.Warning)
            End If
        Catch ex As Exception
            MessageBox.Show("Erreur inattendue lors de l'édition de la note de calcul " & Environment.NewLine & ex.Message & Environment.NewLine & ex.StackTrace, Me.Text,
                            MessageBoxButtons.OK, MessageBoxIcon.Error, MessageBoxDefaultButton.Button1)
        End Try
        Try
            Select Case Aff.Editeur
                Case 1 'Editeur Interne
                    Dim frm1 As New Editeur.frmEdit
                    frm1.Affichage_frmEdit(Fichier_NotedeCalcul)
                Case 2 'éditeur WordPad
                    Dim SousDossier1 As String = My.Application.Info.DirectoryPath 'répertoire dans lequel se trouve le logiciel MecaSol
                    Dim startInfo As New ProcessStartInfo("wordpad.exe") '("word.exe")
                    startInfo.WindowStyle = ProcessWindowStyle.Normal
                    startInfo.Arguments = Fichier_NotedeCalcul
                    Process.Start(startInfo.Arguments)
                Case 3 'éditeur Word
                    Dim SousDossier1 As String = My.Application.Info.DirectoryPath 'répertoire dans lequel se trouve le logiciel MecaSol
                    Dim startInfo As New ProcessStartInfo("word.exe") '("word.exe")
                    startInfo.WindowStyle = ProcessWindowStyle.Normal
                    startInfo.Arguments = Fichier_NotedeCalcul
                    Process.Start(startInfo.Arguments)
            End Select
            BtnNotedeCalcul.Visible = True
        Catch ex As Exception
            Dim msg As String
            msg = "Impossible d'afficher la note de calcul" & Environment.NewLine & "Exception: " & ex.Message & ex.StackTrace
            MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End Try
    End Sub

    Private Sub BtnNotedeCalcul_Click(sender As Object, e As EventArgs) Handles BtnNotedeCalcul.Click
        Try
            Select Case Aff.Editeur
                Case 1 'Editeur Interne
                    Dim frm1 As New Editeur.frmEdit
                    frm1.Affichage_frmEdit(Fichier_NotedeCalcul)
                Case 2 'éditeur WordPad
                    Dim SousDossier1 As String = My.Application.Info.DirectoryPath 'répertoire dans lequel se trouve le logiciel MecaSol
                    Dim startInfo As New ProcessStartInfo("wordpad.exe") '("word.exe")
                    startInfo.WindowStyle = ProcessWindowStyle.Normal
                    startInfo.Arguments = Fichier_NotedeCalcul
                    Process.Start(startInfo.Arguments)
                Case 3 'éditeur Word
                    Dim SousDossier1 As String = My.Application.Info.DirectoryPath 'répertoire dans lequel se trouve le logiciel MecaSol
                    Dim startInfo As New ProcessStartInfo("word.exe") '("word.exe")
                    startInfo.WindowStyle = ProcessWindowStyle.Normal
                    startInfo.Arguments = Fichier_NotedeCalcul
                    Process.Start(startInfo.Arguments)
            End Select

        Catch ex As Exception
            Dim msg As String
            msg = "Impossible d'afficher la note de calcul" & Environment.NewLine & "Exception: " & ex.Message & ex.StackTrace
            MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End Try
    End Sub

    ''' <summary>Lecture des données renseignées</summary>
    ''' <param name="Verif">renvoie FALSE si erreur</param>
    Private Sub Lecture_Donnees(ByRef Verif As Boolean)
        With Pieux
            .Nom = TxtPieuNom.Text
            'côtes
            If RbtnCoteNGF.Checked = True Then
                .CotesNGF = True
                If gestionderreur(TxtCoteTerrainNaturel, EP1) = True Then .CoteTN = CDbl(TxtCoteTerrainNaturel.Text) Else Verif = False
            Else
                .CotesNGF = False
                .CoteTN = 0 'mise à 0 de la valeur
            End If
            If gestionderreur(txtCoteTete, EP1) = True Then .CoteTete = CDbl(txtCoteTete.Text) Else Verif = False
            If gestionderreur(txtCotePointe, EP1) = True Then .CotePointe = CDbl(txtCotePointe.Text) Else Verif = False

            Select Case CbPieuType.SelectedIndex
                Case 0
                    .Classe = 1 : .Categorie = 1 : .Abreviation = "FS"
                Case 1
                    .Classe = 1 : .Categorie = 2 : .Abreviation = "FB"
                Case 2
                    .Classe = 1 : .Categorie = 3 : .Abreviation = "FTP"
                Case 3
                    .Classe = 1 : .Categorie = 4 : .Abreviation = "FTR"
                Case 4
                    .Classe = 1 : .Categorie = 5 : .Abreviation = "FSR"
                Case 5
                    .Classe = 1 : .Categorie = 5 : .Abreviation = "FBR"
                Case 6
                    .Classe = 1 : .Categorie = 5 : .Abreviation = "PU"
                Case 7
                    .Classe = 2 : .Categorie = 6 : .Abreviation = "FTC"
                Case 8
                    .Classe = 2 : .Categorie = 6 : .Abreviation = "FTCD"
                Case 9
                    .Classe = 3 : .Categorie = 7 : .Abreviation = "VM"
                Case 10
                    .Classe = 3 : .Categorie = 8 : .Abreviation = "VT"
                Case 11
                    .Classe = 4 : .Categorie = 9 : .Abreviation = "BPF"
                Case 12
                    .Classe = 4 : .Categorie = 9 : .Abreviation = "BPR"
                Case 13
                    .Classe = 4 : .Categorie = 10 : .Abreviation = "BE"
                Case 14
                    .Classe = 4 : .Categorie = 11 : .Abreviation = "BM"
                Case 15
                    .Classe = 4 : .Categorie = 12 : .Abreviation = "BAF"
                Case 16
                    .Classe = 5 : .Categorie = 13 : .Abreviation = "BAO"
                Case 17
                    .Classe = 6 : .Categorie = 14 : .Abreviation = "HB"
                Case 18
                    .Classe = 6 : .Categorie = 15 : .Abreviation = "HBi"
                Case 19
                    .Classe = 7 : .Categorie = 16 : .Abreviation = "PP"
                Case 20
                    .Classe = 1 : .Categorie = 17 : .Abreviation = "M1"
                Case 21
                    .Classe = 1 : .Categorie = 18 : .Abreviation = "M2"
                Case 22
                    .Classe = 8 : .Categorie = 19 : .Abreviation = "PIGU"
                Case 23
                    .Classe = 8 : .Categorie = 19 : .Abreviation = "MIGU"
                Case 24
                    .Classe = 8 : .Categorie = 20 : .Abreviation = "PIRS"
                Case 25
                    .Classe = 8 : .Categorie = 20 : .Abreviation = "MIRS"
            End Select

            Select Case .Categorie
                Case 1, 2, 5
                    Select Case CbPieuGeometrie.SelectedIndex
                        Case 0 'circulaire
                            .Geom = 1
                            If gestionderreur(TxtPieuDiam, EP1) = True Then .Ø = CDbl(TxtPieuDiam.Text) / 100 Else Verif = False
                        Case 1 'rectangulaire
                            .Geom = 2
                            If gestionderreur(TxtPieuDiam, EP1) = True Then .W = CDbl(TxtPieuDiam.Text) / 100 Else Verif = False
                            If gestionderreur(TxtForageLongueur, EP1) = True Then .L = CDbl(TxtForageLongueur.Text) / 100 Else Verif = False
                        Case 2 'rectangulaire arrondi
                            .Geom = 3
                            If gestionderreur(TxtPieuDiam, EP1) = True Then .W = CDbl(TxtPieuDiam.Text) / 100 Else Verif = False
                            If gestionderreur(TxtForageLongueur, EP1) = True Then .L = CDbl(TxtForageLongueur.Text) / 100 Else Verif = False
                    End Select
                    If .Categorie < 3 Or (.Categorie = 5 And (.Abreviation = "FSR" Or .Abreviation = "FBR") = True) Then
                        If ChkbAbatGrandeLongueur.Checked = True Then .AbattementGrandeLongueur = True Else .AbattementGrandeLongueur = False
                    End If
                Case 3, 4, 6, 11, 17 To 20 'circulaire uniquement
                    .Geom = 1
                    If gestionderreur(TxtPieuDiam, EP1) = True Then .Ø = CDbl(TxtPieuDiam.Text) / 100 Else Verif = False
                    If .Categorie = 17 OrElse .Categorie = 18 Then
                        If CbPieuCat1718.SelectedIndex <= 15 Then
                            .CategorieAssimil = CbPieuCat1718.SelectedIndex + 1
                        ElseIf CbPieuCat1718.SelectedIndex = 16 Then
                            .CategorieAssimil = 19
                        Else
                            .CategorieAssimil = 20
                        End If
                    End If
                    'Clause de la prise en compte de la résistance de pointe pour les micropieux
                    If .Categorie > 16 Then
                        If ChkbResistancePointe.Checked = True Then .AucuneResistancedePointe = False Else .AucuneResistancedePointe = True
                    End If
                Case 7 'Vissé moulé = Fût avec hélice ordinaire ou  épaisse
                    Select Case CbPieuGeometrie.SelectedIndex
                        Case 0 'Fût avec hélice ordinaire
                            .Geom = 1
                        Case 1 'Fût avec hélice épaisse
                            .Geom = 2
                    End Select
                    If gestionderreur(TxtPieuDiam, EP1) = True Then .Bc = CDbl(TxtPieuDiam.Text) / 100 Else Verif = False
                    If gestionderreur(TxtForageLongueur, EP1) = True Then .Bf = CDbl(TxtForageLongueur.Text) / 100 Else Verif = False
                    If gestionderreur(txtDim3, EP1) = True Then .R = CDbl(txtDim3.Text) / 100 Else Verif = False
                    If gestionderreur(txtDim4, EP1) = True Then .Df = CDbl(txtDim4.Text) / 100 Else Verif = False
                Case 8 'Vissé tubé
                    .Geom = 1
                    If gestionderreur(TxtPieuDiam, EP1) = True Then .Øoutil = CDbl(TxtPieuDiam.Text) / 100 Else Verif = False
                    If gestionderreur(TxtForageLongueur, EP1) = True Then .Øfut = CDbl(TxtForageLongueur.Text) / 100 Else Verif = False
                Case 9 'Battu béton préfabriqué et Battu béton précontraint
                    Select Case CbPieuGeometrie.SelectedIndex
                        Case 0 'circulaire
                            .Geom = 1
                            If gestionderreur(TxtPieuDiam, EP1) = True Then .Ø = CDbl(TxtPieuDiam.Text) / 100 Else Verif = False
                        Case 1 'rectangulaire
                            .Geom = 2
                            If gestionderreur(TxtPieuDiam, EP1) = True Then .W = CDbl(TxtPieuDiam.Text) / 100 Else Verif = False
                            If gestionderreur(TxtForageLongueur, EP1) = True Then .L = CDbl(TxtForageLongueur.Text) / 100 Else Verif = False
                    End Select
                Case 10 'pieux métallique battus enrobés
                    .Geom = 1
                    If gestionderreur(TxtPieuDiam, EP1) = True Then .Ab = CDbl(TxtPieuDiam.Text) / 10000 Else Verif = False
                    If gestionderreur(TxtForageLongueur, EP1) = True Then .Ps = CDbl(TxtForageLongueur.Text) / 100 Else Verif = False
                    If gestionderreur(txtDim3, EP1) = True Then .Bmin = CDbl(txtDim3.Text) / 100 Else Verif = False
                Case 12, 13 'pieux battus caisson acier fermé (BAF) ou battus acier ouvert (BAO)
                    Select Case CbPieuGeometrie.SelectedIndex
                        Case 0 'circulaire
                            .Geom = 1
                            If gestionderreur(TxtPieuDiam, EP1) = True Then .Ø = CDbl(TxtPieuDiam.Text) / 100 Else Verif = False
                        Case 1 'caisson palplanche
                            .Geom = 4
                            If gestionderreur(TxtPieuDiam, EP1) = True Then .Ab = CDbl(TxtPieuDiam.Text) / 10000 Else Verif = False
                            If gestionderreur(TxtForageLongueur, EP1) = True Then .Ps = CDbl(TxtForageLongueur.Text) / 100 Else Verif = False
                            If gestionderreur(txtDim3, EP1) = True Then .Bmin = CDbl(txtDim3.Text) / 100 Else Verif = False
                    End Select
                    'Clause Vibrofonçage - pieu BAO
                    If .Categorie = 13 AndAlso ChkbVibrofoncage.Checked = True Then .Vibrofoncage = True Else .Vibrofoncage = False
                Case 14, 15 'pieux métallique profilé H, et H injecté
                    .Geom = 1
                    If gestionderreur(TxtPieuDiam, EP1) = True Then .b = CDbl(TxtPieuDiam.Text) / 100 Else Verif = False
                    If gestionderreur(TxtForageLongueur, EP1) = True Then .h = CDbl(TxtForageLongueur.Text) / 100 Else Verif = False
                    'Clause Vibrofonçage - Pieu HB
                    If .Categorie = 14 AndAlso ChkbVibrofoncage.Checked = True Then .Vibrofoncage = True Else .Vibrofoncage = False
                Case 16 'palplanche
                    .Geom = 1
                    If gestionderreur(TxtPieuDiam, EP1) = True Then .Ab = CDbl(TxtPieuDiam.Text) / 10000 Else Verif = False
                    If gestionderreur(TxtForageLongueur, EP1) = True Then .Ps = CDbl(TxtForageLongueur.Text) / 100 Else Verif = False
                    If gestionderreur(txtDim3, EP1) = True Then .Bmin = CDbl(txtDim3.Text) / 100 Else Verif = False
                    'Clause Vibrofonçage
                    If ChkbVibrofoncage.Checked = True Then .Vibrofoncage = True Else .Vibrofoncage = False
            End Select

            'Effet de groupe
            If RbtnEffetGroupeSansObjet.Checked = True Then
                .EffetGroupe = False
                .ef_Gr_mx = 0 : .ef_Gr_nx = 0 : .ef_Gr_dx = 0 : .ef_Gr_my = 0 : .ef_Gr_ny = 0 : .ef_Gr_dy = 0
            Else
                .EffetGroupe = True
                If gestionderreur(TxtEffetGroupemx, EP1) = True Then .ef_Gr_mx = CInt(TxtEffetGroupemx.Text) Else Verif = False
                If gestionderreur(TxtEffetGroupenx, EP1) = True Then .ef_Gr_nx = CInt(TxtEffetGroupenx.Text) Else Verif = False
                If gestionderreur(TxtEffetGroupeDx, EP1) = True Then .ef_Gr_dx = CDbl(TxtEffetGroupeDx.Text) Else Verif = False
                If ChkbEffetGroupe1ligne.Checked = False Then
                    If gestionderreur(TxtEffetGroupemy, EP1) = True Then .ef_Gr_my = CInt(TxtEffetGroupemy.Text) Else Verif = False
                    If gestionderreur(TxtEffetGroupeny, EP1) = True Then .ef_Gr_ny = CInt(TxtEffetGroupeny.Text) Else Verif = False
                    If gestionderreur(TxtEffetGroupedy, EP1) = True Then .ef_Gr_dy = CDbl(TxtEffetGroupedy.Text) Else Verif = False
                Else
                    .ef_Gr_my = 0 : .ef_Gr_ny = 0 : .ef_Gr_dy = 0
                End If
            End If

        End With
        '
        'Lecture Onglet n°2
        Select Case Aff.ModeleCalcul
            Case 1 'Procédure Modèle terrain + val caractéristiques
                Call Lecture_LithologieModTerrain(Verif)
                If Verif = False Then Exit Sub
                With SondageModele
                    If ChkbPlmoyen.Checked = True Then .Plmoyen = True Else .Plmoyen = False
                    If RbtnNappeEauReconnue.Checked = True Then
                        .NappeEau = True
                        If gestionderreur(TxtZeauModTerrain, EP1) = True Then .Zeau = CDbl(TxtZeauModTerrain.Text) Else Verif = False
                    Else
                        .NappeEau = False : .Zeau = 1001
                    End If
                End With
                If ChkbTassementModTerrain.Checked = True Then Pieux.Tassement = True Else Pieux.Tassement = False
            Case 2 'Procédure Modèle terrain + sondage 5m
                Call Lecture_ValeurPressiometriqueModTerrain(Verif)
                If Verif = False Then Exit Sub
                Call Lecture_LithologieModTerrain(Verif)
                If Verif = False Then Exit Sub
                With SondageModele
                    If RbtnNappeEauReconnue.Checked = True Then
                        .NappeEau = True
                        If gestionderreur(TxtZeauModTerrain, EP1) = True Then .Zeau = CDbl(TxtZeauModTerrain.Text) Else Verif = False
                    Else
                        .NappeEau = False : .Zeau = 1001
                    End If
                End With
                If ChkbTassementModTerrain.Checked = True Then Pieux.Tassement = True Else Pieux.Tassement = False
            Case 3 'Procédure Pieu Modèle
                If gestionderreur(TxtZhomoLongueur, EP1) = True Then Aff.SurfInvestGeotechLongueur = CInt(TxtZhomoLongueur.Text) Else Verif = False
                If gestionderreur(TxtZhomoLargeur, EP1) = True Then Aff.SurfInvestGeotechLargeur = CInt(TxtZhomoLargeur.Text) Else Verif = False
                If ChkbTassementModPieuModele.Checked = True Then Pieux.Tassement = True Else Pieux.Tassement = False
                With SondagesPressio
                    Dim i As Integer 'i = n° de sondage
                    i = CbSondages.SelectedIndex + 1 '= n° de sondage sélectionné
                    Call Lecture_ValeurPressiometriquePieuModele(i, Verif)
                    If Verif = False Then Exit Sub
                    Call Lecture_LithologiePieuModele(i, Verif)
                    If Verif = False Then Exit Sub
                    If RbtnNappeEauReconnuePM.Checked = True Then
                        .Item(i - 1).NappeEau = True
                        If gestionderreur(txtZeauModPieuModele, EP1) = True Then .Item(i - 1).Zeau = CDbl(txtZeauModPieuModele.Text) Else Verif = False
                    Else
                        .Item(i - 1).NappeEau = False : .Item(i - 1).Zeau = 1001
                    End If
                End With
        End Select

    End Sub


    ''' <summary>Vérification de la cohérence des données renseignées</summary>
    ''' <param name="Verif">renvoie FALSE si erreur</param>
    Private Sub Coherence_donnees(ByRef Verif As Boolean)
        Dim msg As String = String.Empty
        Dim msg1 As String = String.Empty
        Dim Modif As Boolean = False
        With Pieux
            'cotes
            If .CotesNGF = True Then
                If .CotePointe >= .CoteTete Then
                    msg = "Côtes du pieu en valeurs NGF : " & Environment.NewLine & "La côte de la pointe du pieu (= " & .CotePointe.ToString("#0.00") & " m) ne doit pas être supérieure ou égale à la côte de la tête de pieu (= " & .CoteTete.ToString("#0.00") & " m). " & Environment.NewLine : Verif = False
                End If
                If .CoteTN > .CoteTete Then
                    msg += "Côtes du pieu en valeurs NGF : " & Environment.NewLine & "La côte du terrain naturel (= " & .CoteTN.ToString("#0.00") & " m) ne doit pas être supérieure à la côte de la tête de pieu (= " & .CoteTete.ToString("#0.00") & " m). " & Environment.NewLine : Verif = False
                End If
                If .CotePointe >= .CoteTN Then
                    msg += "Côtes du pieu en valeurs NGF : " & Environment.NewLine & "La côte de la pointe du pieu (= " & .CotePointe.ToString("#0.00") & " m) ne doit pas être supérieure ou égale à la côte du terrain naturel (= " & .CoteTN.ToString("#0.00") & " m). " & Environment.NewLine : Verif = False
                End If
            End If

            .Geometrie()  'Détermination des caractéristiques mécaniques du pieu, sa classe, ...
            'diamètre et profondeur d'ancrage
            If .D < 5 * .Ø Then msg += "La profondeur du pieu doit être supérieure à 5 fois son diamètre." & Environment.NewLine : Verif = False
            If .EffetGroupe = True AndAlso .ef_Gr_dx > 3 * .Bmin Then
                'je peux considérer ceci comme un avertissement
                Dim msg2 As String = String.Empty
                msg2 = "Un effet de groupe a été indiqué alors que la distance entre pieux (= " & Pieux.ef_Gr_dx.ToString("#0.00") & " m) est supérieure à 3 fois le diamètre. Aucun effet de groupe ne sera calculé. " & Environment.NewLine
                Aff.msg_Avertiss.Add(msg2)
            End If

            Select Case Aff.ModeleCalcul
                Case 1, 2 'Procédure Modèle terrain
                    SondageModele.Caracteristique_Sondage()
                    '--> Vérification de la reconnaissance des 5m en dessous de la pointe du pieu dans la couche porteuse
                    Call Verif_Encastrement(Verif, msg, 0, SondageModele.Lithologie.Item(SondageModele.Lithologie.Count - 1).Zbase - Pieux.D, SondageModele.Lithologie.Item(SondageModele.Lithologie.Count - 1).Zbase)
                Case 3 'Procédure Pieu Modèle
                    For i = 0 To SondagesPressio.Count - 1
                        SondagesPressio.Item(i).Caracteristique_Sondage()
                        '--> Vérification de la reconnaissance des 5m en dessous de la pointe du pieu dans la couche porteuse
                        Call Verif_Encastrement(Verif, msg, i + 1, SondagesPressio.Item(i).Lithologie.Item(SondagesPressio.Item(i).Lithologie.Count - 1).Zbase - Pieux.D,
                                                SondagesPressio.Item(i).Lithologie.Item(SondagesPressio.Item(i).Lithologie.Count - 1).Zbase)
                    Next
                    ''--> test sur la hauteur d'encastrement effectif dans la couche porteuse
                    'msg = "L'encastrement effectif dans la couche porteuse est pris égal à 3 diamètres ou 1,50m pour les pieux de diamètre supérieur à 0,50m. Si l'entreprise de fondation spéciale peut garantir la bonne exécution de l'encastrement " &
                    ' "de la pointe des pieux dans la couche porteuse, l'ancrage peut être réduit à une valeur minimale de 0,50m (Note 1 - §F4.2.(4) de la NF P94-262 - 2013)."
                    'Aff.msg_Avertiss.Add(msg)

            End Select

            'une entrée de donnée est incohérente et doit être corrigée car le module Geometrie va être inopérant
            If Verif = False Then
                msg += "Merci de faire les corrections nécessaires pour permettre de démarrer le calcul."
                MessageBox.Show(msg, "Module de vérification de cohérence des données", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1) : Exit Sub
            End If

        End With
        If Aff.ModeleCalcul < 1 Or Aff.ModeleCalcul > 3 Then
            msg += "Le modèle de calcul n'a pas été défini." & Environment.NewLine : Verif = False
        End If
        Select Case Aff.ModeleCalcul
            Case 1, 2 'Modèle de terrain
                For Each z In SondageModele.Lithologie
                    If z.Zbase < z.Ztoit Then
                        msg += "Couche n°" & (SondageModele.Lithologie.IndexOf(z) + 1).ToString & ": la profondeur de la base de la couche ( = " & z.Zbase.ToString("#0.00") & " m < à la profondeur du toit de la couche ( = " &
                            z.Ztoit.ToString("#0.00") & " m " & Environment.NewLine : Verif = False
                    End If
                Next
                If Verif = False Then MessageBox.Show(msg, "Module de vérification de cohérence des données", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1) : Exit Sub
                SondageModele.Caracteristique_Sondage()
                If Pieux.D > SondageModele.Htotal Then
                    msg += "La profondeur d'assise du pieu (=" & Pieux.D.ToString("#0.00") & " m) est supérieure ou égale à la hauteur totale des couches de terrain (=" & SondageModele.Htotal.ToString("#0.00") & " m). " &
                        Environment.NewLine : Verif = False
                End If
            Case 3 'Pieu modèle
                'le présent calcul est effectué pour le sondage pressiométrique correspondant au n° d'index indexSondage
                For i = 0 To SondagesPressio.Count - 1
                    If Pieux.D > SondagesPressio.Item(i).Htotal Then
                        msg += "La profondeur d'assise du pieu (=" & Pieux.D.ToString("#0.00") & " m) est supérieure ou égale à la hauteur totale des couches de terrain (=" & SondagesPressio.Item(i).Htotal.ToString("#0.00") & " m). " &
                            Environment.NewLine : Verif = False
                        Exit For
                    End If
                Next

        End Select


        'une modification a été apportée aux valeurs renseignées par le projeteur et cette modification est portée à la connaissance du projeteur.
        If Modif = True Then
            MessageBox.Show(msg1, "Module de vérification de cohérence des données", MessageBoxButtons.OK, MessageBoxIcon.Information, MessageBoxDefaultButton.Button1)
        End If
        'une entrée de donnée est incohérente et doit être corrigée
        If Verif = False Then
            msg += "Merci de faire les corrections nécessaires pour permettre de démarrer le calcul."
            MessageBox.Show(msg, "Module de vérification de cohérence des données", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
        End If
    End Sub

    ''' <summary>Module de vérification de l'encastrement</summary>
    ''' <param name="a"> a = SondageModele.Lithologie.Item(SondageModele.Lithologie.Count - 1).Zbase - Pieux.D</param>
    ''' <param name="b"> b = SondageModele.Lithologie.Item(SondageModele.Lithologie.Count - 1).Zbase</param>
    Private Sub Verif_Encastrement(ByRef Verif As Boolean, ByRef msg As String, Optional ByVal Ind As Integer = 0, Optional ByVal a As Double = 10, Optional ByVal b As Double = 10)
        Dim Sond As New clsSondagePressio
        If Ind = 0 Then Sond = SondageModele Else Sond = SondagesPressio.Item(Ind - 1)
        With Pieux
            If Verif = True Then
                'je peux considérer ceci comme un avertissement pour ne pas bloquer la suite du calcul
                '--> Vérification d'une hauteur minimale de 5m sous la pointe du pieu
                If a < 5 Then
                    Dim msg2 As String = String.Empty
                    msg2 = "La profondeur de reconnaissance du sol (= " & b.ToString("#0.00") &
                           " m) est insuffisante par rapport à la profondeur d'encastrement du pieu (= " & Pieux.D.ToString("#0.00") & " m)." & Environment.NewLine &
                           "La reconnaissance doit être portée au dela des 5m en dessous de la côte de la pointe du pieu. Or, dans notre cas, elle est de " & a.ToString("#0.00") & " m." & Environment.NewLine &
                            "Voulez-vous continuer le calcul avec cette valeur d'encastrement (Réponse = OUI), cela génèrera un avertissement dans la note de calcul ou alors " &
                             "modifier la valeur d'encastrement (Réponse = NON), cela arrêtera le calcul pour vous permettre de modifier la valeur de la fiche du pieu."
                    Dim result As Integer
                    result = MessageBox.Show(msg2, "Module de vérification de cohérence des données", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
                    If result = 6 Then 'Yes a été cliqué, le calcul continue
                        msg2 = "La reconnaissance de sol sous la pointe du pieu est insuffisante (= " & a.ToString("#0.00") & " < 5 m requis)  m - Risque d'une discontinuité sous le pieu non reconnue." & Environment.NewLine
                        Aff.msg_Avertiss.Add(msg2)
                    Else
                        msg += "La reconnaissance de sol sous la pointe du pieu est insuffisante (= " & a.ToString("#0.00") &
                               " < 5 m requis)  m - Risque d'une discontinuité sous le pieu non reconnue." & Environment.NewLine : Verif = False
                    End If
                End If
                '--> Vérification d'un ancrage de 50 cm dans la couche de sol porteuse
                If .Verif_Encastrement_Pressio(Sond) = False Then
                    Dim msg2 As String = String.Empty
                    msg2 = "L'ancrage  dans la couche de sol porteuse, " & (.Hencastr * 100).ToString("#0") & " cm est insuffisant. Il doit être minimum de 50 cm." & Environment.NewLine &
                            "Voulez-vous continuer le calcul avec cette valeur d'ancrage (Réponse = OUI), cela génèrera un avertissement dans la note de calcul ou alors " &
                             "modifier la valeur d'ancrage (Réponse = NON), cela arrêtera le calcul pour vous permettre de modifier la valeur de la fiche du pieu."
                    Dim result As Integer
                    result = MessageBox.Show(msg2, "Module de vérification de cohérence des données", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
                    If result = 6 Then 'Yes a été cliqué, le calcul continue
                        msg2 = "L'ancrage  dans la couche de sol porteuse, " & (.Hencastr * 100).ToString("#0") & " cm est insuffisant. Il doit être minimum de 50 cm." & Environment.NewLine
                        Aff.msg_Avertiss.Add(msg2)
                    Else
                        msg += "L'ancrage  dans la couche de sol porteuse, " & (.Hencastr * 100).ToString("#0") & " cm est insuffisant. Il doit être minimum de 50 cm." & Environment.NewLine : Verif = False
                    End If
                End If
            Else
                'ajout du défaut de la reconnaissance de sol des 5m
                If a < 5 Then
                    msg += "La reconnaissance de sol sous la pointe du pieu est insuffisante (= " & a.ToString("#0.00") &
                                  " < 5 m requis)  m - Risque d'une discontinuité sous le pieu non reconnue." & Environment.NewLine
                End If
                '--> Vérification d'un ancrage de 50 cm dans la couche de sol porteuse
                If Pieux.Verif_Encastrement_Pressio(Sond) = False Then
                    msg += "L'ancrage  dans la couche de sol porteuse, " & (.Hencastr * 100).ToString("#0") & " cm est insuffisant. Il doit être minimum de 50 cm." & Environment.NewLine
                End If
            End If
        End With

    End Sub
    Private Sub Pieu_Terrain_Pressio_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        Me.TopMost = False
        Try
            'remise à zero générale
            Pieux = New clsPieux
            SondageModele = New clsSondagePressio
            SondagesPressio = New List(Of clsSondagePressio)
            With Aff
                .msg_Avertiss.Clear()
                .SurfInvestGeotechLargeur = 0
                .SurfInvestGeotechLongueur = 0
                'je conserve les autres données
            End With
            Me.Text = "Calcul de pieux suivant essais pressiométriques : [ aucun fichier de données ]"
            Call Initialisation_donnees_Pieux()
            Select Case Aff.ModeleCalcul

                Case 0 '1, 2 'Procédure Modèle de terrain + val caractéristiques'Procédure Modèle de terrain + sondage 5 m
                    TC1.TabPages.RemoveAt(1)
                    DgvCoucheModTerrain.Visible = False : DgvLithologieModTerrain.Visible = False

                Case 3 'Procédure Pieu Modèle
                    TC1.TabPages.RemoveAt(2)

            End Select
            TC1.SelectedIndex = 0

        Catch ex As Exception
            MessageBox.Show("Erreur lors du chargement du formulaire:" & Environment.NewLine & "Exception: " & ex.Message, "Formulaire ", MessageBoxButtons.OK, MessageBoxIcon.Information)
        End Try
    End Sub
    Private Sub Initialisation_donnees_Pieux()
        Dim t() As String = {"Foré simple", "Foré boue", "Foré tubé(virole perdue)", "Foré tubé(virole récupérée)", "Foré simple avec rainurage", "Foré boue avec rainurage", "Puit", "Foré tarière creuse simple rotation",
        "Foré tarière creuse double rotation", "Vissé moulé", "Vissé tubé", "Battu béton préfabriqué", "Battu béton précontraint", "métallique Battu enrobé (béton - mortier - coulis)", "métallique Battu moulé", "Battu caisson acier fermé",
        "Battu acier ouvert", "Profilé H battu", "Profilé H battu injecté", "Palplanche battues", "Micropieu Type I", "Micropieu Type II", "Pieu injecté mode IGU (type III)", "Micropieu injecté mode IGU (type III)",
        "Pieu injecté mode IRS (type IV)", "Micropieu injecté mode IRS (type IV)"}
        CbPieuType.DataSource = t
        Dim geo() As String = {"Circulaire", "Rectangulaire", "Rectangulaire arrondi"}
        CbPieuGeometrie.DataSource = geo
        Dim Cat() As Integer = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 19, 20}
        CbPieuCat1718.DataSource = Cat
    End Sub

    Private Sub AffichageInitial_Lithologie_PieuModele()
        DgvLithologie.Rows.Clear()
        DgvLithologie.RowCount = 1
    End Sub
    Private Sub RbtnCoteRelative_CheckedChanged(sender As Object, e As EventArgs) Handles RbtnCoteRelative.CheckedChanged
        If RbtnCoteRelative.Checked = True Then
            LblTerrainNaturel.Visible = False : lblTN_unite.Visible = False : TxtCoteTerrainNaturel.Visible = False
            txtCoteTete.Focus()
        End If
    End Sub
    Private Sub RbtnCoteRelative_Enter(sender As Object, e As EventArgs) Handles RbtnCoteRelative.Enter
        txtCoteTete.Focus()
    End Sub
    Private Sub RbtnCoteNGF_CheckedChanged(sender As Object, e As EventArgs) Handles RbtnCoteNGF.CheckedChanged
        If RbtnCoteNGF.Checked = True Then
            LblTerrainNaturel.Visible = True : lblTN_unite.Visible = True : TxtCoteTerrainNaturel.Visible = True
            ToolTip1.SetToolTip(Me.TxtCoteTerrainNaturel, "Vous devez indiquer la côte NGF du terrain naturel pour permettre au logiciel, de calculer la partie de pieu se trouvant au-dessus du sol.")
            TxtCoteTerrainNaturel.Focus()
        End If
    End Sub
    Private Sub CbPieuType_SelectedIndexChanged(sender As Object, e As EventArgs) Handles CbPieuType.SelectedIndexChanged
        'catégorie assimilée pour les micropieux de catégorie 17 et 18
        lblCategorieMicropieux.Visible = False
        CbPieuCat1718.Visible = False
        BtnHlpCatEquivMicropieu.Visible = False
        'Application de la clause des pieux de grande longueur
        ChkbAbatGrandeLongueur.Visible = False : BtnHlpAbbat50.Visible = False
        'Application de la clause des pieux vibrofoncés
        ChkbVibrofoncage.Visible = False : BtnHlpVibrofoncage.Visible = False
        'Application de la clause de résistance de pointe pour les micropieux
        ChkbResistancePointe.Visible = False : BtnHlpResistancePointe.Visible = False

        Select Case CbPieuType.SelectedIndex
            Case 0, 1, 4, 5, 6 '"Foré simple", "Foré boue" , "Foré simple avec rainurage", "Foré boue avec rainurage", "Puit"
                Dim geo() As String = {"Circulaire", "Rectangulaire", "Rectangulaire arrondi"}
                CbPieuGeometrie.DataSource = geo
                'Application de la clause des pieux de grande longueur
                If CbPieuType.SelectedIndex < 6 Then ChkbAbatGrandeLongueur.Visible = True : BtnHlpAbbat50.Visible = True
            Case 2, 3, 7, 8 '  "Foré tubé(virole perdue)", "Foré tubé(virole récupérée)", "Foré tarière creuse simple rotation","Foré tarière creuse double rotation",
                Dim geo() As String = {"Circulaire"}
                CbPieuGeometrie.DataSource = geo
            Case 9 'Vissé moulé
                Dim geo() As String = {"Fût avec hélice ordinaire", "Fût avec hélice épaisse"}
                CbPieuGeometrie.DataSource = geo
            Case 10 'Vissé tubé
                Dim geo() As String = {"Suivant diamètre de l'outil perdu et diamètre du tube"}
                CbPieuGeometrie.DataSource = geo
            Case 11 'Battu béton préfabriqué
                Dim geo() As String = {"Circulaire", "Rectangulaire"}
                CbPieuGeometrie.DataSource = geo
            Case 12 'Battu béton précontraint
                Dim geo() As String = {"Tubulaire"}
                CbPieuGeometrie.DataSource = geo
            Case 13  'Battu enrobé (béton - mortier - coulis)
                Dim geo() As String = {"Tubulaire", "Profilé H", "Caisson de Palplanches"}
                CbPieuGeometrie.DataSource = geo
            Case 14 'Battu moulé
                Dim geo() As String = {"Tubulaire"}
                CbPieuGeometrie.DataSource = geo
            Case 15, 16 'Battu acier fermé  /  Battu acier ouvert
                Dim geo() As String = {"Tubulaire", "Caisson de Palplanches"}
                CbPieuGeometrie.DataSource = geo
                If CbPieuType.SelectedIndex = 16 Then '= BAO
                    'Application de la clause du vibrofonçage pour les pieux de type BAO, HB et PP
                    ChkbVibrofoncage.Visible = True : BtnHlpVibrofoncage.Visible = True
                End If
            Case 17, 18 'Profilé H battu / Profilé H battu injecté
                Dim geo() As String = {"Profilé H"}
                CbPieuGeometrie.DataSource = geo
                If CbPieuType.SelectedIndex = 17 Then '= HB
                    'Application de la clause du vibrofonçage pour les pieux de type BAO, HB et PP
                    ChkbVibrofoncage.Visible = True : BtnHlpVibrofoncage.Visible = True
                End If
            Case 19 'Palplanche battues
                Dim geo() As String = {"Palplanche"}
                CbPieuGeometrie.DataSource = geo
                'Application de la clause du vibrofonçage pour les pieux de type BAO, HB et PP
                ChkbVibrofoncage.Visible = True : BtnHlpVibrofoncage.Visible = True
            Case 20 To 25 'Micropieux
                Dim geo() As String = {"Tubulaire"}
                CbPieuGeometrie.DataSource = geo
                If CbPieuType.SelectedIndex = 20 OrElse CbPieuType.SelectedIndex = 21 Then
                    'catégorie assimilée pour les micropieux de catégorie 17 et 18
                    lblCategorieMicropieux.Visible = True
                    CbPieuCat1718.Visible = True
                    BtnHlpCatEquivMicropieu.Visible = True
                End If
                'Application de la clause de résistance de pointe pour les micropieux
                ChkbResistancePointe.Visible = True : BtnHlpResistancePointe.Visible = True
                ChkbResistancePointe.Left = ChkbAbatGrandeLongueur.Location.X : BtnHlpResistancePointe.Left = ChkbResistancePointe.Location.X + ChkbResistancePointe.Width + BtnHlpResistancePointe.Margin.Left
        End Select
    End Sub
    Private Sub CbPieuCat1718_SelectedIndexChanged(sender As Object, e As EventArgs) Handles CbPieuCat1718.SelectedIndexChanged

    End Sub
    Private Sub CbPieuGeometrie_SelectedIndexChanged(sender As Object, e As EventArgs) Handles CbPieuGeometrie.SelectedIndexChanged
        Pb1.Visible = True

        Select Case CbPieuGeometrie.SelectedIndex
            Case 0 'Variable suivant le type de pieu profil = circulaire ou 1ier profil
                Select Case CbPieuType.SelectedIndex
                    Case 0, 1, 2, 3, 4, 5, 6, 7, 8 '= "Circulaire"
                        '"Foré simple", "Foré boue" , "Foré simple avec rainurage", "Foré boue avec rainurage", "Puit" 
                        '"Foré tubé(virole perdue)", "Foré tubé(virole récupérée)", "Foré tarière creuse simple rotation","Foré tarière creuse double rotation"  
                        lblPieuDiam.Text = "Diamètre du forage :" : lblPieuDiam.Left = TxtPieuDiam.Location.X - lblPieuDiam.Margin.Left - lblPieuDiam.Width
                        LblPieuLongueurSection.Visible = False : TxtForageLongueur.Visible = False : lblForageLongueur.Visible = False
                        LblDim3.Visible = False : txtDim3.Visible = False : LblDim3Unite.Visible = False : LblDim4.Visible = False : txtDim4.Visible = False : LblDim4Unite.Visible = False
                        Pb1.Image = My.Resources.Profil_circulaire
                        Pb1.Refresh()
                    Case 9 'Vissé moulé = Fût avec hélice ordinaire
                        lblPieuDiam.Text = "Diamètre nominal Bc :" : lblPieuDiam.Left = TxtPieuDiam.Location.X - lblPieuDiam.Margin.Left - lblPieuDiam.Width
                        LblPieuLongueurSection.Text = "Diamètre Bf :" : LblPieuLongueurSection.Left = TxtForageLongueur.Location.X - LblPieuLongueurSection.Margin.Left - LblPieuLongueurSection.Width
                        LblPieuLongueurSection.Visible = True : TxtForageLongueur.Visible = True : lblForageLongueur.Visible = True
                        LblDim3.Visible = True : txtDim3.Visible = True : LblDim3Unite.Visible = True : LblDim4.Visible = True : txtDim4.Visible = True : LblDim4Unite.Visible = True
                        Pb1.Image = My.Resources.Fut_helice_ordinaire
                        Pb1.Refresh()
                    Case 10 'Vissé tubé = "Circulaire avec 2 diamètres Suivant diamètre de l'outil perdu et diamètre du tube"
                        lblPieuDiam.Text = "Diamètre de l'outil perdu :" : lblPieuDiam.Left = TxtPieuDiam.Location.X - lblPieuDiam.Margin.Left - lblPieuDiam.Width
                        LblPieuLongueurSection.Text = "Diamètre du fût :" : LblPieuLongueurSection.Left = TxtForageLongueur.Location.X - LblPieuLongueurSection.Margin.Left - LblPieuLongueurSection.Width
                        LblPieuLongueurSection.Visible = True : TxtForageLongueur.Visible = True : lblForageLongueur.Visible = True
                        LblDim3.Visible = False : txtDim3.Visible = False : LblDim3Unite.Visible = False : LblDim4.Visible = False : txtDim4.Visible = False : LblDim4Unite.Visible = False
                        Pb1.Image = My.Resources.Profil_circulaire
                        Pb1.Refresh()
                    Case 11, 12 '= "Circulaire" - Battu béton préfabriqué et Battu béton précontraint
                        lblPieuDiam.Text = "Diamètre du forage :" : lblPieuDiam.Left = TxtPieuDiam.Location.X - lblPieuDiam.Margin.Left - lblPieuDiam.Width
                        LblPieuLongueurSection.Visible = False : TxtForageLongueur.Visible = False : lblForageLongueur.Visible = False
                        LblDim3.Visible = False : txtDim3.Visible = False : LblDim3Unite.Visible = False : LblDim4.Visible = False : txtDim4.Visible = False : LblDim4Unite.Visible = False
                        Pb1.Image = My.Resources.Profil_circulaire
                        Pb1.Refresh()
                    Case 13  'Battu enrobé (béton - mortier - coulis) = "Platine perdue" 
                        lblPieuDiam.Text = "Aire de la platine perdue :" : lblPieuDiam.Left = TxtPieuDiam.Location.X - lblPieuDiam.Margin.Left - lblPieuDiam.Width : lblPieuDiamUnite.Text = "cm²"
                        LblPieuLongueurSection.Text = "Périmètre de la platine perdue :" : LblPieuLongueurSection.Left = TxtForageLongueur.Location.X - LblPieuLongueurSection.Margin.Left - LblPieuLongueurSection.Width
                        LblPieuLongueurSection.Visible = True : TxtForageLongueur.Visible = True : lblForageLongueur.Visible = True
                        LblDim3.Visible = True : LblDim3.Text = "Valeur de la dimension transversale minimale - Bmin "
                        txtDim3.Visible = True : LblDim3.Text = "(cm)" : LblDim3Unite.Visible = True
                        LblDim4.Visible = True : LblDim4.Text = "Suivant article A10(3), prise en compte de l'aire et du périmètre de la platine perdue"
                        txtDim4.Visible = False : LblDim4Unite.Visible = False
                        Pb1.Visible = False
                        Pb1.Refresh()
                    Case 14 'Battu moulé = "Tubulaire" 
                        lblPieuDiam.Text = "Diamètre du forage :" : lblPieuDiam.Left = TxtPieuDiam.Location.X - lblPieuDiam.Margin.Left - lblPieuDiam.Width
                        LblPieuLongueurSection.Visible = False : TxtForageLongueur.Visible = False : lblForageLongueur.Visible = False
                        LblDim3.Visible = False : txtDim3.Visible = False : LblDim3Unite.Visible = False : LblDim4.Visible = False : txtDim4.Visible = False : LblDim4Unite.Visible = False
                        Pb1.Image = My.Resources.Profil_circulaire
                        Pb1.Refresh()
                    Case 15, 16 'Battu acier fermé  /  Battu acier ouvert = "Tubulaire" 
                        lblPieuDiam.Text = "Diamètre du forage :" : lblPieuDiam.Left = TxtPieuDiam.Location.X - lblPieuDiam.Margin.Left - lblPieuDiam.Width
                        LblPieuLongueurSection.Visible = False : TxtForageLongueur.Visible = False : lblForageLongueur.Visible = False
                        LblDim3.Visible = False : txtDim3.Visible = False : LblDim3Unite.Visible = False : LblDim4.Visible = False : txtDim4.Visible = False : LblDim4Unite.Visible = False
                        Pb1.Image = My.Resources.Profil_circulaire
                        Pb1.Refresh()
                    Case 17, 18 'Profilé H battu / Profilé H battu injecté = "Profilé H"
                        lblPieuDiam.Text = "Largeur du profilé - b :" : lblPieuDiam.Left = TxtPieuDiam.Location.X - lblPieuDiam.Margin.Left - lblPieuDiam.Width
                        LblPieuLongueurSection.Text = "Hauteur du profilé - h :" : LblPieuLongueurSection.Left = TxtForageLongueur.Location.X - LblPieuLongueurSection.Margin.Left - LblPieuLongueurSection.Width
                        LblPieuLongueurSection.Visible = True : TxtForageLongueur.Visible = True : lblForageLongueur.Visible = True
                        LblDim3.Visible = False : txtDim3.Visible = False : LblDim3Unite.Visible = False : LblDim4.Visible = False : txtDim4.Visible = False : LblDim4Unite.Visible = False
                        Pb1.Image = My.Resources.Pieux_H
                        Pb1.Refresh()
                    Case 19 'Palplanche battues = "Palplanche"
                        lblPieuDiam.Text = "Aire de la palplanche - Ab :" : lblPieuDiam.Left = TxtPieuDiam.Location.X - lblPieuDiam.Margin.Left - lblPieuDiam.Width : lblPieuDiamUnite.Text = "cm²"
                        LblPieuLongueurSection.Text = "Périmètre de la palplanche - P :" : LblPieuLongueurSection.Left = TxtForageLongueur.Location.X - LblPieuLongueurSection.Margin.Left - LblPieuLongueurSection.Width
                        LblPieuLongueurSection.Visible = True : TxtForageLongueur.Visible = True : lblForageLongueur.Visible = True
                        LblDim3.Visible = True : LblDim3.Text = "Valeur de la dimension transversale minimale - Bmin "
                        txtDim3.Visible = True : LblDim3.Text = "(cm)" : LblDim3Unite.Visible = True
                        LblDim4.Visible = False : txtDim4.Visible = False : LblDim4Unite.Visible = False
                        Pb1.Image = My.Resources.Palplanche_Profil
                        Pb1.Refresh()
                    Case 20 To 25 'Micropieux
                        lblPieuDiam.Text = "Diamètre du forage :" : lblPieuDiam.Left = TxtPieuDiam.Location.X - lblPieuDiam.Margin.Left - lblPieuDiam.Width
                        LblPieuLongueurSection.Visible = False : TxtForageLongueur.Visible = False : lblForageLongueur.Visible = False
                        LblDim3.Visible = False : txtDim3.Visible = False : LblDim3Unite.Visible = False : LblDim4.Visible = False : txtDim4.Visible = False : LblDim4Unite.Visible = False
                        Pb1.Image = My.Resources.Profil_circulaire
                        Pb1.Refresh()
                End Select

            Case 1 'profil rectangulaire ou 2ième profil
                Select Case CbPieuType.SelectedIndex
                    Case 0, 1, 4, 5, 6 '= "Rectangulaire"
                        '"Foré simple", "Foré boue" , "Foré simple avec rainurage", "Foré boue avec rainurage", "Puit"  
                        lblPieuDiam.Text = "Epaisseur du forage W :" : lblPieuDiam.Left = TxtPieuDiam.Location.X - lblPieuDiam.Margin.Left - lblPieuDiam.Width
                        LblPieuLongueurSection.Text = "Longueur - L :" : LblPieuLongueurSection.Left = TxtForageLongueur.Location.X - LblPieuLongueurSection.Margin.Left - LblPieuLongueurSection.Width
                        LblPieuLongueurSection.Visible = True : TxtForageLongueur.Visible = True : lblForageLongueur.Visible = True
                        LblDim3.Visible = False : txtDim3.Visible = False : LblDim3Unite.Visible = False : LblDim4.Visible = False : txtDim4.Visible = False : LblDim4Unite.Visible = False
                        Pb1.Image = My.Resources.Profil_rectangulaire
                        Pb1.Refresh()
                    Case 9 'Vissé moulé = Fût avec hélice épaisse
                        lblPieuDiam.Text = "Diamètre nominal Bc :" : lblPieuDiam.Left = TxtPieuDiam.Location.X - lblPieuDiam.Margin.Left - lblPieuDiam.Width
                        LblPieuLongueurSection.Text = "Diamètre Bf :" : LblPieuLongueurSection.Left = TxtForageLongueur.Location.X - LblPieuLongueurSection.Margin.Left - LblPieuLongueurSection.Width
                        LblPieuLongueurSection.Visible = True : TxtForageLongueur.Visible = True : lblForageLongueur.Visible = True
                        LblDim3.Visible = True : txtDim3.Visible = True : LblDim3Unite.Visible = True : LblDim4.Visible = True : txtDim4.Visible = True : LblDim4Unite.Visible = True
                        Pb1.Image = My.Resources.Fut_helice_epaisse
                        Pb1.Refresh()
                    Case 11, 12 '= "Rectangulaire" - Battu béton préfabriqué et Battu béton précontraint
                        lblPieuDiam.Text = "Epaisseur du forage W :" : lblPieuDiam.Left = TxtPieuDiam.Location.X - lblPieuDiam.Margin.Left - lblPieuDiam.Width
                        LblPieuLongueurSection.Text = "Longueur - L :" : LblPieuLongueurSection.Left = TxtForageLongueur.Location.X - LblPieuLongueurSection.Margin.Left - LblPieuLongueurSection.Width
                        LblPieuLongueurSection.Visible = True : TxtForageLongueur.Visible = True : lblForageLongueur.Visible = True
                        LblDim3.Visible = False : txtDim3.Visible = False : LblDim3Unite.Visible = False : LblDim4.Visible = False : txtDim4.Visible = False : LblDim4Unite.Visible = False
                        Pb1.Image = My.Resources.Profil_rectangulaire
                        Pb1.Refresh()
                    Case 15, 16 'Battu acier fermé  /  Battu acier ouvert = "Caisson de Palplanches"
                        TxtPieuDiam.Left += 50 : lblPieuDiamUnite.Left += 50 : lblPieuDiam.Text = "Aire du caisson :" : lblPieuDiam.Left = TxtPieuDiam.Location.X - lblPieuDiam.Margin.Left - lblPieuDiam.Width : lblPieuDiamUnite.Text = "(cm²)"
                        TxtForageLongueur.Left += 50 : lblForageLongueur.Left += 50 : LblPieuLongueurSection.Text = "Périmètre du caisson :"
                        LblPieuLongueurSection.Left = TxtForageLongueur.Location.X - LblPieuLongueurSection.Margin.Left - LblPieuLongueurSection.Width
                        LblPieuLongueurSection.Visible = True : TxtForageLongueur.Visible = True : lblForageLongueur.Visible = True
                        txtDim3.Left += 50 : LblDim3Unite.Left += 50 : LblDim3.Visible = True : LblDim3.Text = "Dimension transversale minimale - Bmin :" : LblDim3.Left = txtDim3.Location.X - LblDim3.Margin.Left - LblDim3.Width
                        txtDim3.Visible = True : LblDim3Unite.Text = "(cm)" : LblDim3Unite.Visible = True
                        LblDim4.Visible = False : txtDim4.Visible = False : LblDim4Unite.Visible = False
                        Pb1.Image = My.Resources.Caisson_Palplanche
                        Pb1.Refresh()
                End Select
            Case 2 '3ième profil
                Select Case CbPieuType.SelectedIndex
                    Case 0, 1, 4, 5, 6 '= "Rectangulaire arrondi"
                        '"Foré simple", "Foré boue" , "Foré simple avec rainurage", "Foré boue avec rainurage", "Puit"  
                        lblPieuDiam.Text = "Epaisseur W :" : lblPieuDiam.Left = TxtPieuDiam.Location.X - lblPieuDiam.Margin.Left - lblPieuDiam.Width
                        LblPieuLongueurSection.Text = "Longueur - L :" : LblPieuLongueurSection.Left = TxtForageLongueur.Location.X - LblPieuLongueurSection.Margin.Left - LblPieuLongueurSection.Width
                        LblPieuLongueurSection.Visible = True : TxtForageLongueur.Visible = True : lblForageLongueur.Visible = True
                        LblDim3.Visible = False : txtDim3.Visible = False : LblDim3Unite.Visible = False : LblDim4.Visible = False : txtDim4.Visible = False : LblDim4Unite.Visible = False
                        Pb1.Image = My.Resources.Profil_rectangulaire_arrondi
                        Pb1.Refresh()
                End Select
        End Select
        Pb1.Focus()
        ChkbOutildeForage.Visible = True : ChkbOutildeForage.Checked = True
    End Sub

    Private Sub Pb1_DoubleClick(sender As Object, e As EventArgs) Handles Pb1.DoubleClick
        Dim frm1 As New frmPieu_ImageSection
        frm1.Pb1.Image = Pb1.Image
        frm1.Show()
    End Sub

#Region "gestion Textbox"
    Private Sub TxtCoteTerrainNaturel_KeyPress(sender As Object, e As KeyPressEventArgs) Handles TxtCoteTerrainNaturel.KeyPress
        Call Gestion_Keypress(e, TxtCoteTerrainNaturel, True, False)
    End Sub
    Private Sub Txtcotetete_KeyPress(sender As Object, e As KeyPressEventArgs) Handles txtCoteTete.KeyPress
        Call Gestion_Keypress(e, txtCoteTete, True, False)
    End Sub
    Private Sub Txtcotepointe_KeyPress(sender As Object, e As KeyPressEventArgs) Handles txtCotePointe.KeyPress
        Call Gestion_Keypress(e, txtCotePointe, True, False)
    End Sub
    Private Sub TxtPieuDiam_KeyPress(sender As Object, e As KeyPressEventArgs) Handles TxtPieuDiam.KeyPress
        Call Gestion_Keypress(e, TxtPieuDiam, True, True)
    End Sub
    Private Sub TxtForageLongueur_KeyPress(sender As Object, e As KeyPressEventArgs) Handles TxtForageLongueur.KeyPress
        Call Gestion_Keypress(e, TxtForageLongueur, True, False)
    End Sub
    Private Sub txtDim3_KeyPress(sender As Object, e As KeyPressEventArgs) Handles txtDim3.KeyPress
        Call Gestion_Keypress(e, txtDim3, True, False)
    End Sub
    Private Sub txtDim4_KeyPress(sender As Object, e As KeyPressEventArgs) Handles txtDim4.KeyPress
        Call Gestion_Keypress(e, txtDim4, True, False)
    End Sub
    Private Sub TxtZeauModTerrain_KeyPress(sender As Object, e As KeyPressEventArgs) Handles TxtZeauModTerrain.KeyPress
        Call Gestion_Keypress(e, TxtZeauModTerrain, True, False)
    End Sub
    Private Sub TxtZhomoLongueur_KeyPress(sender As Object, e As KeyPressEventArgs) Handles TxtZhomoLongueur.KeyPress
        Call Gestion_Keypress(e, TxtZhomoLongueur, True, True)
    End Sub
    Private Sub TxtZhomoLargeur_KeyPress(sender As Object, e As KeyPressEventArgs) Handles TxtZhomoLargeur.KeyPress
        Call Gestion_Keypress(e, TxtZhomoLargeur, True, True)
    End Sub
    Private Sub txtZeauModPieuModele_KeyPress(sender As Object, e As KeyPressEventArgs) Handles txtZeauModPieuModele.KeyPress
        Call Gestion_Keypress(e, txtZeauModPieuModele, True, False)
    End Sub
    Private Sub TxtEffetGroupeDx_KeyPress(sender As Object, e As KeyPressEventArgs) Handles TxtEffetGroupeDx.KeyPress
        Call Gestion_Keypress(e, TxtEffetGroupeDx, True, False)
    End Sub
    Private Sub TxtEffetGroupeDy_KeyPress(sender As Object, e As KeyPressEventArgs) Handles TxtEffetGroupedy.KeyPress
        Call Gestion_Keypress(e, TxtEffetGroupedy, True, False)
    End Sub
    Private Sub TxtEffetGroupemx_KeyPress(sender As Object, e As KeyPressEventArgs) Handles TxtEffetGroupemx.KeyPress
        Call Gestion_Keypress(e, TxtEffetGroupemx, True, True)
    End Sub
    Private Sub TxtEffetGroupemy_KeyPress(sender As Object, e As KeyPressEventArgs) Handles TxtEffetGroupemy.KeyPress
        Call Gestion_Keypress(e, TxtEffetGroupemy, True, True)
    End Sub
    Private Sub TxtEffetGroupenx_KeyPress(sender As Object, e As KeyPressEventArgs) Handles TxtEffetGroupenx.KeyPress
        Call Gestion_Keypress(e, TxtEffetGroupenx, True, True)
    End Sub
    Private Sub TxtEffetGroupeny_KeyPress(sender As Object, e As KeyPressEventArgs) Handles TxtEffetGroupeny.KeyPress
        Call Gestion_Keypress(e, TxtEffetGroupeny, True, True)
    End Sub
#End Region

#Region "gestion des boutons d'aide"
    Private Sub BtnHlp_Click(sender As Object, e As EventArgs) Handles BtnHlpCategoriePieu.Click
        Dim frm1 As frmAide
        frm1 = New frmAide
        Aff.FichierAide = 1
        frm1.Show()
    End Sub

    Private Sub BtnHlpDimForage_Click(sender As Object, e As EventArgs) Handles BtnHlpDimForage.Click
        Dim frm1 As frmAide
        frm1 = New frmAide
        Aff.FichierAide = 2
        frm1.Show()
    End Sub
    Private Sub BtnHlpCote_Click(sender As Object, e As EventArgs) Handles BtnHlpCote.Click
        Dim frm1 As frmAide
        frm1 = New frmAide
        Aff.FichierAide = 3
        frm1.Show()
    End Sub
    Private Sub BtnHlpCatEquivMicropieu_Click(sender As Object, e As EventArgs) Handles BtnHlpCatEquivMicropieu.Click
        Dim frm1 As frmAide
        frm1 = New frmAide
        Aff.FichierAide = 4
        frm1.Show()
    End Sub

    Private Sub BtnHlpModelTerrainValCaracteristique_Click(sender As Object, e As EventArgs) Handles BtnHlpModelTerrainValCaracteristique.Click
        Dim frm1 As frmAide
        frm1 = New frmAide
        Aff.FichierAide = 6
        frm1.Show()
    End Sub
    Private Sub BtnHlpNiveauEauTerrain_Click_1(sender As Object, e As EventArgs) Handles BtnHlpNiveauEauModTerrain.Click, BtnHlpNiveauEauModPieuModel.Click
        Dim frm1 As frmAide
        frm1 = New frmAide
        Aff.FichierAide = 5
        frm1.Show()
    End Sub
    Private Sub BtnHlpAbbat50_Click(sender As Object, e As EventArgs) Handles BtnHlpAbbat50.Click
        Dim frm1 As frmAide
        frm1 = New frmAide
        Aff.FichierAide = 10
        frm1.Show()
    End Sub

    Private Sub BtnHlpEffetdeGroupe_Click(sender As Object, e As EventArgs) Handles BtnHlpEffetdeGroupe.Click
        Dim frm1 As frmAide
        frm1 = New frmAide
        Aff.FichierAide = 11
        frm1.Show()
    End Sub
    Private Sub BtnHlpVibrofoncage_Click(sender As Object, e As EventArgs) Handles BtnHlpVibrofoncage.Click
        Dim frm1 As frmAide
        frm1 = New frmAide
        Aff.FichierAide = 12
        frm1.Show()
    End Sub
    Private Sub BtnHlpResistancePointe_Click(sender As Object, e As EventArgs) Handles BtnHlpResistancePointe.Click
        Dim frm1 As frmAide
        frm1 = New frmAide
        Aff.FichierAide = 13
        frm1.Show()
    End Sub
    Private Sub BtnHlpTassementModPieuModele_Click(sender As Object, e As EventArgs) Handles BtnHlpTassementModPieuModele.Click, BtnHlpTassementModTerrain.Click
        Dim frm1 As frmAide
        frm1 = New frmAide
        Aff.FichierAide = 9
        frm1.Show()
    End Sub
#End Region

#Region "Gestion des datagridview"

#Region "Modules servant à supprimer une ligne dans les datagridview"
    ''' <summary>
    ''' Module servant à supprimer une ligne dans le datagridview DgvCouches
    ''' </summary>
    Private Sub DgvCouches_DoubleClick(sender As Object, e As EventArgs) Handles DgvCouches.DoubleClick
        Dim i, j As Integer
        Try
            'supprimer la ligne
            i = CInt(DgvCouches.SelectedRows(0).Index) '= n° de ligne
            j = CbSondages.SelectedIndex + 1 '= n° de sondage sélectionné
            If SondagesPressio.Item(j - 1).MesurePressio.Count >= (i + 1) Then SondagesPressio.Item(j - 1).MesurePressio.RemoveAt(i)
            DgvCouches.Rows.RemoveAt(DgvCouches.SelectedRows(0).Index)
        Catch ex As Exception
            MessageBox.Show("Pb lors de la suppression des mesures pressiométriques de la ligne n°" & i.ToString("#0") & Environment.NewLine & "Exception: " & ex.Message & Environment.NewLine & ex.StackTrace,
                            "Module DgvCouches_DoubleClick", MessageBoxButtons.OK, MessageBoxIcon.Information)
        End Try
    End Sub

    ''' <summary>
    ''' Module servant à supprimer une ligne dans le datagridview DgvCoucheModTerrain
    ''' </summary>
    Private Sub DgvCoucheModTerrain_DoubleClick(sender As Object, e As EventArgs) Handles DgvCoucheModTerrain.DoubleClick
        Dim i As Integer
        Try
            'supprimer la ligne
            i = CInt(DgvCoucheModTerrain.SelectedRows(0).Index) '= n° de ligne
            If SondageModele.MesurePressio.Count >= (i + 1) Then SondageModele.MesurePressio.RemoveAt(i)
            DgvCoucheModTerrain.Rows.RemoveAt(DgvCoucheModTerrain.SelectedRows(0).Index)
        Catch ex As Exception
            MessageBox.Show("Pb lors de la suppression des mesures pressiométriques de la ligne n°" & i.ToString("#0") & Environment.NewLine & "Exception: " & ex.Message & Environment.NewLine & ex.StackTrace,
                            "Module DgvCoucheModTerrain_DoubleClick", MessageBoxButtons.OK, MessageBoxIcon.Information)
        End Try
    End Sub

    ''' <summary>
    ''' Module servant à supprimer une ligne dans le datagridview DgvLithologie
    ''' </summary>
    Private Sub DgvLithologie_DoubleClick(sender As Object, e As EventArgs) Handles DgvLithologie.DoubleClick
        Dim i, j As Integer
        Try
            'supprimer la ligne
            i = CInt(DgvLithologie.SelectedRows(0).Index) '= n° de ligne
            j = CbSondages.SelectedIndex + 1 '= n° de sondage sélectionné
            If SondagesPressio.Item(j - 1).Lithologie.Count >= (i + 1) Then SondagesPressio.Item(j - 1).Lithologie.RemoveAt(i)
            DgvLithologie.Rows.RemoveAt(DgvLithologie.SelectedRows(0).Index)
        Catch ex As Exception
            MessageBox.Show("Pb lors de la suppression d'une lithologie à la ligne n°" & i.ToString("#0") & Environment.NewLine & "Exception: " & ex.Message & Environment.NewLine & ex.StackTrace,
                            "Module DgvLithologie_DoubleClick", MessageBoxButtons.OK, MessageBoxIcon.Information)
        End Try
    End Sub

    ''' <summary>
    ''' Module servant à supprimer une ligne dans le datagridview DgvLithologieModTerrain
    ''' </summary>
    Private Sub DgvLithologieModTerrain_DoubleClick(sender As Object, e As EventArgs) Handles DgvLithologieModTerrain.DoubleClick
        Dim i As Integer
        Try
            'supprimer la ligne
            i = CInt(DgvLithologieModTerrain.SelectedRows(0).Index) '= n° de ligne
            If SondageModele.Lithologie.Count >= (i + 1) Then SondageModele.Lithologie.RemoveAt(i)
            DgvLithologieModTerrain.Rows.RemoveAt(DgvLithologieModTerrain.SelectedRows(0).Index)
        Catch ex As Exception
            MessageBox.Show("Pb lors de la suppression d'une lithologie à la ligne n°" & i.ToString("#0") & Environment.NewLine & "Exception: " & ex.Message & Environment.NewLine & ex.StackTrace,
                            "Module DgvLithologieModTerrain_DoubleClick", MessageBoxButtons.OK, MessageBoxIcon.Information)
        End Try
    End Sub
#End Region

#Region "Modules servant à afficher les valeurs dans les datagridview"

#Region "Procédure Pieu Modele - Affichage des Valeurs Pressiometriques et lithologiques "

    ''' <summary>Affichage des Valeurs Pressiometriques pour la procédure Pieu Modele</summary>
    ''' <param name="j">n° du sondage</param>
    Private Sub Affichage_Valeurs_Pressiometriques_PieuModele(ByVal j As Integer)
        Dim i, k As Integer
        k = -1
        Try
            With SondagesPressio.Item(j - 1).MesurePressio
                DgvCouches.RowCount = .Count + 1 'nbre de lignes affichées = nbre de sondages + 1
                For i = 1 To .Count
                    k += 1
                    DgvCouches.Item(0, k).Value = .Item(i - 1).Z
                    DgvCouches.Item(1, k).Value = .Item(i - 1).Em
                    DgvCouches.Item(2, k).Value = .Item(i - 1).Pf
                    DgvCouches.Item(3, k).Value = .Item(i - 1).Pl
                Next
            End With
        Catch ex As Exception
            MessageBox.Show("Pb lors de l'affichage des mesures pressiométriques du sondage n°" & j.ToString("#0") & Environment.NewLine & "Exception: " & ex.Message & Environment.NewLine & ex.StackTrace,
                            "Module Affichage_Valeurs_Pressiometriques_PieuModele", MessageBoxButtons.OK, MessageBoxIcon.Information)
        End Try
    End Sub

    ''' <summary>Affichage des Valeurs du profil lithologique pour la procédure Pieu Modele</summary>
    ''' <param name="j">n° du sondage</param>
    Private Sub Affichage_Valeurs_Lithologiques_PieuModele(ByVal j As Integer)
        Dim i, k As Integer
        k = -1
        Try
            With SondagesPressio.Item(j - 1).Lithologie
                DgvLithologie.RowCount = .Count + 1 'nbre de lignes affichées = nbre de lithologie + 1
                For i = 1 To .Count
                    k += 1
                    DgvLithologie.Item(0, k).Value = .Item(i - 1).Ztoit
                    DgvLithologie.Item(1, k).Value = .Item(i - 1).Zbase
                    DgvLithologie.Item(2, k).Value = .Item(i - 1).NomLithologie
                    Select Case .Item(i - 1).Categorie
                        Case 0 'Remblai
                            DgvLithologie.Item(3, k).Value = "Remblai"
                        Case 1
                            DgvLithologie.Item(3, k).Value = "Argiles et limons"
                        Case 2
                            DgvLithologie.Item(3, k).Value = "Sols intermédiaires de classe 1"
                        Case 3
                            DgvLithologie.Item(3, k).Value = "Sols intermédiaires de classe 2"
                        Case 4
                            DgvLithologie.Item(3, k).Value = "Sables et graves"
                        Case 5
                            DgvLithologie.Item(3, k).Value = "Craies"
                        Case 6
                            DgvLithologie.Item(3, k).Value = "Marnes et calcaires marneux"
                        Case 7
                            DgvLithologie.Item(3, k).Value = "Rocher"
                    End Select
                Next
            End With
        Catch ex As Exception
            MessageBox.Show("Pb lors de l'affichage des lithologies du sondage n°" & j.ToString("#0") & Environment.NewLine & "Exception: " & ex.Message & Environment.NewLine & ex.StackTrace,
                            "Module Affichage_Valeurs_Lithologiques_PieuModele", MessageBoxButtons.OK, MessageBoxIcon.Information)
        End Try
    End Sub
#End Region

#Region "Procédure Modele de terrain - Affichage des Valeurs Pressiometriques et lithologiques "
    ''' <summary>Affichage des Valeurs Pressiometriques pour la procédure Modele de terrain - Sondage 5m</summary>
    Private Sub Affichage_Valeurs_Pressiometriques_ModeleTerrain_Sondage5m()
        Dim i, k As Integer
        k = -1
        Try
            With SondageModele.MesurePressio
                DgvCoucheModTerrain.RowCount = .Count + 1 'nbre de lignes affichées = nbre de sondages + 1
                For i = 1 To .Count
                    k += 1
                    DgvCoucheModTerrain.Item(0, k).Value = .Item(i - 1).Z
                    DgvCoucheModTerrain.Item(1, k).Value = .Item(i - 1).Em
                    DgvCoucheModTerrain.Item(2, k).Value = .Item(i - 1).Pf
                    DgvCoucheModTerrain.Item(3, k).Value = .Item(i - 1).Pl
                Next
            End With
        Catch ex As Exception
            MessageBox.Show("Pb lors de l'affichage des mesures pressiométriques du sondage du modèle de terrain." & Environment.NewLine & "Exception: " & ex.Message & Environment.NewLine & ex.StackTrace,
                            "Module Affichage_Valeurs_Pressiometriques_ModeleTerrain", MessageBoxButtons.OK, MessageBoxIcon.Information)
        End Try
    End Sub

    ''' <summary>Affichage des Valeurs du profil lithologique pour la procédure Modele de terrain - Sondage 5m</summary>
    Private Sub Affichage_Valeurs_Lithologiques_ModeleTerrain_Sondage5m()
        Dim i, k As Integer
        k = -1
        Try
            With SondageModele.Lithologie
                DgvLithologieModTerrain.RowCount = .Count + 1 'nbre de lignes affichées = nbre de lithologie + 1
                For i = 1 To .Count
                    k += 1
                    DgvLithologieModTerrain.Item(0, k).Value = .Item(i - 1).Ztoit
                    DgvLithologieModTerrain.Item(1, k).Value = .Item(i - 1).Zbase
                    DgvLithologieModTerrain.Item(2, k).Value = .Item(i - 1).NomLithologie
                    Select Case .Item(i - 1).Categorie
                        Case 0
                            DgvLithologieModTerrain.Item(3, k).Value = "Remblai"
                        Case 1
                            DgvLithologieModTerrain.Item(3, k).Value = "Argiles et limons"
                        Case 2
                            DgvLithologieModTerrain.Item(3, k).Value = "Sols intermédiaires de classe 1"
                        Case 3
                            DgvLithologieModTerrain.Item(3, k).Value = "Sols intermédiaires de classe 2"
                        Case 4
                            DgvLithologieModTerrain.Item(3, k).Value = "Sables et graves"
                        Case 5
                            DgvLithologieModTerrain.Item(3, k).Value = "Craies"
                        Case 6
                            DgvLithologieModTerrain.Item(3, k).Value = "Marnes et calcaires marneux"
                        Case 7
                            DgvLithologieModTerrain.Item(3, k).Value = "Rocher"
                    End Select
                Next
            End With
        Catch ex As Exception
            MessageBox.Show("Pb lors de l'affichage des lithologies du sondage du modèle de terrain." & Environment.NewLine & "Exception: " & ex.Message & Environment.NewLine & ex.StackTrace,
                            "Module Affichage_Valeurs_Lithologiques_ModeleTerrain", MessageBoxButtons.OK, MessageBoxIcon.Information)
        End Try
    End Sub

    ''' <summary>Affichage des Valeurs Pressiometriques et lithologiques pour la procédure Modele de terrain - Valeurs caractéristiques</summary>
    Private Sub Affichage_Valeurs_Pressiometriques_Lithologiques_ModeleTerrain_ValCar()
        Dim i, k As Integer
        k = -1
        Try
            With SondageModele.Lithologie
                DgvLithologieModTerrain.RowCount = .Count + 1 'nbre de lignes affichées = nbre de sondages + 1
                For i = 1 To .Count
                    k += 1
                    DgvLithologieModTerrain.Item(0, k).Value = .Item(i - 1).Ztoit
                    DgvLithologieModTerrain.Item(1, k).Value = .Item(i - 1).Zbase
                    DgvLithologieModTerrain.Item(2, k).Value = .Item(i - 1).Pl
                    DgvLithologieModTerrain.Item(3, k).Value = .Item(i - 1).NomLithologie
                    Select Case .Item(i - 1).Categorie
                        Case 0
                            DgvLithologieModTerrain.Item(4, k).Value = "Remblai"
                        Case 1
                            DgvLithologieModTerrain.Item(4, k).Value = "Argiles et limons"
                        Case 2
                            DgvLithologieModTerrain.Item(4, k).Value = "Sols intermédiaires de classe 1"
                        Case 3
                            DgvLithologieModTerrain.Item(4, k).Value = "Sols intermédiaires de classe 2"
                        Case 4
                            DgvLithologieModTerrain.Item(4, k).Value = "Sables et graves"
                        Case 5
                            DgvLithologieModTerrain.Item(4, k).Value = "Craies"
                        Case 6
                            DgvLithologieModTerrain.Item(4, k).Value = "Marnes et calcaires marneux"
                        Case 7
                            DgvLithologieModTerrain.Item(4, k).Value = "Rocher"
                    End Select
                Next
            End With
        Catch ex As Exception
            MessageBox.Show("Pb lors de l'affichage des mesures pressiométriques du sondage du modèle de terrain." & Environment.NewLine & "Exception: " & ex.Message & Environment.NewLine & ex.StackTrace,
                            "Module Affichage_Valeurs_Pressiometriques_ModeleTerrain", MessageBoxButtons.OK, MessageBoxIcon.Information)
        End Try
    End Sub
#End Region

#End Region

#Region "Modules servant à lire les valeurs dans les datagridview"
    Private Sub DgvCoucheModTerrain_CellValidating(sender As Object, e As DataGridViewCellValidatingEventArgs) Handles DgvCoucheModTerrain.CellValidating
        Dim j, k As Integer

        j = e.RowIndex 'j = ligne (row)
        k = e.ColumnIndex 'k = colonne (column)
        If DgvCoucheModTerrain.Rows(e.RowIndex).IsNewRow Then Return 'pour éviter tout plantage sur la 1ière ligne
        Me.DgvCoucheModTerrain.Rows(e.RowIndex).ErrorText = ""
        'Z profondeur  'Em'Pf'Pl
        Dim toto As Double
        If Not Double.TryParse(e.FormattedValue.ToString, toto) Then '
            Try
                Dim Verif As Boolean = True
                Dim s As String
                s = e.FormattedValue.ToString
                Gestion_CelluleDbl(s, Verif)
                If Verif = False Then
                    e.Cancel = True
                    DgvCoucheModTerrain.Rows(e.RowIndex).ErrorText = "La valeur n'est pas numérique" 'Affichage erreur
                Else
                    DgvCoucheModTerrain.Item(e.ColumnIndex, e.RowIndex).Value = CType(s, Double)
                End If
            Catch ex As Exception
                e.Cancel = True
                DgvCoucheModTerrain.Rows(e.RowIndex).ErrorText = "La valeur doit être numérique et positive !" 'Affichage erreur
            End Try

        ElseIf toto < 0 Then
            e.Cancel = True
            DgvCoucheModTerrain.Rows(e.RowIndex).ErrorText = "La valeur numérique doit être positive" 'Affichage erreur
        End If

    End Sub
    Private Sub DgvLithologieModTerrain_CellValidating(sender As Object, e As DataGridViewCellValidatingEventArgs) Handles DgvLithologieModTerrain.CellValidating
        Dim j, k As Integer

        j = e.RowIndex 'j = ligne (row)
        k = e.ColumnIndex 'k = colonne (column)
        If DgvLithologieModTerrain.Rows(e.RowIndex).IsNewRow Then Return 'pour éviter tout plantage sur la 1ière ligne
        Select Case Aff.ModeleCalcul
            Case 1 'modèle terrain + val caractéristiques
                If k = 3 Or k = 4 Then Exit Sub 'la valeur est un string
            Case 2 'modèle terrain + sondage 5m
                If k = 2 Or k = 3 Then Exit Sub 'la valeur est un string
        End Select

        Me.DgvLithologieModTerrain.Rows(e.RowIndex).ErrorText = ""
        'Z profondeur  'Em'Pf'Pl
        Dim toto As Double
        If Not Double.TryParse(e.FormattedValue.ToString, toto) Then '
            Try
                Dim Verif As Boolean = True
                Dim s As String
                s = e.FormattedValue.ToString
                Gestion_CelluleDbl(s, Verif)
                If Verif = False Then
                    e.Cancel = True
                    DgvLithologieModTerrain.Rows(e.RowIndex).ErrorText = "La valeur n'est pas numérique" 'Affichage erreur
                Else
                    DgvLithologieModTerrain.Item(e.ColumnIndex, e.RowIndex).Value = CType(s, Double)
                End If
            Catch ex As Exception
                e.Cancel = True
                DgvLithologieModTerrain.Rows(e.RowIndex).ErrorText = "La valeur doit être numérique et positive !" 'Affichage erreur
            End Try

        ElseIf toto < 0 Then
            e.Cancel = True
            DgvLithologieModTerrain.Rows(e.RowIndex).ErrorText = "La valeur numérique doit être positive" 'Affichage erreur
        End If

    End Sub
    Private Sub DgvCouches_CellValidating(sender As Object, e As DataGridViewCellValidatingEventArgs) Handles DgvCouches.CellValidating
        Dim j, k As Integer

        j = e.RowIndex 'j = ligne (row)
        k = e.ColumnIndex 'k = colonne (column)
        If DgvCouches.Rows(e.RowIndex).IsNewRow Then Return 'pour éviter tout plantage sur la 1ière ligne
        Me.DgvCouches.Rows(e.RowIndex).ErrorText = ""
        'Z profondeur  'Em'Pf'Pl
        Dim toto As Double
        If Not Double.TryParse(e.FormattedValue.ToString, toto) Then '
            Try
                Dim Verif As Boolean = True
                Dim s As String
                s = e.FormattedValue.ToString
                Gestion_CelluleDbl(s, Verif)
                If Verif = False Then
                    e.Cancel = True
                    DgvCouches.Rows(e.RowIndex).ErrorText = "La valeur n'est pas numérique" 'Affichage erreur
                Else
                    DgvCouches.Item(e.ColumnIndex, e.RowIndex).Value = CType(s, Double)
                End If
            Catch ex As Exception
                e.Cancel = True
                DgvCouches.Rows(e.RowIndex).ErrorText = "La valeur doit être numérique et positive !" 'Affichage erreur
            End Try

        ElseIf toto < 0 Then
            e.Cancel = True
            DgvCouches.Rows(e.RowIndex).ErrorText = "La valeur numérique doit être positive" 'Affichage erreur
        End If

    End Sub
    Private Sub DgvLithologie_CellValidating(sender As Object, e As DataGridViewCellValidatingEventArgs) Handles DgvLithologie.CellValidating
        Dim j, k As Integer

        j = e.RowIndex 'j = ligne (row)
        k = e.ColumnIndex 'k = colonne (column)
        If DgvLithologie.Rows(e.RowIndex).IsNewRow Then Return 'pour éviter tout plantage sur la 1ière ligne
        If k = 2 Or k = 3 Then Exit Sub 'la valeur est un string
        Me.DgvLithologie.Rows(e.RowIndex).ErrorText = ""
        'Z base / Z toit
        Dim toto As Double
        If Not Double.TryParse(e.FormattedValue.ToString, toto) Then '
            Try
                Dim Verif As Boolean = True
                Dim s As String
                s = e.FormattedValue.ToString
                Gestion_CelluleDbl(s, Verif)
                If Verif = False Then
                    e.Cancel = True
                    DgvLithologie.Rows(e.RowIndex).ErrorText = "La valeur n'est pas numérique" 'Affichage erreur
                Else
                    DgvLithologie.Item(e.ColumnIndex, e.RowIndex).Value = CType(s, Double)
                End If
            Catch ex As Exception
                e.Cancel = True
                DgvLithologie.Rows(e.RowIndex).ErrorText = "La valeur doit être numérique et positive !" 'Affichage erreur
            End Try

        ElseIf toto < 0 Then
            e.Cancel = True
            DgvLithologie.Rows(e.RowIndex).ErrorText = "La valeur numérique doit être positive" 'Affichage erreur
        End If

    End Sub

    ''' <summary>Lecture du tableau Valeurs Pressiométriques - Procédure Modèle terrain</summary>
    ''' <param name="Verif">renvoie FALSE si erreur détectée </param>
    Private Sub Lecture_ValeurPressiometriqueModTerrain(ByRef Verif As Boolean)
        Dim i1, j, k As Integer
        Dim index_initial, index_final, tour As Integer
        Dim msg As String = String.Empty
        'j = ligne (row)
        'k = colonne (column)
        Try
            tour = 0
            For j = 0 To DgvCoucheModTerrain.Rows.Count - 2
                Dim ValPress As New clsValPressio 'initialisation de ValPress à chaque ligne
                For k = 0 To 3 'colonnes
                    With DgvCoucheModTerrain
                        Select Case k
                            Case 0 'Z
                                Call Lecture_Cellule(DgvCoucheModTerrain, k, j, True, ValPress.Z, Verif)
                            Case 1 'Em
                                Call Lecture_Cellule(DgvCoucheModTerrain, k, j, True, ValPress.Em, Verif)
                            Case 2 'Pf
                                Call Lecture_Cellule(DgvCoucheModTerrain, k, j, True, ValPress.Pf, Verif)
                            Case 3 'Pl
                                Call Lecture_Cellule(DgvCoucheModTerrain, k, j, True, ValPress.Pl, Verif)
                        End Select
                    End With
                Next
                SondageModele.MesurePressio.Add(ValPress)
                If tour = 0 Then
                    index_initial = SondageModele.MesurePressio.LastIndexOf(ValPress) : index_final = index_initial 'dans le cas d'un seul élément ajouté
                Else
                    index_final = SondageModele.MesurePressio.LastIndexOf(ValPress)
                End If
                tour = tour + 1
            Next
            j = 0
            'gestion des valeurs pressiométriques ajoutées
            If index_initial = 0 Then
                Exit Sub 'Pas de modification si une seule valeur pressiométrique  
            Else
                'comparaison
                With SondageModele.MesurePressio
                    For i1 = 1 To .Count - tour
                        For k = index_initial To index_final - j
                            If .Item(i1 - 1).Z = .Item(k).Z Then 'si même sondage et même profondeur  alors remplacement
                                .Item(i1 - 1).Em = .Item(k).Em
                                .Item(i1 - 1).Pf = .Item(k).Pf
                                .Item(i1 - 1).Pl = .Item(k).Pl
                                .RemoveAt(k) : j = j + 1 : Exit For
                            End If
                        Next
                    Next
                End With

            End If
            If Verif = False Then
                MessageBox.Show(msg, "Module Lecture_ValeurPressiometriqueModTerrain", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            End If
        Catch ex As Exception
            MessageBox.Show("Erreur lors de la lecture des valeurs pressiométriques renseignées - cellule colonne " & (k + 1).ToString & " ligne " & (j + 1).ToString & Environment.NewLine & "Exception: " & ex.Message & Environment.NewLine & ex.StackTrace,
                            "Module Lecture_ValeurPressiometriqueModTerrain", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            Verif = False
        End Try
    End Sub

    ''' <summary>Lecture du tableau Valeurs Pressiométriques - Procédure Pieu Modèle</summary>
    ''' <param name="i2">= n° de sondage sélectionné</param>
    ''' <param name="Verif">renvoie FALSE si erreur détectée </param>
    Private Sub Lecture_ValeurPressiometriquePieuModele(ByVal i2 As Integer, ByRef Verif As Boolean)
        Dim j, k As Integer
        Dim msg As String = String.Empty
        Dim SondPress As New clsSondagePressio

        'j = ligne (row) //  'k = colonne (column)
        Try

            For j = 0 To DgvCouches.Rows.Count - 2
                Dim ValPress As New clsValPressio 'initialisation de ValPress à chaque ligne
                For k = 0 To 3 'colonnes
                    With DgvCouches
                        Select Case k
                            Case 0 'Z
                                Call Lecture_Cellule(DgvCouches, k, j, True, ValPress.Z, Verif)
                            Case 1 'Em
                                Call Lecture_Cellule(DgvCouches, k, j, True, ValPress.Em, Verif)
                            Case 2 'Pf
                                Call Lecture_Cellule(DgvCouches, k, j, True, ValPress.Pf, Verif)
                            Case 3 'Pl
                                Call Lecture_Cellule(DgvCouches, k, j, True, ValPress.Pl, Verif)
                        End Select
                    End With
                Next
                If Verif = False Then MessageBox.Show(msg, "Module Lecture_ValeurPressiometriquePieuModele", MessageBoxButtons.OK, MessageBoxIcon.Exclamation) : Exit Sub
                SondPress.MesurePressio.Add(ValPress)
            Next
            If i2 > SondagesPressio.Count Then
                SondagesPressio.Add(SondPress) 'soit on ajoute,
            Else
                ' soit on remplace
                SondagesPressio.Item(i2 - 1).MesurePressio.Clear()
                With SondagesPressio.Item(i2 - 1).MesurePressio
                    For j = 0 To DgvCouches.Rows.Count - 2
                        .Add(SondPress.MesurePressio.Item(j))
                    Next
                End With
            End If

        Catch ex As Exception
            MessageBox.Show("Erreur lors de la lecture des valeurs pressiométriques renseignées - cellule colonne " & (k + 1).ToString & " ligne " & (j + 1).ToString & Environment.NewLine & "Exception: " & ex.Message & Environment.NewLine & ex.StackTrace,
                            "Module Lecture_ValeurPressiometriquePieuModele", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            Verif = False
        End Try
    End Sub

    ''' <summary>Lecture du tableau des lithologies - Procédure Pieu Modèle</summary>
    ''' <param name="i2">= n° de sondage sélectionné</param>
    ''' <param name="Verif">renvoie FALSE si erreur détectée </param>
    Private Sub Lecture_LithologiePieuModele(ByVal i2 As Integer, ByRef Verif As Boolean)
        Dim j, k As Integer
        Dim msg As String = String.Empty
        Dim SondPress As New clsSondagePressio

        'j = ligne (row) //  'k = colonne (column)
        Try
            For j = 0 To DgvLithologie.Rows.Count - 2
                Dim ValLitho As New clsLithologie 'initialisation de ValLitho à chaque ligne
                For k = 0 To 3 'colonnes
                    With DgvLithologie
                        Select Case k
                            Case 0 'Ztoit
                                Call Lecture_Cellule(DgvLithologie, k, j, True, ValLitho.Ztoit, Verif)
                                If Verif = False Then msg = "Erreur lors de la lecture de la valeur Ztoit" : Exit For
                            Case 1 'Zbase
                                Call Lecture_Cellule(DgvLithologie, k, j, True, ValLitho.Zbase, Verif)
                                If Verif = False Then msg = "Erreur lors de la lecture de la valeur Zbase" : Exit For
                            Case 2 'Nom de la lithologie
                                ValLitho.NomLithologie = .Item(k, j).Value.ToString
                            Case 3 'catégorie de sol
                                Select Case .Item(k, j).Value.ToString
                                    Case "Remblai"
                                        ValLitho.Categorie = 0
                                    Case "Argiles et limons"
                                        ValLitho.Categorie = 1
                                    Case "Sols intermédiaires de classe 1"
                                        ValLitho.Categorie = 2
                                    Case "Sols intermédiaires de classe 2"
                                        ValLitho.Categorie = 3
                                    Case "Sables et graves"
                                        ValLitho.Categorie = 4
                                    Case "Craies"
                                        ValLitho.Categorie = 5
                                    Case "Marnes et calcaires marneux"
                                        ValLitho.Categorie = 6
                                    Case "Rocher"
                                        ValLitho.Categorie = 7
                                End Select
                        End Select
                    End With
                Next
                If Verif = False Then MessageBox.Show(msg, "Module Lecture_LithologiePieuModele", MessageBoxButtons.OK, MessageBoxIcon.Exclamation) : Exit Sub
                SondPress.Lithologie.Add(ValLitho)
            Next
            If i2 > SondagesPressio.Count Then
                SondagesPressio.Add(SondPress) 'soit on ajoute,
            Else
                ' soit on remplace
                SondagesPressio.Item(i2 - 1).Lithologie.Clear()
                With SondagesPressio.Item(i2 - 1).Lithologie
                    For j = 0 To DgvLithologie.Rows.Count - 2
                        .Add(SondPress.Lithologie.Item(j))
                    Next
                End With
            End If

        Catch ex As Exception
            MessageBox.Show("Erreur lors de la lecture des valeurs lithologiques renseignées - cellule colonne " & (k + 1).ToString & " ligne " & (j + 1).ToString & Environment.NewLine & "Exception: " & ex.Message & Environment.NewLine & ex.StackTrace,
                            "Module Lecture_LithologiePieuModele", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            Verif = False
        End Try
    End Sub

    ''' <summary>Lecture du tableau des lithologies - Procédure Modèle de terrain</summary>
    ''' <param name="Verif">renvoie FALSE si erreur détectée </param>
    Private Sub Lecture_LithologieModTerrain(ByRef Verif As Boolean)
        Dim j, k, ind As Integer
        Dim msg As String = String.Empty
        If SondageModele.Lithologie.Count >= 1 Then SondageModele.Lithologie.Clear() 'je fais une mise à 0 générale et je re-intègre toutes les valeurs de lithologie
        'j = ligne (row)
        'k = colonne (column)
        Select Case Aff.ModeleCalcul
            Case 1 'val caractéristiques
                ind = 4
            Case 2 'sondage 5m
                ind = 3
        End Select
        Try
            For j = 0 To DgvLithologieModTerrain.Rows.Count - 2
                Dim ValLitho As New clsLithologie 'initialisation de ValLitho à chaque ligne
                For k = 0 To ind 'colonnes
                    With DgvLithologieModTerrain
                        Select Case k
                            Case 0 'Ztoit
                                Call Lecture_Cellule(DgvLithologieModTerrain, k, j, True, ValLitho.Ztoit, Verif)
                                If Verif = False Then msg = "Erreur lors de la lecture de la valeur Ztoit" : Exit For
                            Case 1 'Zbase
                                Call Lecture_Cellule(DgvLithologieModTerrain, k, j, True, ValLitho.Zbase, Verif)
                                If Verif = False Then msg = "Erreur lors de la lecture de la valeur Zbase" : Exit For
                            Case 2 'Nom de la lithologie ou Pression limite
                                Select Case Aff.ModeleCalcul
                                    Case 1 'val caractéristiques
                                        Call Lecture_Cellule(DgvLithologieModTerrain, k, j, True, ValLitho.Pl, Verif)
                                    Case 2 'sondage 5m
                                        ValLitho.NomLithologie = .Item(k, j).Value.ToString
                                End Select
                            Case 3 'Nom de la lithologie ou catégorie de sol
                                Select Case Aff.ModeleCalcul
                                    Case 1 'val caractéristiques
                                        ValLitho.NomLithologie = .Item(k, j).Value.ToString
                                    Case 2 'sondage 5m
                                        Select Case CStr(.Item(k, j).Value)
                                            Case "Remblai"
                                                ValLitho.Categorie = 0
                                            Case "Argiles et limons"
                                                ValLitho.Categorie = 1
                                            Case "Sols intermédiaires de classe 1"
                                                ValLitho.Categorie = 2
                                            Case "Sols intermédiaires de classe 2"
                                                ValLitho.Categorie = 3
                                            Case "Sables et graves"
                                                ValLitho.Categorie = 4
                                            Case "Craies"
                                                ValLitho.Categorie = 5
                                            Case "Marnes et calcaires marneux"
                                                ValLitho.Categorie = 6
                                            Case "Rocher"
                                                ValLitho.Categorie = 7
                                        End Select
                                End Select
                            Case 4 '  catégorie de sol
                                Select Case CStr(.Item(k, j).Value)
                                    Case "Remblai"
                                        ValLitho.Categorie = 0
                                    Case "Argiles et limons"
                                        ValLitho.Categorie = 1
                                    Case "Sols intermédiaires de classe 1"
                                        ValLitho.Categorie = 2
                                    Case "Sols intermédiaires de classe 2"
                                        ValLitho.Categorie = 3
                                    Case "Sables et graves"
                                        ValLitho.Categorie = 4
                                    Case "Craies"
                                        ValLitho.Categorie = 5
                                    Case "Marnes et calcaires marneux"
                                        ValLitho.Categorie = 6
                                    Case "Rocher"
                                        ValLitho.Categorie = 7
                                End Select
                        End Select
                    End With
                Next
                If Verif = False Then MessageBox.Show(msg, "Module Lecture_LithologieModTerrain", MessageBoxButtons.OK, MessageBoxIcon.Exclamation) : Exit Sub
                SondageModele.Lithologie.Add(ValLitho)
            Next
        Catch ex As Exception
            MessageBox.Show("Erreur lors de la lecture des valeurs lithologiques renseignées - cellule colonne " & (k + 1).ToString & " ligne " & (j + 1).ToString & Environment.NewLine & "Exception: " & ex.Message & Environment.NewLine & ex.StackTrace,
                            "Module Lecture_LithologieModTerrain", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            Verif = False
        End Try
    End Sub

    ''' <summary>Lecture de la cellule</summary>
    ''' <param name="Dg1">transfert du DataGridView</param>
    ''' <param name="k">numéro de colonne de la cellule</param>
    ''' <param name="j">numéro de ligne de la cellule </param>
    '''  <param name="Positif">valeur TRUE si la varia ble doit être positive</param>
    ''' <param name="X">valeur à retourner</param>
    ''' <param name="Verif">Renvoie FALSE si pb </param>
    Private Sub Lecture_Cellule(ByVal Dg1 As DataGridView, ByVal k As Integer, ByVal j As Integer, ByVal Positif As Boolean, ByRef X As Double, ByRef Verif As Boolean)
        With Dg1
            If .Item(k, j).Value Is Nothing Then .Item(k, j).Value = 0
            If Not Double.TryParse(.Item(k, j).Value.ToString, X) Then
                Try
                    Dim s As String
                    s = .Item(k, j).Value.ToString
                    Call Gestion_CelluleDbl(s, Verif)
                    If Verif = False Then
                        'e.Cancel = True
                        .Rows(j).ErrorText = "La valeur n'est pas numérique" 'Affichage erreur
                    Else
                        X = CType(s, Double)
                        If Positif = True And X < 0 Then
                            .Rows(j).ErrorText = "La valeur doit être positive" 'Affichage erreur
                            Verif = False
                        Else
                            Verif = True
                        End If
                    End If
                Catch ex As Exception
                    .Rows(j).ErrorText = "La valeur doit être numérique." 'Affichage erreur
                End Try
            Else
                X = CDbl(.Item(k, j).Value)
            End If
        End With
    End Sub


#End Region


#End Region

    Private Sub CbSondages_SelectedIndexChanged(sender As Object, e As EventArgs) Handles CbSondages.SelectedIndexChanged
        Dim i As Integer
        i = CbSondages.SelectedIndex + 1

        If SondagesPressio.Count >= i Then
            Call Affichage_Valeurs_Pressiometriques_PieuModele(i)
            Call Affichage_Valeurs_Lithologiques_PieuModele(i)
        Else
            DgvCouches.Rows.Clear()
            DgvCouches.RowCount = 1
            DgvLithologie.Rows.Clear()
            DgvLithologie.RowCount = 1
            DgvCouches.Item(0, 0).Selected = True 'focus dans la 1ière cellule
        End If
    End Sub
    Private Sub BtnSondageSuppression_Click(sender As Object, e As EventArgs) Handles BtnSondageSuppression.Click
        Dim i As Integer
        i = CbSondages.SelectedIndex + 1

        Select Case i
            Case Is > SondagesPressio.Count

            Case SondagesPressio.Count
                SondagesPressio.RemoveAt(i - 1)
                If i = 1 Then
                    DgvCouches.Rows.Clear()
                    DgvCouches.RowCount = 1
                    DgvLithologie.Rows.Clear()
                    DgvLithologie.RowCount = 1
                    DgvCouches.Item(0, 0).Selected = True 'focus dans la 1ière cellule
                Else

                End If
            Case Is < SondagesPressio.Count

        End Select
    End Sub
    Private Sub BtnSondageAjout_Click(sender As Object, e As EventArgs) Handles BtnSondageAjout.Click
        Dim i, j As Integer
        Dim Verif As Boolean = True
        i = CInt(LblSondagesNB.Text) + 1
        If i = SondagesPressio.Count + 1 Then
            LblSondagesNB.Text = (SondagesPressio.Count + 1).ToString("#0")
            'affichage dans le cbsondage
            If CbSondages.Items.Count = i - 1 Then
                j = CbSondages.Items.Count + 1
                CbSondages.Items.Add("Sondage n°" & j.ToString("#0"))
                CbSondages.Text = "Sondage n°" & j.ToString("#0")
            End If
            Exit Sub
        Else
            MessageBox.Show("Vous devez d'abord renseigné le sondage n°" & (SondagesPressio.Count + 1).ToString, "Btn Ajout_Sondage", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            Exit Sub
        End If
    End Sub

    Private Sub BtnAffichageProfil_Click(sender As Object, e As EventArgs) Handles BtnAffichageProfilModelTerrain.Click, BtnAffichageProfilPieuModele.Click
        Dim frm1 As New frmAffichageProfil
        Dim myImage As Image
        Dim g As Graphics
        myImage = My.Resources.Sol_675x900 'Image.FromStream(Img)
        g = Graphics.FromImage(myImage)
        Call Dessin_Litho_Pressio(g, 2, 675, 900)  '   Call Affichage_Courbes(g, 2, 675, 900, 2) 'Affichage_...(ByVal g As Graphics, ByVal Support As Integer, ByVal largeur As Integer, ByVal Hauteur As Integer)
        frm1.Pb1.Image = myImage
        frm1.Show()
        frm1 = Nothing 'pour libérer la mémoire
    End Sub

    ''' <summary>Déclenche la lecture des données du profil pressiométrique et l'affichage dans le tableau</summary>
    ''' <param name="sender"> </param>
    ''' <param name="e"> </param>
    Private Sub BtnProfilPressio_Click(sender As Object, e As EventArgs) Handles BtnProfilPressioModTerrain.Click, BtnProfilPressioPieuModele.Click
        Dim OpenFileDialog As New OpenFileDialog
        Try
            With OpenFileDialog
                If Aff.msgData <> String.Empty Then
                    .InitialDirectory = Aff.msgData
                Else
                    .InitialDirectory = My.Computer.FileSystem.SpecialDirectories.MyDocuments
                End If

                .FileName = "" 'pour éviter tout affichage initial dans la boite de dialogue
                .CheckFileExists = True ' Vérifie que le fichier sélectionné existe. Sinon, la boîte de dialogue affiche un avertissement.
                .CheckPathExists = True ' Vérifie que le chemin sélectionné existe. Sinon, la boîte de dialogue affiche un avertissement.
                .DefaultExt = "txt" ' Obtient ou définit une extension par défaut. N'inclut pas le "." de début.
                ' Retourne le fichier référencé par un lien ? Si la valeur de retour est False, retourne simplement le fichier de liaison
                ' sélectionné. Si elle est True, retourne le fichier lié au fichier LNK.
                .DereferenceLinks = True
                .Title = "Ouvrir le projet"
                ' .InitialDirectory = Directory.GetParent(Directory.GetCurrentDirectory).ToString() & "\data"
                .FilterIndex = 1
                .Filter = "Fichiers textes (*.txt)|*.txt|Tous les fichiers (*.*)|*.*"
                .Multiselect = False
                .RestoreDirectory = True
                .ShowHelp = True ' Affiche le bouton Aide et la case à cocher Lecture seule ?
                .ShowReadOnly = False
                ' Commence avec la case à cocher Lecture seule activée ? Ceci n'est justifié que si ShowReadOnly a la valeur True.
                .ReadOnlyChecked = False
                If .ShowDialog = System.Windows.Forms.DialogResult.OK Then
                    If .FileName <> "" Then
                        Dim Verif As Boolean = True
                        Dim Racine As String = String.Empty
                        Dim NomAffaire As String = String.Empty
                        Call Lecture_chaine_Racine(.FileName, Racine, NomAffaire, Verif)

                        Select Case Aff.ModeleCalcul
                            Case 1 'modèle terrain + val car
                                Call Lecture_DataPressioLithoValCar(.FileName, Verif)
                            Case 2 'Modele terrain + sondage 5m
                                Call Lecture_DataPressioLitho(.FileName, Verif)
                            Case 3 'Pieu Modele
                                Dim i As Integer
                                i = SondagesPressio.Count
                                Call Lecture_DataPressioLitho(.FileName, Verif)
                        End Select

                        If Verif = True Then
                            Call Affichage_onglet2()
                            Me.Text = "Calcul de pieux suivant essais pressiométriques : [ " & NomAffaire.ToString & " ]"
                        End If
                    Else
                        Me.Text = "Calcul de pieux suivant essais pressiométriques : [ aucun fichier de données ]"
                        MessageBox.Show("Aucun nom de fichier Data n'a été indiqué.", "Ouverture du fichier data: ", MessageBoxButtons.OK, MessageBoxIcon.Error)
                    End If
                End If
            End With
        Catch ex As Exception
            Me.Text = "Calcul de pieux suivant essais pressiométriques : [ aucun fichier de données ]"
            MessageBox.Show("Erreur lors de la lecture du fichier: " & Environment.NewLine & ex.Message & ex.StackTrace, "Ouverture de fichier data: " & Aff.FileName, MessageBoxButtons.OK, MessageBoxIcon.Error)
        Finally
            OpenFileDialog.Dispose() 'pour libérer la mémoire
        End Try
    End Sub

    ''' <summary>Lecture des données dans le fichier profil Pressiométrique et lithologique - modèle de terrain + valeurs caractéristiques</summary>
    ''' <param name="FileName">Nom du fichier des données profil lithologique</param>
    ''' <param name="Verif">Renvoie FALSE si pb de lecture</param>
    Private Sub Lecture_DataPressioLithoValCar(ByVal FileName As String, ByRef Verif As Boolean)
        Dim myStreamReader As StreamReader = Nothing
        Dim line, titi(), msg As String
        Dim msg1 As String = String.Empty
        Dim NumLine As Integer
        Dim TotalDonnees As Integer = 0 'nombre total de données sur la ligne correspondante
        Try
            myStreamReader = File.OpenText(FileName)
            NumLine = 0 : TotalDonnees = 2

            SondageModele.MesurePressio.Clear()
            SondageModele.Lithologie.Clear()
            Do
                line = myStreamReader.ReadLine()
                If line Is Nothing Then Exit Do
                ReDim titi(TotalDonnees)
                Call LectureGen(line, titi, Verif, TotalDonnees) : If Verif = False Then myStreamReader.Close() : Exit Sub  'ligne suivante
                msg = String.Empty : NumLine += 1
                Select Case NumLine
                    Case 1 'date
                        If TryCast(titi(2), String) Is Nothing Then
                            msg = "Erreur de conversion de la donnée date sondage, lors de la lecture du fichier Valeurs Caractéristiques."
                            MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                        Else
                            If Date.TryParse(titi(2), SondageModele.DateSondage) = False Then
                                msg = "La valeur date sondage figurant dans le fichier Valeurs Caractéristiques ne correspond pas à une valeur de date."
                                MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                            Else
                                SondageModele.DateSondage = CDate(titi(2))
                                TotalDonnees = 2 '2 pour l'eau
                            End If
                        End If
                    Case 2 'eau   
                        If TryCast(titi(2), String) Is Nothing Then
                            msg = "Erreur de conversion de la donnée valeur altimétrique du niveau d'eau, lors de la lecture du fichier Valeurs Caractéristiques."
                            MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                        Else
                            'vérification que la chaine de caractère est bien une valeur numérique
                            Call Gestion_CelluleDbl(titi(2), Verif) 'nettoyage du string et remplacement de la virgule par un point
                            If Verif = False Then
                                msg = "Problème de conversion de la donnée valeur altimétrique du niveau d'eau, lors de la lecture du fichier Valeurs Caractéristiques."
                                MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Exit Do
                            End If
                            If Double.TryParse(titi(2), SondageModele.Zeau) = False Then
                                msg = "La donnée valeur altimétrique du niveau d'eau figurant dans le fichier Valeurs Caractéristiques n'est pas numérique."
                                MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                            Else
                                SondageModele.Zeau = CDbl(titi(2))
                                If SondageModele.Zeau = 1001 Then
                                    RbtnNappeEauabsente.Checked = True
                                    lblNappeEauAltimetrie.Visible = False : TxtZeauModTerrain.Visible = False : lblNappeEau_m.Visible = False
                                    SondageModele.NappeEau = False
                                Else
                                    RbtnNappeEauReconnue.Checked = True
                                    lblNappeEauAltimetrie.Visible = True : TxtZeauModTerrain.Visible = True : lblNappeEau_m.Visible = True : TxtZeauModTerrain.Text = SondageModele.Zeau.ToString("#0.00")
                                    SondageModele.NappeEau = True
                                End If
                                TotalDonnees = 15 '1 pour le pressio
                            End If
                        End If
                    Case Else 'valeurs caractéristiques
                        If NumLine = 3 Then Continue Do 'il s'agit de la ligne d'entête qui n'est pas lue
                        If titi.Length < 5 Then
                            Select Case titi.Length
                                Case 0
                                    msg = "Aucune donnée dans le fichier profil Valeurs Caractéristiques"
                                Case 1
                                    msg = "Il manque 3 données parmi Ztoit, Zbase, pl*, lithologie et classe de sol dans le fichier Valeurs Caractéristiques"
                                Case 2
                                    msg = "Il manque 2 données parmi Ztoit, Zbase, pl*, lithologie et classe de sol dans le fichier Valeurs Caractéristiques"
                                Case 3
                                    msg = "Il manque 1 donnée parmi Ztoit, Zbase, pl*, lithologie et classe de sol dans le fichier Valeurs Caractéristiques"
                            End Select
                            MessageBox.Show("Erreur lors de la lecture du fichier des données Valeurs Caractéristiques" & Environment.NewLine & msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information)
                            Verif = False : Exit Do
                        Else
                            Dim MesureLitho1 As New clsLithologie
                            With MesureLitho1
                                'vérification que la chaine de caractère est bien une valeur numérique
                                Call Gestion_CelluleDbl(titi(1), Verif) 'nettoyage du string et remplacement de la virgule par un point
                                If Verif = False Then
                                    msg = "Problème de conversion de la donnée valeur altimétrique du niveau haut de la couche de sol du sondage, lors de la lecture du fichier des données pressiométriques."
                                    MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Exit Do
                                End If
                                If Double.TryParse(titi(1), .Ztoit) = False Then
                                    msg = "La donnée valeur altimétrique du niveau haut de la couche de sol figurant dans le fichier des données des valeurs caractéristiques n'est pas numérique."
                                    MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                                Else
                                    .Ztoit = CDbl(titi(1))
                                End If
                                Call Gestion_CelluleDbl(titi(2), Verif) 'nettoyage du string et remplacement de la virgule par un point
                                If Verif = False Then
                                    msg = "Problème de conversion de la donnée valeur altimétrique du niveau bas de la couche de sol du sondage, lors de la lecture du fichier des données pressiométriques."
                                    MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Exit Do
                                End If
                                If Double.TryParse(titi(2), .Zbase) = False Then
                                    msg = "La donnée valeur altimétrique du niveau bas de la couche de sol figurant dans le fichier des données des valeurs caractéristiques n'est pas numérique."
                                    MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                                Else
                                    .Zbase = CDbl(titi(2))
                                End If
                                Call Gestion_CelluleDbl(titi(3), Verif) 'nettoyage du string et remplacement de la virgule par un point
                                If Verif = False Then
                                    msg = "Problème de conversion de la donnée Pl* du sondage, lors de la lecture du fichier des données pressiométriques."
                                    MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Exit Do
                                End If
                                If Double.TryParse(titi(3), .Pl) = False Then
                                    msg = "La donnée Pression limite nette de la couche de sol figurant dans le fichier des données des valeurs caractéristiques n'est pas numérique."
                                    MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                                Else
                                    .Pl = CDbl(titi(3))
                                End If

                                Dim i As Integer = 3
                                Dim compteur As Integer = 0
                                Dim toto As String = String.Empty
                                'Nom de la couche de sol qui peut comporter jusqu'à 15 mots
                                Do
                                    i += 1
                                    If i = TotalDonnees + 1 Then Exit Do
                                    compteur += 1
                                Loop While titi(i) <> Nothing
                                For i = 4 To 4 + compteur - 3
                                    toto += titi(i) & " "
                                Next
                                .NomLithologie = toto
                                If Integer.TryParse(titi(4 + compteur - 2), .Categorie) = False Then
                                    msg = titi(compteur + 1).ToString & " : La donnée Categorie de la couche de sol figurant dans le fichier des données des valeurs caractéristiques n'est pas valeur entière."
                                    MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                                Else
                                    .Categorie = CInt(titi(4 + compteur - 2))
                                End If

                            End With
                            SondageModele.Lithologie.Add(MesureLitho1)
                        End If

                End Select

            Loop Until line Is Nothing
        Catch ex As Exception
            MessageBox.Show("Erreur lors de la lecture du fichier des données pressiométriques et lithologiques" & Environment.NewLine & "Exception: " & ex.Message & ex.StackTrace, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information)
            Verif = False
        Finally
            If Not myStreamReader Is Nothing Then myStreamReader.Close() ' Close the object if it has been created.
        End Try
    End Sub

    ''' <summary>Lecture des données dans le fichier profil Pressiométrique et lithologique</summary>
    ''' <param name="FileName">Nom du fichier des données profil lithologique</param>
    ''' <param name="Verif">Renvoie FALSE si pb de lecture</param>
    Private Sub Lecture_DataPressioLitho(ByVal FileName As String, ByRef Verif As Boolean)
        Dim myStreamReader As StreamReader = Nothing
        Dim line, titi(), msg As String
        Dim msg1 As String = String.Empty
        Dim NumLine As Integer
        Dim TotalDonnees As Integer = 0 'nombre total de données sur la ligne correspondante
        Dim TitreChapitre As Integer
        Dim LectureLigne As Boolean = False
        Dim sondModele As New clsSondagePressio
        Try
            myStreamReader = File.OpenText(FileName)
            NumLine = 0 : TotalDonnees = 2
            line = myStreamReader.ReadLine()
            Do
                ReDim titi(TotalDonnees)
                Call LectureGen(line, titi, Verif, TotalDonnees) : If Verif = False Then myStreamReader.Close() : Exit Sub  'ligne suivante
                msg = String.Empty : NumLine += 1
                Select Case NumLine
                    Case 1 'date
                        If TryCast(titi(2), String) Is Nothing Then
                            msg = "Erreur de conversion de la donnée date sondage, lors de la lecture du fichier des données pressiométriques."
                            MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                        Else
                            If Date.TryParse(titi(2), sondModele.DateSondage) = False Then
                                msg = "La valeur date sondage figurant dans le fichier des données pressiométriques ne correspond pas à une valeur de date."
                                MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                            Else
                                sondModele.DateSondage = CDate(titi(2))
                                TotalDonnees = 2 '2 pour le sondage
                            End If
                        End If
                    Case 2 'nom sondage
                        If TryCast(titi(2), String) Is Nothing Then
                            msg = "La référence du sondage n'est pas correctement indiquée dans le fichier des données pressiométriques."
                            MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                        Else
                            sondModele.NomSondage = titi(2)
                            TotalDonnees = 2 '2 pour l'eau
                        End If
                    Case 3 'eau   
                        If TryCast(titi(2), String) Is Nothing Then
                            msg = "Erreur de conversion de la donnée valeur altimétrique du niveau d'eau, lors de la lecture du fichier des données pressiométriques."
                            MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                        Else
                            'vérification que la chaine de caractère est bien une valeur numérique
                            Call Gestion_CelluleDbl(titi(2), Verif) 'nettoyage du string et remplacement de la virgule par un point
                            If Verif = False Then
                                msg = "Problème de conversion de la donnée valeur altimétrique du niveau d'eau, lors de la lecture du fichier des données pressiométriques."
                                MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Exit Do
                            End If
                            If Double.TryParse(titi(2), sondModele.Zeau) = False Then
                                msg = "La donnée valeur altimétrique du niveau d'eau figurant dans le fichier des données pressiométriques n'est pas numérique."
                                MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                            Else
                                sondModele.Zeau = CDbl(titi(2))
                                If sondModele.Zeau = 1001 Then
                                    Select Case Aff.ModeleCalcul
                                        Case 2
                                            RbtnNappeEauabsente.Checked = True
                                            lblNappeEauAltimetrie.Visible = False : TxtZeauModTerrain.Visible = False : lblNappeEau_m.Visible = False
                                        Case 3
                                            RbtnNappeEauabsentePM.Checked = True
                                            lblNappeEauAltimetriePM.Visible = False : txtZeauModPieuModele.Visible = False : lblNappeEau_mPM.Visible = False
                                    End Select
                                    sondModele.NappeEau = False
                                Else
                                    Select Case Aff.ModeleCalcul
                                        Case 2
                                            RbtnNappeEauReconnue.Checked = True
                                            lblNappeEauAltimetrie.Visible = True : TxtZeauModTerrain.Visible = True : lblNappeEau_m.Visible = True : TxtZeauModTerrain.Text = sondModele.Zeau.ToString("#0.00")
                                        Case 3
                                            RbtnNappeEauReconnuePM.Checked = True
                                            lblNappeEauAltimetriePM.Visible = True : txtZeauModPieuModele.Visible = True : lblNappeEau_mPM.Visible = True : txtZeauModPieuModele.Text = sondModele.Zeau.ToString("#0.00")
                                    End Select
                                    sondModele.NappeEau = True
                                End If
                                TotalDonnees = 1 '1 pour le pressio
                            End If
                        End If
                    Case Else
                        msg1 = titi(1).Substring(0, 1)
                        If msg1 = "p" Then 'pour Pressiométrique
                            TitreChapitre = 1 : LectureLigne = False : TotalDonnees = 4
                        ElseIf msg1 = "l" Then 'pour lithologique
                            TitreChapitre = 2 : LectureLigne = False : TotalDonnees = 15
                        Else
                            LectureLigne = True
                        End If
                        If LectureLigne = True Then
                            Select Case TitreChapitre
                                Case 1 ' "press"
                                    If titi.Length < 4 Then
                                        Select Case titi.Length
                                            Case 0
                                                msg = "Aucune donnée dans le fichier pressiométrique"
                                            Case 1
                                                msg = "Il manque 3 données parmi Z, pl*, pf* et EM dans le fichier pressiométrique"
                                            Case 2
                                                msg = "Il manque 2 données parmi Z, pl*, pf* et EM dans le fichier pressiométrique"
                                            Case 3
                                                msg = "Il manque 1 donnée parmi Z, pl*, pf* et EM dans le fichier pressiométrique"
                                        End Select
                                        MessageBox.Show("Erreur lors de la lecture du fichier des données pressiométriques " & Environment.NewLine & msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information)
                                        Verif = False : Exit Do
                                    Else
                                        Dim MesurePressio1 As New clsValPressio()
                                        With MesurePressio1
                                            Call Gestion_CelluleDbl(titi(1), Verif) 'nettoyage du string et remplacement de la virgule par un point
                                            If Verif = False Then
                                                msg = "Problème de conversion de la donnée côte altimétrique du sondage, lors de la lecture du fichier des données pressiométriques."
                                                MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Exit Do
                                            End If
                                            If Double.TryParse(titi(1), .Z) = False Then
                                                msg = "La donnée côte altimétrique du sondage figurant dans le fichier des données des valeurs pressiométriques n'est pas numérique."
                                                MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                                            Else
                                                .Z = CDbl(titi(1))
                                            End If
                                            Call Gestion_CelluleDbl(titi(2), Verif) 'nettoyage du string et remplacement de la virgule par un point
                                            If Verif = False Then
                                                msg = "Problème de conversion de la donnée Em du sondage, lors de la lecture du fichier des données pressiométriques."
                                                MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Exit Do
                                            End If
                                            If Double.TryParse(titi(2), .Em) = False Then
                                                msg = "La donnée  Em figurant dans le fichier des données des valeurs pressiométriques n'est pas numérique."
                                                MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                                            Else
                                                .Em = CDbl(titi(2))
                                            End If
                                            Call Gestion_CelluleDbl(titi(3), Verif) 'nettoyage du string et remplacement de la virgule par un point
                                            If Verif = False Then
                                                msg = "Problème de conversion de la donnée Pf* du sondage, lors de la lecture du fichier des données pressiométriques."
                                                MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Exit Do
                                            End If
                                            If Double.TryParse(titi(3), .Pf) = False Then
                                                msg = "La donnée Pf* figurant dans le fichier des données des valeurs pressiométriques n'est pas numérique."
                                                MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                                            Else
                                                .Pf = CDbl(titi(3))
                                            End If
                                            Call Gestion_CelluleDbl(titi(4), Verif) 'nettoyage du string et remplacement de la virgule par un point
                                            If Verif = False Then
                                                msg = "Problème de conversion de la donnée Pl* du sondage, lors de la lecture du fichier des données pressiométriques."
                                                MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Exit Do
                                            End If
                                            If Double.TryParse(titi(4), .Pl) = False Then
                                                msg = "La donnée Pl* figurant dans le fichier des données des valeurs pressiométriques n'est pas numérique."
                                                MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                                            Else
                                                .Pl = CDbl(titi(4))
                                            End If
                                        End With
                                        sondModele.MesurePressio.Add(MesurePressio1)
                                    End If
                                    TotalDonnees = 4 '1 pour le pressio
                                Case 2 '"litho"
                                    If titi.Length < 4 Then
                                        Select Case titi.Length
                                            Case 0
                                                msg = "Aucune donnée dans le fichier profil lithologique"
                                            Case 1
                                                msg = "Il manque 3 données parmi Ztoit, Zbase, lithologie et classe de sol dans le fichier profil lithologique"
                                            Case 2
                                                msg = "Il manque 2 données parmi Ztoit, Zbase, lithologie et classe de sol dans le fichier profil lithologique"
                                            Case 3
                                                msg = "Il manque 1 donnée parmi Ztoit, Zbase, lithologie et classe de sol dans le fichier profil lithologique"
                                        End Select
                                        MessageBox.Show("Erreur lors de la lecture du fichier des données profil lithologique" & Environment.NewLine & msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information)
                                        Verif = False : Exit Do
                                    Else
                                        Dim MesureLitho1 As New clsLithologie
                                        With MesureLitho1
                                            Call Gestion_CelluleDbl(titi(1), Verif) 'nettoyage du string et remplacement de la virgule par un point
                                            If Verif = False Then
                                                msg = "Problème de conversion de la donnée valeur altimétrique du niveau haut de la couche de sol du sondage, lors de la lecture du fichier des données pressiométriques."
                                                MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Exit Do
                                            End If
                                            If Double.TryParse(titi(1), .Ztoit) = False Then
                                                msg = "La donnée valeur altimétrique du niveau haut de la couche de sol figurant dans le fichier des données des valeurs lithologiques n'est pas numérique."
                                                MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                                            Else
                                                .Ztoit = CDbl(titi(1))
                                            End If
                                            Call Gestion_CelluleDbl(titi(2), Verif) 'nettoyage du string et remplacement de la virgule par un point
                                            If Verif = False Then
                                                msg = "Problème de conversion de la donnée valeur altimétrique du niveau bas de la couche de sol du sondage, lors de la lecture du fichier des données pressiométriques."
                                                MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Exit Do
                                            End If
                                            If Double.TryParse(titi(2), .Zbase) = False Then
                                                msg = "La donnée valeur altimétrique du niveau bas de la couche de sol figurant dans le fichier des données des valeurs lithologiques n'est pas numérique."
                                                MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                                            Else
                                                .Zbase = CDbl(titi(2))
                                            End If
                                            Dim i As Integer = 2
                                            Dim compteur As Integer = 0
                                            Dim toto As String = String.Empty
                                            Do
                                                i += 1
                                                If i = TotalDonnees + 1 Then Exit Do
                                                compteur += 1
                                            Loop While titi(i) <> Nothing
                                            For i = 3 To 3 + compteur - 3
                                                toto += titi(i) & " "
                                            Next
                                            .NomLithologie = toto
                                            If Integer.TryParse(titi(3 + compteur - 2), .Categorie) = False Then
                                                msg = "La donnée Categorie de la couche de sol figurant dans le fichier des données des valeurs lithologiques n'est pas valeur entière."
                                                MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information) : Verif = False : Exit Do
                                            Else
                                                .Categorie = CInt(titi(3 + compteur - 2))
                                            End If
                                        End With
                                        sondModele.Lithologie.Add(MesureLitho1)
                                    End If
                                    TotalDonnees = 15 '1 pour le lithologie
                            End Select
                        End If
                End Select
                line = myStreamReader.ReadLine()
            Loop Until line Is Nothing
            Select Case Aff.ModeleCalcul
                Case 1 'Valeurs caractéristiques
                    Stop 'le logiciel ne doit pas venir dans ce programme       
                Case 2 'Sondage 5m
                    SondageModele = sondModele
                Case 3 'Pieu modèle
                    Dim i, j As Integer
                    i = CInt(LblSondagesNB.Text) 'nombre total de sondages
                    j = CbSondages.SelectedIndex + 1   'n° de sondage affiché
                    If SondagesPressio.Count < i And i = j Then
                        'Total 2 sondages et sondage n°2 affiché et uniquement sondage n°1 renseigné --> j'ajoute le sondage
                        SondagesPressio.Add(sondModele)
                    ElseIf SondagesPressio.Count < i And i < j And SondagesPressio.Count >= j Then
                        'Total 3 sondages et sondage n°2 affiché et  sondage n°1, 2  renseignés --> je remplace le sondage affiché
                        SondagesPressio.RemoveAt(j - 1)
                        SondagesPressio.Insert(j - 1, sondModele)
                    ElseIf i >= j And SondagesPressio.Count = i Then
                        'Total 3 sondages et sondage n°2 affiché et  sondage n°1, 2 et 3 renseignés --> je remplace le sondage affiché
                        SondagesPressio.RemoveAt(j - 1)
                        SondagesPressio.Insert(j - 1, sondModele)
                    End If
            End Select

        Catch ex As Exception
            MessageBox.Show("Erreur lors de la lecture du fichier des données pressiométriques et lithologiques" & Environment.NewLine & "Exception: " & ex.Message & ex.StackTrace, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information)
            Verif = False
        Finally
            If Not myStreamReader Is Nothing Then myStreamReader.Close() ' Close the object if it has been created.
        End Try
    End Sub

    Private Sub BtnSauvegarder_Click(sender As Object, e As EventArgs) Handles BtnSauvegarder.Click
        Try
            If Aff.FileName = String.Empty Then
                Dim message, title, defaultValue As String
                message = "Validez le nom de l'affaire"   ' Set prompt.
                title = "Calcul de la portance de pieux par la méthode pressiométrique"   ' Set title.
                defaultValue = "Exemple 1"   ' Set default value.

                Dim ib = New InputBox With {.Text = title}
                ib.Lbl.Text = message
                ib.ShowDialog()
                ib.Txt.Focus()
                Dim result As String = String.Empty
                result = ib.Txt.Text   'Aff.FileName = InputBox(message, title, defaultValue)
                If String.IsNullOrEmpty(result) And ib.DialogResult = DialogResult.OK Then
                    Dim msg As String = String.Empty
                    msg = "Aucun nom de répertoire de sauvegarde n'a été indiqué. Aucune sauvegarde n'a été effectuée."
                    MessageBox.Show("Erreur:" & Environment.NewLine & msg, title, MessageBoxButtons.OK, MessageBoxIcon.Error, MessageBoxDefaultButton.Button1)
                    Exit Sub
                ElseIf ib.DialogResult = DialogResult.Cancel Then
                    Exit Sub
                End If
                result = result.Trim(New Char() {" "c, ","c, ";"c, "_"c, ":"c}) 'supprime les espaces , _ en debut et fin de chaine 'supprime les espaces en debut et fin de chaine

                Aff.FileName = result
                If My.Computer.FileSystem.DirectoryExists(Aff.msgData) = False Then
                    Aff.msgData = Directory.GetCurrentDirectory.ToString()
                End If
                If My.Computer.FileSystem.DirectoryExists(Aff.msgResult) = False Then
                    Aff.msgResult = Directory.GetCurrentDirectory.ToString()
                End If
                Aff.FileName = Aff.msgData & "\" & Aff.FileName & ".txt"
                ib.Dispose()
            End If
            Dim Verif As Boolean = True
            'Lecture et vérification des données
            Call Lecture_Donnees(Verif)
            If Verif = False Then MessageBox.Show("Erreur dans les données. La séquence de calcul ne peut être lancée." & Environment.NewLine & "Merci de bien vouloir apporter les corrections nécessaires.", Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Error, MessageBoxDefaultButton.Button1) : Exit Sub
            Call Coherence_donnees(Verif)
            If Verif = False Then Exit Sub
            Call SerializeData()
            MessageBox.Show("Sauvegarde réalisée ", Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information, MessageBoxDefaultButton.Button1)
        Catch ex As Exception
            MessageBox.Show("Erreur inattendue lors de la sauvegarde des données de calcul " & Environment.NewLine & ex.Message & Environment.NewLine & ex.StackTrace, Me.Text,
                                    MessageBoxButtons.OK, MessageBoxIcon.Error, MessageBoxDefaultButton.Button1)
        End Try
    End Sub
    Private Sub BtnCharger_Click(sender As Object, e As EventArgs) Handles BtnCharger.Click
        Dim OpenFileDialog As New OpenFileDialog
        Try
            With OpenFileDialog
                If Aff.msgData <> String.Empty Then
                    .InitialDirectory = Aff.msgData
                Else
                    .InitialDirectory = My.Computer.FileSystem.SpecialDirectories.MyDocuments
                End If

                .FileName = "" 'pour éviter tout affichage initial dans la boite de dialogue
                .CheckFileExists = True ' Vérifie que le fichier sélectionné existe. Sinon, la boîte de dialogue affiche un avertissement.
                .CheckPathExists = True ' Vérifie que le chemin sélectionné existe. Sinon, la boîte de dialogue affiche un avertissement.
                .DefaultExt = "txt" ' Obtient ou définit une extension par défaut. N'inclut pas le "." de début.
                ' Retourne le fichier référencé par un lien ? Si la valeur de retour est False, retourne simplement le fichier de liaison
                ' sélectionné. Si elle est True, retourne le fichier lié au fichier LNK.
                .DereferenceLinks = True
                .Title = "Ouvrir le projet"
                ' .InitialDirectory = Directory.GetParent(Directory.GetCurrentDirectory).ToString() & "\data"
                .FilterIndex = 1
                .Filter = "Fichiers textes (*.txt)|*.txt|Tous les fichiers (*.*)|*.*"
                .Multiselect = False
                .RestoreDirectory = True
                .ShowHelp = True ' Affiche le bouton Aide et la case à cocher Lecture seule ?
                .ShowReadOnly = False
                ' Commence avec la case à cocher Lecture seule activée ? Ceci n'est justifié que si ShowReadOnly a la valeur True.
                .ReadOnlyChecked = False
                If .ShowDialog = System.Windows.Forms.DialogResult.OK Then
                    If .FileName <> "" Then
                        'remise à zero générale
                        Pieux = New clsPieux
                        SondageModele = New clsSondagePressio
                        Aff = New clsAffaire
                        'Appel au fichier
                        Dim Racine As String = String.Empty
                        Dim NomAffaire As String = String.Empty
                        Dim Verif As Boolean = True
                        Call Lecture_chaine_Racine(.FileName, Racine, NomAffaire, Verif)
                        If Verif = True Then
                            Call DeSerializeData(.FileName, Racine, Verif)
                            If Verif = True Then
                                If Aff.FileName <> .FileName Then Aff.FileName = .FileName
                                If Aff.i_data = 1 AndAlso Aff.msgData <> (Directory.GetCurrentDirectory.ToString() & "\Data") Then
                                    'Si Aff.i_data = 1 alors je force  Aff.msgData = Directory.GetCurrentDirectory.ToString() & "\data"
                                    Aff.msgData = Directory.GetCurrentDirectory.ToString() & "\Data" 'je conserve le Aff.i_data = 1 
                                    MessageBox.Show("L'adresse du répertoire par défaut du fichier de données a été modifiée." & Environment.NewLine & "Voir dans le formulaire Configuration, la nouvelle adresse.", Me.Text,
                                MessageBoxButtons.OK, MessageBoxIcon.Information)
                                Else
                                    'Aff.i_data = 2  
                                    'Vérification que le répertoire Racine existe sur l'ordinateur
                                    's'il existe, je conserve le Aff.i_data = 2 sinon je reviens au répertoire par défaut
                                    If My.Computer.FileSystem.DirectoryExists(Aff.msgData) = False Then
                                        Aff.i_data = 1 : Aff.msgData = Directory.GetCurrentDirectory.ToString() & "\Data"
                                        MessageBox.Show("L'adresse du répertoire du fichier de données n'est pas accessible ou n'existe pas." & Environment.NewLine &
                                "Provisoirement, le fichier de données sera sauvegardé dans le répertoire suivant :" & Environment.NewLine & Aff.msgData.ToString, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information)
                                    End If
                                End If
                                If Aff.i_result = 1 AndAlso Aff.msgResult <> (Directory.GetCurrentDirectory.ToString() & "\Note_de_calcul") Then
                                    'Si Aff.i_result = 1 alors je force  Aff.msgResult = Directory.GetCurrentDirectory.ToString() & "\Note_de_calcul"
                                    Aff.msgResult = Directory.GetCurrentDirectory.ToString() & "\Note_de_calcul"
                                    MessageBox.Show("L'adresse du répertoire par défaut des notes de calcul a été modifiée." & Environment.NewLine & "Voir ci-dessous la nouvelle adresse.", Me.Text,
                              MessageBoxButtons.OK, MessageBoxIcon.Information)
                                Else
                                    'Aff.i_result = 2  
                                    'Vérification que le répertoire Racine existe sur l'ordinateur
                                    's'il existe, je conserve le Aff.i_result = 2 sinon je reviens au répertoire par défaut
                                    If My.Computer.FileSystem.DirectoryExists(Aff.msgResult) = False Then
                                        Aff.i_result = 1 : Aff.msgResult = Directory.GetCurrentDirectory.ToString() & "\Note_de_calcul"
                                        MessageBox.Show("L'adresse du répertoire de la note de calcul n'est pas accessible ou n'existe pas." & Environment.NewLine &
                                "Provisoirement, la note de calcul sera sauvegardée dans le répertoire suivant :" & Environment.NewLine & Aff.msgResult.ToString, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information)
                                    End If
                                End If
                                'la deserialization est OK
                                Me.Text = "Portance de pieu par mesures pressiométriques : [ " & NomAffaire.ToString & " ]"
                                'Pour affichage
                                '--> onglet valeurs pieux
                                Call Affichage_onglet1()
                                '--> onglet valeurs terrain
                                Call Affichage_onglet2()

                            Else
                                'Pb sur la deserialization 
                                Me.Text = "Portance de pieu par mesures pressiométriques : [ aucun fichier de données ]"
                                MessageBox.Show("Pb sur la deserialization du fichier Data", "Ouverture du fichier data: ", MessageBoxButtons.OK, MessageBoxIcon.Error)
                            End If
                        Else
                            Me.Text += ": [ aucun fichier de données ]"
                        End If
                    Else
                        Me.Text = "Portance de pieu par mesures pressiométriques : [ aucun fichier de données ]"
                        MessageBox.Show("Aucun nom de fichier Data n'a été indiqué.", "Ouverture du fichier data: ", MessageBoxButtons.OK, MessageBoxIcon.Error)
                    End If
                End If

            End With
        Catch ex As Exception
            Me.Text += ": [ aucun fichier de données ]"
            MessageBox.Show("Erreur lors de la lecture du fichier: " & Environment.NewLine & ex.Message & ex.StackTrace, "Ouverture de fichier data: " & Aff.FileName, MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub
    Private Sub BtnReinitialiser_Click(sender As Object, e As EventArgs) Handles BtnReinitialiser.Click
        'remise à zero générale
        Pieux = New clsPieux
        SondageModele = New clsSondagePressio
        SondagesPressio = New List(Of clsSondagePressio)
        With Aff
            .msg_Avertiss.Clear()
            .SurfInvestGeotechLargeur = 0
            .SurfInvestGeotechLongueur = 0
            'je conserve les autres données
        End With
        'onglet 1
        'je ne fais rien, je pars depuis les données déjà affichées
        'onglet 2
        Call Affichage_onglet2()
    End Sub

    Private Sub Affichage_onglet1()
        'catégorie assimilée pour les micropieux de catégorie 17 et 18
        lblCategorieMicropieux.Visible = False
        CbPieuCat1718.Visible = False
        BtnHlpCatEquivMicropieu.Visible = False
        'Application de la clause des pieux de grande longueur
        ChkbAbatGrandeLongueur.Visible = False : BtnHlpAbbat50.Visible = False
        'Application de la clause des pieux vibrofoncés
        ChkbVibrofoncage.Visible = False : BtnHlpVibrofoncage.Visible = False
        'Clause de la prise en compte de la résistance de pointe pour les micropieux
        ChkbResistancePointe.Visible = False : BtnHlpResistancePointe.Visible = False

        With Pieux
            TxtPieuNom.Text = .Nom
            'côtes
            Select Case .CotesNGF
                Case True
                    RbtnCoteNGF.Checked = True
                    TxtCoteTerrainNaturel.Text = .CoteTN.ToString("#0.00")
                Case False
                    RbtnCoteRelative.Checked = True
                    TxtCoteTerrainNaturel.Text = "0.00"
            End Select
            txtCoteTete.Text = .CoteTete.ToString("#0.00")
            txtCotePointe.Text = .CotePointe.ToString("#0.00")

            Select Case .Categorie
                Case 1  ' FS
                    CbPieuType.Text = CbPieuType.Items(0).ToString
                    'Application de la clause des pieux de grande longueur
                    ChkbAbatGrandeLongueur.Visible = True : BtnHlpAbbat50.Visible = True
                    If .AbattementGrandeLongueur = True Then ChkbAbatGrandeLongueur.Checked = True Else ChkbAbatGrandeLongueur.Checked = False
                Case 2 ' FB
                    CbPieuType.Text = CbPieuType.Items(1).ToString
                    'Application de la clause des pieux de grande longueur
                    ChkbAbatGrandeLongueur.Visible = True : BtnHlpAbbat50.Visible = True
                    If .AbattementGrandeLongueur = True Then ChkbAbatGrandeLongueur.Checked = True Else ChkbAbatGrandeLongueur.Checked = False
                Case 3
                    CbPieuType.Text = CbPieuType.Items(2).ToString
                Case 4
                    CbPieuType.Text = CbPieuType.Items(2).ToString
                Case 5
                    Select Case .Abreviation
                        Case "FSR"
                            CbPieuType.Text = CbPieuType.Items(4).ToString
                            'Application de la clause des pieux de grande longueur
                            ChkbAbatGrandeLongueur.Visible = True : BtnHlpAbbat50.Visible = True
                            If .AbattementGrandeLongueur = True Then ChkbAbatGrandeLongueur.Checked = True Else ChkbAbatGrandeLongueur.Checked = False
                        Case "FBR"
                            CbPieuType.Text = CbPieuType.Items(5).ToString
                            'Application de la clause des pieux de grande longueur
                            ChkbAbatGrandeLongueur.Visible = True : BtnHlpAbbat50.Visible = True
                            If .AbattementGrandeLongueur = True Then ChkbAbatGrandeLongueur.Checked = True Else ChkbAbatGrandeLongueur.Checked = False
                        Case "PU"
                            CbPieuType.Text = CbPieuType.Items(6).ToString
                    End Select
                Case 6
                    Select Case .Abreviation
                        Case "FTC"
                            CbPieuType.Text = CbPieuType.Items(7).ToString
                        Case "FTCD"
                            CbPieuType.Text = CbPieuType.Items(8).ToString
                    End Select
                Case 7
                    CbPieuType.Text = CbPieuType.Items(9).ToString
                Case 8
                    CbPieuType.Text = CbPieuType.Items(10).ToString
                Case 9
                    Select Case .Abreviation
                        Case "BPF"
                            CbPieuType.Text = CbPieuType.Items(11).ToString
                        Case "BPR"
                            CbPieuType.Text = CbPieuType.Items(12).ToString
                    End Select
                Case 10
                    CbPieuType.Text = CbPieuType.Items(13).ToString
                Case 11
                    CbPieuType.Text = CbPieuType.Items(14).ToString
                Case 12
                    CbPieuType.Text = CbPieuType.Items(15).ToString
                Case 13 'BAO
                    CbPieuType.Text = CbPieuType.Items(16).ToString
                    'Application de la clause du vibrofonçage pour les pieux de type BAO, HB et PP
                    ChkbVibrofoncage.Visible = True : BtnHlpVibrofoncage.Visible = True
                    If .Vibrofoncage = True Then ChkbVibrofoncage.Checked = True Else ChkbVibrofoncage.Checked = False
                Case 14 'HB
                    CbPieuType.Text = CbPieuType.Items(17).ToString
                    'Application de la clause du vibrofonçage pour les pieux de type BAO, HB et PP
                    ChkbVibrofoncage.Visible = True : BtnHlpVibrofoncage.Visible = True
                    If .Vibrofoncage = True Then ChkbVibrofoncage.Checked = True Else ChkbVibrofoncage.Checked = False
                Case 15
                    CbPieuType.Text = CbPieuType.Items(18).ToString
                Case 16 'PP
                    CbPieuType.Text = CbPieuType.Items(19).ToString
                    'Application de la clause du vibrofonçage pour les pieux de type BAO, HB et PP
                    ChkbVibrofoncage.Visible = True : BtnHlpVibrofoncage.Visible = True
                    If .Vibrofoncage = True Then ChkbVibrofoncage.Checked = True Else ChkbVibrofoncage.Checked = False
                Case 17 ' les micropieux de type I
                    CbPieuType.Text = CbPieuType.Items(20).ToString
                    'catégorie assimilée pour les micropieux de catégorie 17 et 18
                    lblCategorieMicropieux.Visible = True
                    CbPieuCat1718.Visible = True
                    BtnHlpCatEquivMicropieu.Visible = True
                    If .CategorieAssimil < 17 Then
                        CbPieuCat1718.Text = CbPieuCat1718.Items(.CategorieAssimil - 1).ToString
                    ElseIf .CategorieAssimil = 19 Then
                        CbPieuCat1718.Text = CbPieuCat1718.Items(16).ToString
                    ElseIf .CategorieAssimil = 20 Then
                        CbPieuCat1718.Text = CbPieuCat1718.Items(17).ToString
                    Else
                        CbPieuCat1718.Text = CbPieuCat1718.Items(0).ToString
                    End If
                    'Clause de la prise en compte de la résistance de pointe pour les micropieux
                    ChkbResistancePointe.Visible = True : BtnHlpResistancePointe.Visible = True
                    If .AucuneResistancedePointe = False Then ChkbResistancePointe.Checked = True Else ChkbResistancePointe.Checked = False
                Case 18 ' les micropieux de type II
                    CbPieuType.Text = CbPieuType.Items(21).ToString
                    'catégorie assimilée pour les micropieux de catégorie 17 et 18
                    lblCategorieMicropieux.Visible = True
                    CbPieuCat1718.Visible = True
                    BtnHlpCatEquivMicropieu.Visible = True
                    If .CategorieAssimil < 17 Then
                        CbPieuCat1718.Text = CbPieuCat1718.Items(.CategorieAssimil - 1).ToString
                    ElseIf .CategorieAssimil = 19 Then
                        CbPieuCat1718.Text = CbPieuCat1718.Items(16).ToString
                    ElseIf .CategorieAssimil = 20 Then
                        CbPieuCat1718.Text = CbPieuCat1718.Items(17).ToString
                    Else
                        CbPieuCat1718.Text = CbPieuCat1718.Items(0).ToString
                    End If
                    'Clause de la prise en compte de la résistance de pointe pour les micropieux
                    ChkbResistancePointe.Visible = True : BtnHlpResistancePointe.Visible = True
                    If .AucuneResistancedePointe = False Then ChkbResistancePointe.Checked = True Else ChkbResistancePointe.Checked = False
                Case 19
                    Select Case .Abreviation
                        Case "PIGU"
                            CbPieuType.Text = CbPieuType.Items(22).ToString
                        Case "MIGU"
                            CbPieuType.Text = CbPieuType.Items(23).ToString
                    End Select
                    'Clause de la prise en compte de la résistance de pointe pour les micropieux
                    ChkbResistancePointe.Visible = True : BtnHlpResistancePointe.Visible = True
                    If .AucuneResistancedePointe = False Then ChkbResistancePointe.Checked = True Else ChkbResistancePointe.Checked = False
                Case 20
                    Select Case .Abreviation
                        Case "PIRS"
                            CbPieuType.Text = CbPieuType.Items(24).ToString
                        Case "MIRS"
                            CbPieuType.Text = CbPieuType.Items(25).ToString
                    End Select
                    'Clause de la prise en compte de la résistance de pointe pour les micropieux
                    ChkbResistancePointe.Visible = True : BtnHlpResistancePointe.Visible = True
                    If .AucuneResistancedePointe = False Then ChkbResistancePointe.Checked = True Else ChkbResistancePointe.Checked = False
            End Select

            Select Case .Categorie
                Case 1, 2, 5
                    Select Case .Geom
                        Case 1 'circulaire
                            CbPieuGeometrie.Text = CbPieuGeometrie.Items(0).ToString
                            TxtPieuDiam.Text = (.Ø * 100).ToString("#0")
                        Case 2 'rectangulaire
                            CbPieuGeometrie.Text = CbPieuGeometrie.Items(1).ToString
                            TxtPieuDiam.Text = (.W * 100).ToString("#0")
                            TxtForageLongueur.Text = (.L * 100).ToString("#0")
                        Case 3 'rectangulaire arrondi
                            CbPieuGeometrie.Text = CbPieuGeometrie.Items(2).ToString
                            TxtPieuDiam.Text = (.W * 100).ToString("#0")
                            TxtForageLongueur.Text = (.L * 100).ToString("#0")
                    End Select
                Case 3, 4, 6, 11, 17 To 20 'circulaire uniquement
                    CbPieuGeometrie.Text = CbPieuGeometrie.Items(0).ToString '  .Geom = 1
                    TxtPieuDiam.Text = (.Ø * 100).ToString("#0")
                Case 7 'Vissé moulé = Fût avec hélice ordinaire ou  épaisse
                    Select Case .Geom
                        Case 1 ' 
                            CbPieuGeometrie.Text = CbPieuGeometrie.Items(0).ToString 'Fût avec hélice ordinaire
                        Case 2 ' 
                            CbPieuGeometrie.Text = CbPieuGeometrie.Items(1).ToString 'Fût avec hélice épaisse
                    End Select
                    TxtPieuDiam.Text = (.Bc * 100).ToString("#0")
                    TxtForageLongueur.Text = (.Bf * 100).ToString("#0")
                    txtDim3.Text = (.R * 100).ToString("#0")
                    txtDim4.Text = (.Df * 100).ToString("#0")
                Case 8 'Vissé tubé
                    CbPieuGeometrie.Text = CbPieuGeometrie.Items(0).ToString 'circulaire Vissé tubé
                    TxtPieuDiam.Text = (.Øoutil * 100).ToString("#0")
                    TxtForageLongueur.Text = (.Øfut * 100).ToString("#0")
                Case 9 'Battu béton préfabriqué et Battu béton précontraint
                    Select Case .Geom
                        Case 1 ' 
                            CbPieuGeometrie.Text = CbPieuGeometrie.Items(0).ToString 'circulaire
                            TxtPieuDiam.Text = (.Ø * 100).ToString("#0")
                        Case 2 ' 
                            CbPieuGeometrie.Text = CbPieuGeometrie.Items(1).ToString 'rectangulaire
                            TxtPieuDiam.Text = (.W * 100).ToString("#0")
                            TxtForageLongueur.Text = (.L * 100).ToString("#0")
                    End Select
                Case 10 'pieux métallique battus enrobés
                    CbPieuGeometrie.Text = CbPieuGeometrie.Items(0).ToString 'circulaire pieux métallique battus enrobés
                    TxtPieuDiam.Text = (.Ab * 100).ToString("#0")
                    TxtForageLongueur.Text = (.Ps * 100).ToString("#0")
                    txtDim3.Text = (.Bmin * 100).ToString("#0")
                Case 12, 13 'pieux battus caisson acier fermé (BAF) ou battus acier ouvert (BAO)
                    Select Case .Geom
                        Case 1   'circulaire
                            CbPieuGeometrie.Text = CbPieuGeometrie.Items(0).ToString 'circulaire
                            TxtPieuDiam.Text = (.Ø * 100).ToString("#0")
                        Case 4 ''caisson palplanche
                            CbPieuGeometrie.Text = CbPieuGeometrie.Items(1).ToString 'rectangulaire = caisson palplanche
                            TxtPieuDiam.Text = (.Ab * 10000).ToString("#0")
                            TxtForageLongueur.Text = (.Ps * 100).ToString("#0")
                            txtDim3.Text = (.Bmin * 100).ToString("#0")
                    End Select
                Case 14, 15 'pieux métallique profilé H, et H injecté
                    CbPieuGeometrie.Text = CbPieuGeometrie.Items(0).ToString 'pieux métallique profilé H, et H injecté
                    TxtPieuDiam.Text = (.b * 100).ToString("#0")
                    TxtForageLongueur.Text = (.h * 100).ToString("#0")
                Case 16 'palplanche
                    CbPieuGeometrie.Text = CbPieuGeometrie.Items(0).ToString 'palplanche
                    TxtPieuDiam.Text = (.Ab * 10000).ToString("#0")
                    TxtForageLongueur.Text = (.Ps * 100).ToString("#0")
                    txtDim3.Text = (.Bmin * 100).ToString("#0")
            End Select

            'Effet de groupe
            If .EffetGroupe = False Then
                RbtnEffetGroupeSansObjet.Checked = True
            Else
                RbtnEffetGroupeAvec.Checked = True
                TxtEffetGroupemx.Text = .ef_Gr_mx.ToString("#0") : TxtEffetGroupenx.Text = .ef_Gr_nx.ToString("#0") : TxtEffetGroupeDx.Text = .ef_Gr_dx.ToString("#0.00")
                If .ef_Gr_my > 0.1 Then
                    ChkbEffetGroupe1ligne.Checked = False
                    TxtEffetGroupemy.Text = .ef_Gr_my.ToString("#0") : TxtEffetGroupeny.Text = .ef_Gr_ny.ToString("#0") : TxtEffetGroupedy.Text = .ef_Gr_dy.ToString("#0.00")
                Else
                    ChkbEffetGroupe1ligne.Checked = True
                End If
            End If
        End With
    End Sub
    Private Sub Affichage_onglet2()

        Select Case Aff.ModeleCalcul
            Case 1  'Procédure Modèle de terrain - Valeurs caractéristiques
                Me.Text = "Portance pieu - Modèle de terrain - Valeurs caractéristiques: [" & Aff.FileName.Substring(Aff.FileName.LastIndexOf("\") + 1) & " ]"
                'onglet valeurs terrain
                DgvCoucheModTerrain.Visible = False
                DgvLithologieModTerrain.Visible = True
                Call Affichage_DgvLithologieModTerrain_ValCar()
                With SondageModele
                    If .Plmoyen = True Then ChkbPlmoyen.Visible = True Else ChkbPlmoyen.Visible = False
                    'If .MesurePressio.Count = 0 OrElse .Lithologie.Count = 0 Then
                    '    DgvLithologieModTerrain.Rows.Clear() : DgvLithologieModTerrain.RowCount = 1
                    'Else
                    Call Affichage_Valeurs_Pressiometriques_Lithologiques_ModeleTerrain_ValCar()
                    'End If
                    RbtnModelTerrainValCar.Checked = True
                    ChkbPlmoyen.Visible = True
                    If .Plmoyen = True Then ChkbPlmoyen.Checked = True Else ChkbPlmoyen.Checked = False
                    If .NappeEau = True Then
                        RbtnNappeEauReconnue.Checked = True : TxtZeauModTerrain.Visible = True : TxtZeauModTerrain.Text = .Zeau.ToString("#0.00") : lblNappeEau_m.Visible = True
                    Else
                        RbtnNappeEauabsente.Checked = True : TxtZeauModTerrain.Visible = False : lblNappeEau_m.Visible = False
                    End If
                End With
                If Pieux.Tassement = True Then ChkbTassementModTerrain.Checked = True Else ChkbTassementModTerrain.Checked = False
            Case 2 'Procédure Modèle de terrain - Sondage 5m
                Me.Text = "Portance pieu - Modèle de terrain - Sondage moins de 5m: [" & Aff.FileName.Substring(Aff.FileName.LastIndexOf("\") + 1) & " ]"
                ChkbPlmoyen.Visible = False
                'onglet valeurs terrain
                '-- Tableau des valeurs pressiométriques
                With DgvCoucheModTerrain
                    .Visible = True
                    .ColumnCount = 4
                    .Columns.Item(0).HeaderText = "Z" & Environment.NewLine & "(m)"
                    .Columns.Item(1).HeaderText = "Em" & Environment.NewLine & "(MPa)"
                    .Columns.Item(2).HeaderText = "Pf*" & Environment.NewLine & "(MPa)"
                    .Columns.Item(3).HeaderText = "Pl*" & Environment.NewLine & "(MPa)"
                End With
                '-- Tableau des valeurs lithologiques
                DgvLithologieModTerrain.Visible = True
                Call Affichage_DgvLithologieModTerrain_Sondage()
                With SondageModele
                    'If .MesurePressio.Count = 0 OrElse .Lithologie.Count = 0 Then
                    '    DgvCoucheModTerrain.Rows.Clear() : DgvCoucheModTerrain.RowCount = 1
                    '    DgvLithologieModTerrain.Rows.Clear() : DgvLithologieModTerrain.RowCount = 1
                    'Else
                    Call Affichage_Valeurs_Pressiometriques_ModeleTerrain_Sondage5m()
                    Call Affichage_Valeurs_Lithologiques_ModeleTerrain_Sondage5m()
                    'End If
                    RbtnModelTerrain5m.Checked = True
                    If .NappeEau = True Then
                        RbtnNappeEauReconnue.Checked = True : TxtZeauModTerrain.Visible = True : TxtZeauModTerrain.Text = .Zeau.ToString("#0.00") : lblNappeEau_m.Visible = True
                    Else
                        RbtnNappeEauabsente.Checked = True : TxtZeauModTerrain.Visible = False : lblNappeEau_m.Visible = False
                    End If
                End With
                If Pieux.Tassement = True Then ChkbTassementModTerrain.Checked = True Else ChkbTassementModTerrain.Checked = False
            Case 3 'Procédure Pieu Modèle
                Me.Text = "Portance pieu - Pieu Modèle: [" & Aff.FileName.Substring(Aff.FileName.LastIndexOf("\") + 1) & " ]"
                Dim i As Integer   'i = n° de sondage
                TxtZhomoLongueur.Text = Aff.SurfInvestGeotechLongueur.ToString("#0.00")
                TxtZhomoLargeur.Text = Aff.SurfInvestGeotechLargeur.ToString("#0.00")
                i = CbSondages.SelectedIndex + 1 '= n° de sondage sélectionné
                With SondagesPressio
                    If SondagesPressio.Count > 0 Then
                        LblSondagesNB.Text = SondagesPressio.Count.ToString
                        CbSondages.Items.Clear()
                        For i = 1 To SondagesPressio.Count
                            CbSondages.Items.Add("Sondage n°" & i.ToString("#0"))
                        Next
                        i = 1
                        CbSondages.Text = "Sondage n°" & i.ToString("#0")
                        Call Affichage_Valeurs_Pressiometriques_PieuModele(i)
                        Call Affichage_Valeurs_Lithologiques_PieuModele(i)
                        If .Item(i - 1).NappeEau = True Then
                            RbtnNappeEauReconnuePM.Checked = True : txtZeauModPieuModele.Visible = True : txtZeauModPieuModele.Text = .Item(i - 1).Zeau.ToString("#0.00") : lblNappeEau_mPM.Visible = True
                        Else
                            RbtnNappeEauabsentePM.Checked = True : txtZeauModPieuModele.Visible = False : lblNappeEau_mPM.Visible = False
                        End If

                    End If
                End With
                If Pieux.Tassement = True Then ChkbTassementModPieuModele.Checked = True Else ChkbTassementModPieuModele.Checked = False
                'End If
        End Select

    End Sub

    Private Sub RbtnModelTerrain5m_CheckedChanged(sender As Object, e As EventArgs) Handles RbtnModelTerrain5m.CheckedChanged
        If RbtnModelTerrain5m.Checked = True Then
            LblPressio.Text = "Profil pressiométrique" : LblLithologie.Visible = True
            Aff.ModeleCalcul = 2
            Call Affichage_onglet2()
        End If
    End Sub
    Private Sub RbtnModelTerrainValCar_CheckedChanged(sender As Object, e As EventArgs) Handles RbtnModelTerrainValCar.CheckedChanged
        If RbtnModelTerrainValCar.Checked = True Then
            LblPressio.Text = "Profil pressiométrique et lithologique" : LblLithologie.Visible = False
            Aff.ModeleCalcul = 1
            Call Affichage_onglet2()
        End If
    End Sub

    Private Sub Affichage_DgvLithologieModTerrain_ValCar()
        With DgvLithologieModTerrain
            .Columns.Clear()
            .Location = New Point(8, 116)
            .Width = 814
            .Height = 297
            .RowHeadersVisible = True
            .RowHeadersWidth = 40 ' sinon l'icone d'erreur ne s'affiche pas
            AddTextBoxColumns(ColumnName.Z_toit)
            AddTextBoxColumns(ColumnName.Z_base)
            AddTextBoxColumns(ColumnName.Pl)
            AddTextBoxColumns(ColumnName.Lithologie)
            AddComboBoxColumns()
            .EnableHeadersVisualStyles = False
            With .ColumnHeadersDefaultCellStyle
                .BackColor = Color.LightGray
                .ForeColor = Color.Black
                .Font = New Font("Times New Roman", 10)
            End With
            .Rows(0).Cells(0).Selected = True
        End With
    End Sub
    Private Sub Affichage_DgvLithologieModTerrain_Sondage()
        With DgvLithologieModTerrain
            .Columns.Clear()
            .Location = New Point(320, 116)
            .Width = 540
            .Height = 297
            .RowHeadersVisible = True
            .RowHeadersWidth = 40 ' sinon l'icone d'erreur ne s'affiche pas
            AddTextBoxColumns(ColumnName.Z_toit)
            AddTextBoxColumns(ColumnName.Z_base)
            AddTextBoxColumns(ColumnName.Lithologie)
            AddComboBoxColumns() '  .Columns(3).Name = "Classe de Sol"
            .EnableHeadersVisualStyles = False
            With .ColumnHeadersDefaultCellStyle
                .BackColor = Color.LightGray
                .ForeColor = Color.Black
                .Font = New Font("Times New Roman", 10)
            End With
            .Rows(0).Cells(0).Selected = True
        End With
    End Sub
    Private Sub AddTextBoxColumns(ByVal Nom As ColumnName)
        Dim textBoxColumn As DataGridViewTextBoxColumn
        With DgvLithologieModTerrain
            textBoxColumn = CreateTextBoxColumn(Nom)
            .Columns.Add(textBoxColumn)
        End With
    End Sub
    Private Function CreateTextBoxColumn(ByVal Nom As ColumnName) As DataGridViewTextBoxColumn
        Dim column As New DataGridViewTextBoxColumn()
        With column
            Select Case Nom
                Case ColumnName.Z_toit
                    .HeaderText = "Z" & Environment.NewLine & "toit" & Environment.NewLine & "(m)"
                    .Width = 50 : If Aff.ModeleCalcul = 1 Then .Width = 90
                    .ToolTipText = "Altimétrie supérieure de la couche de sol"
                Case ColumnName.Z_base
                    .HeaderText = "Z" & Environment.NewLine & "base" & Environment.NewLine & "(m)"
                    .Width = 50 : If Aff.ModeleCalcul = 1 Then .Width = 90
                    .ToolTipText = "Altimétrie inférieure de la couche de sol"
                Case ColumnName.Lithologie
                    .HeaderText = "Lithologie"
                    .Width = 200 : If Aff.ModeleCalcul = 1 Then .Width = 300
                    .ToolTipText = "Caractéristiques géologiques de la couche de sol, format libre"
                Case ColumnName.Pl
                    .HeaderText = "Pl*" & Environment.NewLine & "(MPa)"
                    .Width = 50 : If Aff.ModeleCalcul = 1 Then .Width = 90
                    .ToolTipText = "Pression limite nette"
            End Select
            Dim style As DataGridViewCellStyle = New DataGridViewCellStyle()
            style.Alignment = DataGridViewContentAlignment.MiddleCenter
            column.DefaultCellStyle.Alignment = style.Alignment
        End With
        Return column
    End Function
    Private Sub AddComboBoxColumns()
        Dim comboboxColumn As DataGridViewComboBoxColumn
        With DgvLithologieModTerrain
            comboboxColumn = CreateComboBoxColumn()
            .Columns.Add(comboboxColumn)
        End With
    End Sub
    Private Function CreateComboBoxColumn() As DataGridViewComboBoxColumn
        Dim column As New DataGridViewComboBoxColumn()
        With column
            '.DataPropertyName = ColumnName.Classe_de_Sol.ToString()
            .HeaderText = "Classe de Sol"
            .DropDownWidth = 100
            .Width = 180
            .MaxDropDownItems = 3
            .FlatStyle = FlatStyle.Standard
            .Items.AddRange("Remblai", "Argiles et limons", "Sols intermédiaires de classe 1", "Sols intermédiaires de classe 2", "Sables et graves", "Craies", "Marnes et calcaires marneux", "Rocher")
            Dim style As DataGridViewCellStyle = New DataGridViewCellStyle()
            style.Alignment = DataGridViewContentAlignment.MiddleCenter
            column.DefaultCellStyle.Alignment = style.Alignment
        End With
        Return column
    End Function
    Enum ColumnName
        Z_toit
        Z_base
        Lithologie
        Pl
        Classe_de_Sol
    End Enum

    Private Sub RbtnNappeEauabsente_CheckedChanged(sender As Object, e As EventArgs) Handles RbtnNappeEauabsente.CheckedChanged
        If RbtnNappeEauabsente.Checked = True Then
            lblNappeEauAltimetrie.Visible = False : TxtZeauModTerrain.Visible = False : lblNappeEau_m.Visible = False
        End If
    End Sub

    Private Sub RbtnNappeEauReconnue_CheckedChanged(sender As Object, e As EventArgs) Handles RbtnNappeEauReconnue.CheckedChanged
        If RbtnNappeEauReconnue.Checked = True Then
            lblNappeEauAltimetrie.Visible = True : lblNappeEau_m.Visible = True : TxtZeauModTerrain.Visible = True : TxtZeauModTerrain.Focus()
        End If
    End Sub

    Private Sub RbtnNappeEauabsentePM_CheckedChanged(sender As Object, e As EventArgs) Handles RbtnNappeEauabsentePM.CheckedChanged
        If RbtnNappeEauabsentePM.Checked = True Then
            lblNappeEauAltimetriePM.Visible = False : txtZeauModPieuModele.Visible = False : lblNappeEau_mPM.Visible = False
        End If
    End Sub

    Private Sub RbtnNappeEauReconnuePM_CheckedChanged(sender As Object, e As EventArgs) Handles RbtnNappeEauReconnuePM.CheckedChanged
        If RbtnNappeEauReconnuePM.Checked = True Then
            lblNappeEauAltimetriePM.Visible = True : lblNappeEau_mPM.Visible = True : txtZeauModPieuModele.Visible = True : txtZeauModPieuModele.Focus()
        End If
    End Sub

#Region " Code de lecture et d'écriture du fichier de données "

#Region "Sérialization"
    ''' <summary>Routine sauvegardant les données objet par sérialization </summary>
    Private Sub SerializeData()
        Dim Fichier_Pieux As String = String.Empty
        Dim Fichier_SondagePressio As String = String.Empty
        'Dim Fichier_ValPressio As String = String.Empty
        Dim Fichier_Affaire As String = String.Empty

        Dim myStreamWriter As StreamWriter = Nothing
        Try
            myStreamWriter = File.CreateText(Aff.FileName)
            myStreamWriter.WriteLine("Pieux par la méthode Pressiométrique - Fichiers de sauvegarde de l'affaire")
            Fichier_Pieux = "Fichier_Pieux_" & Mise_en_Forme_date(CStr(DateTime.Now))
            myStreamWriter.WriteLine(Fichier_Pieux)
            Fichier_SondagePressio = "Fichier_SondagePressio_" & Mise_en_Forme_date(CStr(DateTime.Now))
            myStreamWriter.WriteLine(Fichier_SondagePressio)
            'Fichier_Barrette = "Fichier_Barrette_" & Mise_en_Forme_date(CStr(DateTime.Now))
            'myStreamWriter.WriteLine(Fichier_Barrette)
            Fichier_Affaire = "Fichier_Affaire_" & Mise_en_Forme_date(CStr(DateTime.Now))
            myStreamWriter.WriteLine(Fichier_Affaire)
            myStreamWriter.Flush()
        Catch exc As Exception
            MessageBox.Show("Le fichier de sauvegarde ne peut être crée." & Environment.NewLine & "SVP, verifiez que le nom du fichier est correct, et que vouz avez la permission de lire ou d'écrire " +
              "dans le répertoire indiqué." & Environment.NewLine & Environment.NewLine & "Erreur: " & exc.Message, "Sauvegarde des données", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        Finally
            ' fermer le fichier si pas de création possible
            If myStreamWriter IsNot Nothing Then myStreamWriter.Close()
        End Try
        'Sérialise les objets
        Call SerializeSysKeys(Aff.msgData & "\" & Fichier_Pieux & ".xml", Pieux)
        Select Case Aff.ModeleCalcul
            Case 1 'Procédure modèle de terrain - Valeurs caractéristiques
                Call SerializeSysKeys(Aff.msgData & "\" & Fichier_SondagePressio & ".xml", SondageModele)
            Case 2 'Procédure modèle de terrain - Sondage 5m
                Call SerializeSysKeys(Aff.msgData & "\" & Fichier_SondagePressio & ".xml", SondageModele)
            Case 3 'Procédure Pieu modèle
                Call SerializeSysKeys(Aff.msgData & "\" & Fichier_SondagePressio & ".xml", SondagesPressio)
        End Select

        '  Call SerializeSysKeys(Aff.msgData & "\" & Fichier_Barrette & ".xml", Barrette)
        Call SerializeSysKeys(Aff.msgData & "\" & Fichier_Affaire & ".xml", Aff)
    End Sub
    Private Sub SerializeSysKeys(ByVal Path As String, ByVal Objet As Object)
        Try
            Call SaveXmlData(Path, Objet)
        Catch ex As Exception
            MessageBox.Show("Problème de sérialisation!" & Environment.NewLine & "Erreur: " & ex.Message, "Sauvegarde des données", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End Try
    End Sub
    Private Sub SaveXmlData(ByVal Path As String, ByVal Objet As Object)
        Dim Type As Type = Objet.GetType
        Dim Serializeur As New XmlSerializer(Type)
        Dim Fi As New FileInfo(Path)
        If Fi.Directory.Exists = False Then System.IO.Directory.CreateDirectory(Fi.DirectoryName)
        'Sérialization
        Using fs As New FileStream(Path, FileMode.Create, FileAccess.Write)
            Serializeur.Serialize(fs, Objet)
            fs.Close()
        End Using
    End Sub
#End Region

#Region "Déserialization"
    ''' <summary>Routine lisant et affectant les données objet sauvegardées par sérialization </summary>
    ''' <param name="PathFileData">chemin d'accès complet du fichier Data/nom du fichier data </param>
    ''' <param name="Racine">Nom du répertoire dans lequel se trouve le fichier data</param>
    ''' <param name="Verif">Renvoie FALSE si l'extraction de la racine n'a pu être réalisé</param>
    Public Sub DeSerializeData(ByVal PathFileData As String, ByVal Racine As String, ByRef Verif As Boolean)
        Dim toto, titi(1) As String
        Dim Fichier_Pieux As String = String.Empty
        'Dim Fichier_Lithologie As String = String.Empty
        Dim Fichier_SondagePressio As String = String.Empty
        'Dim Fichier_ValPressio As String = String.Empty
        Dim Fichier_Affaire As String = String.Empty
        Dim myStreamReader As StreamReader = Nothing

        Try
            myStreamReader = File.OpenText(PathFileData)
            toto = myStreamReader.ReadLine 'barre de titre
            toto = myStreamReader.ReadLine : Call LectureGen(toto, titi, Verif) : If Verif = False Then Exit Sub 'ligne suivante
            Fichier_Pieux = CStr(titi(1))
            toto = myStreamReader.ReadLine : Call LectureGen(toto, titi, Verif) : If Verif = False Then Exit Sub 'ligne suivante
            Fichier_SondagePressio = CStr(titi(1))
            'toto = myStreamReader.ReadLine : Call Lecture_chaine(toto, titi) 'ligne suivante
            'Fichier_Barrette = CStr(titi(1))
            toto = myStreamReader.ReadLine : Call LectureGen(toto, titi, Verif) : If Verif = False Then Exit Sub 'ligne suivante
            Fichier_Affaire = CStr(titi(1))
        Catch exc As Exception
            MessageBox.Show("Le fichier de sauvegarde ne peut être lu." & Environment.NewLine & "SVP, verifiez que le nom du fichier est correct, et que vouz avez la permission de lire ou d'écrire " &
              "dans le répertoire indiqué." & Environment.NewLine & Environment.NewLine & "Erreur: " & exc.Message, "Lecture des données", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            Verif = False
        Finally
            If myStreamReader IsNot Nothing Then myStreamReader.Close() 'fermer le fichier si pas de création possible
        End Try
        'DéSérialise les objets
        If Racine <> Aff.msgData Then
            Call DeSerializeSysKeys(Racine & "\" & Fichier_Affaire & ".xml", Aff, 1)
            Call DeSerializeSysKeys(Racine & "\" & Fichier_Pieux & ".xml", Pieux, 2)
            Select Case Aff.ModeleCalcul
                Case 1 'Procédure modèle de terrain - Valeurs caractéristiques
                    Call DeSerializeSysKeys(Racine & "\" & Fichier_SondagePressio & ".xml", SondageModele, 3)
                Case 2 'Procédure modèle de terrain - Sondage 5m
                    Call DeSerializeSysKeys(Racine & "\" & Fichier_SondagePressio & ".xml", SondageModele, 3)
                Case 3 'Procédure Pieu modèle
                    Call DeSerializeSysKeys(Racine & "\" & Fichier_SondagePressio & ".xml", SondagesPressio, 3)
            End Select
        Else
            Call DeSerializeSysKeys(Aff.msgData & "\" & Fichier_Affaire & ".xml", Aff, 1)
            Call DeSerializeSysKeys(Aff.msgData & "\" & Fichier_Pieux & ".xml", Pieux, 2)
            Select Case Aff.ModeleCalcul
                Case 1 'Procédure modèle de terrain - Valeurs caractéristiques
                    Call DeSerializeSysKeys(Aff.msgData & "\" & Fichier_SondagePressio & ".xml", SondageModele, 3)
                Case 2 'Procédure modèle de terrain - Sondage 5m
                    Call DeSerializeSysKeys(Aff.msgData & "\" & Fichier_SondagePressio & ".xml", SondageModele, 3)
                Case 3 'Procédure Pieu modèle
                    Call DeSerializeSysKeys(Aff.msgData & "\" & Fichier_SondagePressio & ".xml", SondagesPressio, 3)
            End Select

        End If

    End Sub
    Private Sub DeSerializeSysKeys(ByVal Path As String, ByVal Objet As Object, ByVal i As Integer)

        Call LoadXmlData(Path, Objet)
        Select Case i
            Case 1
                Aff = CType(Objet, clsAffaire)
            Case 2
                Pieux = CType(Objet, clsPieux)
            Case 3
                Select Case Aff.ModeleCalcul
                    Case 1 'Procédure modèle de terrain - Valeurs caractéristiques
                        SondageModele = CType(Objet, clsSondagePressio)
                    Case 2 'Procédure modèle de terrain - Sondage 5m
                        SondageModele = CType(Objet, clsSondagePressio)
                    Case 3 'Procédure Pieu modèle
                        SondagesPressio = CType(Objet, List(Of clsSondagePressio))
                End Select

        End Select

    End Sub
    Private Sub LoadXmlData(ByVal Path As String, ByRef Objet As Object)

        ' Try
        Dim Type As Type = Objet.GetType
        Dim Serializeur As New XmlSerializer(Type)
        Dim Fi As New FileInfo(Path)
        If Fi.Directory.Exists = False Then System.IO.Directory.CreateDirectory(Fi.DirectoryName)
        'Sérialization
        Using fs As New FileStream(Path, FileMode.Open, FileAccess.Read)
            Objet = Serializeur.Deserialize(fs)
            fs.Close()
        End Using
        'Catch ex As Exception
        '    MessageBox.Show("Problème de Désérialisation!" & Environment.NewLine & "Erreur: " + ex.Message, "Module LoadXmlData", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        'End Try
    End Sub

#End Region
#End Region

#Region "Effet de groupe"
    Private Sub RbtnEffetGroupeSansObjet_CheckedChanged(sender As Object, e As EventArgs) Handles RbtnEffetGroupeSansObjet.CheckedChanged
        If RbtnEffetGroupeSansObjet.Checked = True Then
            lblnx.Visible = False : TxtEffetGroupenx.Visible = False : lblmx.Visible = False : TxtEffetGroupemx.Visible = False : lbldx.Visible = False : TxtEffetGroupeDx.Visible = False : LblEffetGroupem.Visible = False
            lblny.Visible = False : TxtEffetGroupeny.Visible = False : lblmy.Visible = False : TxtEffetGroupemy.Visible = False : lbldy.Visible = False : TxtEffetGroupedy.Visible = False : LblEffetGroupeligneYm.Visible = False
            ChkbEffetGroupe1ligne.Visible = False
        End If
    End Sub

    Private Sub RbtnEffetGroupeAvec_CheckedChanged(sender As Object, e As EventArgs) Handles RbtnEffetGroupeAvec.CheckedChanged
        If RbtnEffetGroupeAvec.Checked = True Then
            lblnx.Visible = True : TxtEffetGroupenx.Visible = True : lblmx.Visible = True : TxtEffetGroupemx.Visible = True : lbldx.Visible = True : TxtEffetGroupeDx.Visible = True : LblEffetGroupem.Visible = True : TxtEffetGroupemx.Focus()
            lblny.Visible = True : TxtEffetGroupeny.Visible = True : lblmy.Visible = True : TxtEffetGroupemy.Visible = True : lbldy.Visible = True : TxtEffetGroupedy.Visible = True : LblEffetGroupeligneYm.Visible = True
            ChkbEffetGroupe1ligne.Visible = True : ChkbEffetGroupe1ligne.Checked = False
        End If
    End Sub
    Private Sub ChkbEffetGroupe1ligne_CheckedChanged(sender As Object, e As EventArgs) Handles ChkbEffetGroupe1ligne.CheckedChanged
        If ChkbEffetGroupe1ligne.Checked = True Then
            lblny.Visible = False : TxtEffetGroupeny.Visible = False : lblmy.Visible = False : TxtEffetGroupemy.Visible = False : lbldy.Visible = False : TxtEffetGroupedy.Visible = False : LblEffetGroupeligneYm.Visible = False
        Else
            lblny.Visible = True : TxtEffetGroupeny.Visible = True : lblmy.Visible = True : TxtEffetGroupemy.Visible = True : lbldy.Visible = True : TxtEffetGroupedy.Visible = True : LblEffetGroupeligneYm.Visible = True
        End If
    End Sub
#End Region

    Private Sub ChkbPlmoyen_CheckedChanged(sender As Object, e As EventArgs) Handles ChkbPlmoyen.CheckedChanged
        If ChkbPlmoyen.Checked = True Then
            With DgvLithologieModTerrain.Columns.Item(2)
                .HeaderText = "Pl" & Environment.NewLine & "(MPa)"
                .ToolTipText = "Pression limite moyenne"
            End With
        Else
            With DgvLithologieModTerrain.Columns.Item(2)
                .HeaderText = "Pl*" & Environment.NewLine & "(MPa)"
                .ToolTipText = "Pression limite nette"
            End With
        End If
    End Sub

    Private Sub frmPieu_Terrain_Pressio_FormClosing(sender As Object, e As FormClosingEventArgs) Handles Me.FormClosing
        frmMenu.Visible = True
    End Sub

    Private Sub BtnConfig_Click(sender As Object, e As EventArgs) Handles BtnConfig.Click
        Dim frm1 As frmConfig
        frm1 = New frmConfig
        frm1.Show()
    End Sub
End Class