﻿Imports System.IO
Public Class frmMenu

    ' Public Affichage As Integer

    Private Sub frmMenu_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        Dim r As DialogResult
        r = MessageBox.Show("Voulez-vous quitter l'application ?", Me.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1)
        If r = Windows.Forms.DialogResult.Yes Then e.Cancel = False Else e.Cancel = True
    End Sub
    Private Sub frmMenu_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'Chargement en mémoire du fichier config.ini
        Dim msg As String = String.Empty
        Dim filename As String = String.Empty
        Dim Verif As Boolean = True
        Try
            '--> création des répertoires data et note de calcul si n'existe pas
            If My.Computer.FileSystem.DirectoryExists(Directory.GetCurrentDirectory.ToString() & "\Data") = False Then
                My.Computer.FileSystem.CreateDirectory(Directory.GetCurrentDirectory.ToString() & "\Data")
            End If
            If My.Computer.FileSystem.DirectoryExists(Directory.GetCurrentDirectory.ToString() & "\Note_de_calcul") = False Then
                My.Computer.FileSystem.CreateDirectory(Directory.GetCurrentDirectory.ToString() & "\Note_de_calcul")
            End If

            '--> création des répertoires Aide si n'existe pas
            'ce qui est le cas lors de l'installation du logiciel
            If My.Computer.FileSystem.DirectoryExists(Directory.GetCurrentDirectory.ToString() & "\Aide") = False Then
                Try
                    Dim zipPath As String = Directory.GetCurrentDirectory.ToString() & "\Aide.zip"
                    My.Computer.FileSystem.CreateDirectory(Directory.GetCurrentDirectory.ToString() & "\Aide")
                    Dim extractPath As String = Directory.GetCurrentDirectory.ToString() & "\Aide"
                    System.IO.Compression.ZipFile.ExtractToDirectory(zipPath, extractPath)

                Catch ex As Exception
                    MessageBox.Show("Problème de décompression du fichier Aide.zip" & Environment.NewLine & "Exception: " & ex.Message, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
                End Try
            End If

            '--> création du fichier ini si n'existe pas
            filename = Directory.GetCurrentDirectory.ToString() & "\cfg_CalculetteMecaSol.ini" 'obligatoirement dans le répertoire racine
            If File.Exists(filename) = False Then
                Call Variables_generales() 'appel au module contenant les variables par defaut
                Call Ecriture_fichier_Cfg_Ini(filename, Verif) 'creation du fichier lors de l'installation du logiciel
                If Verif = False Then msg = "Erreur: " & Environment.NewLine & "Impossible de lire le fichier de configuration"
            Else
                'Affichage des valeurs en cours
                Try
                    Call Variables_generales() 'lecture variables par defaut
                    Call Lecture_fichier_Ini(filename, Verif) 'Initialisation du logiciel avec les préférences de l'utilisateur
                    If Verif = False Then
                        msg = "Erreur: " & Environment.NewLine & "Impossible de lire le fichier de configuration"
                        MessageBox.Show(msg, "Calculette Géotechnique", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
                    End If
                Catch ex As Exception
                    MessageBox.Show("Erreur lors du chargement du logiciel:" & Environment.NewLine & "Exception: " & ex.Message, "Module général", MessageBoxButtons.OK, MessageBoxIcon.Information)
                    ' Call Variables_generales() 'appel aux variables générales inscrites en dur dans le logiciel
                    MessageBox.Show("Appel à la configuration par défaut", "Module démarrage", MessageBoxButtons.OK, MessageBoxIcon.Information)
                End Try
            End If

            If msg <> String.Empty Then
                MessageBox.Show(msg, "Configuration", MessageBoxButtons.OK, MessageBoxIcon.Error)
                MessageBox.Show("Logiciel arreté", "Calculette Géotechnique", MessageBoxButtons.OK, MessageBoxIcon.Error)
                End
            End If
            Call ForceDot() 'pour éviter tout problème dans la lecture des nombres décimaux quelque soit la culture du PC sur lequel tourne le logiciel
        Catch exc As Exception
            msg = "Erreur: " & exc.Message
            MessageBox.Show(msg, "Calculette Géotechnique", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End Try
    End Sub

    ''' <summary>Programme Force la culture à utiliser le point pour les décimales</summary>
    Private Sub ForceDot() ' Force la culture à utiliser le point pour les décimales

        Dim oldDecimalSeparator As String = Application.CurrentCulture.NumberFormat.NumberDecimalSeparator

        If Not oldDecimalSeparator = "." Then ' Si ce n'est pas un point
            Dim forceDotCulture As Globalization.CultureInfo
            forceDotCulture = CType(Application.CurrentCulture.Clone(), Globalization.CultureInfo)
            forceDotCulture.NumberFormat.NumberDecimalSeparator = "."
            Application.CurrentCulture = forceDotCulture
        End If
    End Sub

#Region "Gestion des boutons d'appel aux différents programmes"

    Private Sub BtnPieuPressioModelTerrain_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnPieuPressioModelTerrain.Click
        Me.Hide()
        Dim frm1 As New frmPieu_Terrain_Pressio
        Aff.ModeleCalcul = 0 'non déterminé à ce stade mais pré-oriente vers une valeur 1 ou 2
        frm1.Show()
        frm1 = Nothing 'pour libérer la mémoire
    End Sub
    Private Sub BtnPieuPressioModelPieu_Click(sender As Object, e As EventArgs) Handles BtnPieuPressioModelPieu.Click
        Me.Hide()
        Dim frm1 As New frmPieu_Terrain_Pressio
        Aff.ModeleCalcul = 3
        frm1.Show()
        frm1 = Nothing 'pour libérer la mémoire
    End Sub
    Private Sub BtnPieuPenetroModelTerrain_Click(sender As Object, e As EventArgs) Handles BtnPieuPenetroModelTerrain.Click
        Me.Hide()
        Dim frm1 As New frmPieu_Terrain_Penetro
        Aff.ModeleCalcul = 4
        frm1.Show()
        frm1 = Nothing 'pour libérer la mémoire
    End Sub

    Private Sub BtnPieuPenetroModelPieu_Click(sender As Object, e As EventArgs) Handles BtnPieuPenetroModelPieu.Click
        Me.Hide()
        Dim frm1 As New frmPieu_Terrain_Penetro
        Aff.ModeleCalcul = 5
        frm1.Show()
        frm1 = Nothing 'pour libérer la mémoire
    End Sub
    Private Sub BtnPieuBetonResistanceStructurale_Click(sender As Object, e As EventArgs) Handles BtnPieuBetonResistanceStructurale.Click
        ' Me.Hide()
        Dim frm1 As New Capacite_Pieu_BA_EC2.frmCapacitePieu
        frm1.Show()
        frm1 = Nothing 'pour libérer la mémoire
    End Sub
    Private Sub BtnSemdev_Click(sender As Object, e As EventArgs) Handles BtnSemdev.Click
        '  Me.Hide()
        Dim frm1 As New Semdev.frmSemdev
        frm1.Show()
        frm1 = Nothing 'pour libérer la mémoire
    End Sub
#End Region

    Private Sub BtnApropos_Click(sender As System.Object, e As System.EventArgs) Handles BtnApropos.Click
        ' My.Forms.frmSplash.MdiParent = Me
        Try
            'Dim ADUpdateAsync As Deployment.Application.ApplicationDeployment
            'ADUpdateAsync = Deployment.Application.ApplicationDeployment.CurrentDeployment
            'Dim version As String = ADUpdateAsync.CurrentVersion.ToString()
            ' My.Forms.frmSplash.LblVersion.Text = "Version " & version
            Dim frm1 As New frmSplash
            frm1.Show()
            frm1 = Nothing 'pour libérer la mémoire
        Catch ex As Exception
            MessageBox.Show(ex.ToString, "Affichage version logiciel", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End Try
        ' My.Forms.frmSplash.Show()
    End Sub
    Private Sub BtnConfig_Click(sender As System.Object, e As System.EventArgs) Handles BtnConfig.Click
        Dim frm1 As New frmConfig
        frm1.Show()
        frm1 = Nothing 'pour libérer la mémoire
    End Sub
    Private Sub BtnAide_Click(sender As Object, e As EventArgs) Handles BtnAide.Click
        Try
            Dim KEY As Microsoft.Win32.RegistryKey = My.Computer.Registry.ClassesRoot.OpenSubKey("acroPDF.PDF")
            If KEY Is Nothing Then
                MessageBox.Show("Impossible d'accéder au lecteur pdf Acrobat Reader!" & Environment.NewLine & "Lecture manuel d'utilisation abandonnée.", Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
                Exit Sub
            End If
            Dim SousDossier1 As String = My.Application.Info.DirectoryPath 'répertoire dans lequel se trouve le logiciel Poutre BA
            Dim startInfo As New ProcessStartInfo("AcroRd32.exe") '("word.exe")
            startInfo.WindowStyle = ProcessWindowStyle.Normal
            startInfo.Arguments = SousDossier1 & "\MecaSol_Notice.pdf"
            Process.Start(startInfo.Arguments)
        Catch ex As Exception
            Dim msg As String = String.Empty
            msg = "Impossible d'afficher le manuel d'utilisation" & Environment.NewLine & "Exception: " & ex.Message
            MessageBox.Show(msg, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End Try
    End Sub


End Class
