﻿Imports System.IO
Public Class frmConfig

    Private Sub frmConfig_FormClosing(sender As Object, e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        frmMenu.Visible = True
    End Sub

    Private Sub frmConfig_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        Dim Verif As Boolean = True
        Dim filename As String

        Try

            If Aff.FileName = String.Empty Then
                filename = Directory.GetCurrentDirectory.ToString() & "\cfg_CalculetteMecaSol.ini" '--> le formulaire Menu assure la création du fichier ini si n'existe pas
                Me.Text = "Configuration du logiciel : [ Aucun projet en cours ]"
                'Affichage des valeurs en cours
                Call Lecture_fichier_Ini(filename, Verif) ' 
                If Verif = False Then Exit Sub
            Else
                Dim Racine As String = String.Empty
                Dim NomAffaire As String = String.Empty
                Call Lecture_chaine_Racine(Aff.FileName, Racine, NomAffaire, Verif)
                Me.Text = "Configuration du logiciel : [ " & NomAffaire.ToString & " ]"
            End If

            If Aff.i_data = 1 And Aff.msgData <> Directory.GetCurrentDirectory.ToString() & "\Data" Then
                Aff.msgData = Directory.GetCurrentDirectory.ToString() & "\Data" 'on conserve le Aff.i_data = 1
                MessageBox.Show("L'adresse du répertoire par défaut du fichier de données a été modifiée." & Environment.NewLine & "Voir ci-dessous la nouvelle adresse.", Me.Text,
                                MessageBoxButtons.OK, MessageBoxIcon.Information)

            ElseIf My.Computer.FileSystem.DirectoryExists(Aff.msgData) = False Then
                'Vérification que le répertoire Racine existe sur l'ordinateur
                's'il existe, je conserve le Aff.i_data = 2 sinon je reviens au répertoire par défaut
                Aff.i_data = 1 : Aff.msgData = Directory.GetCurrentDirectory.ToString() & "\Data"
                MessageBox.Show("L'adresse du répertoire du fichier de données n'est pas accessible ou n'existe pas." & Environment.NewLine &
                                "Provisoirement, le fichier de données sera sauvegardé dans le répertoire suivant :" & Environment.NewLine & Aff.msgData.ToString, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information)
            End If '
            If Aff.i_result = 1 And Aff.msgResult <> Directory.GetCurrentDirectory.ToString() & "\Note_de_calcul" Then
                Aff.msgResult = Directory.GetCurrentDirectory.ToString() & "\Note_de_calcul"
                MessageBox.Show("L'adresse du répertoire par défaut des notes de calcul a été modifiée." & Environment.NewLine & "Voir ci-dessous la nouvelle adresse.", Me.Text,
                               MessageBoxButtons.OK, MessageBoxIcon.Information)
                'Vérification que le répertoire Racine existe sur l'ordinateur
                's'il existe, je conserve le Aff.i_result = 2 sinon je reviens au répertoire par défaut
            ElseIf My.Computer.FileSystem.DirectoryExists(Aff.msgResult) = False Then
                Aff.i_result = 1 : Aff.msgResult = Directory.GetCurrentDirectory.ToString() & "\Note_de_calcul"
                MessageBox.Show("L'adresse du répertoire de la note de calcul n'est pas accessible ou n'existe pas." & Environment.NewLine &
                                "Provisoirement, la note de calcul sera sauvegardé dans le répertoire suivant :" & Environment.NewLine & Aff.msgResult.ToString, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information)
            End If
            Call Affichage()
        Catch ex As Exception
            MessageBox.Show("Erreur lors de la lecture du fichier de configuration: " & Environment.NewLine & ex.Message & ex.StackTrace, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End Try
    End Sub
    Private Sub BtnQuit_Click(sender As Object, e As EventArgs) Handles BtnQuit.Click
        Me.Dispose()
        Me.Close() 'quitte le formulaire
    End Sub
    Private Sub BtnOK_Click(sender As Object, e As EventArgs) Handles BtnOK.Click
        Dim Verif As Boolean = True
        Call Lecture(Verif)
        If Verif = False Then Exit Sub
        Me.Dispose()
        Me.Close() 'quitte le formulaire
    End Sub
    Private Sub BtnSauvegarde_Click(sender As System.Object, e As System.EventArgs) Handles BtnSauvegarde.Click
        Dim Verif As Boolean = True
        Dim filename As String

        filename = Directory.GetCurrentDirectory.ToString() & "\cfg_CalculetteMecaSol.ini"
        Call Lecture(Verif)
        If Verif = False Then Exit Sub
        Call Ecriture_fichier_Cfg_Ini(filename, Verif)
        If Verif = False Then Exit Sub

        MessageBox.Show("Fichier de configuration modifié avec succés.", Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information)

    End Sub
    Private Sub BtnReinit_Click(sender As System.Object, e As System.EventArgs) Handles BtnReinit.Click
        Dim reponse As DialogResult
        reponse = MessageBox.Show("Attention, vous allez modifier vos préférences !!!!" & Environment.NewLine & "Voulez-vous continuer?", "Calculette Géotechnique", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
        If reponse = Windows.Forms.DialogResult.Yes Then
            Call Variables_generales()   'appel au modules contenant les variables par defaut, écrites en dur dans le logiciel, se trouve dans le module General.vb
            Call Affichage()
        End If

    End Sub
    Private Sub Lecture(ByRef Verif As Boolean)
        Try
            'Onglet General
            If RbtnDatadefaut.Checked = True Then
                Aff.msgData = Directory.GetCurrentDirectory.ToString() & "\Data" : Aff.i_data = 1 ' Directory.GetParent(Directory.GetCurrentDirectory).ToString() 
            Else
                Aff.msgData = LblData.Text : Aff.i_data = 2
            End If
            If RbtnResultDefaut.Checked = True Then
                Aff.msgResult = Directory.GetCurrentDirectory.ToString() & "\Note_de_calcul" : Aff.i_result = 1 'Directory.GetParent(Directory.GetCurrentDirectory).ToString() 
            Else
                Aff.msgResult = LblResult.Text : Aff.i_result = 2
            End If
            Aff.Chantier = TxtChantier.Text
            Aff.Redacteur = TxtRedacteur.Text

            'onglet Editeur
            If RbtnEditeurInterne.Checked = True Then Aff.Editeur = 1
            If RbtnWordPad.Checked = True Then Aff.Editeur = 2
            If RbtnWord.Checked = True Then Aff.Editeur = 3
        Catch ex As Exception
            Verif = False
            MessageBox.Show("Erreur lors de lecture des données renseignées: " & Environment.NewLine & ex.Message & ex.StackTrace, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End Try
    End Sub
    Private Sub Affichage()
        'Onglet général
        TxtChantier.Text = Aff.Chantier
        TxtRedacteur.Text = Aff.Redacteur
        If Aff.i_result = 1 Then RbtnResultDefaut.Checked = True Else RbtnResultPerso.Checked = True
        If Aff.i_data = 1 Then RbtnDatadefaut.Checked = True Else RbtndataPerso.Checked = True
        LblData.Text = Aff.msgData
        LblResult.Text = Aff.msgResult

        'Onglet Editeur
        Select Case Aff.Editeur
            Case 1
                RbtnEditeurInterne.Checked = True
            Case 2
                RbtnWordPad.Checked = True
            Case 3
                RbtnWord.Checked = True
        End Select
    End Sub
    Private Sub BtnResultModif_Click(sender As System.Object, e As System.EventArgs) Handles BtnResultModif.Click
        Try
            With FolderBrowserDialog1
                'En principe, après avoir créé un FolderBrowserDialog, vous définissez RootFolder à l'emplacement à partir duquel commencer la navigation. 
                'Vous pouvez choisir un emplacement dans la liste des dossiers système spéciaux, notamment Program Files, Programmes, System ou Démarrage, qui contiennent des informations communes.  
                .RootFolder = Environment.SpecialFolder.Desktop
                ' Si vous le voulez, vous pouvez aussi définir la propriété Description afin de fournir des instructions supplémentaires à l'utilisateur.
                .Description = "Selectionnez le répertoire ..."
                ' Vous pouvez utiliser la propriété ShowNewFolderButton pour déterminer si l'utilisateur est en mesure de créer des dossiers à l'aide du bouton Nouveau dossier.
                .ShowNewFolderButton = True
                If .ShowDialog = DialogResult.OK Then
                    If .SelectedPath = String.Empty Then
                        MessageBox.Show("Aucune sélection", "Modification de répertoire ...", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
                    Else
                        LblResult.Text = .SelectedPath
                    End If
                End If
            End With
        Catch ex As Exception
            MessageBox.Show(ex.Message, "Modification de répertoire ...", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End Try
    End Sub

    Private Sub RbtnResultDefaut_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles RbtnResultDefaut.CheckedChanged
        If RbtnResultDefaut.Checked = True Then BtnResultModif.Visible = False : LblResult.Text = Directory.GetCurrentDirectory.ToString()
    End Sub

    Private Sub RbtnResultPerso_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles RbtnResultPerso.CheckedChanged
        If RbtnResultPerso.Checked = True Then BtnResultModif.Visible = True : BtnResultModif.Focus()
    End Sub

    Private Sub RbtnDatadefaut_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles RbtnDatadefaut.CheckedChanged
        If RbtnDatadefaut.Checked = True Then BtnDataModif.Visible = False : LblData.Text = Directory.GetCurrentDirectory.ToString()
    End Sub

    Private Sub RbtndataPerso_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles RbtndataPerso.CheckedChanged
        If RbtndataPerso.Checked = True Then BtnDataModif.Visible = True : BtnDataModif.Focus()
    End Sub

    Private Sub BtnDataModif_Click(sender As System.Object, e As System.EventArgs) Handles BtnDataModif.Click
        Try
            With FolderBrowserDialog1
                .RootFolder = Environment.SpecialFolder.Desktop
                .Description = "Selectionnez le répertoire ..."
                .ShowNewFolderButton = True
                If .ShowDialog = DialogResult.OK Then
                    If .SelectedPath = String.Empty Then
                        MessageBox.Show("Aucune sélection", "Modification de répertoire ...", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
                    Else
                        LblData.Text = .SelectedPath
                    End If
                End If
            End With
        Catch ex As Exception
            MessageBox.Show(ex.Message, "Modification de répertoire ...", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End Try
    End Sub

End Class