﻿Public Class clsValPressio

    Dim x_Em, x_Pf, x_Pl, x_Z As Double

    ''' <summary>
    ''' Cote altimétrique Z pour l'essai pressiométrique -  Unité:m
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks>La cote se détermine par rapport à la surface du terrain naturel</remarks>
    Public Property Z As Double
        Get
            Z = x_Z
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la Cote altimétrique Z de la couche de sol n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la Cote altimétrique Z de la couche de sol doit être positive.")
            Else
                x_Z = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Module pressiométrique Menard (Em) de la couche de sol mesuré à la profondeur Z - Unité:MPa
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Em As Double
        Get
            Em = x_Em
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur du Module pressiométrique Menard (Em) de la couche de sol n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur du Module pressiométrique Menard (Em) de la couche de sol doit être positive.")
            Else
                x_Em = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Pression limite nette (pl*) de la couche de sol mesurée à la profondeur Z - Unité: m / MPa
    ''' </summary>
    ''' <remarks></remarks>
    Public Property Pl As Double
        Get
            Pl = x_Pl
        End Get
        Set(value As Double)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la Pression limite nette (pl*) de la couche de sol n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la Pression limite nette (pl*) de la couche de sol doit être positive.")
            Else
                x_Pl = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Pression de fluage totale de la couche de sol mesuré à la profondeur Z - Unité: m / MPa
    ''' </summary>
    ''' <remarks></remarks>
    Public Property Pf As Double
        Get
            Pf = x_Pf
        End Get
        Set(value As Double)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la Pression de fluage totale (pf*) de la couche de sol n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la Pression de fluage totale (pf*) de la couche de sol doit être positive.")
            Else
                x_Pf = value
            End If
        End Set
    End Property
    Private Function IsNumeric(Expression As Object) As Boolean
        Dim isNum As Boolean 'Variable to collect the Return value of the TryParse method.
        Dim retNum As Double ' Define variable to collect out parameter of the TryParse method. If the conversion fails, the out parameter Is zero.

        '// The TryParse method converts a string in a specified style And culture-specific format to its double-precision floating point number equivalent.
        '// The TryParse method does Not generate an exception if the conversion fails. If the conversion passes, True Is returned. If it does Not, False Is returned.
        isNum = Double.TryParse(Convert.ToString(Expression), System.Globalization.NumberStyles.Any, System.Globalization.NumberFormatInfo.InvariantInfo, retNum)
        Return isNum
    End Function
End Class
