﻿Public Class clsValPenetro

    Private _a, _b, _Zh, _Zb As Double

    ''' <summary>
    ''' Cote altimétrique Zh pour déterminer la profondeur haute de la couche de sol -  Unité:m
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks>La cote se détermine par rapport à la surface du terrain naturel</remarks>
    Public Property Zh As Double
        Get
            Zh = _Zh
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la Cote altimétrique Z de la couche de sol n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la Cote altimétrique Z de la couche de sol doit être positive.")
            Else
                _Zh = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Cote altimétrique Zb pour déterminer la profondeur basse de la couche de sol -  Unité:m
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks>La cote se détermine par rapport à la surface du terrain naturel</remarks>
    Public Property Zb As Double
        Get
            Zb = _Zb
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la Cote altimétrique Z de la couche de sol n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la Cote altimétrique Z de la couche de sol doit être positive.")
            Else
                _Zb = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Coefficient directeur de la droite qc=a.z+b - Unité:MPa/m
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property a As Double
        Get
            a = _a
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur du Coefficient directeur de la droite qc=a.z+b n'est pas numérique.")
            Else
                _a = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Coefficient correctif de la droite qc=a.z+b - Unité: MPa
    ''' </summary>
    ''' <remarks></remarks>
    Public Property b As Double
        Get
            b = _b
        End Get
        Set(value As Double)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur du Coefficient correctif de la droite qc=a.z+b n'est pas numérique.")
            Else
                _b = value
            End If
        End Set
    End Property

    Private Function IsNumeric(Expression As Object) As Boolean
        Dim isNum As Boolean 'Variable to collect the Return value of the TryParse method.
        Dim retNum As Double ' Define variable to collect out parameter of the TryParse method. If the conversion fails, the out parameter Is zero.

        '// The TryParse method converts a string in a specified style And culture-specific format to its double-precision floating point number equivalent.
        '// The TryParse method does Not generate an exception if the conversion fails. If the conversion passes, True Is returned. If it does Not, False Is returned.
        isNum = Double.TryParse(Convert.ToString(Expression), System.Globalization.NumberStyles.Any, System.Globalization.NumberFormatInfo.InvariantInfo, retNum)
        Return isNum
    End Function
End Class
