﻿Public Class clsSondagePenetrometrique
    Private x_K, x_Ksout, x_Kinst, _hTotal As Double
    Private _Zeau As Double = 1001


    ''' <summary>
    ''' Encapsule des différentes mesures pénétrométriques - Unité: voir la classe
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Xml.Serialization.XmlArray(ElementName:="MesurePenetro")>
    <Xml.Serialization.XmlArrayItem("MesurePenetro", Type:=GetType(clsValPenetro))>
    Public Property MesurePenetro As New List(Of clsValPenetro)

    ''' <summary>
    ''' Encapsule des différentes valeurs lithologiques - Unité: voir la classe
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Xml.Serialization.XmlArray(ElementName:="Lithologie")>
    <Xml.Serialization.XmlArrayItem("Lithologie", Type:=GetType(clsLithologie))>
    Public Property Lithologie As New List(Of clsLithologie)

    ''' <summary>
    ''' Nom ou référence du sondage
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property NomSondage As String

    ''' <summary>
    '''Date du sondage : jour/mois/année = 01/12/2025
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property DateSondage As DateTime

    ''' <summary>
    '''Présence d'une nappe d'eau dans le terrain: TRUE si nappe d'eau / FALSE si pas de nappe d'eau
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property NappeEau As Boolean = False

    ''' <summary>
    ''' Altimétrie du niveau d'eau rencontré - Unité:m - Si la valeur est prise à 1001, le logiciel considère l'absence d'eau
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Zeau As Double
        Get
            Zeau = _Zeau
        End Get
        Set(value As Double)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de l'Altimétrie du niveau d'eau rencontré n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de l'Altimétrie du niveau d'eau rencontré doit être positive.")
            Else
                _Zeau = value
            End If
        End Set
    End Property

    ''' <summary>
    '''Le pénétromètre statique comporte un cône équipé ou pas d'une jupe: TRUE si cône avec jupe / FALSE si si cône sans jupe
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Jupe As Boolean = False

    ''' <summary>
    ''' Hauteur totale cumulée des couche de terrain au droit du sondage i - Unité: m
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Xml.Serialization.XmlIgnore> Public ReadOnly Property Htotal As Double
        Get
            Htotal = _hTotal
        End Get
    End Property

    ''' <summary>
    ''' Détermine plusieurs caractéristiques du sondage dont la hauteur des couches de terrain
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub Caracteristique_Sondage()
        Dim i As Integer
        _hTotal = 0
        If Lithologie.Count = 0 Then
            Throw New ArgumentException("Aucune couche de terrain n'a été renseignée.")
        End If
        For i = 1 To Lithologie.Count
            Lithologie.Item(i - 1).Caracteristique_Lithologie()
            _hTotal += Lithologie.Item(i - 1).hcouche
        Next
    End Sub
    Private Function IsNumeric(Expression As Object) As Boolean
        Dim isNum As Boolean 'Variable to collect the Return value of the TryParse method.
        Dim retNum As Double ' Define variable to collect out parameter of the TryParse method. If the conversion fails, the out parameter Is zero.

        '// The TryParse method converts a string in a specified style And culture-specific format to its double-precision floating point number equivalent.
        '// The TryParse method does Not generate an exception if the conversion fails. If the conversion passes, True Is returned. If it does Not, False Is returned.
        isNum = Double.TryParse(Convert.ToString(Expression), System.Globalization.NumberStyles.Any, System.Globalization.NumberFormatInfo.InvariantInfo, retNum)
        Return isNum
    End Function
End Class
