﻿Imports System.Math
Public Class clsPieux
    Private x_aire, x_coteSup, x_coteInf, x_CoteTN, x_CoteTete, x_CotePointe, x_D_effetGroupe, x_LongPieu, x_Incl, x_Ø, x_W, x_L, x_D, x_Inert, x_EIsout, x_EIinst, x_hsol, x_perimetre, x_Bc, x_Bf, x_R, x_Df, x_Øoutil, x_Øfut, x_b, x_h, x_Bmin As Double
    Dim _ef_Gr_dx, _ef_Gr_dy, _Hencastr As Double
    Private _Ancrage, x_Geom, x_Classe, x_Categorie, x_CategorieAssimil, _ef_Gr_mx, _ef_Gr_my, _ef_Gr_nx, _ef_Gr_ny As Integer
    Dim x_EffetGroupe As Boolean = False
    Dim x_AbattementGrandeLongueur As Boolean = True
    Dim x_Vibrofoncage As Boolean = False
    Dim x_Tassement As Boolean = False
    Dim x_AucuneResistancedePointe As Boolean = True
#Region "Géométrie"
    ''' <summary>
    ''' Nom du pieu = P1, P2, ...
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Nom As String

    ''' <summary>
    ''' Géométrie du pieu - variable suivant le type de pieu
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks> pour toutes les catégories de pieux:
    ''' 1 = circulaire / 2 = rectangulaire  / 3 = rectangulaire arrondi
    ''' sauf:
    ''' pour les Pieux H / geom = 1 uniquement = profilé H
    ''' pour les palplanches: geom = 1 uniquement = profilé palplanche
    ''' certaines catégories qui peuvent avoir des caissons de palplanche: geom = 4 = caissons de palplanche
    ''' </remarks>
    Public Property Geom As Integer
        Get
            Geom = x_Geom
        End Get
        Set(value As Integer)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la catégorie de géométrie n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la catégorie de géométrie doit être positive.")
            Else
                x_Geom = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Diamètre du pieu - Unité: m.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Ø As Double
        Get
            Ø = x_Ø
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur du diamètre n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur du diamètre doit être positive.")
            Else
                x_Ø = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' dimension W de la section du pieu ou barrette ou paroi (cote w sur le dessin) - Unité: m.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property W As Double
        Get
            W = x_W
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La dimension W de la section du pieu ou barrette n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La dimension W de la section du pieu ou barrette doit être positive.")
            Else
                x_W = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' dimension L de la section du pieu ou barrette ou paroi (cote L sur le dessin)- Unité: m.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property L As Double
        Get
            L = x_L
        End Get
        Set(value As Double)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La dimension L de la section du pieu ou barrette n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La dimension L de la section du pieu ou barrette doit être positive.")
            Else
                x_L = value
            End If
        End Set
    End Property

#Region "Uniquement pour les pieux vissés moulés"
    ''' <summary>
    ''' Valeur du diamètre Bc (cote Bc sur le dessin)- Unité: m.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks>Uniquement pour les pieux vissés moulés</remarks>
    Public Property Bc As Double
        Get
            Bc = x_Bc
        End Get
        Set(value As Double)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La dimension de Bc n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La dimension de Bc doit être positive.")
            Else
                x_Bc = value
            End If
        End Set
    End Property
    ''' <summary>
    ''' Valeur du diamètre Bf (cote Bf sur le dessin)- Unité: m.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks>Uniquement pour les pieux vissés moulés</remarks>
    Public Property Bf As Double
        Get
            Bf = x_Bf
        End Get
        Set(value As Double)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La dimension de Bf n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La dimension de Bf doit être positive.")
            Else
                x_Bf = value
            End If
        End Set
    End Property
    ''' <summary>
    ''' Valeur du pas R (cote R sur le dessin)- Unité: m.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks>Uniquement pour les pieux vissés moulés</remarks>
    Public Property R As Double
        Get
            R = x_R
        End Get
        Set(value As Double)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La dimension du pas R n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La dimension du pas R doit être positive.")
            Else
                x_R = value
            End If
        End Set
    End Property
    ''' <summary>
    ''' Valeur de la cote Df (cote Df sur le dessin)- Unité: m.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks>Uniquement pour les pieux vissés moulés</remarks>
    Public Property Df As Double
        Get
            Df = x_Df
        End Get
        Set(value As Double)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La dimension Df n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La dimension Df doit être positive.")
            Else
                x_Df = value
            End If
        End Set
    End Property
#End Region

#Region "Uniquement pour les pieux vissés tubés"
    ''' <summary>
    ''' Valeur du diamètre de l'outil perdu- Unité: m.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks>Uniquement pour les pieux vissés tubés</remarks>
    Public Property Øoutil As Double
        Get
            Øoutil = x_Øoutil
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur du diamètre de l'outil perdu pour les pieux vissés tubés n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur du iamètre de l'outil perdu pour les pieux vissés tubés  doit être positive.")
            Else
                x_Øoutil = value
            End If
        End Set
    End Property
    ''' <summary>
    ''' Valeur du diamètre du tube métallique perdu faisant office de fût- Unité: m.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks>Uniquement pour les pieux vissés tubés</remarks>
    Public Property Øfut As Double
        Get
            Øfut = x_Øfut
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur du diamètre du tube métallique perdu faisant office de fût n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur du diamètre du tube métallique perdu faisant office de fût doit être positive.")
            Else
                x_Øfut = value
            End If
        End Set
    End Property

#End Region

#Region "Uniquement pour les pieux métalliques profilé H"
    ''' <summary>
    ''' dimension h hauteur de la section sur un profilé métallique H (cote h sur le dessin) - Unité: m.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property h As Double
        Get
            h = x_h
        End Get
        Set(value As Double)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La dimension h hauteur de la section d'un profilé métallique H n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La dimension h hauteur de la section d'un profilé métallique H doit être positive.")
            Else
                x_h = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' dimension b largeur de la section d'un profilé métallique H (cote b sur le dessin)- Unité: m.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property b As Double
        Get
            b = x_b
        End Get
        Set(value As Double)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La dimension b largeur de la section d'un profilé métallique H n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La dimension b largeur de la section d'un profilé métallique H doit être positive.")
            Else
                x_b = value
            End If
        End Set
    End Property
#End Region


    ''' <summary>
    ''' Aire du pieu (= Ab suivant article A.10 de la NF P94-262) - Unité: m²
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Ab As Double
        Get
            Ab = x_aire
        End Get
        Set(value As Double)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de l'Aire n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de l'Aire doit être positive.")
            Else
                x_aire = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Périmètre du pieu (= Ps suivant article A.10 de la NF P94-262) - Unité: m
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Ps As Double
        Get
            Ps = x_perimetre
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur du périmètre n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur du périmètre doit être positive.")
            Else
                x_perimetre = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Dimension transversale minimale du pieu - Unité: m
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Bmin As Double
        Get
            Bmin = x_Bmin
        End Get
        Set(value As Double)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la dimension transversale minimale du pieu n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la dimension transversale minimale du pieu doit être positive.")
            Else
                x_Bmin = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Hauteur de l'encastrement effectif dans la couche porteuse - Unité: m
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Xml.Serialization.XmlIgnore> Public ReadOnly Property Hencastr As Double
        Get
            Hencastr = _Hencastr
        End Get
    End Property

#Region "Côtes du pieu - Longueur et Profondeur"
    ''' <summary>
    ''' Mode de côtes du pieu renseigné dans le formulaire - True = côtes NGF / False = côtes relatives
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property CotesNGF As Boolean = False

    ''' <summary>
    ''' Côte du terrain naturel en NGF - Unité: m.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property CoteTN As Double
        Get
            CoteTN = x_CoteTN
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la Côte du terrain naturel en NGF n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la Côte du terrain naturel en NGF doit être positive.")
            Else
                x_CoteTN = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Côte de la tête de pieu (en NGF ou relative) - Unité: m.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property CoteTete As Double
        Get
            CoteTete = x_CoteTete
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la Côte de la tête de pieu n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la Côte de la tête de pieu doit être positive.")
            Else
                x_CoteTete = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Côte de la pointe du pieu (en NGF ou relative) - Unité: m.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property CotePointe As Double
        Get
            CotePointe = x_CotePointe
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la Côte de la pointe du pieu n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la Côte de la pointe du pieu doit être positive.")
            Else
                x_CotePointe = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Profondeur du pieu (= toute la longeur enterrée du pieu) - Unité: m.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property D As Double
        Get
            D = x_D
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la profondeur du pieu n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la profondeur du pieu doit être positive.")
            Else
                x_D = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Longueur du pieu - Unité: m.
    ''' </summary>
    ''' <value>la longueur est prise égale en mètre.</value>
    ''' <returns>= différence entre la tête du pieu et la base du pieu = longueur totale du pieu y compris sa partie non enterrée </returns>
    ''' <remarks>différent de la profondeur du pieu (variable D) qui ne prend en compte que la partie enterrée</remarks>
    Public Property LongPieu As Double
        Get
            LongPieu = x_LongPieu
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la longueur du pieu n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la longueur du pieu doit être positive.")
            Else
                x_LongPieu = value
            End If
        End Set
    End Property
#End Region

#Region "Classe - Catégorie et Abréviation du pieu"
    ''' <summary>
    ''' Classe du pieu suivant tableau A.1 de l'annexe A de la NF P94-262 - Maximum 8 classes
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Classe As Integer
        Get
            Classe = x_Classe
        End Get
        Set(value As Integer)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la classe du pieu n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la classe du pieu doit être positive.")
            ElseIf value > 8 Then
                Throw New ArgumentException("La valeur de la classe du pieu doit être inférieure à 9.")
            Else
                x_Classe = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Catégorie du pieu suivant tableau A.1 de l'annexe A de la NF P94-262 - Maximum 20 catégories
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Categorie As Integer
        Get
            Categorie = x_Categorie
        End Get
        Set(value As Integer)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la Categorie du pieu n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la Categorie du pieu doit être positive.")
            ElseIf value > 20 Then
                Throw New ArgumentException("La valeur de la Categorie du pieu doit être inférieure à 21.")
            Else
                x_Categorie = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Catégorie du pieu assimilé suivant tableau A.1 de l'annexe A de la NF P94-262 pour les micropieux de catégorie 17 et 18
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property CategorieAssimil As Integer
        Get
            CategorieAssimil = x_CategorieAssimil
        End Get
        Set(value As Integer)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la Categorie du pieu n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la Categorie du pieu doit être positive.")
            ElseIf value = 17 Then
                Throw New ArgumentException("La valeur de la Categorie du pieu ne peu pas être égale à 17.")
            ElseIf value = 18 Then
                Throw New ArgumentException("La valeur de la Categorie du pieu ne peu pas être égale à 18.")
            ElseIf value > 20 Then
                Throw New ArgumentException("La valeur de la Categorie du pieu doit être inférieure à 21.")
            Else
                x_CategorieAssimil = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Abréviation du pieu suivant tableau A.1 de l'annexe A de la NF P94-262
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Abreviation As String

    ''' <summary>
    ''' Abattement grande longueur: TRUE si effet / FALSE si sans objet - Uniquement applicable aux pieux de type FB, FS, FSR, FBR de plus de 25m
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property AbattementGrandeLongueur As Boolean
        Get
            AbattementGrandeLongueur = x_AbattementGrandeLongueur
        End Get
        Set(value As Boolean)
            If Not IsBoolean(value) Then
                Throw New ArgumentException("La valeur de la variable AbattementGrandeLongueur doit être booléenne.")
            Else
                x_AbattementGrandeLongueur = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Resistance de Pointe pour les micropieux (ou pieux de catégorie 17 à 20 suivant tableau A.1 de la norme): TRUE si Aucune Resistance de Pointe prise en compte / FALSE si inverse
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property AucuneResistancedePointe As Boolean
        Get
            AucuneResistancedePointe = x_AucuneResistancedePointe
        End Get
        Set(value As Boolean)
            If Not IsBoolean(value) Then
                Throw New ArgumentException("La valeur de la variable AucuneResistancedePointe doit être booléenne.")
            Else
                x_AucuneResistancedePointe = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Vibrofonçage pour pieu type BAO, HB et PP: TRUE si Vibrofonçage / FALSE si battage uniquement
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Vibrofoncage As Boolean
        Get
            Vibrofoncage = x_Vibrofoncage
        End Get
        Set(value As Boolean)
            If Not IsBoolean(value) Then
                Throw New ArgumentException("La valeur de la variable Vibrofoncage doit être booléenne.")
            Else
                x_Vibrofoncage = value
            End If
        End Set
    End Property
#End Region

    ''' <summary>
    ''' Classe du sol dans lequel est ancré le pieu pour calcul γrd1 tableau F.2.1 de l'annexe F de la NF P94-262
    ''' </summary>
    ''' <value> </value>
    ''' <returns>prend les valeurs suivantes:
    ''' 1= Argiles et limons, 2=Sols intermédiaires de classe 1 (= classe Argile), 3=Sols intermédiaires de classe 2(= classe Sables et graves), 
    ''' 4=Sables et graves, 5=Craies, 6= Marnes et calcaires marneux, 7= rocher</returns>
    ''' <remarks></remarks>
    <Xml.Serialization.XmlIgnore> Public ReadOnly Property AncragePressio As Integer
        Get
            AncragePressio = _Ancrage
        End Get
    End Property

    ''' <summary>
    ''' Classe du sol dans lequel est ancré le pieu pour calcul γrd1 tableau G.2.1 de l'annexe G de la NF P94-262
    ''' </summary>
    ''' <value> </value>
    ''' <returns>prend les valeurs suivantes:
    ''' 1= Argiles et limons, 2=Sols intermédiaires , 3=Sables et graves,
    '''  4=Craies, 5= Marnes et calcaires marneux, 6= rocher</returns>
    ''' <remarks></remarks>
    <Xml.Serialization.XmlIgnore> Public ReadOnly Property AncragePenetro As Integer
        Get
            AncragePenetro = _Ancrage
        End Get
    End Property

#Region "Effet de groupe"
    ''' <summary>
    ''' Effet de groupe: TRUE si effet / FALSE si sans objet
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property EffetGroupe As Boolean
        Get
            EffetGroupe = x_EffetGroupe
        End Get
        Set(value As Boolean)
            If Not IsBoolean(value) Then
                Throw New ArgumentException("La valeur de la variable Effet de groupe doit être booléenne.")
            Else
                x_EffetGroupe = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Entraxe suivant X entre pieux pour le calcul de l'effet de groupe - Unité: m
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property ef_Gr_dx As Double
        Get
            ef_Gr_dx = _ef_Gr_dx
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la distance entre pieux n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la distance entre pieux doit être positive.")
            Else
                _ef_Gr_dx = value
            End If
        End Set
    End Property
    ''' <summary>
    ''' Entraxe suivant X entre pieux pour le calcul de l'effet de groupe - Unité: m
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property ef_Gr_dy As Double
        Get
            ef_Gr_dy = _ef_Gr_dy
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la distance entre pieux n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la distance entre pieux doit être positive.")
            Else
                _ef_Gr_dy = value
            End If
        End Set
    End Property
    ''' <summary>
    ''' Nombre de ligne de pieux suivant X pour le calcul de l'effet de groupe  
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property ef_Gr_mx As Integer
        Get
            ef_Gr_mx = _ef_Gr_mx
        End Get
        Set(value As Integer)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("Le nombre de ligne de pieux n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("Le nombre de ligne de pieux doit être positif.")
            Else
                _ef_Gr_mx = value
            End If
        End Set
    End Property
    ''' <summary>
    ''' Nombre de ligne de pieux suivant Y pour le calcul de l'effet de groupe  
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property ef_Gr_my As Integer
        Get
            ef_Gr_my = _ef_Gr_my
        End Get
        Set(value As Integer)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("Le nombre de ligne de pieux n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("Le nombre de ligne de pieux doit être positif.")
            Else
                _ef_Gr_my = value
            End If
        End Set
    End Property
    ''' <summary>
    ''' Nombre de pieux par ligne suivant X pour le calcul de l'effet de groupe  
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property ef_Gr_nx As Integer
        Get
            ef_Gr_nx = _ef_Gr_nx
        End Get
        Set(value As Integer)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("Le nombre de pieux par ligne suivant X n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("Le nombre de pieux par ligne suivant X doit être positif.")
            Else
                _ef_Gr_nx = value
            End If
        End Set
    End Property
    ''' <summary>
    ''' Nombre de pieux par ligne suivant Y pour le calcul de l'effet de groupe  
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property ef_Gr_ny As Integer
        Get
            ef_Gr_ny = _ef_Gr_ny
        End Get
        Set(value As Integer)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("Le nombre de pieux par ligne suivant Y n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("Le nombre de pieux par ligne suivant Y doit être positif.")
            Else
                _ef_Gr_ny = value
            End If
        End Set
    End Property
#End Region

#End Region

    ''' <summary>
    '''Evaluation du tassement du pieu: TRUE si évaluation à réaliser / FALSE si sans objet
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Tassement As Boolean
        Get
            Tassement = x_Tassement
        End Get
        Set(value As Boolean)
            If Not IsBoolean(value) Then
                Throw New ArgumentException("La valeur de la variable pour l'évaluation du tassement doit être booléenne.")
            Else
                x_Tassement = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Caractéristiques mécaniques des pieux: Aire, Moment quadratique (Inertie), etc...
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub Geometrie()

        Select Case Categorie
            Case 1, 2, 5, 9
                Select Case Geom
                    Case 1   'circulaire 
                        x_Inert = PI * (Ø ^ 4) / 64 'calcul de l'inertie brute d'un pieu circulaire
                        x_aire = PI * Ø ^ 2 / 4
                        x_perimetre = PI * Ø
                        x_Bmin = Ø
                    Case 2 'rectangulaire
                        x_aire = W * L
                        x_perimetre = (W + L) * 2
                        If W < L Then x_Bmin = W Else x_Bmin = L
                    Case 3 'rectangulaire arrondi
                        x_aire = PI * W ^ 2 / 4
                        x_aire += W * (L - W)
                        x_perimetre = PI * W + (L - W) * 2
                        If W < L Then x_Bmin = W Else x_Bmin = L
                End Select
            Case 3, 4, 6, 11, 17 To 20
                Select Case Geom
                    Case 1   'circulaire 
                        x_Inert = PI * (Ø ^ 4) / 64 'calcul de l'inertie brute d'un pieu circulaire
                        x_aire = PI * Ø ^ 2 / 4
                        x_perimetre = PI * Ø
                        x_Bmin = Ø
                End Select
            Case 7 'vissé moulé
                Dim Øpieu As Double
                'Quelque soit la géométrie avec geom = 1 = hélice ordinaire // geom = 2 = hélice épaisse
                'calcul du périmètre pour le calcul du frottement axial
                If Df < 0.05 OrElse R / Df > 6 Then
                    Øpieu = Max(Bc, 0.9 * Bf)
                Else
                    Øpieu = Bf ' = Bf
                End If
                x_perimetre = PI * Øpieu 'pour le calcul du frottement
                x_Bmin = Øpieu
                'calcul de l'aire pour la résistance de la pointe
                If Df < 0.05 OrElse R / Df > 6 Then
                    Øpieu = Max(Bc, 0.9 * Bf)
                Else
                    Øpieu = Max(Bc, Bf) '  
                End If
                x_aire = PI * Øpieu ^ 2 / 4
            Case 8 'vissé tubé
                x_perimetre = PI * Øfut 'pour le calcul du frottement
                x_aire = PI * Øoutil ^ 2 / 4 'calcul de l'aire pour la résistance de la pointe
                x_Bmin = Øfut
            Case 10 'battu enrobé
               'sans objet - renseigné directement par le projeteur
            Case 12, 13 'caisson acier fermé, battu caisson acier ouvert
                Select Case Geom
                    Case 1   'circulaire 
                        x_Inert = PI * (Ø ^ 4) / 64 'calcul de l'inertie brute d'un pieu circulaire
                        x_aire = PI * Ø ^ 2 / 4
                        x_perimetre = PI * Ø
                        x_Bmin = Ø
                    Case 4 'caisson de palplanche
                        'sans objet - renseigné directement par le projeteur
                End Select
            Case 14, 15 'Pieux H
                x_aire = b * h
                x_perimetre = (b + h) * 2
                If b < h Then x_Bmin = b Else x_Bmin = h
            Case 16 'palplanche
                'sans objet - renseigné directement par le projeteur
        End Select
        Select Case CotesNGF
            Case True
                x_LongPieu = CoteTete - CotePointe
                x_D = CoteTN - CotePointe
            Case False
                x_LongPieu = CoteTete + CotePointe
                x_D = CotePointe
        End Select
    End Sub

    ''' <summary>Vérification des conditions d'encastrement minimal dans la couche porteuse (mini 50 cm) - Essai Pressiométrique</summary>
    ''' <param name="Sondage">caractéristiques géométriques du sondage</param>
    Public Function Verif_Encastrement_Pressio(ByVal Sondage As clsSondagePressio) As Boolean
        Dim h As Double
        Verif_Encastrement_Pressio = True
        h = Sondage.Htotal
        For j = Sondage.Lithologie.Count To 1 Step -1
            h -= Sondage.Lithologie.Item(j - 1).hcouche 'je décrémente d'une couche chaque fois
            If D - h > 0 Then
                _Hencastr = D - h  '  valeur de l'encastrement dans la couche porteuse
                _Ancrage = Sondage.Lithologie.Item(j - 1).Categorie '--> détermination de la classe de sol dans laquelle est ancré le pieu
                Exit For
            End If
        Next
        If _Hencastr < 0.5 Then Verif_Encastrement_Pressio = False
    End Function

    ''' <summary>Vérification des conditions d'encastrement minimal dans la couche porteuse (mini 50 cm) - Essai Pénétrométrique</summary>
    ''' <param name="Sondage">caractéristiques géométriques du sondage</param>
    Public Function Verif_Encastrement_Penetro(ByVal Sondage As clsSondagePenetrometrique) As Boolean
        Dim h As Double
        Verif_Encastrement_Penetro = True
        h = Sondage.Htotal
        For j = Sondage.Lithologie.Count To 1 Step -1
            h -= Sondage.Lithologie.Item(j - 1).hcouche 'je décrémente d'une couche chaque fois
            If D - h > 0 Then
                _Hencastr = D - h  '  valeur de l'encastrement dans la couche porteuse
                _Ancrage = Sondage.Lithologie.Item(j - 1).Categorie '--> détermination de la classe de sol dans laquelle est ancré le pieu
                Exit For
            End If
        Next
        If _Hencastr < 0.5 Then Verif_Encastrement_Penetro = False
    End Function

    Private Function IsNumeric(Expression As Object) As Boolean
        Dim isNum As Boolean 'Variable to collect the Return value of the TryParse method.
        Dim retNum As Double ' Define variable to collect out parameter of the TryParse method. If the conversion fails, the out parameter Is zero.

        '// The TryParse method converts a string in a specified style And culture-specific format to its double-precision floating point number equivalent.
        '// The TryParse method does Not generate an exception if the conversion fails. If the conversion passes, True Is returned. If it does Not, False Is returned.
        isNum = Double.TryParse(Convert.ToString(Expression), System.Globalization.NumberStyles.Any, System.Globalization.NumberFormatInfo.InvariantInfo, retNum)
        Return isNum
    End Function

    Private Function IsBoolean(Expression As Object) As Boolean
        Dim isBool As Boolean 'Variable to collect the Return value of the TryParse method.
        Dim retBool As Boolean ' Define variable to collect out parameter of the TryParse method. If the conversion fails, the out parameter Is zero.

        '// The TryParse method converts a string in a specified style And culture-specific format to its double-precision floating point number equivalent.
        '// The TryParse method does Not generate an exception if the conversion fails. If the conversion passes, True Is returned. If it does Not, False Is returned.
        isBool = Boolean.TryParse(Convert.ToString(Expression), retBool)
        Return isBool
    End Function
End Class
