﻿Public Class clsLithologie
    Inherits clsValPressio
    Private x_hcouche, x_Ztoit, x_Zbase, x_Zeau As Double
    Private x_Categorie As Integer
    Private x_CategorieNom As String

    ''' <summary>
    ''' Hauteur de la couche de sol - Unité:m
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Xml.Serialization.XmlIgnore> Public ReadOnly Property hcouche As Double
        Get
            hcouche = x_hcouche
        End Get
    End Property

    ''' <summary>
    ''' Altimétrie supérieure de la couche de sol - Unité:m
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Ztoit As Double
        Get
            Ztoit = x_Ztoit
        End Get
        Set(value As Double)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de l'Altimétrie supérieure de la couche de sol n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de l'Altimétrie supérieure de la couche de sol doit être positive.")
            Else
                x_Ztoit = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Altimétrie inférieure de la couche de sol - Unité:m
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Zbase As Double
        Get
            Zbase = x_Zbase
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de l'Altimétrie inférieure de la couche de sol n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de l'Altimétrie inférieure de la couche de sol doit être positive.")
            Else
                x_Zbase = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Nom de la lithologie - Unité: string
    ''' </summary>
    ''' <remarks></remarks>
    Public NomLithologie As String

    ''' <summary>
    ''' Catégorie conventionnelle de terrain suivant tableau B.2.1 de l'annexe B de la NF P94-262 - clé = profondeur / valeur = nom de la Catégorie conventionnelle de terrain - Unité: m / string
    ''' </summary>
    ''' <remarks></remarks>
    Public ReadOnly Property CategorieNom As String
        Get
            CategorieNom = x_CategorieNom
        End Get
    End Property

    ''' <summary>
    ''' Catégorie conventionnelle de terrain suivant tableau B.2.1 de l'annexe B de la NF P94-262 pour la détermination de kpMax du tableau F.4.2.1 de l'annexe F de la NF P94-262 
    ''' Les Catégorie conventionnelle de terrain sont les suivants: 0 = remblai (aucune valeur de résistance en pointe ou en frottement, 1= Argiles et limons, 
    ''' 2 = PRESSIO = Sols intermédiaires de classe 1 (= classe Argile) // PENETRO = Sols intermédiaires , 
    ''' 3 = PRESSIO = Sols intermédiaires de classe 2(= classe Sables et graves)// PENETRO = Sols intermédiaires , 
    ''' 4 = Sables et graves, 5 = Craies, 6 = Marnes et calcaires marneux, 7 = rocher - Unité: integer
    ''' </summary>
    ''' <remarks></remarks>
    Public Property Categorie As Integer
        Get
            Categorie = x_Categorie
        End Get
        Set(value As Integer)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la catégorie de la couche de sol n'est pas numérique.")
            ElseIf value < 0 OrElse value > 7 Then
                Throw New ArgumentException("La valeur de la catégorie de la couche de sol doit être comprise entre 0 et 7.")
            Else
                x_Categorie = value
                Select Case Aff.ModeleCalcul
                    Case 1, 2, 3 'Essais Pressiométriques
                        x_CategorieNom = CategorieSolPressio(x_Categorie)
                    Case 4, 5 'Essais Pénétrométriques
                        x_CategorieNom = CategorieSolPenetro(x_Categorie)
                End Select

            End If
        End Set
    End Property

    ''' <summary>
    ''' Détermine plusieurs caractéristiques de la lithologie du sondage dont le Calcul des hauteurs des différentes couches de sol
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub Caracteristique_Lithologie()
        Dim value As Double
        value = Zbase - Ztoit
        If value <= 0 Then
            Throw New ArgumentException("La valeur de la hauteur de la couche de sol doit être positive.")
        Else
            x_hcouche = value
        End If
    End Sub

    Private Function CategorieSolPressio(ByVal iSol As Integer) As String
        CategorieSolPressio = "Non déterminée"
        If iSol < 0 OrElse iSol > 7 Then
            Throw New ArgumentException("La valeur de la catégorie de la couche de sol doit être comprise entre 0 et 7.")
        Else
            Select Case iSol
                Case 0 '
                    CategorieSolPressio = "Classe Remblai"
                Case 1 '
                    CategorieSolPressio = "Classe argiles et limons "
                Case 2 '
                    CategorieSolPressio = "Classe Sols intermédiaires (sables limoneux, sable argileux, argile sableuse) "
                Case 3 '
                    CategorieSolPressio = "Classe Sols intermédiaires (sables limoneux, sable argileux, argile sableuse) "
                Case 4 '
                    CategorieSolPressio = "Classe sables et graves "
                Case 5 '
                    CategorieSolPressio = "Classe Craie"
                Case 6 '
                    CategorieSolPressio = "Classe Marne et calcaire marneux "
                Case 7 '
                    CategorieSolPressio = "Classe Rocher."
            End Select

        End If
    End Function
    Private Function CategorieSolPenetro(ByVal iSol As Integer) As String
        CategorieSolPenetro = "Non déterminée"
        If iSol < 0 OrElse iSol > 6 Then
            Throw New ArgumentException("La valeur de la catégorie de la couche de sol doit être comprise entre 0 et 6.")
        Else
            Select Case iSol
                Case 0 '
                    CategorieSolPenetro = "Classe Remblai"
                Case 1 '
                    CategorieSolPenetro = "Classe argiles et limons "
                Case 2 '
                    CategorieSolPenetro = "Classe Sols intermédiaires (sables limoneux, sable argileux, argile sableuse) "
                Case 3 '
                    CategorieSolPenetro = "Classe sables et graves "
                Case 4 '
                    CategorieSolPenetro = "Classe Craie"
                Case 5 '
                    CategorieSolPenetro = "Classe Marne et calcaire marneux "
                Case 6 '
                    CategorieSolPenetro = "Classe Rocher."
            End Select

        End If
    End Function
    Private Function IsNumeric(Expression As Object) As Boolean
        Dim isNum As Boolean 'Variable to collect the Return value of the TryParse method.
        Dim retNum As Double ' Define variable to collect out parameter of the TryParse method. If the conversion fails, the out parameter Is zero.

        '// The TryParse method converts a string in a specified style And culture-specific format to its double-precision floating point number equivalent.
        '// The TryParse method does Not generate an exception if the conversion fails. If the conversion passes, True Is returned. If it does Not, False Is returned.
        isNum = Double.TryParse(Convert.ToString(Expression), System.Globalization.NumberStyles.Any, System.Globalization.NumberFormatInfo.InvariantInfo, retNum)
        Return isNum
    End Function
End Class
