﻿Imports System.IO

''' <summary>
''' Classe encapsulant tous les aspects généraux concernant l'affaire comme le projeteur, l'imprimante, etc. ...
''' </summary>
Public Class clsAffaire
    Dim _FileName As String = String.Empty
    Dim _msgData As String = Directory.GetCurrentDirectory.ToString() & "\Data"
    Dim _msgResult As String = Directory.GetCurrentDirectory.ToString() & "\Note_de_calcul"
    Dim _Redacteur As String = "LeFux_Ingenierie"
    Dim _Chantier As String = "A_definir"
    Dim _i_data As Integer = 1
    Dim _i_result As Integer = 1
    Dim _Editeur As Integer = 1
    Dim _ModeleCalcul As Integer = 1
    Dim x_SIGLongueur, x_SIGLargeur As Double

#Region "Formulaire Configuration"

    ''' <summary>
    ''' nom du fichier de données et de son chemin d'accès complet - Exemple: C:\users\fux\documents\pieu\data\pieux_EcoleVauban.txt
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property FileName As String
        Get
            FileName = _FileName
        End Get
        Set(value As String)
            If Not IsString(value) Then
                Throw New ArgumentException("La valeur de l'identifiant du fichier de données n'est pas une chaine de caractères.")
            Else
                _FileName = value
            End If
        End Set
    End Property

    ''' <summary>
    '''Répertoire du fichier de données - exemple: C:\users\fux\documents\pieu\data - NE doit pas contenir de \ en terminaison
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property msgData As String '
        Get
            msgData = _msgData
        End Get
        Set(value As String)
            If Not IsString(value) Then
                Throw New ArgumentException("La valeur de l'identifiant du fichier de données n'est pas une chaine de caractères.")
            Else
                _msgData = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Répertoire des notes de calculs - exemple: C:\users\fux\documents\pieu\note_de_calcul - NE doit pas contenir de \ en terminaison
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property msgResult As String '
        Get
            msgResult = _msgResult
        End Get
        Set(value As String)
            If Not IsString(value) Then
                Throw New ArgumentException("La valeur de l'identifiant du fichier de la note de calcul n'est pas une chaine de caractères.")
            Else
                _msgResult = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' n° du répertoire des notes de calcul: =1 répertoire par défaut (= répertoire Note_de_calcul en sous-répertoire du répertoire accueillant le fichier exe du logiciel)/ =2 répertoire spécifique
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property i_result As Integer
        Get
            i_result = _i_result
        End Get
        Set(value As Integer)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la variable i_result n'est pas numérique.")
            ElseIf value < 1 Then
                Throw New ArgumentException("La valeur de la variable i_result doit être positive.")
            ElseIf value > 2 Then
                Throw New ArgumentException("La valeur de la variable i_result doit être inférieur à 3.")
            Else
                _i_result = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' n° du répertoire du fichier de données: =1 répertoire par défaut (= répertoire data en sous-répertoire du répertoire accueillant le fichier exe du logiciel)/ =2 répertoire spécifique
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property i_data As Integer
        Get
            i_data = _i_data
        End Get
        Set(value As Integer)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la variable i_data n'est pas numérique.")
            ElseIf value < 1 Then
                Throw New ArgumentException("La valeur de la variable i_data doit être positive.")
            ElseIf value > 2 Then
                Throw New ArgumentException("La valeur de la variable i_data doit être positive.")
            Else
                _i_data = value
            End If
        End Set
    End Property

    ''' <summary>
    '''nom du rédacteur
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Redacteur As String
        Get
            Redacteur = _Redacteur
        End Get
        Set(value As String)
            If Not IsString(value) Then
                Throw New ArgumentException("La valeur de l'identifiant Redacteur n'est pas une chaine de caractères.")
            Else
                _Redacteur = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' nom du chantier
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Chantier As String
        Get
            Chantier = _Chantier
        End Get
        Set(value As String)
            If Not IsString(value) Then
                Throw New ArgumentException("La valeur de l'identifiant Redacteur n'est pas une chaine de caractères.")
            Else
                _Chantier = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Editeur: 1=éditeur interne / 2=WordPad / 3=Word
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Editeur As Integer
        Get
            Editeur = _Editeur
        End Get
        Set(value As Integer)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la variable Editeur n'est pas numérique.")
            ElseIf value < 1 Then
                Throw New ArgumentException("La valeur de la variable Editeur doit être positive.")
            ElseIf value > 3 Then
                Throw New ArgumentException("La valeur de la variable Editeur doit être inférieure à 4.")
            Else
                _Editeur = value
            End If
        End Set
    End Property
#End Region


    ''' <summary>
    ''' Modèle de calcul de la portance du pieu avec: 1 = pressio + Modèle terrain + val. caractéristiques  / 2 = pressio + Modèle terrain + sondage 5m / 3 = pressio + Pieu Modèle  / 4 = Pénétro + Modèle terrain
    ''' / 5 = Pénétro + Pieu Modèle  
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property ModeleCalcul As Integer
        Get
            ModeleCalcul = _ModeleCalcul
        End Get
        Set(value As Integer)
            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la variable ModeleCalcul n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la variable ModeleCalcul doit être positive.")
            ElseIf value > 5 Then
                Throw New ArgumentException("La valeur de la variable ModeleCalcul doit être inférieure à 6.")
            Else
                _ModeleCalcul = value
            End If
        End Set
    End Property


    ''' <summary>
    ''' Surface d'investigation géotechnique suivant E.2(2) - Longueur - Unité: m
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property SurfInvestGeotechLongueur As Double
        Get
            SurfInvestGeotechLongueur = x_SIGLongueur
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la longueur de la surface d'investigation géotechnique n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la longueur de la surface d'investigation géotechnique doit être positive.")
            Else
                x_SIGLongueur = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Surface d'investigation géotechnique suivant E.2(2) - Largeur - Unité: m
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property SurfInvestGeotechLargeur As Double
        Get
            SurfInvestGeotechLargeur = x_SIGLargeur
        End Get
        Set(value As Double)

            If Not IsNumeric(value) Then
                Throw New ArgumentException("La valeur de la Largeur de la surface d'investigation géotechnique n'est pas numérique.")
            ElseIf value < 0 Then
                Throw New ArgumentException("La valeur de la Largeur de la surface d'investigation géotechnique doit être positive.")
            Else
                x_SIGLargeur = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' n° du fichier d'aide
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Xml.Serialization.XmlIgnore> Public Property FichierAide As Integer
    ''' <summary>
    ''' Message d'avertissement
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    <Xml.Serialization.XmlIgnore> Public Property msg_Avertiss As New List(Of String)

    ''' <summary>
    ''' Fonction permettant de vérifier que la valeur transmise est bien numérique
    ''' </summary>
    ''' <returns>TRUE si la valeur est bien numérique sinon FALSE</returns>
    ''' <remarks></remarks>
    Private Function IsNumeric(Expression As Object) As Boolean
        Dim isNum As Boolean 'Variable to collect the Return value of the TryParse method.
        Dim retNum As Double ' Define variable to collect out parameter of the TryParse method. If the conversion fails, the out parameter Is zero.

        '// The TryParse method converts a string in a specified style And culture-specific format to its double-precision floating point number equivalent.
        '// The TryParse method does Not generate an exception if the conversion fails. If the conversion passes, True Is returned. If it does Not, False Is returned.
        isNum = Double.TryParse(Convert.ToString(Expression), System.Globalization.NumberStyles.Any, System.Globalization.NumberFormatInfo.InvariantInfo, retNum)
        Return isNum
    End Function

    ''' <summary>
    ''' Fonction permettant de vérifier que la valeur transmise est bien une chaine de caractères
    ''' </summary>
    ''' <returns>TRUE si la valeur est bien une chaine de caractères sinon FALSE</returns>
    ''' <remarks></remarks>
    Private Function IsString(Expression As Object) As Boolean
        Dim isStr As Boolean 'Variable to collect the Return value of the Convert.ToString method.
        Dim retStr As String '  
        '// The Convert.ToString method does Not generate an exception if the conversion fails. If the conversion passes, True Is returned. If it does Not, False Is returned.
        retStr = Convert.ToString(Expression)
        If retStr = "" Then
            isStr = False
        Else
            isStr = True
        End If
        Return isStr
    End Function
End Class
