﻿Imports System.IO
Module General
    Public Pieux As New clsPieux
    Public SondagePenetro As New List(Of clsSondagePenetrometrique)
    Public SondagesPressio As New List(Of clsSondagePressio)
    Public SondageModele As New clsSondagePressio
    Public Aff As New clsAffaire
    Public Function Mise_en_Forme_date(ByVal Toto As String) As String
        Toto = Toto.Replace("/", "_")
        Toto = Toto.Replace(" ", "_")
        Toto = Toto.Replace(":", "_")
        Mise_en_Forme_date = Toto
    End Function
    Private Function checkUnicode(ByVal ee As System.Windows.Forms.KeyPressEventArgs) As Integer
        checkUnicode = 1
        If ee.KeyChar = Convert.ToChar(8) Then Exit Function ' touche del utilisable
        ' If ee.KeyChar = Convert.ToChar(44) Then Exit Function ' touche , utilisable
        If ee.KeyChar = "." Then Exit Function ' touche . utilisable Convert.ToChar(46) 
        If ee.KeyChar = "0" Then Exit Function '0Convert.ToChar(48)
        If ee.KeyChar = "1" Then Exit Function '1 Convert.ToChar(49)
        If ee.KeyChar = "2" Then Exit Function '2Convert.ToChar(50)
        If ee.KeyChar = "3" Then Exit Function '3Convert.ToChar(51)
        If ee.KeyChar = "4" Then Exit Function '4Convert.ToChar(52)
        If ee.KeyChar = "5" Then Exit Function '5Convert.ToChar(53)
        If ee.KeyChar = "6" Then Exit Function '6Convert.ToChar(54)
        If ee.KeyChar = "7" Then Exit Function '7Convert.ToChar(55)
        If ee.KeyChar = "8" Then Exit Function '8Convert.ToChar(56)
        If ee.KeyChar = "9" Then Exit Function '9Convert.ToChar(57)
        checkUnicode = 0
    End Function
    ''' <summary>Programme de gestion des touches pressées</summary>
    '''  <param name="positif">variable prenant la valeur Vrai si la valeur doit être un nombre positif</param>
    ''' <param name="entier"> variable prenant la valeur Vrai si la valeur doit être un entier</param>
    Public Sub Gestion_Keypress(ByRef ee As System.Windows.Forms.KeyPressEventArgs, ByVal text1 As System.Windows.Forms.TextBox, ByVal positif As Boolean, ByVal entier As Boolean)
        Dim Lettre1 As Boolean = False

        If text1.SelectionLength = text1.Text.Length Then text1.Clear() : Lettre1 = True 'Pour gérer la 1ière lettre tapée dans le textbox
        If ee.KeyChar = "," Then
            If Lettre1 = False And entier = False Then 'le text1 comporte plus de 1 chiffre et le chiffre ne doit pas être un entier, remplacer . par ,
                'Pour éviter d'avoir plusieurs points ou virgule
                Dim texte As String = text1.Text
                If texte.Contains(".") OrElse texte.Contains(",") Then ee.Handled = True : Exit Sub
                text1.Text = text1.Text + "."
                text1.SelectionStart = text1.TextLength + 1
            End If
            ee.Handled = True
            Exit Sub
        End If
        If ee.KeyChar = "." Then
            If Lettre1 = True Then 'le text1 comporte  1 chiffre, on ne valide pas la frappe
                ee.Handled = True
                Exit Sub
            ElseIf entier = True Then
                ee.Handled = True
                Exit Sub
            Else
                'Pour éviter d'avoir plusieurs points ou virgule
                Dim texte As String = text1.Text
                If texte.Contains(".") OrElse texte.Contains(",") Then ee.Handled = True : Exit Sub
            End If
        End If
        If ee.KeyChar = "&" Then
            text1.Text = text1.Text + "1"
            text1.SelectionStart = text1.TextLength + 1
            ee.Handled = True
            Exit Sub
        End If
        If ee.KeyChar = "é" Then
            text1.Text = text1.Text + "2"
            text1.SelectionStart = text1.TextLength + 1
            ee.Handled = True
            Exit Sub
        End If
        If ee.KeyChar = Convert.ToChar(34) Then 'ascw(ee.KeyChar) = 34 code " = keyAscii = 34
            text1.Text = text1.Text + "3"
            text1.SelectionStart = text1.TextLength + 1
            ee.Handled = True
            Exit Sub
        End If
        If ee.KeyChar = "'" Then
            text1.Text = text1.Text + "4"
            text1.SelectionStart = text1.TextLength + 1
            ee.Handled = True
            Exit Sub
        End If
        If ee.KeyChar = "(" Then
            text1.Text = text1.Text + "5"
            text1.SelectionStart = text1.TextLength + 1
            ee.Handled = True
            Exit Sub
        End If
        If positif = True Then 'seulement si la valeur >0
            If ee.KeyChar = "-" Then
                text1.Text = text1.Text + "6"
                text1.SelectionStart = text1.TextLength + 1
                ee.Handled = True
                Exit Sub
            End If
        Else
            If ee.KeyChar = "-" Then
                text1.Text = "-"
                text1.SelectionStart = text1.TextLength + 1
                ee.Handled = True
                Exit Sub
            End If
        End If
        If ee.KeyChar = "è" Then
            text1.Text = text1.Text + "7"
            text1.SelectionStart = text1.TextLength + 1
            ee.Handled = True
            Exit Sub
        End If
        If ee.KeyChar = "_" Then
            text1.Text = text1.Text + "8"
            text1.SelectionStart = text1.TextLength + 1
            ee.Handled = True
            Exit Sub
        End If
        If ee.KeyChar = "ç" Then
            text1.Text = text1.Text + "9"
            text1.SelectionStart = text1.TextLength + 1
            ee.Handled = True
            Exit Sub
        End If
        If ee.KeyChar = "à" Then
            text1.Text = text1.Text + "0"
            text1.SelectionStart = text1.TextLength + 1
            ee.Handled = True
            Exit Sub
        End If
        If checkUnicode(ee) = 0 Then ee.Handled = True
    End Sub

    ''' <summary>Programme de gestion des entrées dans les textbox</summary>
    '''  <param name="e">ByVal e As System.Windows.Forms.TextBox</param>
    ''' <param name="ep1">ByRef ep1 As System.Windows.Forms.ErrorProvider</param>
    Public Function gestionderreur(ByVal e As System.Windows.Forms.TextBox, ByRef ep1 As System.Windows.Forms.ErrorProvider) As Boolean
        Try
            gestionderreur = True
            If e.Text = "" Then
                ep1.SetError(e, "le champ n'a pas été renseigné!!")
                gestionderreur = False
            ElseIf e.Text <> "" Then
                Dim isnum As Boolean
                Dim retnum As Double
                Dim toto As String
                toto = Convert.ToString(e.Text) : toto = toto.Trim(" "c)
                isnum = Double.TryParse(toto, System.Globalization.NumberStyles.AllowLeadingSign Or System.Globalization.NumberStyles.AllowDecimalPoint, System.Globalization.NumberFormatInfo.CurrentInfo, retnum)
                If isnum = False Then
                    ep1.SetError(e, "le champ n'est pas une valeur numérique !!")
                    gestionderreur = False
                Else
                    ep1.SetError(e, "") ' Clear the error.
                    gestionderreur = True
                End If
            End If
        Catch ex As Exception
            ep1.SetError(e, ex.Message)
            gestionderreur = False
        End Try
    End Function

    ''' <summary>Programme de lecture dans le fichier ini</summary>
    '''  <param name="filename">nom du fichier ini</param>
    ''' <param name="Verif">renvoie FALSE si erreur</param>
    Public Sub Lecture_fichier_Ini(ByVal filename As String, ByRef Verif As Boolean)
        Dim myStreamReader As StreamReader = Nothing
        Dim toto, titi(2) As String
        Try
            myStreamReader = File.OpenText(filename)
            toto = myStreamReader.ReadLine 'on n'affecte aucune valeur sur la première ligne
            toto = myStreamReader.ReadLine 'ligne de commentaire
            toto = myStreamReader.ReadLine : Call LectureGen(toto, titi, Verif, 1) : If Verif = False Then myStreamReader.Close() : Exit Sub  'ligne suivante
            Aff.Redacteur = CStr(titi(1))
            toto = myStreamReader.ReadLine : Call LectureGen(toto, titi, Verif, 1) : If Verif = False Then myStreamReader.Close() : Exit Sub   'ligne suivante
            Aff.Chantier = CStr(titi(1))
            'fichiers
            toto = myStreamReader.ReadLine  'ligne suivante
            Aff.msgResult = toto
            toto = myStreamReader.ReadLine   'ligne suivante
            Aff.msgData = toto
            toto = myStreamReader.ReadLine : Call LectureGen(toto, titi, Verif, 2) : If Verif = False Then myStreamReader.Close() : Exit Sub  'ligne suivante
            Aff.i_result = CInt(titi(1)) : Aff.i_data = CInt(titi(2))
            'Editeur
            toto = myStreamReader.ReadLine 'pour sauter la ligne
            toto = myStreamReader.ReadLine : Call LectureGen(toto, titi, Verif, 1) : If Verif = False Then myStreamReader.Close() : Exit Sub   'ligne suivante
            Aff.Editeur = CInt(titi(1))
        Catch ex As Exception
            MessageBox.Show("Erreur lors de la lecture du fichier: " & Environment.NewLine & "Exception: " & ex.Message & ex.StackTrace, "General: Module lecture fichier ini", MessageBoxButtons.OK, MessageBoxIcon.Information)
            Verif = False
        Finally
            If Not myStreamReader Is Nothing Then myStreamReader.Close() ' Close the object if it has been created.
        End Try

    End Sub

    ''' <summary>Programme de lecture dans le fichier ini</summary>
    '''  <param name="filename">nom du fichier ini</param>
    ''' <param name="Verif">renvoie FALSE si erreur</param>
    Public Sub Ecriture_fichier_Cfg_Ini(ByVal filename As String, ByRef Verif As Boolean) ' 
        Dim myStreamWriter As StreamWriter = Nothing
        Try
            ' Create a StreamWriter using a Shared (static) File class.
            myStreamWriter = File.CreateText(filename)
            myStreamWriter.WriteLine("Fichier des valeurs par défauts Calculette MécaSol")
            myStreamWriter.WriteLine("formulaire configuration Onglet Général")
            myStreamWriter.WriteLine(Aff.Redacteur)
            myStreamWriter.WriteLine(Aff.Chantier)
            'répertoire
            myStreamWriter.WriteLine(Aff.msgResult)
            myStreamWriter.WriteLine(Aff.msgData)
            myStreamWriter.WriteLine(Aff.i_result & " " & Aff.i_data)
            'Editeur
            myStreamWriter.WriteLine("formulaire configuration Onglet Editeur ")
            myStreamWriter.WriteLine(Aff.Editeur)

            myStreamWriter.Flush() ' Obligatoire - Vide le tampon pour être sûr que tout soit écrit dans le fichier

        Catch exc As Exception
            MessageBox.Show("Le fichier n'a pas pu être ouvert ou écrit. Vérifiez que le nom du fichier et son chemin d'accès soient exact." & Environment.NewLine & "Exception: " & exc.Message, "Module écriture fichier de configuration",
                           MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            Verif = False
        Finally
            ' Close the object if it has been created.
            If Not myStreamWriter Is Nothing Then myStreamWriter.Close()
        End Try
    End Sub

    ''' <summary>Lecture de données se trouvant dans de simples fichiers texte</summary>
    '''  <param name="toto">correspond à une ligne entière du fichier</param>
    ''' <param name="titi">une donnée se trouvant sur la ligne</param>
    ''' <param name="Verif">renvoie FALSE si erreur dans l'exécution du programme</param>
    ''' <param name="Limite">nombre maximal de données pouvant se trouver sur la ligne</param>
    Public Sub LectureGen(ByVal toto As String, ByRef titi() As String, ByRef Verif As Boolean, Optional ByVal Limite As Integer = 2)
        Dim i, i1 As Integer
        Dim tutu() As String
        toto = toto.ToLower() 'transforme la chaine en minuscule, permet dans le fichier original d'écrire en minuscule ou en majuscule
        toto = toto.Trim(New Char() {" "c, ","c, ";"c, "_"c, ":"c}) 'supprime les espaces en debut et fin de chaine
        'recherche de blanc dans la chaine
        tutu = toto.Split(" "c)
        'en cas de dépassement de limite
        If tutu.Length > Limite Then
            If Limite = 1 Then
                Dim msg1 As String = String.Empty
                msg1 = tutu(0).Substring(0, 1)
                If msg1 <> "p" And msg1 <> "l" Then 'pour Pressiométrique'pour lithologique
                    MessageBox.Show("Erreur lors de la lecture du fichier: " & Environment.NewLine & "Le mot-clé Pressiométrique ou lithologique n'a pas été indiqué.", "Sous-Module de lecture fichier texte LectureGen()", MessageBoxButtons.OK, MessageBoxIcon.Information)
                    Verif = False : Exit Sub
                Else
                    titi(1) = tutu(0) : Exit Sub
                End If
            Else
                MessageBox.Show("Erreur lors de la lecture du fichier sur la ligne " & toto.ToString & " : " & Environment.NewLine & "Le nombre de chaines de caractères excède la limite indiquée.", "Sous-Module de lecture fichier texte LectureGen()", MessageBoxButtons.OK, MessageBoxIcon.Information)
                Verif = False : Exit Sub
            End If
        End If
        'Suppression des virgules dans les nombres décimaux et remplacement par des points sinon plantage
        i1 = 0
        For i = 1 To tutu.Length
            i1 += 1
            If tutu(i - 1) = "" Then i1 -= 1 : Continue For
            titi(i1) = tutu(i - 1)
            titi(i1) = titi(i1).Replace(",", ".")
        Next
    End Sub

    ''' <summary>Lecture du nom du fichier de données et de son répertoire racine</summary>
    '''  <param name="toto">correspond à une ligne entière du fichier</param>
    ''' <param name="Racine">Répertoire du fichier de données</param>
    ''' <param name="Verif">renvoie FALSE si erreur dans l'exécution du programme</param>
    Public Sub Lecture_chaine_Racine(ByRef toto As String, ByRef Racine As String, ByRef NomFichier As String, ByRef Verif As Boolean)
        'Traitement de la chaine de caractère pour pouvoir être lu par le logiciel
        Try
            toto.Trim(New Char() {" "c, ","c, ";"c, "_"c, ":"c}) 'supprime les espaces , _ en debut et fin de chaine
            Racine = toto.Substring(0, toto.LastIndexOf("\"))
            NomFichier = toto.Substring(toto.LastIndexOf("\"), toto.Length - toto.LastIndexOf("\"))
        Catch ex As Exception
            MessageBox.Show("Erreur lors de la lecture de la chaine " & toto.ToString & Environment.NewLine & ex.Message & ex.StackTrace, "Module Lecture_Chaine", MessageBoxButtons.OK, MessageBoxIcon.Asterisk, MessageBoxDefaultButton.Button1)
            Verif = False
        End Try
    End Sub

    Public Sub Variables_generales()
        'Général
        With Aff
            .msgData = Directory.GetCurrentDirectory.ToString() & "\Data"
            .msgResult = Directory.GetCurrentDirectory.ToString() & "\Note_de_calcul"
            .i_data = 1
            .i_result = 1
            .Redacteur = "LeFux_Ingenierie"
            .Chantier = "A_définir"
            .Editeur = 1
        End With

    End Sub

    ''' <summary>Gestion des entrées en cellule datagridview</summary>
    ''' <param name="toto">expression que l'on évalue</param>
    '''<param name="Verif">Vrai si l'entrée a pu être traité, Faux si l'entrée n'est pas une valeur numérique</param>
    Public Sub Gestion_CelluleDbl(ByRef toto As String, ByRef Verif As Boolean)
        Dim tutu As Double
        toto = toto.ToLower()  'transforme la chaine en minuscule, permet dans le fichier original d'écrire en minuscule ou en majuscule
        toto = toto.Trim(New Char() {" "c, ","c, ";"c, "_"c, ":"c}) 'supprime les espaces , _ et : en debut et fin de chaine 
        'remplace la virgule par le point
        toto = toto.Replace(",", ".")
        'supprime le caractère -
        ' toto = Replace(toto, "-", "")
        'vérification finale une fois le traitement précédent effectué
        If Not Double.TryParse(toto, tutu) Then Verif = False
    End Sub

    ''' <summary>Ecriture du §Hypothèses de la note de calcul</summary>
    ''' <param name="rtf">flux d'écriture</param>
    Public Sub Pieux_Ecriture_Hypothese_Note_de_calcul(ByRef rtf As To_Rtf.RtfAnsiTextWriter)
        Dim msg As String

        rtf.WriteStartGroup()
        rtf.NewParagraph(To_Rtf.RtfAnsiTextWriter.Align.Center) : rtf.Bold = True : rtf.FontSize = 18 : rtf.Underline = True
        Select Case Aff.ModeleCalcul
            Case 1, 2 ' 
                rtf.WriteString("Calcul de portance d'un pieu par les essais pressiométriques suivant la procédure modèle de terrain")
            Case 3 ' 
                rtf.WriteString("Calcul de portance d'un pieu suivant la procédure pieu modèle et essais pressiométriques")
            Case 4 '  
                rtf.WriteString("Calcul de portance d'un pieu suivant la procédure modèle de terrain et essais pénétrométriques")
            Case 5
                rtf.WriteString("Calcul de portance d'un pieu suivant la procédure pieu modèle et essais pénétrométriques")
        End Select
        rtf.NewLine()
        rtf.Bold = False : rtf.FontSize = 9 : rtf.Underline = False : rtf.NewParagraph(To_Rtf.RtfAnsiTextWriter.Align.Left)
        rtf.WriteString("Note de calcul du : ") : msg = Mise_en_Forme_date(CStr(DateTime.Now)) : rtf.WriteString(msg) : rtf.NewLine()
        rtf.WriteString("Rédacteur : " & Aff.Redacteur) : rtf.NewLine()
        rtf.WriteString("Chantier : " & Aff.Chantier) : rtf.NewLine()
        rtf.WriteString("Logiciel : MecaSol -  version " & My.Application.Info.Version.ToString & "   2025 - " & DateTime.Now.Year.ToString) : rtf.NewLine() '
        rtf.NewLine() : rtf.FontSize = 12 : rtf.Bold = True : rtf.Underline = True
        rtf.WriteString("1 - Rappel des hypothèses") : rtf.Bold = False : rtf.Underline = False : rtf.NewLine()
        rtf.FontSize = 9 : rtf.NewLine()
        rtf.FontSize = 10 : rtf.Underline = True : rtf.WriteString("1 - 1 Codes de calcul") : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine()
        rtf.WriteString("-  EN 1997-1 de juin 2005 et annexe nationale ") : rtf.NewLine()
        rtf.WriteString("-  NF P94.262 de juillet 2013 et son amendement A1") : rtf.NewLine()
        Select Case Aff.ModeleCalcul
            Case 1, 2, 4
                msg = "Modèle de terrain."
            Case 3, 5
                msg = "Pieu Modèle."
        End Select
        rtf.WriteString("La capacité portante des fondations profondes est déterminée selon la Procédure " & msg) : rtf.NewLine()
        Select Case Aff.ModeleCalcul
            Case 1
                msg = "Le Modèle géologique de terrain pour la détermination des valeurs pressiométriques et lithologiques caractéristiques a été déterminé par le Géotechnicien et figure dans son rapport." : rtf.NewLine()
            Case 2
                msg = "Les valeurs pressiométriques et lithologiques du sondage situé à moins de 5 m du point d'implantation du pieu figurent dans le rapport du Géotechnicien et font valeurs caractéristiques au sens de la norme." : rtf.NewLine()
            Case 3
                msg = "Les valeurs pressiométriques et lithologiques des sondages figurent dans le rapport du Géotechnicien." : rtf.NewLine()
            Case 4, 5
                msg = "Les valeurs pénétrométriques et lithologiques des sondages figurent dans le rapport du Géotechnicien." : rtf.NewLine()
        End Select
        rtf.WriteString("Selon l'annexe nationale à l'EC7-1, l'approche de calcul 2 a été adoptée dans le cadre de cette note de calcul.") : rtf.NewLine()
        rtf.WriteString("Elle utilise la combinaison des facteurs partiels suivants pour les situations permanentes et transitoires : A1 + M1 + R2") : rtf.NewLine()
        'Géométrie
        rtf.NewLine() : rtf.FontSize = 10 : rtf.Underline = True : rtf.WriteString("1 - 2 Caractéristiques technologiques du pieu") : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine()
        rtf.WriteString("Nom du pieu: " & Pieux.Nom) : rtf.NewLine()
        rtf.WriteString("Technique de mise en oeuvre :") : rtf.NewLine()
        With Pieux
            Select Case .Categorie
                Case 1 ' 
                    rtf.WriteString("   ► Foré simple - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                Case 2
                    rtf.WriteString("   ► Foré boue - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                Case 3
                    rtf.WriteString("   ► Foré tubé(virole perdue) - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                Case 4
                    rtf.WriteString("   ► Foré tubé(virole récupérée) - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                Case 5
                    Select Case .Abreviation
                        Case "FSR"
                            rtf.WriteString("   ► Foré simple avec rainurage - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                        Case "FBR"
                            rtf.WriteString("   ► Foré boue avec rainurage - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                        Case "PU"
                            rtf.WriteString("   ► Puit - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                    End Select
                Case 6 ' 
                    Select Case .Abreviation
                        Case "FTC"
                            rtf.WriteString("   ► Foré tarière creuse simple rotation - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                        Case "FTCD"
                            rtf.WriteString("   ► Foré tarière creuse double rotation - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                    End Select
                Case 7
                    rtf.WriteString("   ► Vissé moulé - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                Case 8
                    rtf.WriteString("   ► Vissé tubé - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                Case 9
                    Select Case .Abreviation
                        Case "BPF"
                            rtf.WriteString("   ► Battu béton préfabriqué - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                        Case "BPR"
                            rtf.WriteString("   ► Battu béton précontraint - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                    End Select
                Case 10 ' 
                    rtf.WriteString("   ► métallique Battu enrobé (béton - mortier - coulis) - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                Case 11
                    rtf.WriteString("   ► métallique Battu moulé - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                Case 12
                    rtf.WriteString("   ► Battu caisson acier fermé - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                Case 13
                    rtf.WriteString("   ► Battu acier ouvert - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                Case 14 ' 
                    rtf.WriteString("   ► Profilé H battu - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                Case 15
                    rtf.WriteString("   ► Profilé H battu injecté - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                Case 16
                    rtf.WriteString("   ► Palplanche battues - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                Case 17
                    rtf.WriteString("   ► Micropieu Type I - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                Case 18 ' 
                    rtf.WriteString("   ► Micropieu Type II - Abréviation: " & .Abreviation.ToString) : rtf.NewLine()
                Case 19
                    Select Case .Abreviation
                        Case "PIGU"
                            rtf.WriteString("   ► Pieu injecté mode IGU (type III)") : rtf.NewLine()
                        Case "MIGU"
                            rtf.WriteString("   ► Micropieu injecté mode IGU (type III)") : rtf.NewLine()
                    End Select
                Case 20
                    Select Case .Abreviation
                        Case "PIRS"
                            rtf.WriteString("   ► Pieu injecté mode IRS (type IV)") : rtf.NewLine()
                        Case "MIRS"
                            rtf.WriteString("   ► Micropieu injecté mode IRS (type IV)") : rtf.NewLine()
                    End Select
            End Select
            rtf.WriteString("   ► Classe : " & .Classe.ToString("#0")) : rtf.NewLine()
            rtf.WriteString("   ► Catégorie : " & .Categorie.ToString("#0")) : rtf.NewLine()
            rtf.WriteString("Géométrie du pieu: " & Pieux.Nom) : rtf.NewLine()
            Select Case .Categorie
                Case 1, 2, 5, 9
                    Select Case .Geom
                        Case 1   'circulaire 
                            rtf.WriteString("   ► Circulaire : ") : rtf.NewLine()
                            rtf.WriteString("      → Diamètre : " & (.Ø * 100).ToString("#0") & " cm.") : rtf.NewLine()
                            rtf.WriteString("      → Aire : " & (.Ab * 10000).ToString("#0") & " cm².") : rtf.NewLine()
                            rtf.WriteString("   ► Dimension transversale minimale Bmin : " & (.Bmin * 100).ToString("#0") & " cm.") : rtf.NewLine()
                        Case 2 'rectangulaire
                            rtf.WriteString("   ► Rectangulaire : ") : rtf.NewLine()
                            rtf.WriteString("      →  Largeur : " & (.W * 100).ToString("#0") & " cm x " & (.L * 100).ToString("#0") & " cm.") : rtf.NewLine()
                            rtf.WriteString("      → Aire : " & (.Ab * 10000).ToString("#0") & " cm².") : rtf.NewLine()
                            rtf.WriteString("   ► Dimension transversale minimale Bmin : " & (.Bmin * 100).ToString("#0") & " cm.") : rtf.NewLine()
                        Case 3 'rectangulaire arrondi
                            rtf.WriteString("   ► Rectangulaire arrondi : ") : rtf.NewLine()
                            rtf.WriteString("      →  Largeur : " & (.W * 100).ToString("#0") & " cm x " & (.L * 100).ToString("#0") & " cm.") : rtf.NewLine()
                            rtf.WriteString("      → Aire : " & (.Ab * 10000).ToString("#0") & " cm².") : rtf.NewLine()
                            rtf.WriteString("   ► Dimension transversale minimale Bmin : " & (.Bmin * 100).ToString("#0") & " cm.") : rtf.NewLine()
                    End Select
                Case 3, 4, 6, 11, 17 To 20
                    Select Case .Geom
                        Case 1   'circulaire 
                            rtf.WriteString("   ► Circulaire : ") : rtf.NewLine()
                            rtf.WriteString("      → Diamètre : " & (.Ø * 100).ToString("#0") & " cm.") : rtf.NewLine()
                            rtf.WriteString("      → Aire : " & (.Ab * 10000).ToString("#0") & " cm².") : rtf.NewLine()
                            rtf.WriteString("   ► Dimension transversale minimale Bmin : " & (.Bmin * 100).ToString("#0") & " cm.") : rtf.NewLine()
                            If .Categorie > 16 AndAlso .AucuneResistancedePointe = True Then
                                rtf.WriteString("   ► Résistance de pointe : la résistance de pointe Rb des micropieux n'est pas évaluée. Rb = 0 MN.") : rtf.NewLine()
                            End If
                    End Select
                Case 7 'vissé moulé
                    'Quelque soit la géométrie avec geom = 1 = hélice ordinaire // geom = 2 = hélice épaisse
                    rtf.WriteString("   ► Circulaire - hélice ordinaire ou hélice épaisse : ") : rtf.NewLine()
                    rtf.WriteString("      → R : " & (.R * 100).ToString("#0") & " cm.") : rtf.NewLine()
                    rtf.WriteString("      → Df : " & (.Df * 100).ToString("#0") & " cm.") : rtf.NewLine()
                    rtf.WriteString("      → Bc : " & (.Bc * 100).ToString("#0") & " cm.") : rtf.NewLine()
                    rtf.WriteString("      → Diamètre : " & (.Ø * 100).ToString("#0") & " cm.") : rtf.NewLine()
                    rtf.WriteString("      → Aire : " & (.Ab * 10000).ToString("#0") & " cm².") : rtf.NewLine()
                    rtf.WriteString("   ► Dimension transversale minimale Bmin : " & (.Bmin * 100).ToString("#0") & " cm.") : rtf.NewLine()

                Case 8 'vissé tubé
                    rtf.WriteString("   ► Circulaire - hélice ordinaire ou hélice épaisse : ") : rtf.NewLine()
                    rtf.WriteString("      → Diamètre outil : " & (.Øoutil * 100).ToString("#0") & " cm.") : rtf.NewLine()
                    rtf.WriteString("      → Diamètre fût : " & (.Øfut * 100).ToString("#0") & " cm.") : rtf.NewLine()
                    rtf.WriteString("      → Aire : " & (.Ab * 10000).ToString("#0") & " cm².") : rtf.NewLine()
                    rtf.WriteString("   ► Dimension transversale minimale Bmin : " & (.Bmin * 100).ToString("#0") & " cm.") : rtf.NewLine()
                Case 10 'battu enrobé
               'sans objet - renseigné directement par le projeteur
                Case 12, 13 'caisson acier fermé, battu caisson acier ouvert
                    Select Case .Geom
                        Case 1   'circulaire 
                            rtf.WriteString("   ► Circulaire : ") : rtf.NewLine()
                            rtf.WriteString("      → Diamètre : " & (.Ø * 100).ToString("#0") & " cm.") : rtf.NewLine()
                            rtf.WriteString("      → Aire : " & (.Ab * 10000).ToString("#0") & " cm².") : rtf.NewLine()
                            rtf.WriteString("   ► Dimension transversale minimale Bmin : " & (.Bmin * 100).ToString("#0") & " cm.") : rtf.NewLine()
                        Case 4 'caisson de palplanche
                            'sans objet - renseigné directement par le projeteur
                    End Select
                Case 14, 15 'Pieux H
                    rtf.WriteString("   ► H : ") : rtf.NewLine()
                    rtf.WriteString("      →  Largeur x hauteur : " & (.b * 100).ToString("#0") & " cm x " & (.h * 100).ToString("#0") & " cm.") : rtf.NewLine()
                    rtf.WriteString("      → Aire : " & (.Ab * 10000).ToString("#0") & " cm².") : rtf.NewLine()
                    rtf.WriteString("   ► Dimension transversale minimale Bmin : " & (.Bmin * 100).ToString("#0") & " cm.") : rtf.NewLine()
                Case 16 'palplanche
                    'sans objet - renseigné directement par le projeteur
            End Select
            rtf.WriteString("Fiche du pieu D : " & .D.ToString("#0.00") & " m (= longueur enterrée du pieu).") : rtf.NewLine()
            rtf.WriteString("Longueur d'ancrage du pieu dans la couche porteuse : " & .Hencastr.ToString("#0.00") & " m.") : rtf.NewLine()
            rtf.WriteString("Effet de groupe : ")
            Select Case .EffetGroupe
                Case True
                    rtf.WriteString("un effet de groupe a été validé. Voir § correspondant en fin de note de calcul.") : rtf.NewLine()
                Case False
                    rtf.WriteString("aucun effet de groupe n'a été validé.") : rtf.NewLine()
                    rtf.WriteString("Dans le cas où la distance minimale entre axe de fondation est inférieure à 3 diamètres, l'effet de groupe doit être considéré. Un coefficient de réduction Ce devra alors être pris en compte " &
                                 "dans le dimensionnement des pieux concernés.") : rtf.NewLine()
            End Select
            Select Case Aff.ModeleCalcul
                Case 1 'pressio + Modèle terrain + val. caractéristiques 
                    rtf.NewLine() : rtf.FontSize = 10 : rtf.Underline = True : rtf.WriteString("1 - 3 Données sur le terrain dans le cadre de la procédure Modèle de terrain") : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine()
                    rtf.WriteString("Les valeurs affichées sur les courbes pressiométriques ci-dessous sont les valeurs caractéristiques du modèle géologique validé par le Géotechnicien.") : rtf.NewLine()
                    Select Case SondageModele.NappeEau
                        Case True
                            rtf.WriteString("La nappe d'eau a été rencontrée à la profondeur " & SondageModele.Zeau.ToString("#0.00") & " m.") : rtf.NewLine()
                        Case False
                            rtf.WriteString("Aucune nappe d'eau n'a été rencontrée à la profondeur.") : rtf.NewLine()
                    End Select
                    'Calcul tassements
                    If Pieux.Tassement = True Then
                        rtf.WriteString("Tassement : un calcul de tassement a été demandé. Voir § correspondant en fin de note de calcul.") : rtf.NewLine()
                    Else
                        rtf.WriteString("Tassement : aucun calcul de tassement n'a été demandé.") : rtf.NewLine()
                    End If
                    rtf.WriteString("La reconnaissance de sol a été arrêtée à la profondeur " & SondageModele.Lithologie.Item(SondageModele.Lithologie.Count - 1).Zbase.ToString("#0.00") & " m.") : rtf.NewLine()
                    Try
                        Dim myImage As Image
                        myImage = My.Resources.Sol_675x900
                        Dim g As Graphics = Graphics.FromImage(myImage)
                        Call Dessin_Litho_Pressio(g, 2, 675, 900)
                        myImage.Save(Directory.GetCurrentDirectory.ToString() & "\test1.bmp")
                        g.Dispose()
                        rtf.InsertImage(myImage)
                        My.Computer.FileSystem.DeleteFile(Directory.GetCurrentDirectory.ToString() & "\test1.bmp") 'effacement du fichier
                    Catch ex As Exception
                        msg = String.Empty
                        msg = "Le logiciel n'a pas pu charger l'image des diagrammes des sondages pressiométriques." & Environment.NewLine & "Erreur: " & ex.Message & ex.StackTrace & Environment.NewLine & "Note de calcul sans image"
                        MessageBox.Show(msg, "Mecasol: Affichage_Sol_ModeleTerrain_Pressiometrique", MessageBoxButtons.OK, MessageBoxIcon.Information)
                        rtf.WriteString("La note de calcul n'a pas pu afficher les courbes des sondages pressiométriques du relevé Modèle de terrain.") : rtf.NewLine()
                    End Try
                Case 2  'pressio + Modèle terrain + sondage 5m 
                    rtf.NewLine() : rtf.FontSize = 10 : rtf.Underline = True : rtf.WriteString("1 - 3 Données sur le terrain dans le cadre de la procédure Modèle de terrain") : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine()
                    rtf.WriteString("Les valeurs affichées sur les courbes pressiométriques ci-dessous sont les valeurs relevées sur le sondage réalisé à moins de 5 m de l'appui (cf. note 2 Art. 8.5.2(3)  NF P94-262).") : rtf.NewLine()
                    Select Case SondageModele.NappeEau
                        Case True
                            rtf.WriteString("La nappe d'eau a été rencontrée à la profondeur " & SondageModele.Zeau.ToString("#0.00") & " m.") : rtf.NewLine()
                        Case False
                            rtf.WriteString("Aucune nappe d'eau n'a été rencontrée à la profondeur.") : rtf.NewLine()
                    End Select
                    'Calcul tassements
                    If Pieux.Tassement = True Then
                        rtf.WriteString("Tassement : un calcul de tassement a été demandé. Voir § correspondant en fin de note de calcul.") : rtf.NewLine()
                    Else
                        rtf.WriteString("Tassement : aucun calcul de tassement n'a été demandé.") : rtf.NewLine()
                    End If
                    rtf.WriteString("La reconnaissance de sol a été arrêtée à la profondeur " & SondageModele.Lithologie.Item(SondageModele.Lithologie.Count - 1).Zbase.ToString("#0.00") & " m.") : rtf.NewLine()
                    Try
                        Dim myImage As Image
                        myImage = My.Resources.Sol_675x900
                        Dim g As Graphics = Graphics.FromImage(myImage)
                        Call Dessin_Litho_Pressio(g, 2, 675, 900)
                        myImage.Save(Directory.GetCurrentDirectory.ToString() & "\test1.bmp")
                        g.Dispose()
                        rtf.InsertImage(myImage)
                        My.Computer.FileSystem.DeleteFile(Directory.GetCurrentDirectory.ToString() & "\test1.bmp") 'effacement du fichier
                    Catch ex As Exception
                        msg = String.Empty
                        msg = "Le logiciel n'a pas pu charger l'image des diagrammes des sondages pressiométriques." & Environment.NewLine & "Erreur: " & ex.Message & ex.StackTrace & Environment.NewLine & "Note de calcul sans image"
                        MessageBox.Show(msg, "Mecasol: Affichage_Sol_ModeleTerrain_Pressiometrique", MessageBoxButtons.OK, MessageBoxIcon.Information)
                        rtf.WriteString("La note de calcul n'a pas pu afficher les courbes des sondages pressiométriques du relevé Modèle de terrain.") : rtf.NewLine()
                    End Try
                Case 3 'pressio + Pieu Modèle 
                    'le présent calcul est effectué pour le sondage pressiométrique correspondant au n° d'index indexSondage
                    rtf.NewLine() : rtf.FontSize = 10 : rtf.Underline = True : rtf.WriteString("1 - 3 Données sur les terrains dans le cadre de la procédure Pieu Modèle") : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine()
                    rtf.WriteString("Nombre de sondages : " & SondagesPressio.Count.ToString("#0.00")) : rtf.NewLine()
                    rtf.WriteString("Dans cette version logicielle, les sondages ne sont pas représentés.") : rtf.NewLine()
                    With Aff
                        rtf.WriteString("Zone d'investigation géotechnique :  Longueur = " & .SurfInvestGeotechLongueur.ToString("#0.00") & " m x Largeur = " & .SurfInvestGeotechLargeur.ToString("#0.00") & " m")
                    End With
                    'Calcul tassements
                    If Pieux.Tassement = True Then
                        rtf.WriteString("Tassement : un calcul de tassement a été demandé. Voir § correspondant en fin de note de calcul.") : rtf.NewLine()
                    Else
                        rtf.WriteString("Tassement : aucun calcul de tassement n'a été demandé.") : rtf.NewLine()
                    End If
                Case 4 ' Pénétro + Modèle terrain
                    rtf.NewLine() : rtf.FontSize = 10 : rtf.Underline = True : rtf.WriteString("1 - 3 Données sur le terrain dans le cadre de la procédure Modèle de terrain") : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine()
                    If SondagePenetro.Item(0).Jupe = True Then
                        rtf.WriteString("Les sondages ont été réalisés avec un pénétromètre statique comportant un cône avec jupe. Les valeurs de résistance à la pénétration mécanique ont été corrigées par un coefficient correcteur pris égal à 1,3 ")
                        rtf.WriteString("conformément à l'article G.1(2)") : rtf.NewLine() 'prise en compte du pénétromètre comportant un cône avec jupe
                    Else
                        rtf.WriteString("Les sondages ont été réalisés avec un pénétromètre statique comportant un cône sans jupe.") : rtf.NewLine()
                    End If
                    rtf.WriteString("Dans cette version logicielle, les sondages ne sont pas représentés.") : rtf.NewLine()
                    Select Case SondageModele.NappeEau
                        Case True
                            rtf.WriteString("La nappe d'eau a été rencontrée à la profondeur " & SondageModele.Zeau.ToString("#0.00") & " m.") : rtf.NewLine()
                        Case False
                            rtf.WriteString("Aucune nappe d'eau n'a été rencontrée sur la profondeur de réalisation des essais.") : rtf.NewLine()
                    End Select
                    'Calcul tassements
                    If Pieux.Tassement = True Then
                        rtf.WriteString("Tassement : un calcul de tassement a été demandé. Voir § correspondant en fin de note de calcul.") : rtf.NewLine()
                    Else
                        rtf.WriteString("Tassement : aucun calcul de tassement n'a été demandé.") : rtf.NewLine()
                    End If
                Case 5 'Pénétro + Pieu Modèle
                    'le présent calcul est effectué pour le sondage pénétrométrique correspondant au n° d'index indexSondage
                    rtf.NewLine() : rtf.FontSize = 10 : rtf.Underline = True : rtf.WriteString("1 - 3 Données sur les terrains dans le cadre de la procédure Pieu Modèle") : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine()
                    If SondagePenetro.Item(0).Jupe = True Then
                        rtf.WriteString("Les sondages ont été réalisés avec un pénétromètre statique comportant un cône avec jupe. Les valeurs de résistance à la pénétration mécanique ont été corrigées par un coefficient correcteur pris égal à 1,3 ")
                        rtf.WriteString("conformément à l'article G.1(2)") : rtf.NewLine() 'prise en compte du pénétromètre comportant un cône avec jupe
                    Else
                        rtf.WriteString("Les sondages ont été réalisés avec un pénétromètre statique comportant un cône sans jupe.") : rtf.NewLine()
                    End If
                    rtf.WriteString("Nombre de sondages : " & SondagePenetro.Count.ToString("#0.00")) : rtf.NewLine()
                    rtf.WriteString("Dans cette version logicielle, les sondages ne sont pas représentés.") : rtf.NewLine()
                    With Aff
                        rtf.WriteString("Zone d'investigation géotechnique :  Longueur = " & .SurfInvestGeotechLongueur.ToString("#0.00") & " m x Largeur = " & .SurfInvestGeotechLargeur.ToString("#0.00") & " m") : rtf.NewLine()
                    End With
                    'Calcul tassements
                    If Pieux.Tassement = True Then
                        rtf.WriteString("Tassement : un calcul de tassement a été demandé. Voir § correspondant en fin de note de calcul.") : rtf.NewLine()
                    Else
                        rtf.WriteString("Tassement : aucun calcul de tassement n'a été demandé.") : rtf.NewLine()
                    End If
            End Select
        End With
        rtf.WriteEndGroup()
    End Sub


End Module
