﻿Imports System.Drawing.Drawing2D
Imports System.Globalization
Module Dessin

    ''' <summary>Affichage des valeurs de pressions limites Pl*, pressions de fluage Pf* et modules pressiométriques Em sur support variès: écran, image ou imprimante</summary>
    ''' <param name="g">handle graphique </param>
    ''' <param name="Support">type de support: 1=écran / 2 =image / 3 = imprimante</param>
    '''<param name="largeur">Largeur du support - Attention: pour le support papier, la hauteur est donnée en format Portrait</param>
    '''<param name="Hauteur">Hauteur du support - Attention: pour le support papier, la hauteur est donnée en format Portrait</param>
    '''<param name="Modele">=1 Sondage Pressiometrique - Porcédure Pieu Modele / =2 Sondage Pressiometrique - Porcédure Modele de terrain</param>
    Public Sub Dessin_Litho_Pressio(ByVal g As Graphics, ByVal Support As Integer, ByVal largeur As Integer, ByVal Hauteur As Integer, Optional ByRef Verif As Boolean = True)

        Dim myFont As New Font("Times New Roman", 8)
        Dim myFont1 As New Font("Times New Roman", 12)
        Dim myFont2 As New Font("Times New Roman", 10)
        Dim myBrush As New SolidBrush(Color.Black)
        Dim myPen As New Pen(Color.Black, 1)
        Dim myPenRed As New Pen(Color.Red, 1)
        Dim myPen2 As New Pen(Color.Black, 1)
        Dim myPenP As New Pen(Color.Black, 1)
        myPenP.DashStyle = DashStyle.Dot
        Dim w As SizeF
        Dim msg As String = String.Empty
        Dim OriX, OriY, i, d1, d2, d3, d4, d5, d6, d7, d8 As Integer
        Dim x1 As Single ', x2, y1, y2
        Dim Redh, RedEm, RedPf, RedPl, RedEpl, MaxEm, MaxPf, Maxpl, MaxEpl, Z As Double
        'Determination des maximums pour le calcul des valeurs de Réductions d'échelle
        Select Case Aff.ModeleCalcul
            Case 1 'modele terrain + val caracteristique
                With SondageModele.Lithologie
                    MaxEm = 0 : MaxPf = 0 : Maxpl = 0 : MaxEpl = 0
                    For i1 = 0 To .Count - 1
                        If .Item(i1).Em > MaxEm Then MaxEm = .Item(i1).Em
                        If .Item(i1).Pf > MaxPf Then MaxPf = .Item(i1).Pf
                        If .Item(i1).Pl > Maxpl Then Maxpl = .Item(i1).Pl
                        If .Item(i1).Em / .Item(i1).Pl > MaxEpl Then MaxEpl = .Item(i1).Em / .Item(i1).Pl
                    Next
                End With
            Case 2 'modele terrain + sondage 5m
                With SondageModele.MesurePressio
                    MaxEm = 0 : MaxPf = 0 : Maxpl = 0 : MaxEpl = 0
                    For i1 = 0 To .Count - 1
                        If .Item(i1).Em > MaxEm Then MaxEm = .Item(i1).Em
                        If .Item(i1).Pf > MaxPf Then MaxPf = .Item(i1).Pf
                        If .Item(i1).Pl > Maxpl Then Maxpl = .Item(i1).Pl
                        If .Item(i1).Em / .Item(i1).Pl > MaxEpl Then MaxEpl = .Item(i1).Em / .Item(i1).Pl
                    Next
                End With
        End Select

        'Détermination des origines et réductions d'échelle suivant le support
        Select Case Support
            Case 1  'ecran  
                myPen2 = New Pen(Color.Black, 2)
                myFont1 = New Font("Times New Roman", 16, FontStyle.Bold)
                OriX = 12 : OriY = 10
                d1 = 648 : d2 = 100 : d3 = 216 : d4 = 10
                With SondageModele.Lithologie
                    Redh = 700 / (.Item(.Count - 1).Zbase + 1)
                    If Redh > 650 / 10 Then Redh = 65 '650 pixels pour 10 m
                End With
            Case 2 ' support virtuel 675x900 - taille de l'image png
                myPen2 = New Pen(Color.Black, 2)
                myFont1 = New Font("Times New Roman", 12, FontStyle.Bold)
                OriX = 12 : OriY = 10
                d1 = 648 : d2 = 100 : d3 = 216 : d4 = 10
                With SondageModele.Lithologie
                    Redh = 700 / (.Item(.Count - 1).Zbase + 1)
                    If Redh > 650 / 10 Then Redh = 65 '650 pixels pour 10 m
                End With
            Case 3 'imprimante
                myPen = New Pen(Color.Black, 0.2)
                myPen2 = New Pen(Color.Black, 1)
                myFont1 = New Font("Times New Roman", 12, FontStyle.Bold)
                OriX = 10 : OriY = 20
                d1 = 189 : d2 = 27 : d3 = 63 : d4 = 5
                With SondageModele.Lithologie
                    Redh = 200 / (.Item(.Count - 1).Zbase + 1)
                    If Redh > 200 / 10 Then Redh = 20 '200mm pour 10 m
                End With
        End Select

        'dessin cadre haut
        g.DrawRectangle(myPen, OriX, OriY, d3, d2) 'rectangle gauche
        g.DrawRectangle(myPen, OriX + d3, OriY, d3, d2) 'rectangle central
        g.DrawRectangle(myPen, OriX + 2 * d3, OriY, d3, d2) 'rectangle droit
        g.DrawRectangle(myPen, OriX, OriY, d1, d2) 'rectangle général
        'Texte cadre haut
        ' - Cadre 1
        msg = "OPERATION : " & Aff.Chantier : w = g.MeasureString(msg, myFont1)
        g.DrawString(msg, myFont1, myBrush, CSng(OriX + d3 / 2 - w.Width / 2), CSng(OriY + w.Height))
        msg = "Rédacteur : " & Aff.Redacteur : w = g.MeasureString(msg, myFont)
        g.DrawString(msg, myFont, myBrush, CSng(OriX + d3 / 2 - w.Width / 2), CSng(OriY + 4 * w.Height))
        Dim Culture As New CultureInfo("fr-FR")
        msg = "Date : " & DateTime.Now.ToString(Culture) : w = g.MeasureString(msg, myFont)
        g.DrawString(msg, myFont, myBrush, CSng(OriX + d3 / 2 - w.Width / 2), CSng(OriY + d2 - 2 * w.Height))
        ' - Cadre 2
        Select Case Aff.ModeleCalcul
            Case 1
                msg = "SONDAGE PRESSIOMETRIQUE" : w = g.MeasureString(msg, myFont2)
                g.DrawString(msg, myFont2, myBrush, CSng(OriX + d3 + d3 / 2 - w.Width / 2), CSng(OriY + w.Height))
                msg = "Réalisé conformément à la norme NF P94-110" : w = g.MeasureString(msg, myFont)
                g.DrawString(msg, myFont, myBrush, CSng(OriX + d3 + d3 / 2 - w.Width / 2), CSng(OriY + 4 * w.Height))
            Case 2
                msg = "SONDAGE PRESSIOMETRIQUE" : w = g.MeasureString(msg, myFont2)
                g.DrawString(msg, myFont2, myBrush, CSng(OriX + d3 + d3 / 2 - w.Width / 2), CSng(OriY + w.Height))
                msg = "Réalisé conformément à la norme NF P94-110" : w = g.MeasureString(msg, myFont)
                g.DrawString(msg, myFont, myBrush, CSng(OriX + d3 + d3 / 2 - w.Width / 2), CSng(OriY + 4 * w.Height))
        End Select
        ' - Cadre 3
        Select Case Aff.ModeleCalcul
            Case 1 'pressio + Modèle terrain + val. caractéristiques
                msg = "Procédure Modèle de terrain"
                w = g.MeasureString(msg, myFont2)
                g.DrawString(msg, myFont2, myBrush, CSng(OriX + 2 * d3 + d3 / 2 - w.Width / 2), CSng(OriY + w.Height))
                msg = "Suivant valeurs caractéristiques" : w = g.MeasureString(msg, myFont)
                        g.DrawString(msg, myFont, myBrush, CSng(OriX + 2 * d3 + d3 / 2 - w.Width / 2), CSng(OriY + 4 * w.Height))
            Case 2  'pressio + Modèle terrain + sondage 5m 
                msg = "Procédure Modèle de terrain"
                w = g.MeasureString(msg, myFont2)
                g.DrawString(msg, myFont2, myBrush, CSng(OriX + 2 * d3 + d3 / 2 - w.Width / 2), CSng(OriY + w.Height))
                msg = "Sondage à moins de 5 m de l'implantation" : w = g.MeasureString(msg, myFont)
                        g.DrawString(msg, myFont, myBrush, CSng(OriX + 2 * d3 + d3 / 2 - w.Width / 2), CSng(OriY + 4 * w.Height))
            Case 3  'pressio + Pieu Modèle 
                msg = "Procédure Pieu Modèle"
                w = g.MeasureString(msg, myFont2)
                g.DrawString(msg, myFont2, myBrush, CSng(OriX + 2 * d3 + d3 / 2 - w.Width / 2), CSng(OriY + w.Height))
            Case 4 'Pénétro + Modèle terrain

            Case 5 '5 = Pénétro + Pieu Modèle

        End Select


        'Texte cadre bas
        OriY += d2 + d4
        Select Case Support
            Case 1  'ecran  
                d1 = 36 : d2 = 193 : d3 = 99 : d4 = 58 : d5 = 5 : d6 = 14 : d7 = 35 : d8 = 6
                'facteur de réduction
                RedEm = (d3 - 2 * d6) / MaxEm
                RedPf = (d3 - 2 * d6) / MaxPf
                RedPl = (d3 - 2 * d6) / Maxpl
                RedEpl = (d3 - 2 * d6) / MaxEpl
            Case 2 ' support virtuel
                d1 = 36 : d2 = 193 : d3 = 99 : d4 = 58 : d5 = 5 : d6 = 14 : d7 = 35 : d8 = 6
                'facteur de réduction
                RedEm = (d3 - 2 * d6) / MaxEm
                RedPf = (d3 - 2 * d6) / MaxPf
                RedPl = (d3 - 2 * d6) / Maxpl
                RedEpl = (d3 - 2 * d6) / MaxEpl
            Case 3 'imprimante
                d1 = 10 : d2 = 50 : d3 = 28 : d4 = 17 : d5 = 2 : d6 = 4 : d7 = 10 : d8 = 2
                'facteur de réduction
                RedEm = (d3 - 2 * d6) / MaxEm
                RedPf = (d3 - 2 * d6) / MaxPf
                RedPl = (d3 - 2 * d6) / Maxpl
                RedEpl = (d3 - 2 * d6) / MaxEpl
        End Select
        ' - Cadre 1 - Profondeur  
        g.DrawRectangle(myPen, OriX, OriY, d1, d4) 'rectangle Prof
        msg = "Prof." : w = g.MeasureString(msg, myFont1)
        g.DrawString(msg, myFont1, myBrush, CSng(OriX + d1 / 2 - w.Width / 2), CSng(OriY + d4 / 2 - w.Height))
        msg = "(m)" : w = g.MeasureString(msg, myFont2)
        g.DrawString(msg, myFont2, myBrush, CSng(OriX + d1 / 2 - w.Width / 2), CSng(OriY + d4 / 2 + w.Height / 2))
        g.DrawLine(myPen, OriX, OriY + d4, OriX + d1, OriY + d4) 'Horizontale basse
        ' - Cadre 2 - Niveau d'eau
        g.DrawRectangle(myPen, OriX + d1, OriY, d1, d4) 'rectangle Prof
        msg = "Niveau" : w = g.MeasureString(msg, myFont2)
        g.DrawString(msg, myFont2, myBrush, CSng(OriX + d1 + d1 / 2 - w.Width / 2), CSng(OriY + d4 / 2 - w.Height))
        msg = "d'eau" : w = g.MeasureString(msg, myFont2)
        g.DrawString(msg, myFont2, myBrush, CSng(OriX + d1 + d1 / 2 - w.Width / 2), CSng(OriY + d4 / 2 + w.Height / 2))
        g.DrawLine(myPen, OriX + d1, OriY + d4, OriX + 2 * d1, OriY + d4) 'Horizontale basse
        ' - Cadre 3 - Lithologie
        g.DrawRectangle(myPen, OriX + 2 * d1, OriY, d2, d4) 'rectangle Prof
        msg = "Lithologie" : w = g.MeasureString(msg, myFont1)
        g.DrawString(msg, myFont1, myBrush, CSng(OriX + 2 * d1 + d2 / 2 - w.Width / 2), CSng(OriY + d4 / 2 - w.Height / 2))
        g.DrawLine(myPen, OriX + 2 * d1, OriY + d4, OriX + 2 * d1 + d2, OriY + d4) 'Horizontale basse
        ' - Cadre 4 - Em
        g.DrawRectangle(myPen, OriX + 2 * d1 + d2, OriY, d3, d4) 'rectangle Prof
        msg = "Em" : w = g.MeasureString(msg, myFont1)
        g.DrawString(msg, myFont1, myBrush, CSng(OriX + 2 * d1 + d2 + d3 / 2 - w.Width / 2), CSng(OriY + d4 / 2 - w.Height))
        msg = "(MPa)" : w = g.MeasureString(msg, myFont2)
        g.DrawString(msg, myFont2, myBrush, CSng(OriX + 2 * d1 + d2 + d3 / 2 - w.Width / 2), CSng(OriY + d4 / 2 + w.Height / 2))
        g.DrawLine(myPen, OriX + 2 * d1 + d2, OriY + d4, OriX + 2 * d1 + d2 + d3, OriY + d4) 'Horizontale basse
        ' - Cadre 5 -Pf
        g.DrawRectangle(myPen, OriX + 2 * d1 + d2 + d3, OriY, d3, d4) 'rectangle Prof
        msg = "Pf*" : w = g.MeasureString(msg, myFont1)
        g.DrawString(msg, myFont1, myBrush, CSng(OriX + 2 * d1 + d2 + d3 + d3 / 2 - w.Width / 2), CSng(OriY + d4 / 2 - w.Height))
        msg = "(MPa)" : w = g.MeasureString(msg, myFont2)
        g.DrawString(msg, myFont2, myBrush, CSng(OriX + 2 * d1 + d2 + d3 + d3 / 2 - w.Width / 2), CSng(OriY + d4 / 2 + w.Height / 2))
        g.DrawLine(myPen, OriX + 2 * d1 + d2 + d3, OriY + d4, OriX + 2 * d1 + d2 + 2 * d3, OriY + d4) 'Horizontale basse
        ' - Cadre 6 -Pl*
        g.DrawRectangle(myPen, OriX + 2 * d1 + d2 + 2 * d3, OriY, d3, d4) 'rectangle Prof
        msg = "Pl*" : w = g.MeasureString(msg, myFont1)
        g.DrawString(msg, myFont1, myBrush, CSng(OriX + 2 * d1 + d2 + 2 * d3 + d3 / 2 - w.Width / 2), CSng(OriY + d4 / 2 - w.Height))
        msg = "(MPa)" : w = g.MeasureString(msg, myFont2)
        g.DrawString(msg, myFont2, myBrush, CSng(OriX + 2 * d1 + d2 + 2 * d3 + d3 / 2 - w.Width / 2), CSng(OriY + d4 / 2 + w.Height / 2))
        g.DrawLine(myPen, OriX + 2 * d1 + d2 + 2 * d3, OriY + d4, OriX + 2 * d1 + d2 + 3 * d3, OriY + d4) 'Horizontale basse
        ' - Cadre 7 -E/Pl*
        g.DrawRectangle(myPen, OriX + 2 * d1 + d2 + 3 * d3, OriY, d3, d4) 'rectangle Prof
        msg = "Em/Pl*" : w = g.MeasureString(msg, myFont1)
        g.DrawString(msg, myFont1, myBrush, CSng(OriX + 2 * d1 + d2 + 3 * d3 + d3 / 2 - w.Width / 2), CSng(OriY + d4 / 2 - w.Height))
        g.DrawLine(myPen, OriX + 2 * d1 + d2 + 3 * d3, OriY + d4, OriX + 2 * d1 + d2 + 4 * d3, OriY + d4) 'Horizontale basse
        ' - 2ième série de cadres - cadres inférieurs
        OriY += d4
        ' - Cadre 1 - Dessin echelle
        With SondageModele.Lithologie
            i = 0 : msg = i.ToString("#") : w = g.MeasureString(msg, myFont)
            g.DrawString(msg, myFont, myBrush, CSng(OriX + d1 - d5 - w.Width), CSng(OriY + w.Height / 2))
            i = 1
            Do
                g.DrawLine(myPen, OriX + d1, CSng(OriY + Redh * i), OriX + d1 - d5, CSng(OriY + Redh * i)) 'Horizontale  
                msg = i.ToString("#") : w = g.MeasureString(msg, myFont)
                g.DrawString(msg, myFont, myBrush, CSng(OriX + d1 - d5 - w.Width), CSng(OriY + Redh * i - w.Height / 2))
                i += 1
            Loop While i < .Item(.Count - 1).Zbase
            Z = 0
            For i = 1 To .Count - 1
                Z = .Item(i).Ztoit
                msg = .Item(i).Ztoit.ToString("#0.00") & " m" : w = g.MeasureString(msg, myFont)
                g.DrawString(msg, myFont, myBrush, OriX, CSng(OriY + Redh * Z - w.Height))
                g.DrawLine(myPen, OriX, CSng(OriY + Redh * Z), OriX + d1, CSng(OriY + Redh * Z)) 'Horizontale
            Next
        End With
        ' - Cadre 2 - Niveau d'eau
        With SondageModele
            If .Zeau < .Lithologie.Item(.Lithologie.Count - 1).Zbase Then
                msg = .Zeau.ToString("#0.00") & " m" : w = g.MeasureString(msg, myFont)
                g.DrawString(msg, myFont, myBrush, CSng(OriX + d1 + d1 / 2 - w.Width / 2), CSng(OriY + Redh * .Zeau - w.Height))
                g.DrawLine(myPen, OriX + d1, CSng(OriY + Redh * .Zeau), OriX + 2 * d1, CSng(OriY + Redh * .Zeau)) 'Horizontale
                g.DrawLine(myPen, OriX + d1 + d5, CSng(OriY + Redh * .Zeau) + d5, OriX + 2 * d1 - d5, CSng(OriY + Redh * .Zeau) + d5) 'Horizontale
                g.DrawLine(myPen, OriX + d1 + 2 * d5, CSng(OriY + Redh * .Zeau) + 2 * d5, OriX + 2 * d1 - 2 * d5, CSng(OriY + Redh * .Zeau) + 2 * d5) 'Horizontale
            End If
        End With
        ' - Cadre 3 - Lithologie
        With SondageModele.Lithologie
            Dim ImageSol As Image
            Dim destRect As New Rectangle(0, 0, 10, 10) ' Create rectangle for displaying image.
            Z = 0
            For i = 0 To .Count - 1
                With .Item(i)
                    msg = .NomLithologie.ToString() : w = g.MeasureString(msg, myFont)
                    If w.Width > d2 - d7 Then
                        'écriture sur 2 lignes
                        Dim Nom1, Nom2 As String
                        Dim i1 As Integer
                        i1 = CInt(.NomLithologie.Length / 2)
                        Nom1 = .NomLithologie.Substring(0, i1)
                        Nom2 = .NomLithologie.Substring(i1 - 1, .NomLithologie.Length - i1 - 1)
                        msg = Nom1 : w = g.MeasureString(msg, myFont)
                        g.DrawString(msg, myFont, myBrush, OriX + 2 * d1 + d7, CSng(OriY + Redh * Z + Redh * (.Zbase - .Ztoit) / 2 - w.Height / 2))
                        msg = Nom2 : w = g.MeasureString(msg, myFont)
                        g.DrawString(msg, myFont, myBrush, OriX + 2 * d1 + d7, CSng(OriY + Redh * Z + Redh * (.Zbase - .Ztoit) / 2 + w.Height / 2))
                    Else
                        'écriture sur une ligne
                        g.DrawString(msg, myFont, myBrush, OriX + 2 * d1 + d7, CSng(OriY + Redh * Z + Redh * (.Zbase - .Ztoit) / 2 - w.Height / 2))
                    End If

                    ImageSol = My.Resources.aide 'image générique
                    destRect = New Rectangle(OriX + 2 * d1, CInt(OriY + Redh * Z), d7, CInt(Redh * (.Zbase - .Ztoit))) ' Create rectangle for displaying image.
                    Select Case .Categorie
                        Case 0  ' Remblai
                            ImageSol = My.Resources.ImgRemblai
                        Case 1 'argiles et limons
                            ImageSol = My.Resources.ImgLimon1 ' Create image.         
                        Case 2 'sol intermédiaire de classe 1 argiles et limons
                            ImageSol = My.Resources.ImgLimon2 ' Create image.     
                        Case 3 'sol intermédiaire de classe 2 argiles et limons
                            ImageSol = My.Resources.ImgArgile1 ' Create image.
                        Case 4 'sables et graves
                            ImageSol = My.Resources.ImgSableGrave ' Create image.
                        Case 5  'Craies
                            ImageSol = My.Resources.ImgCraie ' Create image.
                        Case 6    'Marnes et calcaire marneux
                            ImageSol = My.Resources.ImgMarneCalcaire ' Create image.
                        Case 7 ' Rocher
                            ImageSol = My.Resources.ImgRocher ' Create image.
                    End Select
                    g.DrawImage(ImageSol, destRect)  ' Draw image to screen.
                    Z = .Zbase
                    g.DrawLine(myPen, OriX + 2 * d1, CSng(OriY + Redh * .Ztoit), OriX + 2 * d1 + d2, CSng(OriY + Redh * .Ztoit)) 'Horizontale
                End With
            Next
            Z = .Item(i - 1).Zbase
            g.DrawLine(myPen, OriX + 2 * d1, CSng(OriY + Redh * Z), OriX + 2 * d1 + d2, CSng(OriY + Redh * Z)) 'Horizontale
        End With
        ' - Cadre 4 - Em
        'ligne verticale de profondeur
        i = 1 : x1 = OriX + 2 * d1 + d2 + d6
        Do
            g.DrawLine(myPen, x1, CSng(OriY + Redh * i), x1 - d5, CSng(OriY + Redh * i)) 'Horizontale  
            g.DrawLine(myPenP, x1, CSng(OriY + Redh * i), x1 - d6 + d3, CSng(OriY + Redh * i)) 'Horizontale  point
            msg = i.ToString("#") : w = g.MeasureString(msg, myFont)
            g.DrawString(msg, myFont, myBrush, CSng(x1 - w.Width), CSng(OriY + Redh * i - w.Height))
            i += 1
        Loop While i < SondageModele.Lithologie.Item(SondageModele.Lithologie.Count - 1).Zbase
        msg = "0" : w = g.MeasureString(msg, myFont)
        g.DrawString(msg, myFont, myBrush, x1, CSng(OriY - w.Height)) 'affichage de la valeur 0 sur l'échelle
        g.DrawLine(myPen, x1, OriY, x1, CSng(OriY + Redh * SondageModele.Lithologie.Item(SondageModele.Lithologie.Count - 1).Zbase)) 'Verticale
        Select Case Aff.ModeleCalcul
            Case 1'modele terrain + val caracteristiques

            Case 2 'modele terrain + sondage moins de 5m
                With SondageModele.MesurePressio
                    x1 = OriX + 2 * d1 + d2 + d6
                    For i = 0 To .Count - 2
                        g.DrawLine(myPen, CSng(x1 + RedEm * .Item(i).Em), CSng(OriY + Redh * .Item(i).Z), CSng(x1 + RedEm * .Item(i + 1).Em), CSng(OriY + Redh * .Item(i + 1).Z)) 'verticale reliant les points de mesures 
                        g.DrawEllipse(myPen, CSng(x1 + RedEm * .Item(i).Em - d8 / 2), CSng(OriY + Redh * .Item(i).Z - d8 / 2), d8, d8)
                        msg = .Item(i).Em.ToString("#,##0.00") : w = g.MeasureString(msg, myFont)
                        If CSng(x1 + d8 / 2 + RedEm * .Item(i).Em) + w.Width > OriX + 2 * d1 + d2 + d3 Then
                            g.DrawString(msg, myFont, myBrush, CSng(x1 + d8 / 2 + RedEm * .Item(i).Em - w.Width), CSng(OriY + Redh * .Item(i).Z - w.Height / 2))  'affichage de la valeur i à gauche
                        Else
                            g.DrawString(msg, myFont, myBrush, CSng(x1 + d8 / 2 + RedEm * .Item(i).Em), CSng(OriY + Redh * .Item(i).Z - w.Height / 2))  'affichage de la valeur i à droite
                        End If
                    Next
                    g.DrawEllipse(myPen, CSng(x1 + RedEm * .Item(i).Em - d8 / 2), CSng(OriY + Redh * .Item(i).Z - d8 / 2), d8, d8)
                    msg = .Item(i).Em.ToString("#,##0.00") : w = g.MeasureString(msg, myFont)
                    If CSng(x1 + d8 / 2 + RedEm * .Item(i).Em) + w.Width > OriX + 2 * d1 + d2 + d3 Then
                        g.DrawString(msg, myFont, myBrush, CSng(x1 + d8 / 2 + RedEm * .Item(i).Em - w.Width), CSng(OriY + Redh * .Item(i).Z - w.Height / 2))  'affichage de la valeur i à gauche
                    Else
                        g.DrawString(msg, myFont, myBrush, CSng(x1 + d8 / 2 + RedEm * .Item(i).Em), CSng(OriY + Redh * .Item(i).Z - w.Height / 2)) 'affichage de la valeur i+1
                    End If
                End With
        End Select

        ' - Cadre 5 - Pf
        'ligne verticale de profondeur
        i = 1 : x1 = OriX + 2 * d1 + d2 + d3 + d6
        Do
            g.DrawLine(myPen, x1, CSng(OriY + Redh * i), x1 - d5, CSng(OriY + Redh * i)) 'Horizontale  
            g.DrawLine(myPenP, x1, CSng(OriY + Redh * i), x1 - d6 + d3, CSng(OriY + Redh * i)) 'Horizontale  point
            msg = i.ToString("#") : w = g.MeasureString(msg, myFont)
            g.DrawString(msg, myFont, myBrush, CSng(x1 - w.Width), CSng(OriY + Redh * i - w.Height))
            i += 1
        Loop While i < SondageModele.Lithologie.Item(SondageModele.Lithologie.Count - 1).Zbase
        msg = "0" : w = g.MeasureString(msg, myFont)
        g.DrawString(msg, myFont, myBrush, x1, CSng(OriY - w.Height)) 'affichage de la valeur 0 sur l'échelle
        g.DrawLine(myPen, x1, OriY, x1, CSng(OriY + Redh * SondageModele.Lithologie.Item(SondageModele.Lithologie.Count - 1).Zbase)) 'Verticale
        Select Case Aff.ModeleCalcul
            Case 1'modele terrain + val caracteristiques

            Case 2 'modele terrain + sondage moins de 5m
                With SondageModele.MesurePressio
                    For i = 0 To .Count - 2
                        g.DrawLine(myPen, CSng(x1 + RedPf * .Item(i).Pf), CSng(OriY + Redh * .Item(i).Z), CSng(x1 + RedPf * .Item(i + 1).Pf), CSng(OriY + Redh * .Item(i + 1).Z)) 'verticale reliant les points de mesures 
                        g.DrawEllipse(myPen, CSng(x1 + RedPf * .Item(i).Pf - d8 / 2), CSng(OriY + Redh * .Item(i).Z - d8 / 2), d8, d8)
                        msg = .Item(i).Pf.ToString("#,##0.00") : w = g.MeasureString(msg, myFont)
                        If CSng(x1 + d8 / 2 + RedPf * .Item(i).Pf) + w.Width > OriX + 2 * d1 + d2 + 2 * d3 Then
                            g.DrawString(msg, myFont, myBrush, CSng(x1 + d8 / 2 + RedPf * .Item(i).Pf - w.Width), CSng(OriY + Redh * .Item(i).Z - w.Height / 2))  'affichage de la valeur i à gauche
                        Else
                            g.DrawString(msg, myFont, myBrush, CSng(x1 + d8 / 2 + RedPf * .Item(i).Pf), CSng(OriY + Redh * .Item(i).Z - w.Height / 2)) 'affichage de la valeur i
                        End If
                    Next
                    g.DrawEllipse(myPen, CSng(x1 + RedPf * .Item(i).Pf - d8 / 2), CSng(OriY + Redh * .Item(i).Z - d8 / 2), d8, d8)
                    msg = .Item(i).Pf.ToString("#,##0.00") : w = g.MeasureString(msg, myFont)
                    If CSng(x1 + d8 / 2 + RedPf * .Item(i).Pf) + w.Width > OriX + 2 * d1 + d2 + 2 * d3 Then
                        g.DrawString(msg, myFont, myBrush, CSng(x1 + d8 / 2 + RedPf * .Item(i).Pf - w.Width), CSng(OriY + Redh * .Item(i).Z - w.Height / 2))  'affichage de la valeur i à gauche
                    Else
                        g.DrawString(msg, myFont, myBrush, CSng(x1 + d8 / 2 + RedPf * .Item(i).Pf), CSng(OriY + Redh * .Item(i).Z - w.Height / 2)) 'affichage de la valeur i+1
                    End If
                End With
        End Select

        ' - Cadre 6 - Pl*
        'ligne verticale de profondeur
        i = 1 : x1 = OriX + 2 * d1 + d2 + 2 * d3 + d6
        Do
            g.DrawLine(myPen, x1, CSng(OriY + Redh * i), x1 - d5, CSng(OriY + Redh * i)) 'Horizontale  
            g.DrawLine(myPenP, x1, CSng(OriY + Redh * i), x1 - d6 + d3, CSng(OriY + Redh * i)) 'Horizontale  point
            msg = i.ToString("#") : w = g.MeasureString(msg, myFont)
            g.DrawString(msg, myFont, myBrush, CSng(x1 - w.Width), CSng(OriY + Redh * i - w.Height))
            i += 1
        Loop While i < SondageModele.Lithologie.Item(SondageModele.Lithologie.Count - 1).Zbase
        msg = "0" : w = g.MeasureString(msg, myFont)
        g.DrawString(msg, myFont, myBrush, x1, CSng(OriY - w.Height)) 'affichage de la valeur 0 sur l'échelle
        g.DrawLine(myPen, x1, OriY, x1, CSng(OriY + Redh * SondageModele.Lithologie.Item(SondageModele.Lithologie.Count - 1).Zbase)) 'Verticale
        Select Case Aff.ModeleCalcul
            Case 1 'modele terrain + val caracteristiques
                With SondageModele.Lithologie
                    For i = 0 To .Count - 1
                        g.DrawLine(myPenRed, CSng(x1 + RedPl * .Item(i).Pl), CSng(OriY + Redh * .Item(i).Ztoit), CSng(x1 + RedPl * .Item(i).Pl), CSng(OriY + Redh * .Item(i).Zbase)) 'verticale reliant les points de mesures 
                        If i <> .Count - 1 Then g.DrawLine(myPenRed, CSng(x1 + RedPl * .Item(i).Pl), CSng(OriY + Redh * .Item(i).Zbase), CSng(x1 + RedPl * .Item(i + 1).Pl), CSng(OriY + Redh * .Item(i + 1).Ztoit)) 'horizontale reliant les points de mesures 
                        g.DrawEllipse(myPen, CSng(x1 + RedPl * .Item(i).Pl - d8 / 2), CSng(OriY + Redh * .Item(i).Ztoit - d8 / 2), d8, d8)
                        msg = .Item(i).Pl.ToString("#,##0.00") : w = g.MeasureString(msg, myFont)
                        If CSng(x1 + d8 / 2 + RedPl * .Item(i).Pl) + w.Width > OriX + 2 * d1 + d2 + 3 * d3 Then
                            g.DrawString(msg, myFont, myBrush, CSng(x1 + d8 / 2 + RedPl * .Item(i).Pl - w.Width), CSng(OriY + Redh * .Item(i).Ztoit - w.Height / 2)) 'affichage de la valeur à gauche
                        Else
                            g.DrawString(msg, myFont, myBrush, CSng(x1 + d8 / 2 + RedPl * .Item(i).Pl), CSng(OriY + Redh * .Item(i).Ztoit - w.Height / 2)) 'affichage de la valeur i
                        End If
                    Next
                End With
            Case 2 'modele terrain + sondage moins de 5m
                With SondageModele.MesurePressio
                    For i = 0 To .Count - 2
                        g.DrawLine(myPen, CSng(x1 + RedPl * .Item(i).Pl), CSng(OriY + Redh * .Item(i).Z), CSng(x1 + RedPl * .Item(i + 1).Pl), CSng(OriY + Redh * .Item(i + 1).Z)) 'verticale reliant les points de mesures 
                        g.DrawEllipse(myPen, CSng(x1 + RedPl * .Item(i).Pl - d8 / 2), CSng(OriY + Redh * .Item(i).Z - d8 / 2), d8, d8)
                        msg = .Item(i).Pl.ToString("#,##0.00") : w = g.MeasureString(msg, myFont)
                        If CSng(x1 + d8 / 2 + RedPl * .Item(i).Pl) + w.Width > OriX + 2 * d1 + d2 + 3 * d3 Then
                            g.DrawString(msg, myFont, myBrush, CSng(x1 + d8 / 2 + RedPl * .Item(i).Pl - w.Width), CSng(OriY + Redh * .Item(i).Z - w.Height / 2)) 'affichage de la valeur à gauche
                        Else
                            g.DrawString(msg, myFont, myBrush, CSng(x1 + d8 / 2 + RedPl * .Item(i).Pl), CSng(OriY + Redh * .Item(i).Z - w.Height / 2)) 'affichage de la valeur i
                        End If
                    Next
                    g.DrawEllipse(myPen, CSng(x1 + RedPl * .Item(i).Pl - d8 / 2), CSng(OriY + Redh * .Item(i).Z - d8 / 2), d8, d8)
                    msg = .Item(i).Pl.ToString("#,##0.00") : w = g.MeasureString(msg, myFont)
                    If CSng(x1 + d8 / 2 + RedPl * .Item(i).Pl) + w.Width > OriX + 2 * d1 + d2 + 3 * d3 Then
                        g.DrawString(msg, myFont, myBrush, CSng(x1 + d8 / 2 + RedPl * .Item(i).Pl - w.Width), CSng(OriY + Redh * .Item(i).Z - w.Height / 2)) 'affichage de la valeur à gauche
                    Else
                        g.DrawString(msg, myFont, myBrush, CSng(x1 + d8 / 2 + RedPl * .Item(i).Pl), CSng(OriY + Redh * .Item(i).Z - w.Height / 2)) 'affichage de la valeur i+1
                    End If
                End With
        End Select

        ' - Cadre 7 - E/Pl*
        'ligne verticale de profondeur
        i = 1 : x1 = OriX + 2 * d1 + d2 + 3 * d3 + d6
        Do
            g.DrawLine(myPen, x1, CSng(OriY + Redh * i), x1 - d5, CSng(OriY + Redh * i)) 'Horizontale  
            g.DrawLine(myPenP, x1, CSng(OriY + Redh * i), x1 - d6 + d3, CSng(OriY + Redh * i)) 'Horizontale  point
            msg = i.ToString("#") : w = g.MeasureString(msg, myFont)
            g.DrawString(msg, myFont, myBrush, CSng(x1 - w.Width), CSng(OriY + Redh * i - w.Height))
            i += 1
        Loop While i < SondageModele.Lithologie.Item(SondageModele.Lithologie.Count - 1).Zbase
        msg = "0" : w = g.MeasureString(msg, myFont)
        g.DrawString(msg, myFont, myBrush, x1, CSng(OriY - w.Height)) 'affichage de la valeur 0 sur l'échelle
        g.DrawLine(myPen, x1, OriY, x1, CSng(OriY + Redh * SondageModele.Lithologie.Item(SondageModele.Lithologie.Count - 1).Zbase)) 'Verticale
        Select Case Aff.ModeleCalcul
            Case 1'modele terrain + val caracteristiques

            Case 2 'modele terrain + sondage moins de 5m
                With SondageModele.MesurePressio
                    For i = 0 To .Count - 2
                        g.DrawLine(myPen, CSng(x1 + RedEpl * (.Item(i).Em / .Item(i).Pl)), CSng(OriY + Redh * .Item(i).Z), CSng(x1 + RedEpl * (.Item(i + 1).Em / .Item(i + 1).Pl)), CSng(OriY + Redh * .Item(i + 1).Z)) 'verticale reliant les points de mesures 
                        g.DrawEllipse(myPen, CSng(x1 + RedEpl * (.Item(i).Em / .Item(i).Pl) - d8 / 2), CSng(OriY + Redh * .Item(i).Z - d8 / 2), d8, d8)
                        msg = (.Item(i).Em / .Item(i).Pl).ToString("#,##0.00") : w = g.MeasureString(msg, myFont)
                        If CSng(x1 + d8 / 2 + RedEpl * (.Item(i).Em / .Item(i).Pl)) + w.Width > OriX + 2 * d1 + d2 + 4 * d3 Then
                            g.DrawString(msg, myFont, myBrush, CSng(x1 + d8 / 2 + RedEpl * (.Item(i).Em / .Item(i).Pl) - w.Width), CSng(OriY + Redh * .Item(i).Z - w.Height / 2)) 'affichage de la valeur à gauche
                        Else
                            g.DrawString(msg, myFont, myBrush, CSng(x1 + d8 / 2 + RedEpl * (.Item(i).Em / .Item(i).Pl)), CSng(OriY + Redh * .Item(i).Z - w.Height / 2)) 'affichage de la valeur i
                        End If
                    Next
                    g.DrawEllipse(myPen, CSng(x1 + RedEpl * (.Item(i).Em / .Item(i).Pl) - d8 / 2), CSng(OriY + Redh * .Item(i).Z - d8 / 2), d8, d8)
                    msg = (.Item(i).Em / .Item(i).Pl).ToString("#,##0.00") : w = g.MeasureString(msg, myFont)
                    If CSng(x1 + d8 / 2 + RedEpl * (.Item(i).Em / .Item(i).Pl)) + w.Width > OriX + 2 * d1 + d2 + 4 * d3 Then
                        g.DrawString(msg, myFont, myBrush, CSng(x1 + d8 / 2 + RedEpl * (.Item(i).Em / .Item(i).Pl) - w.Width), CSng(OriY + Redh * .Item(i).Z - w.Height / 2)) 'affichage de la valeur à gauche
                    Else
                        g.DrawString(msg, myFont, myBrush, CSng(x1 + d8 / 2 + RedEpl * (.Item(i).Em / .Item(i).Pl)), CSng(OriY + Redh * .Item(i).Z - w.Height / 2)) 'affichage de la valeur i+1
                    End If
                End With
        End Select

        'Dessin des rectangles
        With SondageModele.Lithologie
            g.DrawRectangle(myPen, OriX, OriY, d1, CSng(Redh * .Item(.Count - 1).Zbase)) 'rectangle Prof
            g.DrawRectangle(myPen, OriX, OriY, 2 * d1, CSng(Redh * .Item(.Count - 1).Zbase)) 'rectangle niveau eau
            g.DrawRectangle(myPen, OriX, OriY, 2 * d1 + d2, CSng(Redh * .Item(.Count - 1).Zbase)) 'rectangle Lithologie
            g.DrawRectangle(myPen, OriX, OriY, 2 * d1 + d2 + d3, CSng(Redh * .Item(.Count - 1).Zbase)) 'rectangle Em
            g.DrawRectangle(myPen, OriX, OriY, 2 * d1 + d2 + 2 * d3, CSng(Redh * .Item(.Count - 1).Zbase)) 'rectangle Pf
            g.DrawRectangle(myPen, OriX, OriY, 2 * d1 + d2 + 3 * d3, CSng(Redh * .Item(.Count - 1).Zbase)) 'rectangle Pl
            g.DrawRectangle(myPen, OriX, OriY, 2 * d1 + d2 + 4 * d3, CSng(Redh * .Item(.Count - 1).Zbase)) 'rectangle Em/pl
        End With
    End Sub
End Module
