﻿Imports System.Math
Module CalculMecaSol
#Region "Calcul de la portance de pieu par les essais au Pressiomètre"
    ''' <summary>Calcul de la portance d'un pieu par la procédure Modèle de terrain et essais pressiométriques</summary>
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    ''' <param name="Verif">renvoie FALSE si erreur</param>
    Public Sub Calcul_Pieu_Portance_ModeleTerrain_Pressiometrique(ByRef rtf As To_Rtf.RtfAnsiTextWriter, ByRef Verif As Boolean)
        Dim Def, ple, Rb, Rs, Rbk, Rsk As Double '
        Dim i_chap As Integer = 2

        'Détermination des résistances de pointe Rb et des résistances par frottement Rs à partir des essais pressiométriques
        Call Pieu_Portance_EssaisPressiometriques(Rb, Rs, ple, Def, i_chap, rtf, Verif)
        '
        'Détermination des valeurs de calcul de portance par la procédure du Modèle de Terrain
        Call Portance_Modele_de_Terrain(i_chap, 1, Rb, Rs, Rbk, Rsk, rtf)
        '
        '---------------> Effet de groupe (éventuellement)
        If Pieux.EffetGroupe = True Then
            'dans le cadre de la procédure Modèle de Terrain, Rb et Rs sont égaux à Rbk et Rsk car les propriétés du terrain sont déjà des valeurs caractéristiques
            'calcul de l'incidence pour le pieu isolé
            Call Effet_de_Groupe(i_chap, Rbk, Rsk, rtf)
            'calcul pour l'ensemble des pieux
            Call Effet_de_Groupe_Bloc(i_chap, rtf, Def, ple)
        End If
        '
        '---------------> Evaluation des tassements
        If Pieux.Tassement = True Then Call Evaluation_tassement(i_chap, rtf)
        '
        '---------------> Affichage des avertissements
        rtf.WriteStartGroup() : rtf.NewParagraph()
        rtf.FontSize = 12 : rtf.Bold = True : i_chap += 1
        rtf.Underline = True : rtf.WriteString(i_chap.ToString("#") & " - Avertissements") : rtf.Bold = False : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine() : rtf.NewLine()
        If Aff.msg_Avertiss.Count > 0 Then
            For i1 = 0 To Aff.msg_Avertiss.Count - 1
                rtf.WriteString(Aff.msg_Avertiss.Item(i1).ToString()) : rtf.NewLine()
            Next i1
        Else
            rtf.WriteString("Aucun avertissement.") : rtf.NewLine()
        End If
        rtf.WriteEndGroup()
    End Sub

    ''' <summary>Calcul de Rb et Rs suivant les essais pressiométriques suivant la Procédure Modèle de terrain</summary>
    ''' <param name="i_chap">indice de chapitre</param>  
    ''' <param name="Rb">Résistance de pointe du pieu déterminé par les essais pressiométriques</param>
    ''' <param name="Rs">Résistance de frottement du pieu déterminé par les essais pressiométriques</param>
    ''' <param name="Def">hauteur de l'encastrement effectif suivant Annexe F - essais pressiométriques, en m</param>
    ''' <param name="ple">pression limite nette équivalente suivant Annexe F - essais pressiométriques, en MPa</param>
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    ''' <param name="Verif">renvoie FALSE si erreur</param>
    Private Sub Pieu_Portance_EssaisPressiometriques(ByRef Rb As Double, ByRef Rs As Double, ByRef ple As Double, ByRef Def As Double, ByRef i_chap As Integer, ByRef rtf As To_Rtf.RtfAnsiTextWriter, ByRef Verif As Boolean)
        Dim a, b, h, hD, Kp, kpMax, pl1_2, pl3_4, plmin, plMax, pl_dz, qb, zinf1, zinf2 As Double ' 
        Dim i, ind1, ind2, ind3, ind4, j As Integer
        Dim ind1_ind2, ind3_ind4 As Boolean
        Dim msg As String = String.Empty

        'Ecriture dans la note de calcul 
        rtf.WriteStartGroup()
        rtf.NewParagraph()
        rtf.FontSize = 12 : rtf.NewLine()
        rtf.Bold = True : rtf.Underline = True
        rtf.WriteString(i_chap.ToString("#0") & " -  Calcul de la résistance de pointe Rb") : rtf.FontSize = 10 : rtf.Bold = False : rtf.NewLine() : rtf.NewLine()
        rtf.WriteString(i_chap.ToString("#0") & " - 1  Calcul de la pression limite nette équivalente P*") : rtf.Subscript = True : rtf.WriteString("le") : rtf.Subscript = False
        rtf.FontSize = 9 : rtf.Underline = False : rtf.NewLine() : rtf.NewLine()
        rtf.WriteString("Le calcul de la valeur de la pression limite nette équivalente est réalisé suivant l'équation F.4.2.3 de l'annexe F de la NF P94-262 - 2013") : rtf.NewLine()
        'calcul de la résistance de pointe Rb
        '-----------------------------------------------
        'calcul de ple pression limite nette equivalente
        '-----------------------------------------------
        '--> calcul des coefficients a, b pour la détermination de la pression limite nette equivalente
        'hencastrement = hauteur du pieu dans la formation porteuse
        '
        rtf.WriteString("Fiche du pieu D : " & Pieux.D.ToString("#0.00") & " m (= longueur enterrée du pieu).") : rtf.NewLine()
        rtf.WriteString("Hauteur d'encastrement du pieu dans la couche porteuse : " & Pieux.Hencastr.ToString("#0.00") & " m.") : rtf.NewLine()

        '--> détermination coefficients a, b
        a = Max(Pieux.Bmin / 2, 0.5)
        b = Min(a, Pieux.Hencastr)
        rtf.WriteString("Valeur a = " & a.ToString("#0.00") & " m  = Max(Bmin/2; 0,50 m)") : rtf.NewLine()
        rtf.WriteString("Valeur b = " & a.ToString("#0.00") & " m  = Min(a, Hauteur d'encastrement du pieu dans la couche porteuse)") : rtf.NewLine()

        '--> calcul de ple pression limite nette equivalente
        zinf1 = Pieux.D - b
        zinf2 = Pieux.D + 3 * a
        rtf.WriteString("Côte relative de D-b = " & zinf1.ToString("#0.00") & " m.") : rtf.NewLine()
        rtf.WriteString("Côte relative de D+3a = " & zinf2.ToString("#0.00") & " m.") : rtf.NewLine()
        Select Case Aff.ModeleCalcul
            Case 1 'Modele terrain + val car
                With SondageModele.Lithologie
                    For j = .Count To 1 Step -1 'les indices augmentent avec la profondeur
                        If Pieux.D > .Item(j - 1).Ztoit AndAlso Pieux.D < .Item(j - 1).Zbase Then
                            plmin = .Item(j - 1).Pl : plMax = plmin
                            Select Case SondageModele.Plmoyen
                                Case True 'les Pl renseignées sont des Pression Limites moyennes
                                    pl_dz = PressionLimiteNette(.Item(j - 1).Pl, Pieux.D) * (b + 3 * a)
                                    rtf.WriteString("Pression limite nette caractéristique de la couche d'ancrage = " & PressionLimiteNette(.Item(j - 1).Pl, Pieux.D).ToString("#0.00") & " MPa.") : rtf.NewLine()
                                    Exit For
                                Case False 'les Pl renseignées sont des Pression Limites nettes
                                    pl_dz = .Item(j - 1).Pl * (b + 3 * a) : Exit For
                            End Select

                        End If
                    Next
                End With
            Case 2 'modele terrain + sondage 5m
                ind1 = 0 : ind2 = 0 : ind3 = 0 : ind4 = 0 : ind1_ind2 = False : ind3_ind4 = False
                For j = SondageModele.MesurePressio.Count To 1 Step -1 'les indices augmentent avec la profondeur
                    With SondageModele.MesurePressio.Item(j - 1)
                        Select Case j
                            Case SondageModele.MesurePressio.Count
                                If zinf2 < .Z Then
                                    ind4 = j - 1
                                ElseIf zinf2 = .Z Then
                                    ind3_ind4 = True
                                    ind4 = j - 1 : ind3 = ind4
                                End If
                            Case Is <= 2
                                If ind3_ind4 = False Then
                                    ind3_ind4 = True : ind1_ind2 = True
                                    ind4 = 1 : ind3 = ind4
                                    ind1 = 0 : ind2 = ind1
                                Else
                                    If zinf1 < .Z Then
                                        ind2 = j - 1 '--> .Z( ind2) > zinf1 = borne inférieure
                                    ElseIf zinf1 = .Z Then
                                        ind1_ind2 = True
                                        ind1 = j - 1 : ind2 = ind1
                                    ElseIf j = 1 Then
                                        ind2 = 0 : ind1 = 0 : ind1_ind2 = True
                                    End If
                                End If
                            Case Else
                                If ind3_ind4 = False Then
                                    If .Z > zinf2 Then
                                        ind4 = j - 1 '--> .Z(ind4) > zinf2 = borne inférieure
                                    ElseIf zinf2 = .Z Then
                                        ind3_ind4 = True
                                        ind4 = j - 1 : ind3 = ind4
                                    Else
                                        ind3_ind4 = True
                                        ind3 = j - 1  '--> .Z(ind3) < zinf2 = borne supérieure
                                    End If
                                Else
                                    If zinf1 < .Z Then
                                        ind2 = j - 1 '--> .Z( ind2) > zinf1 = borne inférieure
                                    ElseIf zinf1 = .Z Then
                                        ind1_ind2 = True
                                        ind1 = j - 1 : ind2 = ind1
                                    Else
                                        ind1_ind2 = True
                                        ind1 = j - 1  '--> .Z(ind1) < zinf2 = borne supérieure
                                        ind2 = j   '--> .Z( ind2) > zinf1 = borne inférieure
                                    End If
                                End If
                        End Select
                        If ind3_ind4 = True AndAlso ind1_ind2 = True Then Exit For
                    End With
                Next

                With SondageModele.MesurePressio
                    If ind1 <> ind2 Then
                        pl1_2 = .Item(ind1).Pl + ((.Item(ind2).Pl - .Item(ind1).Pl) / (.Item(ind2).Z - .Item(ind1).Z)) * (zinf1 - .Item(ind1).Z)
                    Else
                        pl1_2 = .Item(ind1).Pl
                    End If
                    plmin = pl1_2 : plMax = pl1_2
                    If ind3 <> ind4 Then
                        pl3_4 = .Item(ind3).Pl + ((.Item(ind4).Pl - .Item(ind3).Pl) / (.Item(ind4).Z - .Item(ind3).Z)) * (zinf2 - .Item(ind3).Z)
                    Else
                        pl3_4 = .Item(ind3).Pl
                    End If
                    If plmin > pl3_4 Then plmin = pl3_4 : If plMax < pl3_4 Then plMax = pl3_4
                    pl_dz = (.Item(ind2).Z - zinf1) * (pl1_2 + .Item(ind2).Pl) / 2
                    If plmin > .Item(ind2).Pl Then plmin = .Item(ind2).Pl : If plMax < .Item(ind2).Pl Then plMax = .Item(ind2).Pl
                    For i = ind2 To ind3 - 1
                        pl_dz += (.Item(i + 1).Z - .Item(i).Z) * (.Item(i + 1).Pl + .Item(i).Pl) / 2
                        If plmin > .Item(i + 1).Pl Then plmin = .Item(i + 1).Pl : If plMax < .Item(i + 1).Pl Then plMax = .Item(i + 1).Pl
                        If plmin > .Item(i).Pl Then plmin = .Item(i).Pl : If plMax < .Item(i).Pl Then plMax = .Item(i).Pl
                    Next
                    pl_dz += (zinf2 - .Item(ind3).Z) * (pl3_4 + .Item(ind3).Pl) / 2 'calcul de l'intégration sur le dernier tronçon
                    If plmin > .Item(ind3).Pl Then plmin = .Item(ind3).Pl : If plMax < .Item(ind3).Pl Then plMax = .Item(ind3).Pl
                End With
        End Select

        rtf.WriteString("Valeur de l'intégrale P*l(z)dz entre les bornes D-b et D+3a = " & pl_dz.ToString("#0.00") & " MPa.m.") : rtf.NewLine()
        ple = pl_dz / (b + 3 * a)
        rtf.WriteString("Valeur de la pression limite nette équivalente - P*le  = " & ple.ToString("#0.00") & " MPa.") : rtf.NewLine()
        '--> test sur l'homogénéité de la couche porteuse
        rtf.WriteString("La Note 1 - §F4.2.(3) de la NF P94-262 - 2013 impose de vérifier l'homogènéité de la couche porteuse ")
        If plMax < 2 * plmin Then
            rtf.WriteString("plMax (= " & plMax.ToString("#0.00") & " MPa) < 2 x plmin ( = 2 x " & plmin.ToString("#0.00") & " MPa) - Condition satisfaite.") : rtf.NewLine()
        Else
            rtf.WriteString("plMax (= " & plMax.ToString("#0.00") & " MPa) > 2 x plmin ( = 2 x " & plmin.ToString("#0.00") & " MPa) - Condition NON satisfaite.") : rtf.NewLine()
            msg = "La couche porteuse est considérée comme non homogène car la pression limite maximale mesurée dans cette couche excède plus de deux fois la pression limite minimale (Note 1 - §F4.2.(3) de la NF P94-262 - 2013)."
            Aff.msg_Avertiss.Add(msg)
        End If
        rtf.NewLine() : rtf.FontSize = 10 : rtf.Underline = True
        rtf.WriteString(i_chap.ToString("#0") & " - 2  Calcul du facteur de portance Kp") : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine() : rtf.NewLine()
        '
        'calcul de l'encastrement effectif
        '-------------------------------- 
        hD = Min(10 * Pieux.Bmin, Pieux.D) 'Condition du CEREMA
        rtf.WriteString("Valeur de hD = " & hD.ToString("#0.00") & " m.") : rtf.NewLine()
        zinf1 = Pieux.D - hD
        Select Case Aff.ModeleCalcul
            Case 1 'Modele terrain + val car
                With SondageModele.Lithologie
                    ind1 = 0
                    'calcul de l'intégration sur la dernière couche (la plus profonde)
                    For j = .Count To 1 Step -1 'les indices augmentent avec la profondeur
                        If Pieux.D > .Item(j - 1).Ztoit AndAlso Pieux.D < .Item(j - 1).Zbase Then
                            Select Case SondageModele.Plmoyen
                                Case True 'les Pl renseignées sont des Pression Limites moyennes
                                    pl_dz = PressionLimiteNette(.Item(j - 1).Pl, (.Item(j - 1).Ztoit + Pieux.D) / 2) * (Pieux.D - .Item(j - 1).Ztoit)
                                Case False 'les Pl renseignées sont des Pression Limites nettes
                                    pl_dz = .Item(j - 1).Pl * (Pieux.D - .Item(j - 1).Ztoit)
                            End Select
                            Exit For
                        End If
                    Next
                    'calcul de l'intégration sur les couches intermédiaires
                    j -= 1
                    If j > 0 Then 'dans le cas ou il n'y aurait qu'une seule couche de terrain
                        Do
                            Select Case SondageModele.Plmoyen
                                Case True 'les Pl renseignées sont des Pression Limites moyennes
                                    pl_dz += PressionLimiteNette(.Item(j - 1).Pl, (.Item(j - 1).Ztoit + .Item(j - 1).Zbase) / 2) * (.Item(j - 1).Zbase - .Item(j - 1).Ztoit)
                                Case False 'les Pl renseignées sont des Pression Limites nettes
                                    pl_dz += .Item(j - 1).Pl * (.Item(j - 1).Zbase - .Item(j - 1).Ztoit)
                            End Select
                            j -= 1
                            If j = 0 Then Exit Do
                        Loop While zinf1 >= .Item(j - 1).Ztoit
                    End If
                    'calcul de l'intégration sur la première couche
                    If zinf1 > 0.1 Then
                        If j = 0 Then j = 1
                        Select Case SondageModele.Plmoyen
                            Case True 'les Pl renseignées sont des Pression Limites moyennes
                                If PressionLimiteNette(.Item(0).Pl, (.Item(0).Zbase)) > 0 Then pl_dz += PressionLimiteNette(.Item(j - 1).Pl, (.Item(j - 1).Ztoit + zinf1) / 2) * (.Item(j - 1).Zbase - zinf1)
                            Case False 'les Pl renseignées sont des Pression Limites nettes
                                pl_dz += .Item(j - 1).Pl * (.Item(j - 1).Zbase - zinf1)
                        End Select
                    Else
                        'calcul de l'intégration sur le 1ier tronçon
                        Select Case SondageModele.Plmoyen
                            Case True 'les Pl renseignées sont des Pression Limites moyennes
                                If PressionLimiteNette(.Item(0).Pl, (.Item(0).Zbase)) > 0 Then pl_dz += PressionLimiteNette(.Item(0).Pl, (.Item(0).Zbase) / 2) * .Item(0).Zbase
                            Case False 'les Pl renseignées sont des Pression Limites nettes
                                pl_dz += .Item(0).Pl * .Item(0).Zbase
                        End Select
                    End If
                End With
            Case 2 'modele terrain + sondage 5m
                ind1 = 0 : ind2 = 0 : ind3 = 0 : ind4 = 0 : pl_dz = 0
                With SondageModele.MesurePressio
                    If zinf1 > 0.1 Then
                        For j = 1 To SondageModele.MesurePressio.Count
                            If zinf1 < .Item(j - 1).Z Then
                                ind2 = j - 1 'index de la 1ière valeur de pression limite au delà de Zinf1
                                If ind2 > 0.1 Then
                                    ind1 = ind2 - 1 'index de la 1ière valeur de pression limite au deça de Zinf2
                                    pl1_2 = .Item(ind1).Pl + ((.Item(ind2).Pl - .Item(ind1).Pl) / (.Item(ind2).Z - .Item(ind1).Z)) * (zinf1 - .Item(ind1).Z)
                                Else
                                    pl1_2 = .Item(ind2).Pl * zinf1 / .Item(ind2).Z
                                End If
                                Exit For
                            End If
                        Next
                        pl_dz = (.Item(ind2).Z - zinf1) * (pl1_2 + .Item(ind2).Pl) / 2 'calcul de l'intégration sur le 1ier tronçon
                    Else
                        pl_dz = .Item(ind2).Z * .Item(ind2).Pl / 2 'calcul de l'intégration sur le 1ier tronçon
                    End If

                    zinf2 = Pieux.D
                    For j = 1 To SondageModele.MesurePressio.Count
                        If zinf2 < .Item(j - 1).Z Then
                            ind4 = j - 1 'index de la 1ière valeur de pression limite au delà de Zinf2
                            If ind4 > 0.1 Then ind3 = ind4 - 1 'index de la 1ière valeur de pression limite au deça de Zinf2
                            'calcul de la pression limite sur le dernier tronçon
                            pl3_4 = .Item(ind3).Pl + ((.Item(ind4).Pl - .Item(ind3).Pl) / (.Item(ind4).Z - .Item(ind3).Z)) * (zinf2 - .Item(ind3).Z)
                            Exit For
                        End If
                    Next

                    'calcul de l'intégration sur les tronçons intermédiaires et final
                    If ind2 < ind3 - 1 Then
                        For i = ind2 To ind3 - 1
                            pl_dz += (.Item(i + 1).Z - .Item(i).Z) * (.Item(i + 1).Pl + .Item(i).Pl) / 2
                        Next
                    End If
                    pl_dz += (zinf2 - .Item(ind3).Z) * (pl3_4 + .Item(ind3).Pl) / 2 'calcul de l'intégration sur le dernier tronçon
                End With
        End Select
        rtf.WriteString("Valeur de l'intégrale P*l(z)dz entre les bornes D-hD (= " & (Pieux.D - hD).ToString("#0.00") & " m) et D (= " & Pieux.D.ToString("#0.00") & " m); P*l(z)dz = " & pl_dz.ToString("#0.00") & " MPa.m.") : rtf.NewLine()
        Def = pl_dz / ple
        rtf.WriteString("Hauteur d'encastrement effective Def (définition suivant annexe F §F.4.2(4) de la NF P94.262) = " & Def.ToString("#0.00") & " m.")
        '
        'Calcul de Kp et KpMax pour la détermination de qb puis Rb (résistance de pointe) Exception faite pour les micropieux
        If Pieux.Categorie > 16 AndAlso Pieux.AucuneResistancedePointe = True Then 'Clause de la prise en compte de la résistance de pointe pour les micropieux
            'pas de calcul de résistance de pointe pour les micropieux, sauf dans le cas d'un effet de groupe ou ple doit être calculée
            'détermination de kp
            rtf.WriteString("Valeur du facteur de portance Kp  = 0  -  Pas de calcul de résistance de pointe pour les micropieux") : rtf.NewLine()
            rtf.NewLine() : rtf.FontSize = 10 : rtf.Underline = True
            rtf.WriteString(i_chap.ToString("#0") & " - 3  Effort limite mobilisable dû au terme de pointe") : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine() : rtf.NewLine()
            rtf.WriteString("Valeur de la résistance de pointe Rb : 0 MN  -  Aucune résistance de pointe pour les micropieux, uniquement une résistance par frottement (voir ci-dessous).") : rtf.NewLine() : rtf.NewLine()
            Rb = 0 : Kp = 0 : qb = 0
        Else
            '--> test sur la hauteur d'encastrement effectif dans la couche porteuse
            If Pieux.Bmin > 0.5 Then
                If Def < 1.5 Then
                    rtf.WriteString(" - Non Satisfaisant - voir §Avertissement.") : rtf.NewLine()
                    msg = "La profondeur d'encastrement du pieu dans la couche porteuse Def (= " & Def.ToString("#0.00") & " m) ne répond pas aux conditions de la note 1 de l'annexe F §F4.2.(4) de la NF P94-262 - 2013, " &
               "- Soit 1,50m pour les pieux de diamètre supérieur à 0,50m." & Environment.NewLine
                    Aff.msg_Avertiss.Add(msg)
                Else
                    rtf.WriteString(" - Satisfaisant.") : rtf.NewLine()
                End If
            Else
                If Def < 3 * Pieux.Bmin Then
                    rtf.WriteString(" - Non Satisfaisant - voir §Avertissement.") : rtf.NewLine()
                    msg = "La profondeur d'encastrement du pieu dans la couche porteuse Def (= " & Def.ToString("#0.00") & " m) ne répond pas aux conditions de la note 1 de l'annexe F §F4.2.(4) de la NF P94-262 - 2013, " &
                 "- Soit < à 3 diamètres pour les pieux de diamètre inférieur à 0,50m." & Environment.NewLine
                    Aff.msg_Avertiss.Add(msg)
                Else
                    rtf.WriteString(" - Satisfaisant.") : rtf.NewLine()
                End If
            End If
            'détermination de kpMax
            'détermination de l'index de la couche de sol correspondante
            With SondageModele.Lithologie
                h = 0
                For j = 1 To .Count
                    h += .Item(j - 1).hcouche
                    If zinf2 < h Then
                        ' j - 1 = index de la 1ière valeur de Zinf en dessous de Zinf2
                        'détermination de kpmax
                        Call KpMax_Determination(.Item(j - 1).Categorie, kpMax)
                        Exit For
                    End If
                Next
            End With
            'détermination de kp
            rtf.WriteString("Valeur du facteur de portance maximal KpMax = " & kpMax.ToString("#0.00") & " ") : rtf.NewLine()
            rtf.WriteString("Valeur du rapport Def/B = " & (Def / Pieux.Bmin).ToString("#0.00") & " ") : rtf.NewLine()
            If Def / Pieux.Bmin >= 5 Then
                Kp = kpMax
                rtf.WriteString("Rapport Def/B ≥ 5 - Kp = kpMax soit Kp = " & kpMax.ToString("#0.00") & " ") : rtf.NewLine()
            Else
                Kp = 1 + (kpMax - 1) * (Def / Pieux.Bmin) / 5
                rtf.WriteString("Rapport Def/B < 5 - Kp = " & Kp.ToString("#0.00") & " suivant équation du §F.4.2(4) de la NF P94.262. ") : rtf.NewLine()
            End If
            'Calcul de la résistance de pointe de la fondation profonde
            qb = Kp * ple
            Rb = Pieux.Ab * qb
            rtf.NewLine() : rtf.FontSize = 10 : rtf.Underline = True
            rtf.WriteString(i_chap.ToString("#0") & " - 3  Effort limite mobilisable dû au terme de pointe") : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine() : rtf.NewLine()
            rtf.WriteString("Valeur de la pression de rupture du terrain sous la base du pieu qb (= Kp * pl*e) : " & qb.ToString("#0.000") & " MPa.") : rtf.NewLine()
            rtf.WriteString("Valeur de la résistance de pointe Rb (= aire.qb) : ") : rtf.Bold = True : rtf.Underline = True : rtf.WriteString(Rb.ToString("#0.0000")) : rtf.Bold = False : rtf.Underline = False : rtf.WriteString(" MN.") : rtf.NewLine() : rtf.NewLine()
        End If
        '
        '
        'calcul de la résistance de frottement axial Rs
        '-----------------------------------------------
        i_chap += 1 : rtf.FontSize = 12 : rtf.Bold = True : rtf.Underline = True
        rtf.WriteString(i_chap.ToString("#0") & " -  Calcul de la résistance de frottement axial Rs") : rtf.FontSize = 10 : rtf.Bold = False : rtf.NewLine() : rtf.NewLine()
        rtf.WriteString(i_chap.ToString("#0") & " - 1  Calcul de qs(z) pour toutes les valeurs mesurées de la pression limite nette Pl*")
        rtf.FontSize = 9 : rtf.Underline = False : rtf.NewLine() : rtf.NewLine()
        rtf.WriteEndGroup()
        Dim c, qs_D, ʃqs, qsMax, qsi, qs1(SondageModele.Lithologie.Count), qs2(SondageModele.MesurePressio.Count), αpieu_sol As Double
        Dim entete As Boolean = True
        'calcul de qs(z) pour toutes les valeurs mesurées de pl*
        ind1 = 0 : h = 0 : msg = String.Empty


        For i = 0 To SondageModele.Lithologie.Count - 1
            'calcul sur toutes les couches lithologiques
            Select Case Aff.ModeleCalcul
                Case 1 'Modele terrain + val car
                    With SondageModele.Lithologie
                        Dim pl As Double
                        Call αpieu_sol_Pressiometrique(.Item(i).Categorie, αpieu_sol)
                        If αpieu_sol = 1000 Then
                            msg = "Calcul de qs(z) - Détermination du coefficient αpieu_sol:" : Aff.msg_Avertiss.Add(msg)
                            msg = "Couche de sol n°" & (i + 1).ToString("#0") & ": le coefficient αpieu_sol n'a pas pu être déterminé. Le coefficient a été pris égal à αpieu_sol = 1 pour la suite des calculs." : Aff.msg_Avertiss.Add(msg)
                            αpieu_sol = 1
                        End If
                        Call Coef_a_b_c_fsol(.Item(i).Categorie, a, b, c)
                        Select Case SondageModele.Plmoyen
                            Case True 'les Pl renseignées sont des Pression Limites moyennes
                                If i = .Count - 1 Then
                                    pl = PressionLimiteNette(.Item(i).Pl, (.Item(i).Ztoit + Pieux.D) / 2)
                                Else
                                    pl = PressionLimiteNette(.Item(i).Pl, (.Item(i).Ztoit + .Item(i).Zbase) / 2)
                                End If
                            Case False 'les Pl renseignées sont des Pression Limites nettes
                                pl = .Item(i).Pl
                        End Select
                        qs1(i) = αpieu_sol * (a * pl + b) * (1 - E ^ (-c * pl)) : qsi = qs1(i)
                        Call Val_maximale_FrottementAxialUnitaire(.Item(i).Categorie, qsMax, qs1(i))
                        Call Tableaux_qs(entete, .Item(i).Ztoit, .Item(i).Categorie, .Item(i).hcouche, pl, αpieu_sol, a, b, c, qsi, qsMax, qs1(i), rtf)
                    End With
                Case 2 'modele terrain + sondage 5m
                    h += SondageModele.Lithologie.Item(i).hcouche
                    For j = ind1 To SondageModele.MesurePressio.Count - 1
                        'calcul sur toutes les mesures de pl réalisées dans chaque couche lithologique
                        Select Case i
                            Case SondageModele.Lithologie.Count - 1  'dernière couche
                                Call αpieu_sol_Pressiometrique(SondageModele.Lithologie.Item(i).Categorie, αpieu_sol)
                                If αpieu_sol = 1000 Then
                                    msg = "Calcul de qs(z) - Détermination du coefficient αpieu_sol:" : Aff.msg_Avertiss.Add(msg)
                                    msg = "Dernière couche : le coefficient αpieu_sol n'a pas pu être déterminé. Le coefficient a été pris égal à αpieu_sol = 1 pour la suite des calculs." : Aff.msg_Avertiss.Add(msg)
                                    αpieu_sol = 1
                                End If
                                Call Coef_a_b_c_fsol(SondageModele.Lithologie.Item(i).Categorie, a, b, c)
                                qs2(j) = αpieu_sol * (a * SondageModele.MesurePressio.Item(j).Pl + b) * (1 - E ^ (-c * SondageModele.MesurePressio.Item(j).Pl)) : qsi = qs2(j)
                                Call Val_maximale_FrottementAxialUnitaire(SondageModele.Lithologie.Item(i).Categorie, qsMax, qs2(j))
                                Call Tableaux_qs(entete, SondageModele.MesurePressio.Item(j).Z, SondageModele.Lithologie.Item(i).Categorie, SondageModele.Lithologie.Item(i).hcouche, SondageModele.MesurePressio.Item(j).Pl, αpieu_sol, a, b, c, qsi, qsMax, qs2(j), rtf)
                            Case Else   '1ière couche et couches intermédiaires
                                If SondageModele.MesurePressio.Item(j).Z <= h Then 'z de la mesure de pl* < z de la catégorisation de la couche de sol
                                    Call αpieu_sol_Pressiometrique(SondageModele.Lithologie.Item(i).Categorie, αpieu_sol)
                                    If αpieu_sol = 1000 Then
                                        msg = "Calcul de qs(z) - Détermination du coefficient αpieu_sol:" : Aff.msg_Avertiss.Add(msg)
                                        msg = "Couche de sol n°" & (i + 1).ToString("#0") & ": le coefficient αpieu_sol n'a pas pu être déterminé. Le coefficient a été pris égal à αpieu_sol = 1 pour la suite des calculs." : Aff.msg_Avertiss.Add(msg)
                                        αpieu_sol = 1
                                    End If
                                    Call Coef_a_b_c_fsol(SondageModele.Lithologie.Item(i).Categorie, a, b, c)
                                    qs2(j) = αpieu_sol * (a * SondageModele.MesurePressio.Item(j).Pl + b) * (1 - E ^ (-c * SondageModele.MesurePressio.Item(j).Pl)) : qsi = qs2(j)
                                    Call Val_maximale_FrottementAxialUnitaire(SondageModele.Lithologie.Item(i).Categorie, qsMax, qs2(j))
                                    Call Tableaux_qs(entete, SondageModele.MesurePressio.Item(j).Z, SondageModele.Lithologie.Item(i).Categorie, SondageModele.Lithologie.Item(i).hcouche, SondageModele.MesurePressio.Item(j).Pl, αpieu_sol, a, b, c, qsi, qsMax, qs2(j), rtf)
                                Else
                                    ind1 = j
                                    Exit For  'passage à la catégorie suivante en conservant le même indice
                                End If
                        End Select
                    Next
            End Select
        Next
        rtf.WriteStartGroup()
        rtf.NewParagraph()
        rtf.FontSize = 12 : rtf.FontSize = 9
        rtf.WriteString("Les valeurs de α pieu_sol sont établies conformément au tableau F.5.2.1 de la NF P94-262.") : rtf.NewLine()
        rtf.WriteString("Les valeurs des coefficients a, b et c sont établies conformément au tableau F.5.2.2 de la NF P94-262.") : rtf.NewLine()
        rtf.WriteString("Les valeurs de qsMax sont établies conformément au tableau F.5.2.3 de la NF P94-262.") : rtf.NewLine()
        rtf.Bold = True : rtf.Underline = True
        rtf.WriteString("Rappel:") : rtf.Bold = False : rtf.Underline = False : rtf.NewLine()
        rtf.WriteString("    - si qs > qsMax alors La valeur de qs est limitée à qsmax.") : rtf.NewLine()
        rtf.WriteString("    - si qs < qsMax alors La valeur initiale de qs est conservée.") : rtf.NewLine()
        'Ecriture du pb de détermination du coefficient αpieu_sol 
        If msg <> String.Empty Then
            rtf.Bold = True
            rtf.WriteString("Voir § Avertissement: Problème de détermination de la valeur de αpieu_sol pour certaines couches de sol.") : rtf.Bold = False : rtf.NewLine()
        End If
        'calcul de l'intégration de qs(z) sur la longueur de fondation D
        rtf.NewLine() : rtf.FontSize = 10 : rtf.Underline = True
        rtf.WriteString(i_chap.ToString("#0") & " - 2  Calcul de l'intégration de qs(z) sur la longueur de fondation D")
        rtf.FontSize = 9 : rtf.Underline = False : rtf.NewLine() : rtf.NewLine()
        rtf.WriteString("Valeur de D, longueur de la fondation contenue dans le terrain, D = " & Pieux.D.ToString("#0.00") & " m.") : rtf.NewLine()
        rtf.WriteString("Valeur de Ps, périmètre du fût du pieu, Ps = " & Pieux.Ps.ToString("#0.000") & " ml.") : rtf.NewLine()
        Select Case Aff.ModeleCalcul
            Case 1 'Modele terrain + val car
                With SondageModele.Lithologie
                    ind2 = .Count - 1 : If ind2 > 0 Then ind1 = ind2 - 1 Else ind1 = ind2
                    For j = 1 To .Count
                        If Pieux.D < .Item(j - 1).Ztoit Then
                            ind2 = j - 1 'index de la 1ière valeur de pression limite au delà de D
                            If ind2 > 0.1 Then ind1 = ind2 - 1 'index de la 1ière valeur de pression limite au deça de Zinf2
                            Exit For
                        End If
                    Next
                    'Application de la clause des pieux de grande longueur
                    Dim abat As Double = 1
                    If Pieux.D >= 25 AndAlso (Pieux.Abreviation = "FS" OrElse Pieux.Abreviation = "FB" OrElse Pieux.Abreviation = "FSR" OrElse Pieux.Abreviation = "FBR" OrElse Pieux.Abreviation = "PU") Then
                        If Pieux.AbattementGrandeLongueur = True Then
                            abat = 0.5
                        Else
                            'Insertion d'un avertissement dans la note de calcul
                            msg = "Application de la clause des pieux de grande longueur: Pieu de type " & Pieux.Abreviation.ToString & " et longueur du pieu excédant les 25 m, aucun coefficient d'abattement n'a été appliqué." : Aff.msg_Avertiss.Add(msg)
                        End If
                    End If
                    ʃqs = 0
                    For i = 0 To ind1
                        If .Item(i + 1).Ztoit < Pieux.D - 25 Then
                            ʃqs += (.Item(i + 1).Ztoit - .Item(i).Ztoit) * qs1(i) * abat
                        Else
                            If .Item(i).Ztoit > Pieux.D - 25 Then
                                ʃqs += (.Item(i + 1).Ztoit - .Item(i).Ztoit) * qs1(i)
                            Else
                                ʃqs += (.Item(i + 1).Ztoit - (Pieux.D - 25)) * qs1(i)
                                ʃqs += (Pieux.D - 25 - .Item(i).Ztoit) * qs1(i) * abat
                            End If
                        End If
                    Next
                    ʃqs += (Pieux.D - .Item(ind2).Ztoit) * qs1(ind2)  'calcul de l'intégration sur le dernier tronçon
                    Rs = Pieux.Ps * ʃqs
                End With
            Case 2 'modele terrain + sondage 5m
                With SondageModele.MesurePressio
                    For j = 1 To .Count
                        If Pieux.D < .Item(j - 1).Z Then
                            ind2 = j - 1 'index de la 1ière valeur de pression limite au delà de D
                            If ind2 > 0.1 Then ind1 = ind2 - 1 'index de la 1ière valeur de pression limite au deça de Zinf2
                            'calcul de la pression limite sur le dernier tronçon
                            qs_D = qs2(ind1) + ((qs2(ind2) - qs2(ind1)) / (.Item(ind2).Z - .Item(ind1).Z)) * (Pieux.D - .Item(ind1).Z)
                            Exit For
                        End If
                    Next
                    'Application de la clause des pieux de grande longueur
                    Dim abat As Double = 1
                    If Pieux.D >= 25 AndAlso (Pieux.Abreviation = "FS" OrElse Pieux.Abreviation = "FB" OrElse Pieux.Abreviation = "FSR" OrElse Pieux.Abreviation = "FBR" OrElse Pieux.Abreviation = "PU") Then
                        If Pieux.AbattementGrandeLongueur = True Then
                            abat = 0.5
                            rtf.WriteString("Application d'un coefficient d'abattement de 50% sur les valeurs de frottements pour les premiers " & (Pieux.D - 25).ToString("#0.00") & " m du pieu suivant la clause F.5.2(6).") : rtf.NewLine()
                        Else
                            'Insertion d'un avertissement dans la note de calcul
                            msg = "Application de la clause des pieux de grande longueur: Pieu de type " & Pieux.Abreviation.ToString & " et longueur du pieu excédant les 25 m, aucun coefficient d'abattement n'a été appliqué." : Aff.msg_Avertiss.Add(msg)
                        End If
                    End If
                    ʃqs = SondageModele.MesurePressio.Item(0).Z * qs2(0) / 2
                    If .Item(0).Z < Pieux.D - 25 Then ʃqs = abat * ʃqs
                    For i = 0 To ind1 - 1
                        If .Item(i + 1).Z < Pieux.D - 25 Then
                            ʃqs += abat * (.Item(i + 1).Z - .Item(i).Z) * (qs2(i + 1) + qs2(i)) / 2
                        Else
                            If .Item(i).Z > Pieux.D - 25 Then
                                ʃqs += (.Item(i + 1).Z - .Item(i).Z) * (qs2(i + 1) + qs2(i)) / 2
                            Else
                                ʃqs += (.Item(i + 1).Z - (Pieux.D - 25)) * (qs2(i + 1) + qs2(i)) / 2
                                ʃqs += abat * (Pieux.D - 25 - .Item(i).Z) * (qs2(i + 1) + qs2(i)) / 2
                            End If
                        End If
                    Next
                    ʃqs += (Pieux.D - .Item(ind1).Z) * (qs_D + qs2(ind1)) / 2 'calcul de l'intégration sur le dernier tronçon
                    Rs = Pieux.Ps * ʃqs
                End With
        End Select
        'Application de la clause du vibrofonçage pour les pieux de type BAO, HB et PP
        If (Pieux.Abreviation = "BAO" OrElse Pieux.Abreviation = "HB" OrElse Pieux.Abreviation = "PP") AndAlso Pieux.Vibrofoncage = True Then
            rtf.WriteString("Application de la clause du vibrofonçage pour les pieux de type BAO, HB et PP: réduction de 30% de la valeur de qs") : rtf.NewLine()
            Rs = 0.7 * Rs : ʃqs = 0.7 * ʃqs
        ElseIf (Pieux.Abreviation = "BAO" OrElse Pieux.Abreviation = "HB" OrElse Pieux.Abreviation = "PP") AndAlso Pieux.Vibrofoncage = False Then
            rtf.WriteString("Mise en oeuvre des pieux de type BAO, HB et PP par battage: aucune réduction de la valeur de qs (clause tableau F.5.2.1(#)).") : rtf.NewLine()
        End If
        rtf.WriteString("Valeur de l'intégration ʃqs déterminée sur " & (1 + ind1 + 1).ToString("#0") & " tronçons, de 0 m à D (= " & Pieux.D.ToString("#0.00") & " m), ʃqs = " & ʃqs.ToString("#0.00") & " MN/m.") : rtf.NewLine()
        rtf.WriteString("Valeur de la résistance de frottement axial du pieu, Rs = ") : rtf.Bold = True : rtf.Underline = True : rtf.WriteString(Rs.ToString("#0.0000")) : rtf.Bold = False : rtf.Underline = False : rtf.WriteString(" MN (suivant équation F5.1).") : rtf.NewLine()
        rtf.WriteEndGroup()
    End Sub

    ''' <summary>Calcul de la portance d'un pieu par la procédure du Pieu Modèle et essais pressiométriques</summary>
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    ''' <param name="Verif">renvoie FALSE si erreur</param>
    Public Sub Calcul_Pieu_Portance_PieuModele_Pressiometrique(ByRef rtf As To_Rtf.RtfAnsiTextWriter, ByRef Verif As Boolean)

        Dim Rb(SondagesPressio.Count), Rs(SondagesPressio.Count), Def(SondagesPressio.Count), Ple(SondagesPressio.Count), Rbk, Rsk As Double
        Dim ʃqs(SondagesPressio.Count) As Double
        Dim i As Integer
        Dim msg As String = String.Empty
        Dim Avertissement As Boolean = False
        Dim i_chap As Integer = 2


        With SondagesPressio
            '
            'Calcul de la résistance de pointe Rb
#Region "entête Ecriture dans la note de calcul"
            rtf.WriteStartGroup()
            rtf.NewParagraph() : rtf.FontSize = 12 : rtf.NewLine() : rtf.Bold = True : rtf.Underline = True
            rtf.WriteString(i_chap.ToString("#0") & " - Calcul de la résistance de pointe Rb pour les " & .Count.ToString("#0") & " sondages") : rtf.FontSize = 9 : rtf.Bold = False : rtf.Underline = False : rtf.NewLine() : rtf.NewLine()
            If Pieux.Categorie > 16 AndAlso Pieux.AucuneResistancedePointe = True Then
                'pas de calcul de résistance de pointe pour les micropieux, sauf dans le cas d'un effet de groupe ou ple doit être calculée
                'détermination de kp
                rtf.WriteString("Valeur du facteur de portance Kp  = 0  -  Pas de calcul de résistance de pointe pour les micropieux") : rtf.NewLine()
                rtf.WriteString("Valeur de la résistance de pointe Rb : 0 MN  -  Aucune résistance de pointe pour les micropieux, uniquement une résistance par frottement (voir ci-dessous).") : rtf.NewLine()
            Else
                rtf.WriteString("Le calcul de la valeur de la pression limite nette équivalente P*") : rtf.Subscript = True : rtf.WriteString("le") : rtf.Subscript = False : rtf.WriteString(" est réalisé suivant l'équation F.4.2.3 de l'annexe F de la NF P94-262 - 2013") : rtf.NewLine()
                rtf.WriteString("Fiche du pieu D : " & Pieux.D.ToString("#0.00") & " m (= longueur enterrée du pieu).") : rtf.NewLine()
                rtf.WriteString("Hauteur d'encastrement du pieu dans la couche porteuse : " & Pieux.Hencastr.ToString("#0.00") & " m.") : rtf.NewLine()
            End If
            rtf.WriteEndGroup()
#End Region
            For i = 0 To .Count - 1
                Dim a, b, Db, D3a, IntPl, Hd, IntPlz, DefB, KpMax, Kp As Double
                Dim CSnote1 As Boolean = True
                Dim CSHd As Boolean = True
                Call Pieu_Portance_EssaisPressiometriques_PieuModele_Rb(.Item(i), Rb(i), rtf, Verif, a, b, Db, D3a, IntPl, Ple(i), CSnote1, Hd, IntPlz, Def(i), DefB, CSHd, KpMax, Kp)
                Call Tableaux_Rb(i + 1, Pieux.Hencastr, a, b, Db, D3a, IntPl, Ple(i), CSnote1, Hd, IntPlz, Def(i), CSHd, DefB, KpMax, Kp, Kp * Ple(i), Rb(i), rtf)
            Next
            '
            'Calcul de la résistance de frottement axial Rs
#Region "entête Ecriture dans la note de calcul"      'Ecriture dans la note de calcul 
            rtf.WriteStartGroup() : rtf.NewParagraph() : i_chap += 1 : rtf.FontSize = 12 : rtf.Bold = True : rtf.Underline = True
            rtf.WriteString(i_chap.ToString("#0") & " - Calcul de la résistance de frottement axial Rs pour les " & .Count.ToString("#0") & " sondages") : rtf.FontSize = 10 : rtf.Bold = False : rtf.NewLine() : rtf.NewLine()
            rtf.WriteString(i_chap.ToString("#0") & " - 1  Calcul de qs(z) pour toutes les valeurs mesurées de la pression limite nette Pl* sur les " & .Count.ToString("#0.00") & " sondages.")
            rtf.FontSize = 9 : rtf.Underline = False : rtf.NewLine() : rtf.NewLine()
            rtf.WriteString("Les valeurs de α pieu_sol sont établies conformément au tableau F.5.2.1 de la NF P94-262.") : rtf.NewLine()
            rtf.WriteString("Les valeurs des coefficients a, b et c sont établies conformément au tableau F.5.2.2 de la NF P94-262.") : rtf.NewLine()
            rtf.WriteString("Les valeurs de qsMax sont établies conformément au tableau F.5.2.3 de la NF P94-262.") : rtf.NewLine()
            rtf.Bold = True : rtf.Underline = True
            rtf.WriteString("Rappel:") : rtf.Bold = False : rtf.Underline = False : rtf.NewLine()
            rtf.WriteString("    - si qs > qsMax alors La valeur de qs est limitée à qsmax.") : rtf.NewLine()
            rtf.WriteString("    - si qs < qsMax alors La valeur initiale de qs est conservée.") : rtf.NewLine()
            rtf.WriteEndGroup()
#End Region
            For i = 0 To .Count - 1
                rtf.WriteStartGroup() : rtf.FontSize = 12 : rtf.FontSize = 9 : rtf.Bold = True
                rtf.WriteString("Sondage n°" & (i + 1).ToString("#0") & " : ") : rtf.Bold = False : rtf.NewLine()
                rtf.WriteEndGroup()
                Call Pieu_Portance_EssaisPressiometriques_PieuModele_Rs(.Item(i), ʃqs(i), Rs(i), rtf, Verif)
            Next
#Region "entête Ecriture dans la note de calcul avant tableau"      'Ecriture dans la note de calcul 
            rtf.WriteStartGroup() : rtf.NewParagraph() : rtf.FontSize = 10 : rtf.Underline = True
            rtf.WriteString(i_chap.ToString("#0") & " - 2  Calcul de l'intégration de qs(z) sur la longueur de fondation D")
            rtf.FontSize = 9 : rtf.Underline = False : rtf.NewLine() : rtf.NewLine()
            rtf.WriteString("Valeur de D, longueur de la fondation contenue dans le terrain, D = " & Pieux.D.ToString("#0.00") & " m.") : rtf.NewLine()
            rtf.WriteString("Valeur de Ps, périmètre du fût du pieu, Ps = " & Pieux.Ps.ToString("#0.000") & " ml.") : rtf.NewLine()
            If Pieux.D > 25 AndAlso (Pieux.Abreviation = "FS" OrElse Pieux.Abreviation = "FB" OrElse Pieux.Abreviation = "FSR" OrElse Pieux.Abreviation = "FBR" OrElse Pieux.Abreviation = "PU") Then
                If Pieux.AbattementGrandeLongueur = True Then
                    rtf.WriteString("Application d'un coefficient d'abattement de 50% sur les valeurs de frottements pour les premiers " & (Pieux.D - 25).ToString("#0.00") & " m du pieu suivant la clause F.5.2(6).") : rtf.NewLine()
                Else
                    'Insertion d'un avertissement dans la note de calcul
                    msg = "Application de la clause des pieux de grande longueur: Pieu de type " & Pieux.Abreviation.ToString & " et longueur du pieu excédant les 25 m, aucun coefficient d'abattement n'a été appliqué." : Aff.msg_Avertiss.Add(msg)
                End If
            End If
            'Application de la clause du vibrofonçage pour les pieux de type BAO, HB et PP
            If (Pieux.Abreviation = "BAO" OrElse Pieux.Abreviation = "HB" OrElse Pieux.Abreviation = "PP") AndAlso Pieux.Vibrofoncage = True Then
                rtf.WriteString("Application de la clause du vibrofonçage pour les pieux de type BAO, HB et PP: réduction de 30% de la valeur de qs") : rtf.NewLine()
            ElseIf (Pieux.Abreviation = "BAO" OrElse Pieux.Abreviation = "HB" OrElse Pieux.Abreviation = "PP") AndAlso Pieux.Vibrofoncage = False Then
                rtf.WriteString("Mise en oeuvre des pieux de type BAO, HB et PP par battage: aucune réduction de la valeur de qs (clause tableau F.5.2.1(#)).") : rtf.NewLine()
            End If
            rtf.WriteEndGroup()
#End Region
            Call Tableaux_Rs(ʃqs, Rs, rtf)
        End With
        '
        'Détermination des valeurs de calcul de portance par la procédure du Modèle de Terrain
        Call Portance_Pieu_Modele(i_chap, 1, Rb, Rs, Rbk, Rsk, rtf)
        '
        '---------------> Effet de groupe (éventuellement)
        If Pieux.EffetGroupe = True Then
            'dans le cadre de la procédure Modèle de Terrain, Rb et Rs sont égaux à Rbk et Rsk car les propriétés du terrain sont déjà des valeurs caractéristiques
            'calcul de l'incidence pour le pieu isolé
            Call Effet_de_Groupe(i_chap, Rbk, Rsk, rtf)
            'calcul pour l'ensemble des pieux
            Call Effet_de_Groupe_Bloc(i_chap, rtf,,, Def, Ple)
        End If
        '
        '---------------> Evaluation des tassements
        If Pieux.Tassement = True Then Call Evaluation_tassement(i_chap, rtf)
        '
        '---------------> Affichage des avertissements
        rtf.WriteStartGroup() : rtf.NewParagraph()
        rtf.FontSize = 12 : rtf.Bold = True : i_chap += 1
        rtf.Underline = True : rtf.WriteString(i_chap.ToString("#") & " - Avertissements") : rtf.Bold = False : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine() : rtf.NewLine()
        If Aff.msg_Avertiss.Count > 0 Then
            For i1 = 0 To Aff.msg_Avertiss.Count - 1
                rtf.WriteString(Aff.msg_Avertiss.Item(i1).ToString()) : rtf.NewLine()
            Next i1
        Else
            rtf.WriteString("Aucun avertissement.") : rtf.NewLine()
        End If
        rtf.WriteEndGroup()
    End Sub

    ''' <summary>Determination du coefficient de modèle γrd1</summary>
    ''' <param name=" γrd1">valeur du coefficient de modèle γrd1</param> 
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    Private Sub Determination_γrd1_Pressio(ByRef γrd1 As Double, ByRef rtf As To_Rtf.RtfAnsiTextWriter)
        'Ecriture dans la note de calcul 
        rtf.WriteStartGroup()
        rtf.FontSize = 12 : rtf.FontSize = 9
        Select Case Pieux.Categorie
            Case 1 To 9, 11 To 14, 16
                Select Case Pieux.AncragePressio
                    Case 5 'pieux ancrés dans la craie
                        γrd1 = 1.4
                        rtf.WriteString(" ► γrd1 : Pieux de catégorie " & Pieux.Categorie.ToString("#0") & " et ancrage dans la craie - γrd1 = " & γrd1.ToString("#0.00")) : rtf.NewLine()
                    Case Else 'pieux NON ancrés dans la craie
                        γrd1 = 1.15
                        rtf.WriteString(" ► γrd1 : Pieux de catégorie " & Pieux.Categorie.ToString("#0") & " et ancrés dans un sol autre que la craie - γrd1 = " & γrd1.ToString("#0.00")) : rtf.NewLine()
                End Select
            Case 10, 15, 17, 18, 19, 20
                Dim msg1 As String = String.Empty
                Select Case Pieux.AncragePressio
                    Case 2, 3, 4, 7
                        msg1 = "roches"
                        If Pieux.AncragePressio = 2 Then msg1 = "sols intermédiaires" : If Pieux.AncragePressio = 3 Then msg1 = "sols intermédiaires" : If Pieux.AncragePressio = 4 Then msg1 = "sables"
                        γrd1 = 1.4
                    Case 1, 5, 6 'argile, craie, marnes
                        msg1 = "marnes"
                        If Pieux.AncragePressio = 1 Then msg1 = "argiles" : If Pieux.AncragePressio = 5 Then msg1 = "craies"
                        γrd1 = 2
                End Select
                rtf.WriteString(" ► γrd1 : Pieux de catégorie " & Pieux.Categorie.ToString("#0") & " ancré  dans les " & msg1.ToString & " - γrd1 = " & γrd1.ToString("#0.00")) : rtf.NewLine()
        End Select
        rtf.WriteEndGroup()
    End Sub

    ''' <summary>Tableau d'affichage des valeurs intermédiaires pour le calcul de Rb suivant les essais pressiométriques</summary>
    ''' <param name="i">n° de sondage</param>
    '''  <param name="He">hauteur d'encastrement</param>
    ''' <param name="db">= d - b</param>
    ''' <param name="d3a">= d + 3.a</param>
    ''' <param name="IntPl">intégration sur pl</param>
    ''' <param name="ple">pression limite nette équivalente</param>
    ''' <param name="a">coefficient a pour le calcul des bornes d'intégration</param>
    ''' <param name="b">coefficient b pour le calcul des bornes d'intégration</param>
    ''' <param name="Hd"> = H - 10.B</param>
    ''' <param name="Def">hauteur d'encastrement effective</param>
    ''' <param name="kpMax">facteur de portance Maximal</param>
    ''' <param name="qb">contrainte de pointe retenue</param>
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    Private Sub Tableaux_Rb(ByVal i As Integer, ByVal He As Double, ByVal a As Double, ByVal b As Double, ByVal Db As Double, ByVal D3a As Double, ByVal IntPl As Double, ByVal Ple As Double, ByVal CSnote1 As Boolean, ByVal Hd As Double,
                            ByVal IntPlz As Double, ByVal Def As Double, ByVal CSHd As Boolean, ByVal DefB As Double, ByVal KpMax As Double, ByVal Kp As Double, ByVal qb As Double, ByVal Rb As Double, ByRef rtf As To_Rtf.RtfAnsiTextWriter)
        rtf.WriteStartGroup()
        rtf.FontSize = 12 : rtf.FontSize = 8
        Dim msg As String = String.Empty
        If i = 1 Then
            rtf.NewParagraph()
            'entête du tableau et ligne 1
            rtf.BeginRow() : rtf.DeclareCell(600) : rtf.BeginCell(True) : rtf.WriteString("Sond.") : rtf.EndCell()
            rtf.DeclareCell(600) : rtf.BeginCell(True) : rtf.WriteString("H encast. (m)") : rtf.EndCell()
            rtf.DeclareCell(600) : rtf.BeginCell(True) : rtf.WriteString("a (m)") : rtf.EndCell()
            rtf.DeclareCell(600) : rtf.BeginCell(True) : rtf.WriteString("b (m)") : rtf.EndCell()
            rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString("D-b (m)") : rtf.EndCell()
            rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString("D+3a (m)") : rtf.EndCell()
            rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString("P*l(z)dz (MPa.m)") : rtf.EndCell()
            rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString("P*le (MPa)") : rtf.EndCell()
            rtf.DeclareCell(400) : rtf.BeginCell(True) : rtf.WriteString("< 2.plmin") : rtf.EndCell()
            rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString("Hd (m)") : rtf.EndCell()
            rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString("P*l(z)dzk (MPa.m)") : rtf.EndCell()
            rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString("Def (m)") : rtf.EndCell()
            If Pieux.Categorie <= 16 OrElse (Pieux.Categorie > 16 And Pieux.AucuneResistancedePointe = False) Then 'ne s'affiche que si résistance de pointe
                rtf.DeclareCell(400) : rtf.BeginCell(True) : rtf.WriteString("Test Hd ") : rtf.EndCell()
                rtf.DeclareCell(575) : rtf.BeginCell(True) : rtf.WriteString("Def/B") : rtf.EndCell()
                rtf.DeclareCell(550) : rtf.BeginCell(True) : rtf.WriteString("Kp Max") : rtf.EndCell()
                rtf.DeclareCell(550) : rtf.BeginCell(True) : rtf.WriteString("Kp") : rtf.EndCell()
                rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString("qb (MPa)") : rtf.EndCell()
                rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString("Rb (MN)") : rtf.EndCell()
            End If
            rtf.EndRow()
            End If
            rtf.BeginRow()
        rtf.DeclareCell(600) : rtf.BeginCell(True) : rtf.WriteString("P" & i.ToString("#0")) : rtf.EndCell()
        rtf.DeclareCell(600) : rtf.BeginCell(True) : rtf.WriteString(He.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(600) : rtf.BeginCell(True) : rtf.WriteString(a.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(600) : rtf.BeginCell(True) : rtf.WriteString(b.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString(Db.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString(D3a.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString(IntPl.ToString("#0.000")) : rtf.EndCell()
        rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString(Ple.ToString("#0.000")) : rtf.EndCell()
        If CSnote1 = False Then msg = "KO" Else msg = "OK"
        rtf.DeclareCell(400) : rtf.BeginCell(True) : rtf.WriteString(msg) : rtf.EndCell()
        rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString(Hd.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString(IntPlz.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString(Def.ToString("#0.00")) : rtf.EndCell()
        If Pieux.Categorie <= 16 OrElse (Pieux.Categorie > 16 And Pieux.AucuneResistancedePointe = False) Then 'ne s'affiche que si résistance de pointe
            If CSHd = False Then msg = "KO" Else msg = "OK"
            rtf.DeclareCell(400) : rtf.BeginCell(True) : rtf.WriteString(msg) : rtf.EndCell()
            rtf.DeclareCell(575) : rtf.BeginCell(True) : rtf.WriteString(DefB.ToString("#0.00")) : rtf.EndCell()
            rtf.DeclareCell(550) : rtf.BeginCell(True) : rtf.WriteString(KpMax.ToString("#0.00")) : rtf.EndCell()
            rtf.DeclareCell(550) : rtf.BeginCell(True) : rtf.WriteString(Kp.ToString("#0.00")) : rtf.EndCell()
            rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString(qb.ToString("#0.000")) : rtf.EndCell()
            rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString(Rb.ToString("#0.000")) : rtf.EndCell()
        End If
        rtf.EndRow()
        rtf.WriteEndGroup()
        If i = SondagesPressio.Count Then
            rtf.WriteStartGroup() : rtf.NewParagraph() : rtf.FontSize = 12 : rtf.FontSize = 9
            rtf.WriteString("Avec les définitions suivantes:") : rtf.NewLine()
            rtf.WriteString("  - a = Max(Bmin/2; 0,50 m)") : rtf.NewLine()
            rtf.WriteString("  - b = Min(a, Hauteur d'encastrement du pieu dans la couche porteuse)") : rtf.NewLine()
            rtf.WriteString("  - D-b = Valeur limite haute de l'intégration pour le calcul de Pl*e") : rtf.NewLine()
            rtf.WriteString("  - D+3a = Valeur limite basse de l'intégration pour le calcul de Pl*e") : rtf.NewLine()
            rtf.WriteString("  - P*l(z)dz = Valeur de l'intégrale P*l(z)dz entre les bornes D-b et D+3a en MPa.m.") : rtf.NewLine()
            rtf.WriteString("  - P*le = Valeur de la pression limite nette équivalente en MPa.") : rtf.NewLine()
            rtf.WriteString("  - Homogénéité de la couche porteuse :") : rtf.NewLine()
            rtf.WriteString("      - La Note 1 - §F4.2.(3) de la NF P94-262 - 2013 impose de vérifier l'homogénéité de la couche porteuse ") : rtf.NewLine()
            rtf.WriteString("      - Si plMax < 2 x plmin - Condition satisfaite.") : rtf.NewLine()
            rtf.WriteString("      - Si plMax > 2 x plmin - Condition NON satisfaite.") : rtf.NewLine()
            rtf.WriteString("  - hD = Min(10 * Pieux.Bmin, Pieux.D) = Condition du CEREMA") : rtf.NewLine()
            rtf.WriteString("  - P*l(z)dzk = Valeur de l'intégrale P*l(z)dz entre les bornes D-hD et D (= " & Pieux.D.ToString("#0.00") & " m); en MPa.m.") : rtf.NewLine()
            rtf.WriteString("  - Def = Hauteur d'encastrement effective  (définition suivant annexe F §F.4.2(4) de la NF P94.262) = pl_dzk / Ple")
            If Pieux.Categorie <= 16 OrElse (Pieux.Categorie > 16 And Pieux.AucuneResistancedePointe = False) Then 'ne s'affiche que si résistance de pointe
                rtf.WriteString("  - Vérification de la profondeur d'encastrement du pieu dans la couche porteuse :") : rtf.NewLine()
                rtf.WriteString("    La profondeur d'encastrement du pieu dans la couche porteuse Def doit répondre aux conditions de la note 1 de l'annexe F §F4.2.(4) de la NF P94-262 - 2013 ") : rtf.NewLine()
                rtf.WriteString("       - Soit 1,50m pour les pieux de diamètre supérieur à 0,50m.") : rtf.NewLine()
                rtf.WriteString("       - Soit < à 3 diamètres pour les pieux de diamètre inférieur à 0,50m.") : rtf.NewLine()
                rtf.WriteString("  - Kp Max facteur de portance maximal ") : rtf.NewLine()
                rtf.WriteString("  - Def/B = Valeur du rapport Def/B") : rtf.NewLine()
                rtf.WriteString("      Avec Rapport Def/B ≥ 5 - Kp = kpMax ") : rtf.NewLine()
                rtf.WriteString("      Avec Rapport Def/B < 5 - Kp suivant équation du §F.4.2(4) de la NF P94.262. ") : rtf.NewLine()
                rtf.WriteString("  - Kp facteur de portance") : rtf.NewLine()
                rtf.Underline = True
                rtf.WriteString(" Effort limite mobilisable dû au terme de pointe") : rtf.Underline = False : rtf.NewLine()
                rtf.WriteString("  - Valeur de la pression de rupture du terrain sous la base du pieu qb (= Kp * pl*e) en MPa.") : rtf.NewLine()
                rtf.WriteString("  - Valeur de la résistance de pointe Rb (= aire.qb) en MN ") : rtf.NewLine()
            End If
            rtf.WriteEndGroup()
            End If

    End Sub

    Private Sub Tableaux_Rs(ByVal ʃqs() As Double, ByVal Rs() As Double, ByRef rtf As To_Rtf.RtfAnsiTextWriter)
        rtf.WriteStartGroup()
        rtf.FontSize = 12 : rtf.FontSize = 8
        Dim msg As String = String.Empty

        rtf.NewParagraph()
        'entête du tableau et ligne 1
        rtf.BeginRow() : rtf.DeclareCell(800) : rtf.BeginCell(True) : rtf.WriteString("Sondages") : rtf.EndCell()
        rtf.DeclareCell(800) : rtf.BeginCell(True) : rtf.WriteString("ʃqs (MN/m)") : rtf.EndCell()
        rtf.DeclareCell(800) : rtf.BeginCell(True) : rtf.WriteString("Rs (MN)") : rtf.EndCell()
        rtf.EndRow()

        For i = 0 To SondagesPressio.Count - 1
            rtf.BeginRow()
            rtf.DeclareCell(800) : rtf.BeginCell(True) : rtf.WriteString("P" & (i + 1).ToString("#0")) : rtf.EndCell()
            rtf.DeclareCell(800) : rtf.BeginCell(True) : rtf.WriteString(ʃqs(i).ToString("#0.000")) : rtf.EndCell()
            rtf.DeclareCell(800) : rtf.BeginCell(True) : rtf.WriteString(Rs(i).ToString("#0.000")) : rtf.EndCell()
            rtf.EndRow()
        Next
        rtf.WriteEndGroup()
        rtf.WriteStartGroup() : rtf.NewParagraph() : rtf.FontSize = 12 : rtf.FontSize = 9
        rtf.WriteString("Avec les définitions suivantes:") : rtf.NewLine()
        rtf.WriteString("  - ʃqs = Valeur de l'intégration ʃqs déterminée sur les tronçons, de 0 m à D (= " & Pieux.D.ToString("#0.00") & " m), en MN/m.") : rtf.NewLine()
        rtf.WriteString("  - Rs = Valeur de la résistance de frottement axial du pieu suivant équation F5.1.") : rtf.NewLine()
        rtf.WriteEndGroup()
    End Sub

    ''' <summary>Calcul de Rb suivant les essais pressiométriques pour la Procédure Pieu Modèle</summary>
    '''  <param name="Sondage">Ensemble des caractéristiques pressiométriques et lithologiques du sondage i</param>
    ''' <param name="Rb">Résistance de pointe du pieu déterminé par les essais pressiométriques</param>
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    ''' <param name="Verif">renvoie FALSE si erreur</param>
    ''' <param name="a">calcul du coefficients a pour la détermination de la pression limite nette equivalente</param>
    ''' <param name="b">calcul du coefficient b pour la détermination de la pression limite nette equivalente</param>
    ''' <param name="Db">limite haute de l'intégration pour le calcul de Pl*e</param>
    ''' <param name="D3a">limite basse de l'intégration pour le calcul de Pl*e</param>
    ''' <param name="pl_dz">Valeur de l'intégrale P*l(z)dz entre les bornes D-b et D+3a</param>
    ''' <param name="ple">Valeur de la pression limite nette équivalente </param>
    ''' <param name="CSnote1">TRUE si couche porteuse est considérée comme homogène sinon FALSE</param>
    ''' <param name="hD">= Min(10 * Pieux.Bmin, Pieux.D) 'Condition du CEREMA</param>
    ''' <param name="pl_dzk">Valeur de l'intégrale P*l(z)dz entre les bornes Pieux.D - hD et hD </param>
    ''' <param name="Def">Hauteur d'encastrement effective  (définition suivant annexe F §F.4.2(4) de la NF P94.262) = pl_dzk / Ple</param>
    ''' <param name="DefB">= rapport Def / Pieux.Bmin </param>
    ''' <param name="CSHd">test sur la hauteur d'encastrement effectif dans la couche porteuse: TRUE si OK sinon FALSE</param> 
    ''' <param name="kpMax">Calcul du facteur de portance Kp Maximal</param>
    ''' <param name="Kp">Calcul du facteur de portance Kp </param>
    Private Sub Pieu_Portance_EssaisPressiometriques_PieuModele_Rb(ByVal Sondage As clsSondagePressio, ByRef Rb As Double, ByRef rtf As To_Rtf.RtfAnsiTextWriter, ByRef Verif As Boolean, ByRef a As Double,
                                                                ByRef b As Double, ByRef Db As Double, ByRef D3a As Double, ByRef pl_dz As Double, ByRef ple As Double, ByRef CSnote1 As Boolean, ByRef hD As Double, ByRef pl_dzk As Double,
                                                                ByRef Def As Double, ByRef DefB As Double, ByRef CSHd As Boolean, ByRef kpMax As Double, ByRef Kp As Double)
        Dim h, pl1_2, pl3_4, plmin, plMax, qb, zinf1, zinf2 As Double ' 
        Dim i, ind1, ind2, ind3, ind4, j As Integer
        Dim ind1_ind2, ind3_ind4 As Boolean
        Dim msg As String = String.Empty

        'calcul de la résistance de pointe Rb
        '-----------------------------------------------
        'calcul de ple pression limite nette equivalente
        '-----------------------------------------------
        '--> calcul des coefficients a, b pour la détermination de la pression limite nette equivalente
        a = Max(Pieux.Bmin / 2, 0.5)
        b = Min(a, Pieux.Hencastr) 'hencastrement = hauteur du pieu dans la formation porteuse
        '--> calcul de ple pression limite nette equivalente
        zinf1 = Pieux.D - b : Db = zinf1
        zinf2 = Pieux.D + 3 * a : D3a = zinf2
        '--> détermination des indices pour le calcul de l'intégration
        ind1 = 0 : ind2 = 0 : ind3 = 0 : ind4 = 0 : ind1_ind2 = False : ind3_ind4 = False
        For j = Sondage.MesurePressio.Count To 1 Step -1 'les indices augmentent avec la profondeur
            With Sondage.MesurePressio.Item(j - 1)
                Select Case j
                    Case Sondage.MesurePressio.Count
                        If zinf2 < .Z Then
                            ind4 = j - 1
                        ElseIf zinf2 = .Z Then
                            ind3_ind4 = True
                            ind4 = j - 1 : ind3 = ind4
                        End If
                    Case Is <= 2
                        If ind3_ind4 = False Then
                            ind3_ind4 = True : ind1_ind2 = True
                            ind4 = 1 : ind3 = ind4
                            ind1 = 0 : ind2 = ind1
                        Else
                            If zinf1 < .Z Then
                                ind2 = j - 1 '--> .Z( ind2) > zinf1 = borne inférieure
                            ElseIf zinf1 = .Z Then
                                ind1_ind2 = True
                                ind1 = j - 1 : ind2 = ind1
                            ElseIf j = 1 Then
                                ind2 = 0 : ind1 = 0 : ind1_ind2 = True
                            End If
                        End If
                    Case Else
                        If ind3_ind4 = False Then
                            If .Z > zinf2 Then
                                ind4 = j - 1 '--> .Z(ind4) > zinf2 = borne inférieure
                            ElseIf zinf2 = .Z Then
                                ind3_ind4 = True
                                ind4 = j - 1 : ind3 = ind4
                            Else
                                ind3_ind4 = True
                                ind3 = j - 1  '--> .Z(ind3) < zinf2 = borne supérieure
                            End If
                        Else
                            If zinf1 < .Z Then
                                ind2 = j - 1 '--> .Z( ind2) > zinf1 = borne inférieure
                            ElseIf zinf1 = .Z Then
                                ind1_ind2 = True
                                ind1 = j - 1 : ind2 = ind1
                            Else
                                ind1_ind2 = True
                                ind1 = j - 1  '--> .Z(ind1) < zinf2 = borne supérieure
                                ind2 = j   '--> .Z( ind2) > zinf1 = borne inférieure
                            End If
                        End If
                End Select
                If ind3_ind4 = True AndAlso ind1_ind2 = True Then Exit For
            End With
        Next
        '--> calcul de l'intégration sur les divers tronçons
        With Sondage.MesurePressio
            If ind1 <> ind2 Then
                pl1_2 = .Item(ind1).Pl + ((.Item(ind2).Pl - .Item(ind1).Pl) / (.Item(ind2).Z - .Item(ind1).Z)) * (zinf1 - .Item(ind1).Z)
            Else
                pl1_2 = .Item(ind1).Pl
            End If
            plmin = pl1_2 : plMax = pl1_2
            If ind3 <> ind4 Then
                pl3_4 = .Item(ind3).Pl + ((.Item(ind4).Pl - .Item(ind3).Pl) / (.Item(ind4).Z - .Item(ind3).Z)) * (zinf2 - .Item(ind3).Z)
            Else
                pl3_4 = .Item(ind3).Pl
            End If
            If plmin > pl3_4 Then plmin = pl3_4 : If plMax < pl3_4 Then plMax = pl3_4
            pl_dz = (.Item(ind2).Z - zinf1) * (pl1_2 + .Item(ind2).Pl) / 2
            If plmin > .Item(ind2).Pl Then plmin = .Item(ind2).Pl : If plMax < .Item(ind2).Pl Then plMax = .Item(ind2).Pl
            For i = ind2 To ind3 - 1
                pl_dz += (.Item(i + 1).Z - .Item(i).Z) * (.Item(i + 1).Pl + .Item(i).Pl) / 2
                If plmin > .Item(i + 1).Pl Then plmin = .Item(i + 1).Pl : If plMax < .Item(i + 1).Pl Then plMax = .Item(i + 1).Pl
                If plmin > .Item(i).Pl Then plmin = .Item(i).Pl : If plMax < .Item(i).Pl Then plMax = .Item(i).Pl
            Next
            pl_dz += (zinf2 - .Item(ind3).Z) * (pl3_4 + .Item(ind3).Pl) / 2 'calcul de l'intégration sur le dernier tronçon
            If plmin > .Item(ind3).Pl Then plmin = .Item(ind3).Pl : If plMax < .Item(ind3).Pl Then plMax = .Item(ind3).Pl
        End With

        ple = pl_dz / (b + 3 * a)

        '
        'calcul de l'encastrement effectif
        '-------------------------------- 
        hD = Min(10 * Pieux.Bmin, Pieux.D) 'Condition du CEREMA
        zinf1 = Pieux.D - hD
        ind1 = 0 : ind2 = 0 : ind3 = 0 : ind4 = 0 : pl_dzk = 0
        With Sondage.MesurePressio
            If zinf1 > 0.1 Then
                For j = 1 To Sondage.MesurePressio.Count
                    If zinf1 < .Item(j - 1).Z Then
                        ind2 = j - 1 'index de la 1ière valeur de pression limite au delà de Zinf1
                        If ind2 > 0.1 Then
                            ind1 = ind2 - 1 'index de la 1ière valeur de pression limite au deça de Zinf2
                            pl1_2 = .Item(ind1).Pl + ((.Item(ind2).Pl - .Item(ind1).Pl) / (.Item(ind2).Z - .Item(ind1).Z)) * (zinf1 - .Item(ind1).Z)
                        Else
                            pl1_2 = .Item(ind2).Pl * zinf1 / .Item(ind2).Z
                        End If
                        Exit For
                    End If
                Next
                pl_dzk = (.Item(ind2).Z - zinf1) * (pl1_2 + .Item(ind2).Pl) / 2 'calcul de l'intégration sur le 1ier tronçon
            Else
                pl_dzk = .Item(ind2).Z * .Item(ind2).Pl / 2 'calcul de l'intégration sur le 1ier tronçon
            End If

            zinf2 = Pieux.D
            For j = 1 To .Count
                If zinf2 < .Item(j - 1).Z Then
                    ind4 = j - 1 'index de la 1ière valeur de pression limite au delà de Zinf2
                    If ind4 > 0.1 Then ind3 = ind4 - 1 'index de la 1ière valeur de pression limite au deça de Zinf2
                    'calcul de la pression limite sur le dernier tronçon
                    pl3_4 = .Item(ind3).Pl + ((.Item(ind4).Pl - .Item(ind3).Pl) / (.Item(ind4).Z - .Item(ind3).Z)) * (zinf2 - .Item(ind3).Z)
                    Exit For
                End If
            Next

            'calcul de l'intégration sur les tronçons intermédiaires et final
            If ind2 < ind3 - 1 Then
                For i = ind2 To ind3 - 1
                    pl_dzk += (.Item(i + 1).Z - .Item(i).Z) * (.Item(i + 1).Pl + .Item(i).Pl) / 2
                Next
            End If
            pl_dzk += (zinf2 - .Item(ind3).Z) * (pl3_4 + .Item(ind3).Pl) / 2 'calcul de l'intégration sur le dernier tronçon
        End With

        Def = pl_dzk / ple
        '
        'Calcul de Kp et KpMax pour la détermination de qb puis Rb (résistance de pointe) Exception faite pour les micropieux
        If Pieux.Categorie > 16 AndAlso Pieux.AucuneResistancedePointe = True Then 'Clause de la prise en compte de la résistance de pointe pour les micropieux
            'pas de calcul de résistance de pointe pour les micropieux, sauf dans le cas d'un effet de groupe ou ple doit être calculée
            CSHd = True : DefB = 0 : kpMax = 0 : Rb = 0 : Kp = 0
        Else
            '--> test sur l'homogénéité de la couche porteuse
            If plMax < 2 * plmin Then
                CSnote1 = True
            Else
                CSnote1 = False
                msg = "La couche porteuse est considérée comme non homogène car la pression limite maximale mesurée dans cette couche excède plus de deux fois la pression limite minimale (Note 1 - §F4.2.(3) de la NF P94-262 - 2013)."
                Aff.msg_Avertiss.Add(msg)
            End If
            '--> test sur la hauteur d'encastrement effectif dans la couche porteuse
            If Pieux.Bmin > 0.5 Then
                If Def < 1.5 Then
                    CSHd = False
                    msg = "La profondeur d'encastrement du pieu dans la couche porteuse Def (= " & Def.ToString("#0.00") & " m) ne répond pas aux conditions de la note 1 de l'annexe F §F4.2.(4) de la NF P94-262 - 2013, " &
                   "- Soit 1,50m pour les pieux de diamètre supérieur à 0,50m." & Environment.NewLine
                    Aff.msg_Avertiss.Add(msg)
                Else
                    CSHd = True
                End If
            Else
                If Def < 3 * Pieux.Bmin Then
                    CSHd = False
                    msg = "La profondeur d'encastrement du pieu dans la couche porteuse Def (= " & Def.ToString("#0.00") & " m) ne répond pas aux conditions de la note 1 de l'annexe F §F4.2.(4) de la NF P94-262 - 2013, " &
                     "- Soit < à 3 diamètres pour les pieux de diamètre inférieur à 0,50m." & Environment.NewLine
                    Aff.msg_Avertiss.Add(msg)
                Else
                    CSHd = True
                End If
            End If

            'détermination de kpMax
            'détermination de l'index de la couche de sol correspondante
            With Sondage.Lithologie
                h = 0
                For j = 1 To .Count
                    h += .Item(j - 1).hcouche
                    If zinf2 < h Then
                        ' j - 1 = index de la 1ière valeur de Zinf en dessous de Zinf2
                        'détermination de kpmax
                        Call KpMax_Determination(.Item(j - 1).Categorie, kpMax)
                        Exit For
                    End If
                Next
            End With
            'détermination de kp
            DefB = Def / Pieux.Bmin
            If Def / Pieux.Bmin >= 5 Then
                Kp = kpMax
            Else
                Kp = 1 + (kpMax - 1) * (Def / Pieux.Bmin) / 5  'Rapport Def/B < 5 - Kp suivant équation du §F.4.2(4) de la NF P94.262. 
            End If
            'Calcul de la résistance de pointe de la fondation profonde
            qb = Kp * ple
            Rb = Pieux.Ab * qb
        End If
    End Sub

    ''' <summary>Calcul de Rs suivant les essais pressiométriques pour la Procédure Pieu Modèle</summary>
    '''  <param name="Sondage">Ensemble des caractéristiques pressiométriques et lithologiques du sondage i</param>
    ''' <param name="ʃqs">intégration de qs sur la longueur D du pieu</param>
    ''' <param name="Rs">Résistance de frottement du pieu déterminé par les essais pressiométriques</param>
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    ''' <param name="Verif">renvoie FALSE si erreur</param>
    Private Sub Pieu_Portance_EssaisPressiometriques_PieuModele_Rs(ByVal Sondage As clsSondagePressio, ByRef ʃqs As Double, ByRef Rs As Double, ByRef rtf As To_Rtf.RtfAnsiTextWriter, ByRef Verif As Boolean)
        Dim i, ind1, ind2, j As Integer
        Dim msg As String = String.Empty
        Dim a, b, c, h, qs_D, qsMax, qsi, qs1(Sondage.Lithologie.Count), qs2(Sondage.MesurePressio.Count), αpieu_sol As Double
        Dim entete As Boolean = True

        'calcul de qs(z) pour toutes les valeurs mesurées de pl*
        ind1 = 0 : h = 0 : msg = String.Empty
        With Sondage
            For i = 0 To .Lithologie.Count - 1
                h += .Lithologie.Item(i).hcouche
                For j = ind1 To Sondage.MesurePressio.Count - 1
                    'calcul sur toutes les mesures de pl réalisées dans chaque couche lithologique
                    Select Case i
                        Case .Lithologie.Count - 1  'dernière couche
                            Call αpieu_sol_Pressiometrique(.Lithologie.Item(i).Categorie, αpieu_sol)
                            If αpieu_sol = 1000 Then
                                msg = "Calcul de qs(z) - Détermination du coefficient αpieu_sol:" : Aff.msg_Avertiss.Add(msg)
                                msg = "Dernière couche : le coefficient αpieu_sol n'a pas pu être déterminé. Le coefficient a été pris égal à αpieu_sol = 1 pour la suite des calculs." : Aff.msg_Avertiss.Add(msg)
                                αpieu_sol = 1
                            End If
                            Call Coef_a_b_c_fsol(.Lithologie.Item(i).Categorie, a, b, c)
                            qs2(j) = αpieu_sol * (a * .MesurePressio.Item(j).Pl + b) * (1 - E ^ (-c * .MesurePressio.Item(j).Pl)) : qsi = qs2(j)
                            Call Val_maximale_FrottementAxialUnitaire(.Lithologie.Item(i).Categorie, qsMax, qs2(j))
                            Call Tableaux_qs(entete, .MesurePressio.Item(j).Z, .Lithologie.Item(i).Categorie, .Lithologie.Item(i).hcouche, .MesurePressio.Item(j).Pl, αpieu_sol, a, b, c, qsi, qsMax, qs2(j), rtf)
                        Case Else   '1ière couche et couches intermédiaires
                            If .MesurePressio.Item(j).Z <= h Then 'z de la mesure de pl* < z de la catégorisation de la couche de sol
                                Call αpieu_sol_Pressiometrique(.Lithologie.Item(i).Categorie, αpieu_sol)
                                If αpieu_sol = 1000 Then
                                    msg = "Calcul de qs(z) - Détermination du coefficient αpieu_sol:" : Aff.msg_Avertiss.Add(msg)
                                    msg = "Couche de sol n°" & (i + 1).ToString("#0") & ": le coefficient αpieu_sol n'a pas pu être déterminé. Le coefficient a été pris égal à αpieu_sol = 1 pour la suite des calculs." : Aff.msg_Avertiss.Add(msg)
                                    αpieu_sol = 1
                                End If
                                Call Coef_a_b_c_fsol(.Lithologie.Item(i).Categorie, a, b, c)
                                qs2(j) = αpieu_sol * (a * .MesurePressio.Item(j).Pl + b) * (1 - E ^ (-c * .MesurePressio.Item(j).Pl)) : qsi = qs2(j)
                                Call Val_maximale_FrottementAxialUnitaire(.Lithologie.Item(i).Categorie, qsMax, qs2(j))
                                Call Tableaux_qs(entete, .MesurePressio.Item(j).Z, .Lithologie.Item(i).Categorie, .Lithologie.Item(i).hcouche, .MesurePressio.Item(j).Pl, αpieu_sol, a, b, c, qsi, qsMax, qs2(j), rtf)
                            Else
                                ind1 = j
                                Exit For  'passage à la catégorie suivante en conservant le même indice
                            End If
                    End Select
                Next
            Next
            'Ecriture du pb de détermination du coefficient αpieu_sol 
            If msg <> String.Empty Then
                rtf.WriteStartGroup() : rtf.NewParagraph() : rtf.FontSize = 12 : rtf.FontSize = 9
                rtf.WriteString("Voir § Avertissement: Problème de détermination de la valeur de αpieu_sol pour certaines couches de sol.") : rtf.NewLine()
                rtf.WriteEndGroup()
            End If
        End With

        'calcul de l'intégration de qs(z) sur la longueur de fondation D


        With Sondage.MesurePressio
            For j = 1 To .Count
                If Pieux.D < .Item(j - 1).Z Then
                    ind2 = j - 1 'index de la 1ière valeur de pression limite au delà de D
                    If ind2 > 0.1 Then ind1 = ind2 - 1 'index de la 1ière valeur de pression limite au deça de Zinf2
                    'calcul de la pression limite sur le dernier tronçon
                    qs_D = qs2(ind1) + ((qs2(ind2) - qs2(ind1)) / (.Item(ind2).Z - .Item(ind1).Z)) * (Pieux.D - .Item(ind1).Z)
                    Exit For
                End If
            Next
            'Application de la clause des pieux de grande longueur
            Dim abat As Double = 1
            If Pieux.D > 25 AndAlso (Pieux.Abreviation = "FS" OrElse Pieux.Abreviation = "FB" OrElse Pieux.Abreviation = "FSR" OrElse Pieux.Abreviation = "FBR" OrElse Pieux.Abreviation = "PU") Then
                If Pieux.AbattementGrandeLongueur = True Then
                    abat = 0.5
                Else
                    'Insertion d'un avertissement dans la note de calcul
                    msg = "Application de la clause des pieux de grande longueur: Pieu de type " & Pieux.Abreviation.ToString & " et longueur du pieu excédant les 25 m, aucun coefficient d'abattement n'a été appliqué." : Aff.msg_Avertiss.Add(msg)
                End If
            End If
            ʃqs = .Item(0).Z * qs2(0) / 2
            If .Item(0).Z < Pieux.D - 25 Then ʃqs = abat * ʃqs
            For i = 0 To ind1 - 1
                If .Item(i + 1).Z < Pieux.D - 25 Then
                    ʃqs += abat * (.Item(i + 1).Z - .Item(i).Z) * (qs2(i + 1) + qs2(i)) / 2
                Else
                    If .Item(i).Z > Pieux.D - 25 Then
                        ʃqs += (.Item(i + 1).Z - .Item(i).Z) * (qs2(i + 1) + qs2(i)) / 2
                    Else
                        ʃqs += (.Item(i + 1).Z - (Pieux.D - 25)) * (qs2(i + 1) + qs2(i)) / 2
                        ʃqs += abat * (Pieux.D - 25 - .Item(i).Z) * (qs2(i + 1) + qs2(i)) / 2
                    End If
                End If
            Next
            ʃqs += (Pieux.D - .Item(ind1).Z) * (qs_D + qs2(ind1)) / 2 'calcul de l'intégration sur le dernier tronçon
            Rs = Pieux.Ps * ʃqs
        End With

        'Application de la clause du vibrofonçage pour les pieux de type BAO, HB et PP
        If (Pieux.Abreviation = "BAO" OrElse Pieux.Abreviation = "HB" OrElse Pieux.Abreviation = "PP") AndAlso Pieux.Vibrofoncage = True Then
            Rs = 0.7 * Rs : ʃqs = 0.7 * ʃqs
        End If

    End Sub

    ''' <summary>Module de calcul de la Pression Limite Nette Pl*</summary>
    ''' <param name="Pl">Pression limite à la profondeur H</param>
    ''' <param name="H">Profondeur à laquelle la pression limite nette est calculée</param>
    Private Function PressionLimiteNette(ByVal Pl As Double, ByVal H As Double) As Double
        Dim σhs, σvs, K0, Us, ϒw, ϒ As Double
        ϒw = 10 'densité de l'eau KN/m3
        ϒ = 18 'densité du sol KN/m3
        K0 = 0.5
        With SondageModele
            If .NappeEau = False Then
                Us = 0
            Else
                If .Zeau < H Then
                    Us = ϒw * (H - .Zeau)
                Else
                    Us = 0 'cas ou la nappe d'eau est situé en dessous de la pointe du pieu
                End If
            End If
            σvs = ϒ * H
            σhs = K0 * (σvs - Us) + Us
            Return Pl - (σhs / 1000)
        End With
    End Function

    ''' <summary>Tableau d'affichage des valeurs intermédiaires pour le calcul du frottement unitaire suivant les essais pressiométriques</summary>
    ''' <param name="entete">= TRUE pour l'affichage de l'entête du tableau</param>
    '''  <param name="z">profondeur du sondage</param>
    ''' <param name="CatSol">catégorie du sol</param>
    ''' <param name="hCouche">hauteur de la couche de sol</param>
    ''' <param name="pl">pression limite nette à la profondeur z</param>
    ''' <param name="αpieu_sol">coefficient αpieu_sol suivant tableau F.5.2.1</param>
    ''' <param name="a">coefficient a pour la fonction f sol - tableau F.5.2.2</param>
    ''' <param name="b">coefficient b pour la fonction f sol - tableau F.5.2.2</param>
    ''' <param name="c">coefficient c pour la fonction f sol - tableau F.5.2.2</param>
    ''' <param name="qsi">frottement unitaire initialement calculé</param>
    ''' <param name="qsMax">frottement unitaire Maximal</param>
    ''' <param name="qs">frottement unitaire retenue</param>
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    Private Sub Tableaux_qs(ByRef entete As Boolean, ByVal z As Double, ByVal CatSol As Integer, ByVal hCouche As Double, ByVal pl As Double, ByVal αpieu_sol As Double, ByVal a As Double, ByVal b As Double, ByVal c As Double, ByVal qsi As Double,
                            ByVal qsMax As Double, ByVal qs As Double, ByRef rtf As To_Rtf.RtfAnsiTextWriter)
        rtf.WriteStartGroup()
        rtf.FontSize = 12 : rtf.FontSize = 8
        Dim msg As String = String.Empty
        If entete = True Then
            rtf.NewParagraph()
            'entête du tableau et ligne 1
            rtf.BeginRow() : rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("Z (m)") : rtf.EndCell() : rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("Catégorie sol") : rtf.EndCell()
            rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("h couche") : rtf.EndCell() : rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("pl (MPa)") : rtf.EndCell()
            rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("αpieu_sol") : rtf.EndCell()
            rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("a") : rtf.EndCell() : rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("b") : rtf.EndCell()
            rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("c") : rtf.EndCell()
            rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("qs initial (MPa)") : rtf.EndCell() : rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("qsmax (MPa)") : rtf.EndCell()
            rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("qs retenue (MPa)") : rtf.EndCell()
            rtf.EndRow()
            entete = False
        End If
        rtf.BeginRow()
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(z.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(CatSol.ToString("#0")) : rtf.EndCell()
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(hCouche.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(pl.ToString("#0.000")) : rtf.EndCell()
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(αpieu_sol.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(a.ToString("#0.000")) : rtf.EndCell()
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(b.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(c.ToString("#0.0")) : rtf.EndCell()
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(qsi.ToString("#0.000")) : rtf.EndCell()
        If qsMax = 1000 Then msg = "S.O" Else msg = qsMax.ToString("#0.000")
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(msg) : rtf.EndCell()
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(qs.ToString("#0.000")) : rtf.EndCell()
        rtf.EndRow()

        rtf.WriteEndGroup()
    End Sub

    ''' <summary>Détermination de la valeur de Kpmax suivant tableau F.4.2.1 de la NF P94.262</summary>
    ''' <param name="Categorie">Catégorie conventionnelle de terrain suivant tableau B.2.1 de l'annexe B de la NF P94-262 pour la détermination de kpMax du tableau F.4.2.1 de l'annexe F de la NF P94-262</param>
    ''' <param name="kpMax">valeur de Kpmax suivant tableau F.4.2.1 de la NF P94.262</param>
    Private Sub KpMax_Determination(ByVal Categorie As Integer, ByRef kpMax As Double)
        Select Case Pieux.Classe
            Case 1
                Select Case Categorie
                    Case 1, 2
                        kpMax = 1.15
                    Case 3, 4
                        kpMax = 1.1
                    Case 5
                        kpMax = 1.45
                    Case 6
                        kpMax = 1.45
                    Case 7
                        kpMax = 1.45
                End Select
            Case 2
                Select Case Categorie
                    Case 1, 2
                        kpMax = 1.3
                    Case 3, 4
                        kpMax = 1.65
                    Case 5
                        kpMax = 1.6
                    Case 6
                        kpMax = 1.6
                    Case 7
                        kpMax = 2
                End Select
            Case 3
                Select Case Categorie
                    Case 1, 2
                        kpMax = 1.55
                    Case 3, 4
                        kpMax = 3.2
                    Case 5
                        kpMax = 2.35
                    Case 6
                        kpMax = 2.1
                    Case 7
                        kpMax = 2.1
                End Select
            Case 4
                Select Case Categorie
                    Case 1, 2
                        kpMax = 1.35
                    Case 3, 4
                        kpMax = 3.1
                    Case 5
                        kpMax = 2.3
                    Case 6
                        kpMax = 2.3
                    Case 7
                        kpMax = 2.3
                End Select
            Case 5
                Select Case Categorie
                    Case 1, 2
                        kpMax = 1
                    Case 3, 4
                        kpMax = 1.9
                    Case 5
                        kpMax = 1.4
                    Case 6
                        kpMax = 1.4
                    Case 7
                        kpMax = 1.2
                End Select
            Case 6
                Select Case Categorie
                    Case 1, 2
                        kpMax = 1.2
                    Case 3, 4
                        kpMax = 3.1
                    Case 5
                        kpMax = 1.7
                    Case 6
                        kpMax = 2.2
                    Case 7
                        kpMax = 1.5
                End Select
            Case 7
                Select Case Categorie
                    Case 1, 2
                        kpMax = 1
                    Case 3, 4
                        kpMax = 1
                    Case 5
                        kpMax = 1
                    Case 6
                        kpMax = 1
                    Case 7
                        kpMax = 1.2
                End Select
            Case 8
                Select Case Categorie
                    Case 1, 2
                        kpMax = 1.15
                    Case 3, 4
                        kpMax = 1.1
                    Case 5
                        kpMax = 1.45
                    Case 6
                        kpMax = 1.45
                    Case 7
                        kpMax = 1.45
                End Select
        End Select
    End Sub

    ''' <summary>Détermination de la valeur de αpieu_sol suivant le tableau F.5.2.1 de la NF P94.262</summary>
    ''' <param name="Categorie">Catégorie conventionnelle de terrain suivant tableau B.2.1 de l'annexe B de la NF P94-262 pour la détermination du coefficient αpieu_sol du tableau F.5.2.1 de l'annexe F de la NF P94-262</param>
    ''' <param name="αpieu_sol">coefficient αpieu_sol</param>
    Private Sub αpieu_sol_Pressiometrique(ByVal Categorie As Integer, ByRef αpieu_sol As Double)
        Dim Categorie_Pieux As Integer
        If Pieux.Categorie = 17 OrElse Pieux.Categorie = 18 Then Categorie_Pieux = Pieux.CategorieAssimil Else Categorie_Pieux = Pieux.Categorie
        αpieu_sol = 1000 'pour le cas ou αpieu_sol ne figure pas dans le tableau F.5.2.1
        Select Case Categorie_Pieux
            Case 1
                Select Case Categorie
                    Case 1, 2
                        αpieu_sol = 1.1
                    Case 3, 4
                        αpieu_sol = 1
                    Case 5
                        αpieu_sol = 1.8
                    Case 6
                        αpieu_sol = 1.5
                    Case 7
                        αpieu_sol = 1.6
                End Select
            Case 2
                Select Case Categorie
                    Case 1, 2
                        αpieu_sol = 1.25
                    Case 3, 4
                        αpieu_sol = 1.4
                    Case 5
                        αpieu_sol = 1.8
                    Case 6
                        αpieu_sol = 1.5
                    Case 7
                        αpieu_sol = 1.6
                End Select
            Case 3
                Select Case Categorie
                    Case 1, 2
                        αpieu_sol = 0.7
                    Case 3, 4
                        αpieu_sol = 0.6
                    Case 5
                        αpieu_sol = 0.5
                    Case 6
                        αpieu_sol = 0.9
                End Select
            Case 4
                Select Case Categorie
                    Case 1, 2
                        αpieu_sol = 1.25
                    Case 3, 4
                        αpieu_sol = 1.4
                    Case 5
                        αpieu_sol = 1.7
                    Case 6
                        αpieu_sol = 1.4
                End Select
            Case 5
                Select Case Categorie
                    Case 1, 2
                        αpieu_sol = 1.3
                End Select
            Case 6
                Select Case Categorie
                    Case 1, 2
                        αpieu_sol = 1.5
                    Case 3, 4
                        αpieu_sol = 1.8
                    Case 5
                        αpieu_sol = 2.1
                    Case 6
                        αpieu_sol = 1.6
                    Case 7
                        αpieu_sol = 1.6
                End Select
            Case 7
                Select Case Categorie
                    Case 1, 2
                        αpieu_sol = 1.9
                    Case 3, 4
                        αpieu_sol = 2.1
                    Case 5
                        αpieu_sol = 1.7
                    Case 6
                        αpieu_sol = 1.7
                End Select
            Case 8
                Select Case Categorie
                    Case 1, 2
                        αpieu_sol = 0.6
                    Case 3, 4
                        αpieu_sol = 0.6
                    Case 5
                        αpieu_sol = 1
                    Case 6
                        αpieu_sol = 0.7
                End Select
            Case 9
                Select Case Categorie
                    Case 1, 2
                        αpieu_sol = 1.1
                    Case 3, 4
                        αpieu_sol = 1.4
                    Case 5
                        αpieu_sol = 1
                    Case 6
                        αpieu_sol = 0.9
                End Select
            Case 10
                Select Case Categorie
                    Case 1, 2
                        αpieu_sol = 2
                    Case 3, 4
                        αpieu_sol = 2.1
                    Case 5
                        αpieu_sol = 1.9
                    Case 6
                        αpieu_sol = 1.6
                End Select
            Case 11
                Select Case Categorie
                    Case 1, 2
                        αpieu_sol = 1.2
                    Case 3, 4
                        αpieu_sol = 1.4
                    Case 5
                        αpieu_sol = 2.1
                    Case 6
                        αpieu_sol = 1
                End Select
            Case 12
                Select Case Categorie
                    Case 1, 2
                        αpieu_sol = 0.8
                    Case 3, 4
                        αpieu_sol = 1.2
                    Case 5
                        αpieu_sol = 0.4
                    Case 6
                        αpieu_sol = 0.9
                End Select
            Case 13
                Select Case Categorie
                    Case 1, 2
                        αpieu_sol = 1.2
                    Case 3, 4
                        αpieu_sol = 0.7
                    Case 5
                        αpieu_sol = 0.5
                    Case 6
                        αpieu_sol = 1
                    Case 7
                        αpieu_sol = 1
                End Select
            Case 14
                Select Case Categorie
                    Case 1, 2
                        αpieu_sol = 1.1
                    Case 3, 4
                        αpieu_sol = 1
                    Case 5
                        αpieu_sol = 0.4
                    Case 6
                        αpieu_sol = 1
                    Case 7
                        αpieu_sol = 0.9
                End Select
            Case 15
                Select Case Categorie
                    Case 1, 2
                        αpieu_sol = 2.7
                    Case 3, 4
                        αpieu_sol = 2.9
                    Case 5
                        αpieu_sol = 2.4
                    Case 6
                        αpieu_sol = 2.4
                    Case 7
                        αpieu_sol = 2.4
                End Select
            Case 16
                Select Case Categorie
                    Case 1, 2
                        αpieu_sol = 0.9
                    Case 3, 4
                        αpieu_sol = 0.8
                    Case 5
                        αpieu_sol = 0.4
                    Case 6
                        αpieu_sol = 1.2
                    Case 7
                        αpieu_sol = 1.2
                End Select
            Case 19
                Select Case Categorie
                    Case 1, 2
                        αpieu_sol = 2.7
                    Case 3, 4
                        αpieu_sol = 2.9
                    Case 5
                        αpieu_sol = 2.4
                    Case 6
                        αpieu_sol = 2.4
                    Case 7
                        αpieu_sol = 12.4
                End Select
            Case 20
                Select Case Categorie
                    Case 1, 2
                        αpieu_sol = 3.4
                    Case 3, 4
                        αpieu_sol = 3.8
                    Case 5
                        αpieu_sol = 3.1
                    Case 6
                        αpieu_sol = 3.1
                    Case 7
                        αpieu_sol = 3.1
                End Select
        End Select
        If Categorie = 0 Then αpieu_sol = 0
    End Sub

    ''' <summary>Détermination des coefficients a, b, c suivant le tableau F.5.2.2 de la NF P94.262 pour la fonction fsol</summary>
    ''' <param name="Categorie">Catégorie conventionnelle de terrain suivant tableau B.2.1 de l'annexe B de la NF P94-262</param>
    ''' <param name="a">coefficient a de l'équation F.5.2.2</param>
    ''' <param name="b">coefficient b de l'équation F.5.2.2</param>
    ''' <param name="c">coefficient c de l'équation F.5.2.2</param>
    Private Sub Coef_a_b_c_fsol(ByVal Categorie As Integer, ByRef a As Double, ByRef b As Double, ByRef c As Double)
        Select Case Categorie
            Case 0 'remblai - aucune valeur de frottement
                a = 0 : b = 0 : c = 0
            Case 1, 2 'argile limon - sol intermediaire de catégorie 1
                a = 0.003 : b = 0.04 : c = 3.5
            Case 3, 4 'sol intermediaire de catégorie 2 - Sables et Graves
                a = 0.01 : b = 0.06 : c = 1.2
            Case 5 'craie
                a = 0.007 : b = 0.07 : c = 1.3
            Case 6  'marne et calcaires marneux
                a = 0.008 : b = 0.08 : c = 3
            Case 7 'rocher
                a = 0.01 : b = 0.08 : c = 3
        End Select
    End Sub

    ''' <summary>Détermination du frottement axial unitaire Maximal qsMax suivant le tableau F.5.2.3 de la NF P94.262</summary>
    ''' <param name="Categorie">Catégorie conventionnelle de terrain suivant tableau B.2.1 de l'annexe B de la NF P94-262 pour la détermination de qsMax du tableau F.5.2.3 de l'annexe F de la NF P94-262</param>
    ''' <param name="qs">frottement axial unitaire limite - MPa</param>
    ''' <param name="qsMax">frottement axial unitaire Maximal limite - MPa</param>
    Private Sub Val_maximale_FrottementAxialUnitaire(ByVal Categorie As Integer, ByRef qsMax As Double, ByRef qs As Double)
        qsMax = 1000
        Select Case Pieux.Categorie
            Case 1
                Select Case Categorie
                    Case 1
                        qsMax = 90
                    Case 2, 3
                        qsMax = 90
                    Case 4
                        qsMax = 90
                    Case 5
                        qsMax = 200
                    Case 6
                        qsMax = 170
                    Case 7
                        qsMax = 200
                End Select
            Case 2
                Select Case Categorie
                    Case 1
                        qsMax = 90
                    Case 2, 3
                        qsMax = 90
                    Case 4
                        qsMax = 90
                    Case 5
                        qsMax = 200
                    Case 6
                        qsMax = 170
                    Case 7
                        qsMax = 200
                End Select
            Case 3
                Select Case Categorie
                    Case 1
                        qsMax = 50
                    Case 2, 3
                        qsMax = 50
                    Case 4
                        qsMax = 50
                    Case 5
                        qsMax = 50
                    Case 6
                        qsMax = 90
                End Select
            Case 4
                Select Case Categorie
                    Case 1
                        qsMax = 90
                    Case 2, 3
                        qsMax = 90
                    Case 4
                        qsMax = 90
                    Case 5
                        qsMax = 170
                    Case 6
                        qsMax = 170
                End Select
            Case 5
                Select Case Categorie
                    Case 1
                        qsMax = 90
                    Case 2
                        qsMax = 90
                End Select
            Case 6
                Select Case Categorie
                    Case 1
                        qsMax = 90
                    Case 2, 3
                        qsMax = 90
                    Case 4
                        qsMax = 170
                    Case 5
                        qsMax = 200
                    Case 6
                        qsMax = 200
                    Case 7
                        qsMax = 200
                End Select
            Case 7
                Select Case Categorie
                    Case 1
                        qsMax = 130
                    Case 2, 3
                        qsMax = 130
                    Case 4
                        qsMax = 200
                    Case 5
                        qsMax = 170
                    Case 6
                        qsMax = 170
                End Select
            Case 8
                Select Case Categorie
                    Case 1
                        qsMax = 50
                    Case 2, 3
                        qsMax = 50
                    Case 4
                        qsMax = 90
                    Case 5
                        qsMax = 90
                    Case 6
                        qsMax = 90
                End Select
            Case 9
                Select Case Categorie
                    Case 1
                        qsMax = 130
                    Case 2, 3
                        qsMax = 130
                    Case 4
                        qsMax = 130
                    Case 5
                        qsMax = 90
                    Case 6
                        qsMax = 90
                End Select
            Case 10
                Select Case Categorie
                    Case 1
                        qsMax = 170
                    Case 2, 3
                        qsMax = 170
                    Case 4
                        qsMax = 260
                    Case 5
                        qsMax = 200
                    Case 6
                        qsMax = 200
                End Select
            Case 11
                Select Case Categorie
                    Case 1
                        qsMax = 90
                    Case 2, 3
                        qsMax = 90
                    Case 4
                        qsMax = 130
                    Case 5
                        qsMax = 260
                    Case 6
                        qsMax = 200
                End Select
            Case 12
                Select Case Categorie
                    Case 1
                        qsMax = 90
                    Case 2, 3
                        qsMax = 90
                    Case 4
                        qsMax = 90
                    Case 5
                        qsMax = 50
                    Case 6
                        qsMax = 90
                End Select
            Case 13
                Select Case Categorie
                    Case 1
                        qsMax = 90
                    Case 2, 3
                        qsMax = 90
                    Case 4
                        qsMax = 50
                    Case 5
                        qsMax = 50
                    Case 6
                        qsMax = 90
                    Case 7
                        qsMax = 90
                End Select
            Case 14
                Select Case Categorie
                    Case 1
                        qsMax = 90
                    Case 2, 3
                        qsMax = 90
                    Case 4
                        qsMax = 130
                    Case 5
                        qsMax = 50
                    Case 6
                        qsMax = 90
                    Case 7
                        qsMax = 90
                End Select
            Case 15
                Select Case Categorie
                    Case 1
                        qsMax = 200
                    Case 2, 3
                        qsMax = 200
                    Case 4
                        qsMax = 380
                    Case 5
                        qsMax = 320
                    Case 6
                        qsMax = 320
                    Case 7
                        qsMax = 320
                End Select
            Case 16
                Select Case Categorie
                    Case 1
                        qsMax = 90
                    Case 2, 3
                        qsMax = 90
                    Case 4
                        qsMax = 50
                    Case 5
                        qsMax = 50
                    Case 6
                        qsMax = 90
                    Case 7
                        qsMax = 90
                End Select
            Case 19
                Select Case Categorie
                    Case 1
                        qsMax = 200
                    Case 2, 3
                        qsMax = 200
                    Case 4
                        qsMax = 380
                    Case 5
                        qsMax = 320
                    Case 6
                        qsMax = 320
                    Case 7
                        qsMax = 320
                End Select
            Case 20
                Select Case Categorie
                    Case 1
                        qsMax = 200
                    Case 2, 3
                        qsMax = 200
                    Case 4
                        qsMax = 440
                    Case 5
                        qsMax = 440
                    Case 6
                        qsMax = 440
                    Case 7
                        qsMax = 500
                End Select
        End Select
        If qsMax = 1000 Then
            qs = 0
            If Categorie = 0 Then qsMax = 0 'remblai = pas de frottement
        Else
            qsMax = qsMax / 1000  'transformation de KPa en MPa
            If qs > qsMax Then qs = qsMax
        End If
    End Sub
#End Region

#Region "Calcul de la portance de pieu par les essais au Pénétromètre statique"

    ''' <summary>Calcul de la portance d'un pieu par la procédure Modèle de terrain et essais pénétrométriques statiques</summary>
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    ''' <param name="Verif">renvoie FALSE si erreur</param>
    Public Sub Calcul_Pieu_Portance_ModeleTerrain_Penetrometrique(ByRef rtf As To_Rtf.RtfAnsiTextWriter, ByRef Verif As Boolean)
        Dim Rbk, Rsk, Rb, Rs As Double
        Dim ʃqs As Double
        Dim msg As String = String.Empty
        Dim Avertissement As Boolean = False
        Dim i_chap As Integer = 2

        'Calcul de la résistance de pointe Rb
#Region "entête Ecriture dans la note de calcul"
        rtf.WriteStartGroup()
        rtf.NewParagraph() : rtf.FontSize = 12 : rtf.NewLine() : rtf.Bold = True : rtf.Underline = True
        rtf.WriteString(i_chap.ToString("#0") & " - Calcul de la résistance de pointe Rb pour le Modèle de terrain") : rtf.FontSize = 9 : rtf.Bold = False : rtf.Underline = False : rtf.NewLine() : rtf.NewLine()
        If Pieux.AucuneResistancedePointe = True Then
            'pas de calcul de résistance de pointe pour les micropieux, sauf dans le cas d'un effet de groupe ou qce doit être calculée
            rtf.WriteString("Valeur du facteur de portance Kc  = 0  -  Pas de calcul de résistance de pointe pour les micropieux") : rtf.NewLine()
            rtf.WriteString("Valeur de la résistance de pointe Rb : 0 MN  -  Aucune résistance de pointe pour les micropieux, uniquement une résistance par frottement (voir ci-dessous).") : rtf.NewLine()
        Else
            rtf.WriteString("Le calcul de la valeur de la résistance à la pénétration équivalente q") : rtf.Subscript = True : rtf.WriteString("ce") : rtf.Subscript = False : rtf.WriteString(" est réalisé suivant l'équation G.4.2.3 de l'annexe G de la NF P94-262 - 2013") : rtf.NewLine()
            rtf.WriteString("Fiche du pieu D : " & Pieux.D.ToString("#0.00") & " m (= longueur enterrée du pieu).") : rtf.NewLine()
            rtf.WriteString("Hauteur d'encastrement du pieu dans la couche porteuse : " & Pieux.Hencastr.ToString("#0.00") & " m.") : rtf.NewLine()
        End If
        rtf.WriteEndGroup()
#End Region
        Dim a, b, Db, D3a, Intqcc, qce, Hd, Intqc, Def, DefB, KcMax, Kc As Double
        Dim CSnote1 As Boolean = True
        Dim CSHd As Boolean = True
        Call Pieu_Portance_EssaisPenetrometriques_PieuModele_Rb(0, Rb, rtf, Verif, a, b, Db, D3a, Intqcc, qce, CSnote1, Hd, Intqc, Def, DefB, CSHd, KcMax, Kc)
        Call Tableaux_Rb_Penetro(1, Pieux.Hencastr, a, b, Db, D3a, Intqcc, qce, CSnote1, Hd, Intqc, Def, CSHd, DefB, KcMax, Kc, Kc * qce, Rb, rtf)

        'Calcul de la résistance de frottement axial Rs
#Region "entête Ecriture dans la note de calcul"      'Ecriture dans la note de calcul 
        rtf.WriteStartGroup() : rtf.NewParagraph() : i_chap += 1 : rtf.FontSize = 12 : rtf.Bold = True : rtf.Underline = True
        rtf.WriteString(i_chap.ToString("#0") & " - Calcul de la résistance de frottement axial Rs pour le Modèle de terrain") : rtf.FontSize = 10 : rtf.Bold = False : rtf.NewLine() : rtf.NewLine()
        rtf.WriteString(i_chap.ToString("#0") & " - 1  Calcul de qs(z) pour toutes les valeurs mesurées de la résistance à la pénétration q") : rtf.Subscript = True : rtf.WriteString("c") : rtf.Subscript = False
        rtf.WriteString(" sur le Modèle de terrain.")
        rtf.FontSize = 9 : rtf.Underline = False : rtf.NewLine() : rtf.NewLine()
        rtf.WriteString("Les valeurs de α pieu_sol sont établies conformément au tableau G.5.2.1 de la NF P94-262.") : rtf.NewLine()
        rtf.WriteString("Les valeurs des coefficients a, b et c sont établies conformément au tableau G.5.2.2 de la NF P94-262.") : rtf.NewLine()
        rtf.WriteString("Les valeurs de qsMax sont établies conformément au tableau G.5.2.3 de la NF P94-262.") : rtf.NewLine()
        rtf.Bold = True : rtf.Underline = True
        rtf.WriteString("Rappel:") : rtf.Bold = False : rtf.Underline = False : rtf.NewLine()
        rtf.WriteString("    - si qs > qsMax alors La valeur de qs est limitée à qsmax.") : rtf.NewLine()
        rtf.WriteString("    - si qs < qsMax alors La valeur initiale de qs est conservée.") : rtf.NewLine()
        rtf.WriteEndGroup()
#End Region
        Call Pieu_Portance_EssaisPenetrometriques_PieuModele_Rs(0, ʃqs, Rs, rtf, Verif)
#Region "entête Ecriture dans la note de calcul avant tableau"      'Ecriture dans la note de calcul 
        rtf.WriteStartGroup() : rtf.NewParagraph() : rtf.FontSize = 10 : rtf.Underline = True
        rtf.WriteString(i_chap.ToString("#0") & " - 2  Calcul de l'intégration de qs(z) sur la longueur de fondation D")
        rtf.FontSize = 9 : rtf.Underline = False : rtf.NewLine() : rtf.NewLine()
        rtf.WriteString("Valeur de D, longueur de la fondation contenue dans le terrain, D = " & Pieux.D.ToString("#0.00") & " m.") : rtf.NewLine()
        rtf.WriteString("Valeur de Ps, périmètre du fût du pieu, Ps = " & Pieux.Ps.ToString("#0.000") & " ml.") : rtf.NewLine()
        If Pieux.D > 25 AndAlso (Pieux.Abreviation = "FS" OrElse Pieux.Abreviation = "FB" OrElse Pieux.Abreviation = "FSR" OrElse Pieux.Abreviation = "FBR" OrElse Pieux.Abreviation = "PU") Then
            If Pieux.AbattementGrandeLongueur = True Then
                rtf.WriteString("Application d'un coefficient d'abattement de 50% sur les valeurs de frottements pour les premiers " & (Pieux.D - 25).ToString("#0.00") & " m du pieu suivant la clause G.5.2(6).") : rtf.NewLine()
            Else
                'Insertion d'un avertissement dans la note de calcul
                msg = "Application de la clause des pieux de grande longueur: Pieu de type " & Pieux.Abreviation.ToString & " et longueur du pieu excédant les 25 m, aucun coefficient d'abattement n'a été appliqué." : Aff.msg_Avertiss.Add(msg)
            End If
        End If
        'Application de la clause du vibrofonçage pour les pieux de type BAO, HB et PP
        If (Pieux.Abreviation = "BAO" OrElse Pieux.Abreviation = "HB" OrElse Pieux.Abreviation = "PP") AndAlso Pieux.Vibrofoncage = True Then
            rtf.WriteString("Application de la clause du vibrofonçage pour les pieux de type BAO, HB et PP: réduction de 30% de la valeur de qs") : rtf.NewLine()
        ElseIf (Pieux.Abreviation = "BAO" OrElse Pieux.Abreviation = "HB" OrElse Pieux.Abreviation = "PP") AndAlso Pieux.Vibrofoncage = False Then
            rtf.WriteString("Mise en oeuvre des pieux de type BAO, HB et PP par battage: aucune réduction de la valeur de qs (clause tableau G.5.2.1(#)).") : rtf.NewLine()
        End If
        rtf.WriteEndGroup()
#End Region
        Call Tableaux_Rs_Penetro(rtf, , , ʃqs, Rs)

        'Détermination des valeurs de calcul de portance par la procédure du Modèle de Terrain
        Call Portance_Modele_de_Terrain(i_chap, 2, Rb, Rs, Rbk, Rsk, rtf)

        ' ---------------> Effet de groupe (éventuellement)
        If Pieux.EffetGroupe = True Then
            'dans le cadre de la procédure Modèle de Terrain, Rb et Rs sont égaux à Rbk et Rsk car les propriétés du terrain sont déjà des valeurs caractéristiques
            'calcul de l'incidence pour le pieu isolé
            Call Effet_de_Groupe(i_chap, Rbk, Rsk, rtf)
            'calcul pour l'ensemble des pieux
            Call Effet_de_Groupe_Bloc(i_chap, rtf, Def, qce)
        End If
        '
        '---------------> Evaluation des tassements
        If Pieux.Tassement = True Then Call Evaluation_tassement(i_chap, rtf)

        '---------------> Affichage des avertissements
        rtf.WriteStartGroup() : rtf.NewParagraph()
        rtf.FontSize = 12 : rtf.Bold = True : i_chap += 1
        rtf.Underline = True : rtf.WriteString(i_chap.ToString("#") & " - Avertissements") : rtf.Bold = False : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine() : rtf.NewLine()
        If Aff.msg_Avertiss.Count > 0 Then
            For i1 = 0 To Aff.msg_Avertiss.Count - 1
                rtf.WriteString(Aff.msg_Avertiss.Item(i1).ToString()) : rtf.NewLine()
            Next i1
        Else
            rtf.WriteString("Aucun avertissement.") : rtf.NewLine()
        End If
        rtf.WriteEndGroup()
    End Sub

    ''' <summary>Calcul de la portance d'un pieu par la procédure du Pieu Modèle et essais pénétrométriques statiques</summary>
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    ''' <param name="Verif">renvoie FALSE si erreur</param>
    Public Sub Calcul_Pieu_Portance_PieuModele_Penetrometrique(ByRef rtf As To_Rtf.RtfAnsiTextWriter, ByRef Verif As Boolean)

        Dim Rb(SondagesPressio.Count), Rs(SondagesPressio.Count), Defi(SondagesPressio.Count), qcei(SondagesPressio.Count), Rbk, Rsk As Double
        Dim ʃqs(SondagesPressio.Count) As Double
        Dim i As Integer
        Dim msg As String = String.Empty
        Dim Avertissement As Boolean = False
        Dim i_chap As Integer = 2


        With SondagePenetro
            'Calcul de la résistance de pointe Rb
#Region "entête Ecriture dans la note de calcul"
            rtf.WriteStartGroup()
            rtf.NewParagraph() : rtf.FontSize = 12 : rtf.NewLine() : rtf.Bold = True : rtf.Underline = True
            If SondagePenetro.Count = 1 Then
                rtf.WriteString(i_chap.ToString("#0") & " - Calcul de la résistance de pointe Rb pour le sondage unique")
            Else
                rtf.WriteString(i_chap.ToString("#0") & " - Calcul de la résistance de pointe Rb pour les " & .Count.ToString("#0") & " sondages")
            End If
            rtf.FontSize = 9 : rtf.Bold = False : rtf.Underline = False : rtf.NewLine() : rtf.NewLine()
            If Pieux.Categorie > 16 AndAlso Pieux.AucuneResistancedePointe = True Then
                'pas de calcul de résistance de pointe pour les micropieux, sauf dans le cas d'un effet de groupe ou ple doit être calculée
                rtf.WriteString("Valeur du facteur de portance Kc  = 0  -  Pas de calcul de résistance de pointe pour les micropieux") : rtf.NewLine()
                rtf.WriteString("Valeur de la résistance de pointe Rb : 0 MN  -  Aucune résistance de pointe pour les micropieux, uniquement une résistance par frottement (voir ci-dessous).") : rtf.NewLine()
            Else
                rtf.WriteString("Le calcul de la valeur de la résistance à la pénétration équivalente q") : rtf.Subscript = True : rtf.WriteString("ce") : rtf.Subscript = False : rtf.WriteString(" est réalisé suivant l'équation G.4.2.3 de l'annexe G de la NF P94-262 - 2013") : rtf.NewLine()
                rtf.WriteString("Fiche du pieu D : " & Pieux.D.ToString("#0.00") & " m (= longueur enterrée du pieu).") : rtf.NewLine()
                rtf.WriteString("Hauteur d'encastrement du pieu dans la couche porteuse : " & Pieux.Hencastr.ToString("#0.00") & " m.") : rtf.NewLine()
            End If
            rtf.WriteEndGroup()
#End Region
            For i = 0 To .Count - 1
                Dim a, b, Db, D3a, Intqcc, qce, Hd, Intqc, Def, DefB, KcMax, Kc As Double
                Dim CSnote1 As Boolean = True
                Dim CSHd As Boolean = True
                Call Pieu_Portance_EssaisPenetrometriques_PieuModele_Rb(i, Rb(i), rtf, Verif, a, b, Db, D3a, Intqcc, qce, CSnote1, Hd, Intqc, Def, DefB, CSHd, KcMax, Kc)
                Defi(i) = Def : qcei(i) = qce 'uniquement pour le calcul de l'effet de groupe
                Call Tableaux_Rb_Penetro(i + 1, Pieux.Hencastr, a, b, Db, D3a, Intqcc, qce, CSnote1, Hd, Intqc, Def, CSHd, DefB, KcMax, Kc, Kc * qce, Rb(i), rtf)
            Next

            'Calcul de la résistance de frottement axial Rs
#Region "entête Ecriture dans la note de calcul"      'Ecriture dans la note de calcul 
            rtf.WriteStartGroup() : rtf.NewParagraph() : i_chap += 1 : rtf.FontSize = 12 : rtf.Bold = True : rtf.Underline = True
            If SondagePenetro.Count = 1 Then
                rtf.WriteString(i_chap.ToString("#0") & " - Calcul de la résistance de frottement axial Rs pour le sondage unique")
            Else
                rtf.WriteString(i_chap.ToString("#0") & " - Calcul de la résistance de frottement axial Rs pour les " & .Count.ToString("#0") & " sondages")
            End If
            rtf.FontSize = 10 : rtf.Bold = False : rtf.NewLine() : rtf.NewLine()
            rtf.WriteString(i_chap.ToString("#0") & " - 1  Calcul de qs(z) pour toutes les valeurs mesurées de la résistance à la pénétration q") : rtf.Subscript = True : rtf.WriteString("c") : rtf.Subscript = False
            If SondagePenetro.Count = 1 Then
                rtf.WriteString(" sur le sondage unique")
            Else
                rtf.WriteString(" sur les " & .Count.ToString("#0.00") & " sondages.")
            End If
            rtf.FontSize = 9 : rtf.Underline = False : rtf.NewLine() : rtf.NewLine()
            rtf.WriteString("Les valeurs de α pieu_sol sont établies conformément au tableau G.5.2.1 de la NF P94-262.") : rtf.NewLine()
            rtf.WriteString("Les valeurs des coefficients a, b et c sont établies conformément au tableau G.5.2.2 de la NF P94-262.") : rtf.NewLine()
            rtf.WriteString("Les valeurs de qsMax sont établies conformément au tableau G.5.2.3 de la NF P94-262.") : rtf.NewLine()
            rtf.Bold = True : rtf.Underline = True
            rtf.WriteString("Rappel:") : rtf.Bold = False : rtf.Underline = False : rtf.NewLine()
            rtf.WriteString("    - si qs > qsMax alors La valeur de qs est limitée à qsmax.") : rtf.NewLine()
            rtf.WriteString("    - si qs < qsMax alors La valeur initiale de qs est conservée.") : rtf.NewLine()
            rtf.WriteEndGroup()
#End Region
            For i = 0 To .Count - 1
                rtf.WriteStartGroup() : rtf.FontSize = 12 : rtf.FontSize = 9 : rtf.Bold = True
                rtf.WriteString("Sondage n°" & (i + 1).ToString("#0") & " : ") : rtf.Bold = False : rtf.NewLine()
                rtf.WriteEndGroup()
                Call Pieu_Portance_EssaisPenetrometriques_PieuModele_Rs(i, ʃqs(i), Rs(i), rtf, Verif)
            Next
#Region "entête Ecriture dans la note de calcul avant tableau"      'Ecriture dans la note de calcul 
            rtf.WriteStartGroup() : rtf.NewParagraph() : rtf.FontSize = 10 : rtf.Underline = True
            rtf.WriteString(i_chap.ToString("#0") & " - 2  Calcul de l'intégration de qs(z) sur la longueur de fondation D")
            rtf.FontSize = 9 : rtf.Underline = False : rtf.NewLine() : rtf.NewLine()
            rtf.WriteString("Valeur de D, longueur de la fondation contenue dans le terrain, D = " & Pieux.D.ToString("#0.00") & " m.") : rtf.NewLine()
            rtf.WriteString("Valeur de Ps, périmètre du fût du pieu, Ps = " & Pieux.Ps.ToString("#0.000") & " ml.") : rtf.NewLine()
            If Pieux.D > 25 AndAlso (Pieux.Abreviation = "FS" OrElse Pieux.Abreviation = "FB" OrElse Pieux.Abreviation = "FSR" OrElse Pieux.Abreviation = "FBR" OrElse Pieux.Abreviation = "PU") Then
                If Pieux.AbattementGrandeLongueur = True Then
                    rtf.WriteString("Application d'un coefficient d'abattement de 50% sur les valeurs de frottements pour les premiers " & (Pieux.D - 25).ToString("#0.00") & " m du pieu suivant la clause G.5.2(6).") : rtf.NewLine()
                Else
                    'Insertion d'un avertissement dans la note de calcul
                    msg = "Application de la clause des pieux de grande longueur: Pieu de type " & Pieux.Abreviation.ToString & " et longueur du pieu excédant les 25 m, aucun coefficient d'abattement n'a été appliqué." : Aff.msg_Avertiss.Add(msg)
                End If
            End If
            'Application de la clause du vibrofonçage pour les pieux de type BAO, HB et PP
            If (Pieux.Abreviation = "BAO" OrElse Pieux.Abreviation = "HB" OrElse Pieux.Abreviation = "PP") AndAlso Pieux.Vibrofoncage = True Then
                rtf.WriteString("Application de la clause du vibrofonçage pour les pieux de type BAO, HB et PP: réduction de 30% de la valeur de qs") : rtf.NewLine()
            ElseIf (Pieux.Abreviation = "BAO" OrElse Pieux.Abreviation = "HB" OrElse Pieux.Abreviation = "PP") AndAlso Pieux.Vibrofoncage = False Then
                rtf.WriteString("Mise en oeuvre des pieux de type BAO, HB et PP par battage: aucune réduction de la valeur de qs (clause tableau G.5.2.1(#)).") : rtf.NewLine()
            End If
            rtf.WriteEndGroup()
#End Region
            Call Tableaux_Rs_Penetro(rtf, ʃqs, Rs)
        End With
        '
        '---------------> Calcul de la portance du pieu via la procédure statistique du Pieu Modèle
        Call Portance_Pieu_Modele(i_chap, 2, Rb, Rs, Rbk, Rsk, rtf)
        '
        '---------------> Effet de groupe (éventuellement)
        If Pieux.EffetGroupe = True Then
            'dans le cadre de la procédure Modèle de Terrain, Rb et Rs sont égaux à Rbk et Rsk car les propriétés du terrain sont déjà des valeurs caractéristiques
            'calcul de l'incidence pour le pieu isolé
            Call Effet_de_Groupe(i_chap, Rbk, Rsk, rtf)
            'calcul pour l'ensemble des pieux
            Call Effet_de_Groupe_Bloc(i_chap, rtf,,, Defi, qcei)
        End If
        '
        '---------------> Evaluation des tassements
        If Pieux.Tassement = True Then Call Evaluation_tassement(i_chap, rtf)
        '
        '---------------> Affichage des avertissements
        rtf.WriteStartGroup() : rtf.NewParagraph()
        rtf.FontSize = 12 : rtf.Bold = True : i_chap += 1
        rtf.Underline = True : rtf.WriteString(i_chap.ToString("#") & " - Avertissements") : rtf.Bold = False : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine() : rtf.NewLine()
        If Aff.msg_Avertiss.Count > 0 Then
            For i1 = 0 To Aff.msg_Avertiss.Count - 1
                rtf.WriteString(Aff.msg_Avertiss.Item(i1).ToString()) : rtf.NewLine()
            Next i1
        Else
            rtf.WriteString("Aucun avertissement.") : rtf.NewLine()
        End If
        rtf.WriteEndGroup()
    End Sub

    ''' <summary>Calcul de Rb suivant les essais pénétrométriques statiques pour la Procédure Pieu Modèle</summary>
    '''  <param name="i_Sond">n° du sondage des caractéristiques pénétrométriques et lithologiques, attention i_Sond =0 pour le 1ier sondage</param>
    ''' <param name="Rb">Résistance de pointe du pieu déterminé par les essais pénétrométriques</param>
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    ''' <param name="Verif">renvoie FALSE si erreur</param>
    ''' <param name="a">calcul du coefficients a pour la détermination de la résistance à la pression equivalente</param>
    ''' <param name="b">calcul du coefficient b pour la détermination de la résistance à la pression equivalente</param>
    ''' <param name="Db">limite haute de l'intégration pour le calcul de qce</param>
    ''' <param name="D3a">limite basse de l'intégration pour le calcul de qce</param>
    ''' <param name="qc_dz">Valeur de l'intégrale qcc(z)dz entre les bornes D-b et D+3a</param>
    ''' <param name="qce">Valeur de la résistance à la pénétration équivalente </param>
    ''' <param name="CSnote1">TRUE si couche porteuse est considérée comme homogène sinon FALSE</param>
    ''' <param name="hD">= Min(10 * Pieux.Bmin, Pieux.D) 'Condition du CEREMA</param>
    ''' <param name="qc_dzk">Valeur de l'intégrale qc(z)dz entre les bornes Pieux.D - hD et hD </param>
    ''' <param name="Def">Hauteur d'encastrement effective  (définition suivant annexe F §F.4.2(4) de la NF P94.262) = pl_dzk / Ple</param>
    ''' <param name="DefB">= rapport Def / Pieux.Bmin </param>
    ''' <param name="CSHd">test sur la hauteur d'encastrement effectif dans la couche porteuse: TRUE si OK sinon FALSE</param> 
    ''' <param name="kcMax">Calcul du facteur de portance Maximal Kc </param>
    ''' <param name="Kc">Calcul du facteur de portance Kc </param>
    Private Sub Pieu_Portance_EssaisPenetrometriques_PieuModele_Rb(ByVal i_Sond As Integer, ByRef Rb As Double, ByRef rtf As To_Rtf.RtfAnsiTextWriter, ByRef Verif As Boolean, ByRef a As Double,
                                                                ByRef b As Double, ByRef Db As Double, ByRef D3a As Double, ByRef qc_dz As Double, ByRef qce As Double, ByRef CSnote1 As Boolean, ByRef hD As Double, ByRef qc_dzk As Double,
                                                                ByRef Def As Double, ByRef DefB As Double, ByRef CSHd As Boolean, ByRef kcMax As Double, ByRef Kc As Double)
        Dim h, qc1_2, qc3_4, qcmin, qcMax, qci, qci1, qb, zinf1, zinf2 As Double ' 
        Dim ind1, ind3, j As Integer ' 
        Dim ind1_ind2, ind3_ind4 As Boolean
        Dim msg As String = String.Empty

        'calcul de la résistance de pointe Rb
        '-----------------------------------------------
        'calcul de qce résistance à la pénétration equivalente
        '-----------------------------------------------
        '--> calcul des coefficients a, b pour la détermination de la résistance à la pénétration equivalente
        a = Max(Pieux.Bmin / 2, 0.5)
        b = Min(a, Pieux.Hencastr) 'hencastrement = hauteur du pieu dans la formation porteuse
        '--> calcul de qce résistance à la pénétration equivalente
        zinf1 = Pieux.D - b : Db = zinf1
        zinf2 = Pieux.D + 3 * a : D3a = zinf2
        '--> détermination des indices pour le calcul de l'intégration
        ind1 = 0 : ind3 = 0 : ind1_ind2 = False : ind3_ind4 = False
        For j = SondagePenetro.Item(i_Sond).MesurePenetro.Count To 1 Step -1 'les indices augmentent avec la profondeur
            With SondagePenetro.Item(i_Sond).MesurePenetro.Item(j - 1)
                Select Case j
                    Case SondagePenetro.Item(i_Sond).MesurePenetro.Count 'cas du dernier tronçon
                        If zinf1 >= .Zh Then
                            'Zinf1 se trouve dans le dernier tronçon
                            ind1 = j - 1 : ind1_ind2 = True
                            'Zinf2 se trouve dans le dernier tronçon
                            ind3 = j - 1 : ind3_ind4 = True 'je sors de la boucle
                        Else
                            'au mieux, Zinf1 se trouve dans le tronçon précédent
                            If zinf2 >= .Zh Then
                                'Zinf2 se trouve dans le dernier tronçon
                                ind3 = j - 1 : ind3_ind4 = True
                            End If
                        End If
                    Case Is <= 2 'cas des 2 premiers tronçons
                        If ind3_ind4 = False Then
                            If zinf2 < .Zh Then
                                'toutes les valeurs sont dans le 1ier tronçon
                                ind3_ind4 = True : ind1_ind2 = True : ind3 = 0 : ind1 = 0
                            Else
                                'Zinf2 se trouve dans le 2ième tronçon
                                ind3 = 1 : ind3_ind4 = True
                                If zinf1 >= .Zh Then
                                    'Zinf1 se trouve dans le 2ième tronçon
                                    ind1 = 1 : ind1_ind2 = True
                                Else
                                    'Zinf1 se trouve dans le 1ier tronçon
                                    ind1 = 0 : ind1_ind2 = True
                                End If
                            End If
                        Else
                            'Zinf2 se trouve dans le 3ième tronçon
                            If zinf1 < .Zh Then
                                'Zinf1 se trouve dans le 1ier tronçon
                                ind1 = 0 : ind1_ind2 = True
                            Else
                                'Zinf1 se trouve dans le 2ième tronçon
                                ind1 = 1 : ind1_ind2 = True
                            End If
                        End If
                    Case Else 'cas des tronçons intermédiaires
                        If ind3_ind4 = False Then
                            'Zinf2 ne se trouve pas dans le tronçon inférieur
                            If zinf2 >= .Zh Then
                                'Zinf2 se trouve dans le tronçon j
                                ind3 = j - 1 : ind3_ind4 = True
                                If zinf1 >= .Zh Then ind1 = j - 1 : ind1_ind2 = True 'Zinf1 se trouve dans le tronçon j
                            End If
                        Else
                            'Zinf2 se trouve dans le tronçon inférieur
                            If zinf1 >= .Zh Then ind1 = j - 1 : ind1_ind2 = True 'Zinf1 se trouve dans le tronçon j
                        End If
                End Select
                If ind3_ind4 = True AndAlso ind1_ind2 = True Then Exit For
            End With
        Next
        '--> calcul de l'intégration sur les divers tronçons
        With SondagePenetro.Item(i_Sond).MesurePenetro
            '1ier tronçon = tronçon le plus haut
            qc1_2 = .Item(ind1).a * zinf1 + .Item(ind1).b
            qcmin = qc1_2 : qcMax = qc1_2
            'Calcul de qc_dz  
            If zinf2 <= .Item(ind1).Zb Then
                'Zinf1 et Zinf2 sur le même tronçon
                qc3_4 = .Item(ind3).a * zinf2 + .Item(ind3).b
                qc_dz = (zinf2 - zinf1) * (qc1_2 + qc3_4) / 2
                If qcmin > qc3_4 Then qcmin = qc3_4
                If qcMax < qc3_4 Then qcMax = qc3_4
            Else
                'Zinf1 et Zinf2 sur deux tronçons différents
                qci = .Item(ind1).a * .Item(ind1).Zb + .Item(ind1).b
                qc_dz = (.Item(ind1).Zb - zinf1) * (qc1_2 + qci) / 2 'valeur de qc_dz sur le 1ier tronçon
                If qcmin > qci Then qcmin = qci
                If qcMax < qci Then qcMax = qci
                'dernier tronçon = tronçon le plus bas
                qc3_4 = .Item(ind3).a * zinf2 + .Item(ind3).b
                If qcmin > qc3_4 Then qcmin = qc3_4
                If qcMax < qc3_4 Then qcMax = qc3_4
                qci = .Item(ind3).a * .Item(ind3).Zh + .Item(ind3).b
                qc_dz += (zinf2 - .Item(ind3).Zh) * (qc3_4 + qci) / 2 'valeur de qc_dz sur le dernier tronçon
                If qcmin > qci Then qcmin = qci
                If qcMax < qci Then qcMax = qci
                'pour les autres tronçons intermédiaires si ind1<>ind3-1
                For i = ind1 To ind3 - 1
                    qci = .Item(i).a * .Item(i).Zh + .Item(i).b : If qcmin > qci Then qcmin = qci : 
                    If qcMax < qci Then qcMax = qci
                    qci1 = .Item(i).a * .Item(i).Zb + .Item(i).b : If qcmin > qci1 Then qcmin = qci1 : 
                    If qcMax < qci1 Then qcMax = qci1
                    qc_dz += (.Item(i).Zb - .Item(i).Zh) * (qci + qci1) / 2
                Next
            End If

        End With

        qce = qc_dz / (b + 3 * a)
        If SondagePenetro.Item(i_Sond).Jupe = True Then qce = qce / 1.3
        '
        'calcul de l'encastrement effectif
        '-------------------------------- 
        hD = Min(10 * Pieux.Bmin, Pieux.D) 'Condition du CEREMA
        zinf1 = Pieux.D - hD : zinf2 = Pieux.D
        If zinf1 < 0 Then zinf1 = 0
        qc_dzk = 0
        With SondagePenetro.Item(i_Sond).MesurePenetro
            For j = 1 To SondagePenetro.Item(i_Sond).MesurePenetro.Count
                If zinf1 < .Item(j - 1).Zb Then
                    qc1_2 = .Item(j - 1).a * zinf1 + .Item(j - 1).b
                    If zinf2 < .Item(j - 1).Zb Then
                        'Zinf1 et Zinf2 dans le même tronçon
                        qc3_4 = .Item(j - 1).a * zinf2 + .Item(j - 1).b
                        qc_dzk = (zinf2 - zinf1) * (qc1_2 + qc3_4) / 2
                        Exit For
                    Else
                        'calcul de  qc_dzk sur le 1ier tronçon
                        qci = .Item(j - 1).a * .Item(j - 1).Zb + .Item(j - 1).b
                        qc_dzk = (.Item(j - 1).Zb - zinf1) * (qc1_2 + qci) / 2 'valeur de qc_dz sur le 1ier tronçon
                        'calcul de  qc_dzk sur les autres tronçons
                        j += 1
                        Do
                            If zinf2 < .Item(j - 1).Zb Then
                                qc3_4 = .Item(j - 1).a * zinf2 + .Item(j - 1).b
                                qci = .Item(j - 1).a * .Item(j - 1).Zh + .Item(j - 1).b
                                qc_dzk += (zinf2 - .Item(j - 1).Zh) * (qci + qc3_4) / 2
                                Exit For
                            Else
                                'calcul de  qc_dzk sur le tronçon intermédiaire
                                qci = .Item(j - 1).a * .Item(j - 1).Zh + .Item(j - 1).b
                                qci1 = .Item(j - 1).a * .Item(j - 1).Zb + .Item(j - 1).b
                                qc_dzk += (.Item(j - 1).Zb - .Item(j - 1).Zh) * (qci + qci1) / 2
                                j += 1
                            End If
                        Loop While j <= SondagePenetro.Item(i_Sond).MesurePenetro.Count
                    End If
                End If
            Next
        End With

        Def = qc_dzk / qce
        If SondagePenetro.Item(i_Sond).Jupe = True Then Def = qc_dzk / 1.3 / qce

        'Calcul de Kp et KpMax pour la détermination de qb puis Rb (résistance de pointe) Exception faite pour les micropieux
        If Pieux.Categorie > 16 AndAlso Pieux.AucuneResistancedePointe = True Then 'Clause de la prise en compte de la résistance de pointe pour les micropieux
            'pas de calcul de résistance de pointe pour les micropieux, sauf dans le cas d'un effet de groupe ou ple doit être calculée
            CSnote1 = True : CSHd = True : Rb = 0 : Kc = 0 : qb = 0 : DefB = Def / Pieux.Bmin : kcMax = 0
        Else
            '--> test sur l'homogénéité de la couche porteuse
            If qcMax < 2 * qcmin Then
                CSnote1 = True
            Else
                CSnote1 = False
                msg = "La couche porteuse est considérée comme non homogène car la résistance à la pénétration qc mesurée dans cette couche excède plus de deux fois la résistance à la pénétration minimale (Note 1 - §G4.2.(4) de la NF P94-262 - 2013)."
                Aff.msg_Avertiss.Add(msg)
            End If
            '--> test sur la hauteur d'encastrement effectif dans la couche porteuse
            If Pieux.Bmin > 0.5 Then
                If Def < 1.5 Then
                    CSHd = False
                    msg = "La profondeur d'encastrement du pieu dans la couche porteuse Def (= " & Def.ToString("#0.00") & " m) ne répond pas aux conditions de la note 1 de l'annexe G §G4.2.(6) de la NF P94-262 - 2013, " &
                   "- Soit 1,50m pour les pieux de diamètre supérieur à 0,50m." & Environment.NewLine
                    Aff.msg_Avertiss.Add(msg)
                Else
                    CSHd = True
                End If
            Else
                If Def < 3 * Pieux.Bmin Then
                    CSHd = False
                    msg = "La profondeur d'encastrement du pieu dans la couche porteuse Def (= " & Def.ToString("#0.00") & " m) ne répond pas aux conditions de la note 1 de l'annexe G §G4.2.(6) de la NF P94-262 - 2013, " &
                     "- Soit < à 3 diamètres pour les pieux de diamètre inférieur à 0,50m." & Environment.NewLine
                    Aff.msg_Avertiss.Add(msg)
                Else
                    CSHd = True
                End If
            End If
            'détermination de kpMax
            'détermination de l'index de la couche de sol correspondante
            With SondagePenetro.Item(i_Sond).Lithologie
                h = 0
                For j = 1 To .Count
                    h += .Item(j - 1).hcouche
                    If zinf2 < h Then
                        ' j - 1 = index de la 1ière valeur de Zinf en dessous de Zinf2
                        'détermination de kpmax
                        Call KcMax_Determination_Penetrometrique(.Item(j - 1).Categorie, kcMax)
                        Exit For
                    End If
                Next
            End With
            'détermination de kc
            DefB = Def / Pieux.Bmin
            If Def / Pieux.Bmin >= 5 Then
                Kc = kcMax
            Else
                Select Case SondagePenetro.Item(i_Sond).Lithologie.Item(j - 1).Categorie
                    Case 1 'Argile, Limon
                        Kc = 0.3 + (kcMax - 0.3) * DefB / 5
                    Case 2 'sol intermédiaire
                        Kc = 0.2 + (kcMax - 0.2) * DefB / 5
                    Case 3 'Sable Grave
                        Kc = 0.1 + (kcMax - 0.1) * DefB / 5
                    Case 4, 5, 6 'craie // Marne et Calcaire-marneux// Roche altérée ou fragmentée
                        Kc = 0.15 + (kcMax - 0.15) * DefB / 5
                End Select
            End If
            'Calcul de la résistance de pointe de la fondation profonde
            qb = Kc * qce
            Rb = Pieux.Ab * qb
        End If
    End Sub

    ''' <summary>Détermination de la valeur de Kcmax suivant tableau G.4.2.1 de la NF P94.262</summary>
    ''' <param name="Categorie">Catégorie conventionnelle de terrain suivant tableau B.2.1 de l'annexe B de la NF P94-262 pour la détermination de kcMax du tableau G.4.2.1 de l'annexe F de la NF P94-262</param>
    ''' <param name="kcMax">valeur de Kcmax facteur de portance pénétrométrique maximale suivant tableau G.4.2.1 de la NF P94.262</param>
    Private Sub KcMax_Determination_Penetrometrique(ByVal Categorie As Integer, ByRef kcMax As Double)
        Select Case Pieux.Classe
            Case 1
                Select Case Categorie
                    Case 1 'Argile, Limon
                        kcMax = 0.4
                    Case 2 'sol intermédiaire
                        kcMax = 0.3
                    Case 3 'Sable Grave
                        kcMax = 0.2
                    Case 4, 5, 6 'craie // Marne et Calcaire-marneux// Roche altérée ou fragmentée
                        kcMax = 0.3
                End Select
            Case 2
                Select Case Categorie
                    Case 1 'Argile, Limon
                        kcMax = 0.45
                    Case 2 'sol intermédiaire
                        kcMax = 0.3
                    Case 3 'Sable Grave
                        kcMax = 0.25
                    Case 4, 5, 6 'craie // Marne et Calcaire-marneux// Roche altérée ou fragmentée
                        kcMax = 0.3
                End Select
            Case 3
                Select Case Categorie
                    Case 1, 2, 3 'Argile, Limon // sol intermédiaire // Sable Grave
                        kcMax = 0.5
                    Case 4 'craie
                        kcMax = 0.4
                    Case 5, 6 '  Marne et Calcaire-marneux // Roche altérée ou fragmentée
                        kcMax = 0.35
                End Select
            Case 4
                Select Case Categorie
                    Case 1 'Argile, Limon
                        kcMax = 0.45
                    Case 2, 3, 4, 5, 6 'sol intermédiaire// Sable Grave // craie // Marne et Calcaire-marneux// Roche altérée ou fragmentée
                        kcMax = 0.4
                End Select
            Case 5
                Select Case Categorie
                    Case 1 'Argile, Limon
                        kcMax = 0.35
                    Case 2 'sol intermédiaire
                        kcMax = 0.3
                    Case 3 'Sable Grave
                        kcMax = 0.25
                    Case 4, 5, 6 'craie // Marne et Calcaire-marneux// Roche altérée ou fragmentée
                        kcMax = 0.15
                End Select
            Case 6
                Select Case Categorie
                    Case 1, 2, 3 'Argile, Limon // sol intermédiaire // Sable Grave
                        kcMax = 0.4
                    Case 4 'craie
                        kcMax = 0.35
                    Case 5, 6 '  Marne et Calcaire-marneux // Roche altérée ou fragmentée
                        kcMax = 0.2
                End Select
            Case 7
                Select Case Categorie
                    Case 1 'Argile, Limon
                        kcMax = 0.35
                    Case 2 'sol intermédiaire
                        kcMax = 0.3
                    Case 3, 4, 5, 6 'Sable Grave // craie // Marne et Calcaire-marneux// Roche altérée ou fragmentée
                        kcMax = 0.15
                End Select
            Case 8
                Select Case Categorie
                    Case 1 'Argile, Limon
                        kcMax = 0.45
                    Case 2 'sol intermédiaire
                        kcMax = 0.3
                    Case 3 'Sable Grave
                        kcMax = 0.2
                    Case 4, 5 'craie // Marne et Calcaire-marneux
                        kcMax = 0.3
                    Case 6 ' Roche altérée ou fragmentée
                        kcMax = 0.25
                End Select
        End Select
    End Sub

    ''' <summary>Tableau d'affichage des valeurs intermédiaires pour le calcul de Rb à partir des essais pénétrométriques statiques</summary>
    ''' <param name="i">n° du sondage</param>
    ''' <param name="He">longueur du pieu dans la couche porteuse</param>
    '''  <param name="Intqcc">valeur de l'intégrale de qcc pour la détermination de qce </param>
    '''  <param name="Hd">longueur sur laquelle l'intégration de qc pour le calcul de Def</param>
    ''' <param name="Intqc">valeur de l'intégrale de qc pour la détermination de Def</param>
    ''' <param name="D3a">borne de l'intégration pour le calcul de qce</param>
    ''' <param name="Db">borne de l'intégration pour le calcul de qce</param>
    ''' <param name="qce">résistance à la pénétration équivalente</param>
    ''' <param name="a">coefficient a pour la détermination de la résistance à la pénétration equivalente</param>
    ''' <param name="b">coefficient b pour la détermination de la résistance à la pénétration equivalente</param>
    ''' <param name="Def">hauteur d'encastrement effective</param>
    ''' <param name="DefB">égal au rapport Def/B</param>
    ''' <param name="Kc">facteur de portance pénétrométrique</param>
    ''' <param name="KcMax">facteur de portance pénétrométrique Maximal</param>
    ''' <param name="qb">valeur de rupture du terrain sous la base du pieu</param>
    ''' <param name="Rb">valeur de la résistance à la compressiondu terrain sous la base du pieu</param>
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    Private Sub Tableaux_Rb_Penetro(ByVal i As Integer, ByVal He As Double, ByVal a As Double, ByVal b As Double, ByVal Db As Double, ByVal D3a As Double, ByVal Intqcc As Double, ByVal qce As Double, ByVal CSnote1 As Boolean, ByVal Hd As Double,
                            ByVal Intqc As Double, ByVal Def As Double, ByVal CSHd As Boolean, ByVal DefB As Double, ByVal KcMax As Double, ByVal Kc As Double, ByVal qb As Double, ByVal Rb As Double, ByRef rtf As To_Rtf.RtfAnsiTextWriter)
        rtf.WriteStartGroup()
        rtf.FontSize = 12 : rtf.FontSize = 8
        Dim msg As String = String.Empty
        If i = 1 Then
            rtf.NewParagraph()
            'entête du tableau et ligne 1
            rtf.BeginRow() : rtf.DeclareCell(600) : rtf.BeginCell(True) : rtf.WriteString("Sond.") : rtf.EndCell()
            rtf.DeclareCell(600) : rtf.BeginCell(True) : rtf.WriteString("H encast. (m)") : rtf.EndCell()
            rtf.DeclareCell(600) : rtf.BeginCell(True) : rtf.WriteString("a (m)") : rtf.EndCell()
            rtf.DeclareCell(600) : rtf.BeginCell(True) : rtf.WriteString("b (m)") : rtf.EndCell()
            rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString("D-b (m)") : rtf.EndCell()
            rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString("D+3a (m)") : rtf.EndCell()
            rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString("qcc(z)dz (MPa.m)") : rtf.EndCell()
            rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString("qce (MPa)") : rtf.EndCell()
            rtf.DeclareCell(400) : rtf.BeginCell(True) : rtf.WriteString("< 2.plmin") : rtf.EndCell()
            rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString("Hd (m)") : rtf.EndCell()
            rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString("qc(z)dz (MPa.m)") : rtf.EndCell()
            rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString("Def (m)") : rtf.EndCell()
            If Pieux.Categorie <= 16 OrElse (Pieux.Categorie > 16 And Pieux.AucuneResistancedePointe = False) Then 'ne s'affiche que si résistance de pointe
                rtf.DeclareCell(400) : rtf.BeginCell(True) : rtf.WriteString("Test Hd ") : rtf.EndCell()
                rtf.DeclareCell(575) : rtf.BeginCell(True) : rtf.WriteString("Def/B") : rtf.EndCell()
                rtf.DeclareCell(550) : rtf.BeginCell(True) : rtf.WriteString("Kc Max") : rtf.EndCell()
                rtf.DeclareCell(550) : rtf.BeginCell(True) : rtf.WriteString("Kc") : rtf.EndCell()
                rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString("qb (MPa)") : rtf.EndCell()
                rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString("Rb (MN)") : rtf.EndCell()
            End If
            rtf.EndRow()
        End If
        rtf.BeginRow()
        rtf.DeclareCell(600) : rtf.BeginCell(True) : rtf.WriteString("P" & i.ToString("#0")) : rtf.EndCell()
        rtf.DeclareCell(600) : rtf.BeginCell(True) : rtf.WriteString(He.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(600) : rtf.BeginCell(True) : rtf.WriteString(a.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(600) : rtf.BeginCell(True) : rtf.WriteString(b.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString(Db.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString(D3a.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString(Intqcc.ToString("#0.000")) : rtf.EndCell()
        rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString(qce.ToString("#0.000")) : rtf.EndCell()
        If CSnote1 = False Then msg = "KO" Else msg = "OK"
        rtf.DeclareCell(400) : rtf.BeginCell(True) : rtf.WriteString(msg) : rtf.EndCell()
        rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString(Hd.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString(Intqc.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString(Def.ToString("#0.00")) : rtf.EndCell()
        If Pieux.Categorie <= 16 OrElse (Pieux.Categorie > 16 And Pieux.AucuneResistancedePointe = False) Then 'ne s'affiche que si résistance de pointe
            If CSHd = False Then msg = "KO" Else msg = "OK"
            rtf.DeclareCell(400) : rtf.BeginCell(True) : rtf.WriteString(msg) : rtf.EndCell()
            rtf.DeclareCell(575) : rtf.BeginCell(True) : rtf.WriteString(DefB.ToString("#0.00")) : rtf.EndCell()
            rtf.DeclareCell(550) : rtf.BeginCell(True) : rtf.WriteString(KcMax.ToString("#0.00")) : rtf.EndCell()
            rtf.DeclareCell(550) : rtf.BeginCell(True) : rtf.WriteString(Kc.ToString("#0.00")) : rtf.EndCell()
            rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString(qb.ToString("#0.000")) : rtf.EndCell()
            rtf.DeclareCell(650) : rtf.BeginCell(True) : rtf.WriteString(Rb.ToString("#0.000")) : rtf.EndCell()
        End If
        rtf.EndRow()
        rtf.WriteEndGroup()
        If i = SondagePenetro.Count Then
            rtf.WriteStartGroup() : rtf.NewParagraph() : rtf.FontSize = 12 : rtf.FontSize = 9
            rtf.WriteString("Avec les définitions suivantes:") : rtf.NewLine()
            rtf.WriteString("  - a = Max(Bmin/2; 0,50 m)") : rtf.NewLine()
            rtf.WriteString("  - b = Min(a, Hauteur d'encastrement du pieu dans la couche porteuse)") : rtf.NewLine()
            rtf.WriteString("  - D-b = Valeur limite haute de l'intégration pour le calcul de Pl*e") : rtf.NewLine()
            rtf.WriteString("  - D+3a = Valeur limite basse de l'intégration pour le calcul de Pl*e") : rtf.NewLine()
            rtf.WriteString("  - qcc(z)dz = Valeur de l'intégrale qcc(z)dz entre les bornes D-b et D+3a en MPa.m. Equation G.4.2.3") : rtf.NewLine()
            rtf.WriteString("  - qce = Valeur de la résistance à la pénétration équivalente en MPa.") : rtf.NewLine()
            rtf.WriteString("  - Homogénéité de la couche porteuse :") : rtf.NewLine()
            rtf.WriteString("      - La Note 1 - §G4.2.(4) de la NF P94-262 - 2013 impose de vérifier l'homogénéité de la couche porteuse ") : rtf.NewLine()
            rtf.WriteString("      - Si qcMax < 2 x qcmin - Condition satisfaite.") : rtf.NewLine()
            rtf.WriteString("      - Si qcMax > 2 x qcmin - Condition NON satisfaite.") : rtf.NewLine()
            rtf.WriteString("  - hD = Min(10 * Pieux.Bmin, Pieux.D) = Condition du CEREMA") : rtf.NewLine()
            rtf.WriteString("  - qc(z)dz = Valeur de l'intégrale qc(z)dz entre les bornes D-hD et D (= " & Pieux.D.ToString("#0.00") & " m); en MPa.m.") : rtf.NewLine()
            rtf.WriteString("  - Def = Hauteur d'encastrement effective  (définition suivant annexe G §G.4.2(4) de la NF P94.262) = qc(z)dz / qce")
            If Pieux.Categorie <= 16 OrElse (Pieux.Categorie > 16 And Pieux.AucuneResistancedePointe = False) Then 'ne s'affiche que si résistance de pointe
                rtf.WriteString("  - Vérification de la profondeur d'encastrement du pieu dans la couche porteuse :") : rtf.NewLine()
                rtf.WriteString("    La profondeur d'encastrement du pieu dans la couche porteuse Def doit répondre aux conditions de la note 1 de l'annexe G §G4.2.(6) de la NF P94-262 - 2013 ") : rtf.NewLine()
                rtf.WriteString("       - Soit 1,50m pour les pieux de diamètre supérieur à 0,50m.") : rtf.NewLine()
                rtf.WriteString("       - Soit < à 3 diamètres pour les pieux de diamètre inférieur à 0,50m.") : rtf.NewLine()
                rtf.WriteString("  - Kc Max facteur de portance pénétrométrique maximal ") : rtf.NewLine()
                rtf.WriteString("  - Def/B = Valeur du rapport Def/B") : rtf.NewLine()
                rtf.WriteString("      Avec Rapport Def/B ≥ 5 - Kc = kcMax ") : rtf.NewLine()
                rtf.WriteString("      Avec Rapport Def/B < 5 - Kc suivant conditions du §G4.2.(6) de la NF P94.262. ") : rtf.NewLine()
                rtf.WriteString("  - Kp facteur de portance") : rtf.NewLine()
                rtf.Underline = True
                rtf.WriteString(" Effort limite mobilisable dû au terme de pointe") : rtf.Underline = False : rtf.NewLine()
                rtf.WriteString("  - Valeur de la pression de rupture du terrain sous la base du pieu qb (= Kc * qce) en MPa.") : rtf.NewLine()
                rtf.WriteString("  - Valeur de la résistance de pointe Rb (= aire.qb) en MN ") : rtf.NewLine()
            End If
            rtf.WriteEndGroup()
        End If

    End Sub

    ''' <summary>Calcul de Rs suivant les essais pénétrométriques statiques pour la Procédure Pieu Modèle</summary>
    '''  <param name="i_Sond">n° du sondage des caractéristiques pénétrométriques et lithologiques, attention i_Sond =0 pour le 1ier sondage</param>
    ''' <param name="ʃqs">intégration de qs sur la longueur D du pieu</param>
    ''' <param name="Rs">Résistance de frottement du pieu déterminé par les essais pressiométriques</param>
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    ''' <param name="Verif">renvoie FALSE si erreur</param>
    Private Sub Pieu_Portance_EssaisPenetrometriques_PieuModele_Rs(ByVal i_Sond As Integer, ByRef ʃqs As Double, ByRef Rs As Double, ByRef rtf As To_Rtf.RtfAnsiTextWriter, ByRef Verif As Boolean)
        Dim i, j, j1 As Integer ' 
        Dim msg As String = String.Empty
        Dim a, b, c, qsD25, qsMax, qcb, qch, qsb(1), qsh(1), Zh(1), Zb(1), αpieu_sol As Double 'h,Zh_PieuxD,
        Dim entete As Boolean = True
        Dim i_couche As Boolean = True

        'calcul de qs(z) pour toutes les valeurs mesurées de qc
        j = 0 ': Zh_PieuxD = 0
        With SondagePenetro.Item(i_Sond)
            j1 = .MesurePenetro.Count
            For i = .Lithologie.Count - 1 To 0 Step -1 'calcul des qs en remontant le long du pieu
                'traitement du cas du remblai
                If .Lithologie.Item(i).Categorie = 0 Then Continue For 'Remblai = pas de calcul de qs
                'traitement du cas ou la couche lithologique se trouve en dessous de l'embase du pieu
                If Pieux.D < .Lithologie.Item(i).Ztoit Then Continue For
                i_couche = True 'nouvelle couche lithologique
                'calcul des constantes pour chaque couche lithologique
                Call αpieu_sol_Penetrometrique(.Lithologie.Item(i).Categorie, αpieu_sol)
                If αpieu_sol = 1000 Then
                    msg = "Calcul de qs(z) - Détermination du coefficient αpieu_sol:" : Aff.msg_Avertiss.Add(msg)
                    msg = "Couche de sol n°" & (i + 1).ToString("#0") & ": le coefficient αpieu_sol n'a pas pu être déterminé. Le coefficient a été pris égal à αpieu_sol = 1 pour la suite des calculs." : Aff.msg_Avertiss.Add(msg)
                    αpieu_sol = 1
                End If
                Call Coef_a_b_c_fsol_Penetro(.Lithologie.Item(i).Categorie, a, b, c)
                Call Val_maximale_FrottementAxialUnitaire_Penetro(.Lithologie.Item(i).Categorie, qsMax)
                Do
                    j1 -= 1 'index de la couche pénétrométrique
                    j += 1 'index de numérotation des valeurs qsb et qsh
                    ReDim Preserve qsb(j), qsh(j), Zh(j), Zb(j)
                    If Pieux.D < .MesurePenetro.Item(j1).Zb Then
                        qcb = .MesurePenetro.Item(j1).a * Pieux.D + .MesurePenetro.Item(j1).b
                        Zb(j) = Pieux.D
                    Else
                        qcb = .MesurePenetro.Item(j1).a * .MesurePenetro.Item(j1).Zb + .MesurePenetro.Item(j1).b
                        Zb(j) = .MesurePenetro.Item(j1).Zb
                    End If
                    If .Jupe = True Then qcb = qcb / 1.3 'prise en compte du pénétromètre comportant un cône avec jupe
                    If Pieux.D - 25 <= .MesurePenetro.Item(j1).Zb AndAlso Pieux.D - 25 > .MesurePenetro.Item(j1).Zh Then
                        qsD25 = .MesurePenetro.Item(j1).a * (Pieux.D - 25) + .MesurePenetro.Item(j1).b   'pour faire le calcul 1 fois
                        qsD25 = .MesurePenetro.Item(j1).a * qsD25 + .MesurePenetro.Item(j1).b
                        qsD25 = αpieu_sol * (a * qsD25 + b) * (1 - E ^ (-c * qsD25))
                        If qsMax = 1000 Then
                            qsD25 = 0
                        ElseIf qsD25 > qsMax Then
                            qsD25 = qsMax
                        End If
                        If .Jupe = True Then qsD25 = qsD25 / 1.3 'prise en compte du pénétromètre comportant un cône avec jupe
                    End If
                    qch = .MesurePenetro.Item(j1).a * .MesurePenetro.Item(j1).Zh + .MesurePenetro.Item(j1).b : Zh(j) = .MesurePenetro.Item(j1).Zh
                    If .Jupe = True Then qch = qch / 1.3 'prise en compte du pénétromètre comportant un cône avec jupe
                    qsb(j) = αpieu_sol * (a * qcb + b) * (1 - E ^ (-c * qcb))
                    qsh(j) = αpieu_sol * (a * qch + b) * (1 - E ^ (-c * qch))
                    If i_couche = True Then
                        Call Tableaux_qs_Penetro(entete, .MesurePenetro.Item(j1).Zh, .Lithologie.Item(i).Categorie, qch, αpieu_sol, a, b, c, qsh(j), qsMax, rtf, i + 1)
                    Else
                        Call Tableaux_qs_Penetro(entete, .MesurePenetro.Item(j1).Zh, .Lithologie.Item(i).Categorie, qch, αpieu_sol, a, b, c, qsh(j), qsMax, rtf)
                    End If
                    Call Tableaux_qs_Penetro(entete, Zb(j), .Lithologie.Item(i).Categorie, qcb, αpieu_sol, a, b, c, qsb(j), qsMax, rtf)
                    If qsMax = 1000 Then
                        qsb(j) = 0 : qsh(j) = 0
                    Else
                        qsMax = qsMax / 1000  'transformation de KPa en MPa
                        If qsb(j) > qsMax Then qsb(j) = qsMax
                        If qsh(j) > qsMax Then qsh(j) = qsMax
                    End If
                    If j1 - 1 = -1 Then Exit For 'toutes les couches pénétrométriques ont été passées en revue
                    i_couche = False 'pas de changement de couche lithologique dans la boucle do
                Loop While .MesurePenetro.Item(j1 - 1).Zh >= .Lithologie.Item(i).Ztoit
            Next
            'Ecriture du pb de détermination du coefficient αpieu_sol 
            If msg <> String.Empty Then
                rtf.WriteStartGroup() : rtf.NewParagraph() : rtf.FontSize = 12 : rtf.FontSize = 9
                rtf.WriteString("Voir § Avertissement: Problème de détermination de la valeur de αpieu_sol pour certaines couches de sol.") : rtf.NewLine()
                rtf.WriteEndGroup()
            End If
        End With

        'calcul de l'intégration de qs(z) sur la longueur de fondation D
        With SondagePenetro.Item(i_Sond).MesurePenetro
            'Application de la clause des pieux de grande longueur
            Dim abat As Double = 1
            If Pieux.D > 25 AndAlso (Pieux.Abreviation = "FS" OrElse Pieux.Abreviation = "FB" OrElse Pieux.Abreviation = "FSR" OrElse Pieux.Abreviation = "FBR" OrElse Pieux.Abreviation = "PU") Then
                If Pieux.AbattementGrandeLongueur = True Then
                    abat = 0.5
                Else
                    'Insertion d'un avertissement dans la note de calcul
                    msg = "Application de la clause des pieux de grande longueur: Pieu de type " & Pieux.Abreviation.ToString & " et longueur du pieu excédant les 25 m, aucun coefficient d'abattement n'a été appliqué." : Aff.msg_Avertiss.Add(msg)
                End If
            End If
            'le calcul se fait en remontant
            ʃqs = (Zb(1) - Zh(1)) * (qsb(1) + qsh(1)) / 2 'calcul de l'intégration sur le dernier tronçon
            For i = 2 To qsb.Length - 1
                If Zb(i) < Pieux.D - 25 Then
                    ʃqs += abat * (Zb(i) - Zh(i)) * (qsb(i) + qsh(i)) / 2 'le coefficient de réduction s'applique sur toute la couche
                Else
                    If Zh(i) > Pieux.D - 25 Then
                        ʃqs += (Zb(i) - Zh(i)) * (qsb(i) + qsh(i)) / 2 'toute la couche est au-delà des 25m, pas de coef de réduction
                    Else
                        ʃqs += (Zb(i) - (Pieux.D - 25)) * (qsb(i) + qsD25) / 2
                        ʃqs += abat * (Pieux.D - 25 - Zh(i)) * (qsh(i) + qsD25) / 2
                    End If
                End If
            Next
            Rs = Pieux.Ps * ʃqs
        End With

        'Application de la clause du vibrofonçage pour les pieux de type BAO, HB et PP
        If (Pieux.Abreviation = "BAO" OrElse Pieux.Abreviation = "HB" OrElse Pieux.Abreviation = "PP") AndAlso Pieux.Vibrofoncage = True Then
            Rs = 0.7 * Rs : ʃqs = 0.7 * ʃqs
        End If

    End Sub

    ''' <summary>Détermination de la valeur de αpieu_sol suivant le tableau G.5.2.1 de la NF P94.262</summary>
    ''' <param name="Categorie">Catégorie conventionnelle de terrain suivant tableau B.2.1 de l'annexe B de la NF P94-262 pour la détermination de αpieu_sol du tableau G.5.2.1 de l'annexe G de la NF P94-262</param>
    ''' <param name="αpieu_sol">coefficient αpieu_sol</param>
    Private Sub αpieu_sol_Penetrometrique(ByVal Categorie As Integer, ByRef αpieu_sol As Double)
        Dim Categorie_Pieux As Integer
        If Pieux.Categorie = 17 OrElse Pieux.Categorie = 18 Then Categorie_Pieux = Pieux.CategorieAssimil Else Categorie_Pieux = Pieux.Categorie
        αpieu_sol = 1000 'pour le cas ou αpieu_sol ne figure pas dans le tableau F.5.2.1
        Select Case Categorie_Pieux
            Case 1
                Select Case Categorie
                    Case 1 'Argile, Limon
                        αpieu_sol = 0.55
                    Case 2 'sol intermédiaire
                        αpieu_sol = 0.65
                    Case 3 'Sable Grave
                        αpieu_sol = 0.7
                    Case 4 'craie
                        αpieu_sol = 0.8
                    Case 5 ' Marne et Calcaire-marneux
                        αpieu_sol = 1.4
                    Case 6 ' Roche altérée ou fragmentée
                        αpieu_sol = 1.5
                End Select
            Case 2
                Select Case Categorie
                    Case 1 'Argile, Limon
                        αpieu_sol = 0.65
                    Case 2 'sol intermédiaire
                        αpieu_sol = 0.8
                    Case 3 'Sable Grave
                        αpieu_sol = 1
                    Case 4 'craie
                        αpieu_sol = 0.8
                    Case 5 ' Marne et Calcaire-marneux
                        αpieu_sol = 1.4
                    Case 6 ' Roche altérée ou fragmentée
                        αpieu_sol = 1.5
                End Select
            Case 3
                Select Case Categorie
                    Case 1 'Argile, Limon
                        αpieu_sol = 0.35
                    Case 2 'sol intermédiaire
                        αpieu_sol = 0.4
                    Case 3 'Sable Grave
                        αpieu_sol = 0.4
                    Case 4 'craie
                        αpieu_sol = 0.25
                    Case 5 ' Marne et Calcaire-marneux
                        αpieu_sol = 0.85
                End Select
            Case 4
                Select Case Categorie
                    Case 1 'Argile, Limon
                        αpieu_sol = 0.65
                    Case 2 'sol intermédiaire
                        αpieu_sol = 0.8
                    Case 3 'Sable Grave
                        αpieu_sol = 1
                    Case 4 'craie
                        αpieu_sol = 0.75
                    Case 5 ' Marne et Calcaire-marneux
                        αpieu_sol = 1.3
                End Select
            Case 5
                Select Case Categorie
                    Case 1 'Argile, Limon
                        αpieu_sol = 0.7
                    Case 2 'sol intermédiaire
                        αpieu_sol = 0.85
                End Select
            Case 6
                Select Case Categorie
                    Case 1 'Argile, Limon
                        αpieu_sol = 0.75
                    Case 2 'sol intermédiaire
                        αpieu_sol = 0.9
                    Case 3 'Sable Grave
                        αpieu_sol = 1.5
                    Case 4 'craie
                        αpieu_sol = 0.95
                    Case 5 ' Marne et Calcaire-marneux
                        αpieu_sol = 1.5
                    Case 6 ' Roche altérée ou fragmentée
                        αpieu_sol = 1.5
                End Select
            Case 7
                Select Case Categorie
                    Case 1 'Argile, Limon
                        αpieu_sol = 0.95
                    Case 2 'sol intermédiaire
                        αpieu_sol = 1.15
                    Case 3 'Sable Grave
                        αpieu_sol = 1.45
                    Case 4 'craie
                        αpieu_sol = 0.75
                    Case 5 ' Marne et Calcaire-marneux
                        αpieu_sol = 1.6
                End Select
            Case 8
                Select Case Categorie
                    Case 1 'Argile, Limon
                        αpieu_sol = 0.3
                    Case 2 'sol intermédiaire
                        αpieu_sol = 0.35
                    Case 3 'Sable Grave
                        αpieu_sol = 0.4
                    Case 4 'craie
                        αpieu_sol = 0.45
                    Case 5 ' Marne et Calcaire-marneux
                        αpieu_sol = 0.65
                End Select
            Case 9
                Select Case Categorie
                    Case 1 'Argile, Limon
                        αpieu_sol = 0.55
                    Case 2 'sol intermédiaire
                        αpieu_sol = 0.65
                    Case 3 'Sable Grave
                        αpieu_sol = 1
                    Case 4 'craie
                        αpieu_sol = 0.45
                    Case 5 ' Marne et Calcaire-marneux
                        αpieu_sol = 0.85
                End Select
            Case 10
                Select Case Categorie
                    Case 1 'Argile, Limon
                        αpieu_sol = 1
                    Case 2 'sol intermédiaire
                        αpieu_sol = 1.2
                    Case 3 'Sable Grave
                        αpieu_sol = 1.45
                    Case 4 'craie
                        αpieu_sol = 0.85
                    Case 5 ' Marne et Calcaire-marneux
                        αpieu_sol = 1.5
                End Select
            Case 11
                Select Case Categorie
                    Case 1 'Argile, Limon
                        αpieu_sol = 0.6
                    Case 2 'sol intermédiaire
                        αpieu_sol = 0.7
                    Case 3 'Sable Grave
                        αpieu_sol = 1
                    Case 4 'craie
                        αpieu_sol = 0.95
                    Case 5 ' Marne et Calcaire-marneux
                        αpieu_sol = 0.95
                End Select
            Case 12
                Select Case Categorie
                    Case 1 'Argile, Limon
                        αpieu_sol = 0.4
                    Case 2 'sol intermédiaire
                        αpieu_sol = 0.5
                    Case 3 'Sable Grave
                        αpieu_sol = 0.85
                    Case 4 'craie
                        αpieu_sol = 0.2
                    Case 5 ' Marne et Calcaire-marneux
                        αpieu_sol = 0.85
                End Select
            Case 13
                Select Case Categorie
                    Case 1 'Argile, Limon
                        αpieu_sol = 0.6
                    Case 2 'sol intermédiaire
                        αpieu_sol = 0.7
                    Case 3 'Sable Grave
                        αpieu_sol = 0.5
                    Case 4 'craie
                        αpieu_sol = 0.25
                    Case 5 ' Marne et Calcaire-marneux
                        αpieu_sol = 0.95
                    Case 6 ' Roche altérée ou fragmentée
                        αpieu_sol = 0.95
                End Select
            Case 14
                Select Case Categorie
                    Case 1 'Argile, Limon
                        αpieu_sol = 0.55
                    Case 2 'sol intermédiaire
                        αpieu_sol = 0.65
                    Case 3 'Sable Grave
                        αpieu_sol = 0.7
                    Case 4 'craie
                        αpieu_sol = 0.2
                    Case 5 ' Marne et Calcaire-marneux
                        αpieu_sol = 0.95
                    Case 6 ' Roche altérée ou fragmentée
                        αpieu_sol = 0.85
                End Select
            Case 15
                Select Case Categorie
                    Case 1 'Argile, Limon
                        αpieu_sol = 1.35
                    Case 2 'sol intermédiaire
                        αpieu_sol = 1.6
                    Case 3 'Sable Grave
                        αpieu_sol = 2
                    Case 4 'craie
                        αpieu_sol = 1.1
                    Case 5 ' Marne et Calcaire-marneux
                        αpieu_sol = 2.25
                    Case 6 ' Roche altérée ou fragmentée
                        αpieu_sol = 2.25
                End Select
            Case 16
                Select Case Categorie
                    Case 1 'Argile, Limon
                        αpieu_sol = 0.45
                    Case 2 'sol intermédiaire
                        αpieu_sol = 0.55
                    Case 3 'Sable Grave
                        αpieu_sol = 0.55
                    Case 4 'craie
                        αpieu_sol = 0.2
                    Case 5 ' Marne et Calcaire-marneux
                        αpieu_sol = 1.25
                    Case 6 ' Roche altérée ou fragmentée
                        αpieu_sol = 1.15
                End Select
            Case 19
                Select Case Categorie
                    Case 1 'Argile, Limon
                        αpieu_sol = 1.35
                    Case 2 'sol intermédiaire
                        αpieu_sol = 1.6
                    Case 3 'Sable Grave
                        αpieu_sol = 2
                    Case 4 'craie
                        αpieu_sol = 1.1
                    Case 5 ' Marne et Calcaire-marneux
                        αpieu_sol = 2.25
                    Case 6 ' Roche altérée ou fragmentée
                        αpieu_sol = 2.25
                End Select
            Case 20
                Select Case Categorie
                    Case 1 'Argile, Limon
                        αpieu_sol = 1.7
                    Case 2 'sol intermédiaire
                        αpieu_sol = 2.05
                    Case 3 'Sable Grave
                        αpieu_sol = 2.65
                    Case 4 'craie
                        αpieu_sol = 1.4
                    Case 5 ' Marne et Calcaire-marneux
                        αpieu_sol = 2.9
                    Case 6 ' Roche altérée ou fragmentée
                        αpieu_sol = 2.9
                End Select
        End Select
        If Categorie = 0 Then αpieu_sol = 0
    End Sub

    ''' <summary>Détermination des coefficients a, b, c suivant le tableau G.5.2.2 de la NF P94.262 pour la fonction fsol</summary>
    ''' <param name="Categorie">Catégorie conventionnelle de terrain suivant tableau B.2.1 de l'annexe B de la NF P94-262</param>
    ''' <param name="a">coefficient a de l'équation G.5.2.2</param>
    ''' <param name="b">coefficient b de l'équation G.5.2.2</param>
    ''' <param name="c">coefficient c de l'équation G.5.2.2</param>
    Private Sub Coef_a_b_c_fsol_Penetro(ByVal Categorie As Integer, ByRef a As Double, ByRef b As Double, ByRef c As Double)
        Select Case Categorie
            Case 0 'remblai - aucune valeur de frottement
                a = 0 : b = 0 : c = 0
            Case 1 'Argile, Limon
                a = 0.0018 : b = 0.1 : c = 0.4
            Case 2 'sol intermédiaire
                a = 0.0015 : b = 0.1 : c = 0.25
            Case 3 'Sable Grave
                a = 0.0012 : b = 0.1 : c = 0.15
            Case 4 'craie
                a = 0.0015 : b = 0.1 : c = 0.25
            Case 5 ' Marne et Calcaire-marneux
                a = 0.0015 : b = 0.1 : c = 0.25
            Case 6 ' Roche altérée ou fragmentée
                a = 0.0015 : b = 0.1 : c = 0.25
        End Select
    End Sub

    ''' <summary>Détermination du frottement axial unitaire Maximal qsMax suivant le tableau G.5.2.3 de la NF P94.262</summary>
    ''' <param name="Categorie">Catégorie conventionnelle de terrain suivant tableau B.2.1 de l'annexe B de la NF P94-262 pour la détermination de qsMax du tableau G.5.2.3 de l'annexe G de la NF P94-262</param>
    ''' <param name="qsMax">frottement axial unitaire Maximal - MPa</param>
    Private Sub Val_maximale_FrottementAxialUnitaire_Penetro(ByVal Categorie As Integer, ByRef qsMax As Double)
        qsMax = 1000
        If Categorie = 0 Then Exit Sub  'qsMax = 0 remblai = pas de frottement
        Select Case Pieux.Categorie
            Case 1, 2
                Select Case Categorie
                    Case 1 'Argile, Limon
                        qsMax = 90
                    Case 2 'sol intermédiaire
                        qsMax = 90
                    Case 3 'Sable Grave
                        qsMax = 90
                    Case 4 'craie
                        qsMax = 200
                    Case 5 ' Marne et Calcaire-marneux
                        qsMax = 170
                    Case 6 ' Roche altérée ou fragmentée
                        qsMax = 200
                End Select
            Case 3
                Select Case Categorie
                    Case 1 'Argile, Limon
                        qsMax = 50
                    Case 2 'sol intermédiaire
                        qsMax = 50
                    Case 3 'Sable Grave
                        qsMax = 50
                    Case 4 'craie
                        qsMax = 50
                    Case 5 ' Marne et Calcaire-marneux
                        qsMax = 90
                End Select
            Case 4
                Select Case Categorie
                    Case 1 'Argile, Limon
                        qsMax = 90
                    Case 2 'sol intermédiaire
                        qsMax = 90
                    Case 3 'Sable Grave
                        qsMax = 90
                    Case 4 'craie
                        qsMax = 170
                    Case 5 ' Marne et Calcaire-marneux
                        qsMax = 170
                End Select
            Case 5
                Select Case Categorie
                    Case 1, 2 'Argile, Limon // sol intermédiaire
                        qsMax = 90
                End Select
            Case 6
                Select Case Categorie
                    Case 1 'Argile, Limon
                        qsMax = 90
                    Case 2 'sol intermédiaire
                        qsMax = 90
                    Case 3 'Sable Grave
                        qsMax = 170
                    Case 4 'craie
                        qsMax = 200
                    Case 5 ' Marne et Calcaire-marneux
                        qsMax = 200
                    Case 6 ' Roche altérée ou fragmentée
                        qsMax = 200
                End Select
            Case 7
                Select Case Categorie
                    Case 1, 2  'Argile, Limon // sol intermédiaire  
                        qsMax = 130
                    Case 3 'Sable Grave
                        qsMax = 200
                    Case 4, 5 'craie // Marne et Calcaire-marneux
                        qsMax = 170
                End Select
            Case 8
                Select Case Categorie
                    Case 1, 2  'Argile, Limon // sol intermédiaire  
                        qsMax = 50
                    Case 3, 4, 5 'Sable Grave // craie // Marne et Calcaire-marneux
                        qsMax = 170
                End Select
            Case 9
                Select Case Categorie
                    Case 1, 2, 3  'Argile, Limon // sol intermédiaire // Sable Grave //  
                        qsMax = 130
                    Case 4, 5 'craie // Marne et Calcaire-marneux
                        qsMax = 90
                End Select
            Case 10
                Select Case Categorie
                    Case 1, 2   'Argile, Limon // sol intermédiaire //  
                        qsMax = 170
                    Case 3 'Sable Grave // 
                        qsMax = 260
                    Case 4, 5 'craie // Marne et Calcaire-marneux
                        qsMax = 200
                End Select
            Case 11
                Select Case Categorie
                    Case 1, 2   'Argile, Limon // sol intermédiaire //  
                        qsMax = 90
                    Case 3 'Sable Grave // 
                        qsMax = 130
                    Case 4 'craie  
                        qsMax = 260
                    Case 5 ' Marne et Calcaire-marneux
                        qsMax = 200
                End Select
            Case 12
                Select Case Categorie
                    Case 1, 2, 3  'Argile, Limon // sol intermédiaire // Sable Grave //  
                        qsMax = 90
                    Case 4 'craie  
                        qsMax = 50
                    Case 5 ' Marne et Calcaire-marneux
                        qsMax = 90
                End Select
            Case 13
                Select Case Categorie
                    Case 1, 2   'Argile, Limon // sol intermédiaire //  
                        qsMax = 90
                    Case 3, 4 'Sable Grave // craie //
                        qsMax = 50
                    Case 5, 6 ' Marne et Calcaire-marneux // Roche altérée ou fragmentée
                        qsMax = 90
                End Select
            Case 14
                Select Case Categorie
                    Case 1, 2   'Argile, Limon // sol intermédiaire //  
                        qsMax = 90
                    Case 3 'Sable Grave //
                        qsMax = 130
                    Case 4 ' craie //
                        qsMax = 50
                    Case 5, 6 ' Marne et Calcaire-marneux // Roche altérée ou fragmentée
                        qsMax = 90
                End Select
            Case 15
                Select Case Categorie
                    Case 1, 2   'Argile, Limon // sol intermédiaire //  
                        qsMax = 200
                    Case 3 'Sable Grave //
                        qsMax = 380
                    Case 4, 5, 6 ' craie // Marne et Calcaire-marneux // Roche altérée ou fragmentée
                        qsMax = 320
                End Select
            Case 16
                Select Case Categorie
                    Case 1, 2   'Argile, Limon // sol intermédiaire //  
                        qsMax = 90
                    Case 3, 4 'Sable Grave // craie //
                        qsMax = 50
                    Case 5, 6 ' Marne et Calcaire-marneux // Roche altérée ou fragmentée
                        qsMax = 90
                End Select
            Case 19
                Select Case Categorie
                    Case 1, 2   'Argile, Limon // sol intermédiaire //  
                        qsMax = 200
                    Case 3 'Sable Grave //
                        qsMax = 380
                    Case 4, 5, 6 ' craie // Marne et Calcaire-marneux // Roche altérée ou fragmentée
                        qsMax = 320
                End Select
            Case 20
                Select Case Categorie
                    Case 1, 2   'Argile, Limon // sol intermédiaire //  
                        qsMax = 200
                    Case 3, 4, 5  'Sable Grave // craie // Marne et Calcaire-marneux //
                        qsMax = 440
                    Case 6 ' Roche altérée ou fragmentée
                        qsMax = 500
                End Select
        End Select

    End Sub

    ''' <summary>Tableau d'affichage des valeurs intermédiaires pour le calcul du frottement unitaire suivant les essais pénétrométriques</summary>
    ''' <param name="entete">= TRUE pour l'affichage de l'entête du tableau</param>
    '''  <param name="z">profondeur du sondage</param>
    ''' <param name="CatSol">catégorie du sol</param>
    ''' <param name="qc">résistance à la pénétration à la profondeur z</param>
    ''' <param name="αpieu_sol">coefficient αpieu_sol suivant tableau F.5.2.1</param>
    ''' <param name="a">coefficient a pour la fonction f sol - tableau F.5.2.2</param>
    ''' <param name="b">coefficient b pour la fonction f sol - tableau F.5.2.2</param>
    ''' <param name="c">coefficient c pour la fonction f sol - tableau F.5.2.2</param>
    ''' <param name="qs">frottement unitaire initialement calculé et après vérification auprès de qsMax</param>
    ''' <param name="qsMax">frottement unitaire Maximal</param>
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    Private Sub Tableaux_qs_Penetro(ByRef entete As Boolean, ByVal z As Double, ByVal CatSol As Integer, ByVal qc As Double, ByVal αpieu_sol As Double, ByVal a As Double, ByVal b As Double, ByVal c As Double, ByVal qs As Double,
                            ByVal qsMax As Double, ByRef rtf As To_Rtf.RtfAnsiTextWriter, Optional ByVal i_couche As Integer = 0)
        rtf.WriteStartGroup()
        rtf.FontSize = 12 : rtf.FontSize = 8
        Dim msg As String = String.Empty
        If entete = True Then
            rtf.NewParagraph()
            'entête du tableau et ligne 1
            rtf.BeginRow() : rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("Z (m)") : rtf.EndCell() : rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("Catégorie sol") : rtf.EndCell()
            rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("qc (MPa)") : rtf.EndCell()
            rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("αpieu_sol") : rtf.EndCell()
            rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("a") : rtf.EndCell() : rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("b") : rtf.EndCell()
            rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("c") : rtf.EndCell()
            rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("qs initial (MPa)") : rtf.EndCell() : rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("qsmax (MPa)") : rtf.EndCell()
            rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString("qs retenue (MPa)") : rtf.EndCell()
            rtf.EndRow()
            entete = False
        End If
        If i_couche > 0 Then
            'indication du n° de couche
            rtf.BeginRow() : rtf.DeclareCell(7000) : rtf.BeginCell(True) : rtf.WriteString("Couche n°" & i_couche.ToString("#0")) : rtf.EndCell() : rtf.EndRow()
        End If
        rtf.BeginRow()
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(z.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(CatSol.ToString("#0")) : rtf.EndCell()
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(qc.ToString("#0.000")) : rtf.EndCell()
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(αpieu_sol.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(a.ToString("#0.0000")) : rtf.EndCell()
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(b.ToString("#0.0")) : rtf.EndCell()
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(c.ToString("#0.00")) : rtf.EndCell()
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(qs.ToString("#0.000")) : rtf.EndCell()
        If qsMax = 1000 Then msg = "S.O" Else msg = qsMax.ToString("#0.000")
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(msg) : rtf.EndCell()
        If qs > qsMax Then qs = qsMax
        rtf.DeclareCell(700) : rtf.BeginCell(True) : rtf.WriteString(qs.ToString("#0.000")) : rtf.EndCell()
        rtf.EndRow()

        rtf.WriteEndGroup()
    End Sub

    ''' <summary>Tableau d'affichage des valeurs intermédiaires pour le calcul du frottement unitaire suivant les essais pénétrométriques</summary>
    ''' <param name="ʃqs"> intégration de qs pour le sondage pénétro n°i</param>
    '''  <param name="Rs">valeur de la résistance par frottement pour le sondage pénétro n°i</param>
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    Private Sub Tableaux_Rs_Penetro(ByRef rtf As To_Rtf.RtfAnsiTextWriter, Optional ByVal ʃqs() As Double = Nothing, Optional ByVal Rs() As Double = Nothing, Optional ByVal ʃqsi As Double = 0, Optional ByVal Rsi As Double = 0)
        rtf.WriteStartGroup()
        rtf.FontSize = 12 : rtf.FontSize = 8
        Dim msg As String = String.Empty

        rtf.NewParagraph()
        'entête du tableau et ligne 1
        rtf.BeginRow() : rtf.DeclareCell(800) : rtf.BeginCell(True) : rtf.WriteString("Sondages") : rtf.EndCell()
        rtf.DeclareCell(800) : rtf.BeginCell(True) : rtf.WriteString("ʃqs (MN/m)") : rtf.EndCell()
        rtf.DeclareCell(800) : rtf.BeginCell(True) : rtf.WriteString("Rs (MN)") : rtf.EndCell()
        rtf.EndRow()
        Select Case Aff.ModeleCalcul
            Case 4 'Penetro + Modèle de terrain
                rtf.BeginRow()
                rtf.DeclareCell(800) : rtf.BeginCell(True) : rtf.WriteString("P1") : rtf.EndCell()
                rtf.DeclareCell(800) : rtf.BeginCell(True) : rtf.WriteString(ʃqsi.ToString("#0.000")) : rtf.EndCell()
                rtf.DeclareCell(800) : rtf.BeginCell(True) : rtf.WriteString(Rsi.ToString("#0.000")) : rtf.EndCell()
                rtf.EndRow()
            Case 5 'Penetro + Pieu Modèle
                For i = 0 To SondagePenetro.Count - 1
                    rtf.BeginRow()
                    rtf.DeclareCell(800) : rtf.BeginCell(True) : rtf.WriteString("P" & (i + 1).ToString("#0")) : rtf.EndCell()
                    rtf.DeclareCell(800) : rtf.BeginCell(True) : rtf.WriteString(ʃqs(i).ToString("#0.000")) : rtf.EndCell()
                    rtf.DeclareCell(800) : rtf.BeginCell(True) : rtf.WriteString(Rs(i).ToString("#0.000")) : rtf.EndCell()
                    rtf.EndRow()
                Next
        End Select


        rtf.WriteEndGroup()
        rtf.WriteStartGroup() : rtf.NewParagraph() : rtf.FontSize = 12 : rtf.FontSize = 9
        rtf.WriteString("Avec les définitions suivantes:") : rtf.NewLine()
        rtf.WriteString("  - ʃqs = Valeur de l'intégration ʃqs déterminée sur les tronçons, de 0 m à D (= " & Pieux.D.ToString("#0.00") & " m), en MN/m.") : rtf.NewLine()
        rtf.WriteString("  - Rs = Valeur de la résistance de frottement axial du pieu suivant équation G.5.1.") : rtf.NewLine()
        rtf.WriteEndGroup()
    End Sub

    ''' <summary>Determination du coefficient de modèle γrd1 - Essais pénétrométriques</summary>
    ''' <param name=" γrd1">valeur du coefficient de modèle γrd1</param> 
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    Private Sub Determination_γrd1_Penetro(ByRef γrd1 As Double, ByRef rtf As To_Rtf.RtfAnsiTextWriter)
        'Ecriture dans la note de calcul 
        rtf.WriteStartGroup()
        rtf.FontSize = 12 : rtf.FontSize = 9
        Select Case Pieux.Categorie
            Case 1 To 9, 11 To 14, 16
                Select Case Pieux.AncragePenetro
                    Case 4 'pieux ancrés dans la craie
                        γrd1 = 1.45
                        rtf.WriteString(" ► γrd1 : Pieux de catégorie " & Pieux.Categorie.ToString("#0") & " et ancrage dans la craie - γrd1 = " & γrd1.ToString("#0.00")) : rtf.NewLine()
                    Case Else 'pieux NON ancrés dans la craie
                        γrd1 = 1.18
                        rtf.WriteString(" ► γrd1 : Pieux de catégorie " & Pieux.Categorie.ToString("#0") & " et ancrés dans un sol autre que la craie - γrd1 = " & γrd1.ToString("#0.00")) : rtf.NewLine()
                End Select
            Case 10, 15, 17, 18, 19, 20
                Dim msg1 As String = String.Empty
                Select Case Pieux.AncragePenetro
                    Case 2, 3, 6 'sol intermédiaire // Sable - Graves // Roches
                        msg1 = "roches"
                        If Pieux.AncragePenetro = 2 Then msg1 = "sols intermédiaires" : If Pieux.AncragePenetro = 3 Then msg1 = "Sable - Grave"
                        γrd1 = 1.45
                    Case 1, 4, 5 'argile, craie, marnes
                        msg1 = "marnes"
                        If Pieux.AncragePenetro = 1 Then msg1 = "argiles" : If Pieux.AncragePenetro = 4 Then msg1 = "craies"
                        γrd1 = 2
                End Select
                rtf.WriteString(" ► γrd1 : Pieux de catégorie " & Pieux.Categorie.ToString("#0") & " ancré  dans les " & msg1.ToString & " - γrd1 = " & γrd1.ToString("#0.00")) : rtf.NewLine()
        End Select
        rtf.WriteEndGroup()
    End Sub
#End Region

    ''' <summary>Calcul de la portance d'un pieu par la procédure Modèle de terrain - essais pressiométriques ou pénétrométriques</summary>
    ''' <param name="i_chap">n° de tête de chapitre pour le chapitrage de la note de calcul</param>
    ''' <param name="Type_Essai">= 1 si essai Pressiométrique // = 2 si essai Pénétrométrique</param>
    ''' <param name="Rb">Résistance de pointe, en MPa</param>
    ''' <param name="Rs">Résistance de frottement le long du pieu, en MPa</param>
    ''' <param name="Rbk">Résistance de pointe caractéristique, en MPa</param>
    ''' <param name="Rsk">Résistance de frottement le long du pieu caractéristique, en MPa</param>
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    Private Sub Portance_Modele_de_Terrain(ByRef i_chap As Integer, ByVal Type_Essai As Integer, ByVal Rb As Double, ByVal Rs As Double, ByRef Rbk As Double, ByRef Rsk As Double, ByRef rtf As To_Rtf.RtfAnsiTextWriter)
        Dim γrd1, γrd2, γb, γs, γcrCar, γcrQP As Double
        Dim Rcd, Rccrk, RcCar, RcQP As Double
        Dim msg As String = String.Empty

        '--> Détermination des coefficients de modèle γrd1 et γrd2  
        i_chap += 1
        rtf.WriteStartGroup() 'Ecriture dans la note de calcul
        rtf.FontSize = 12 : rtf.FontSize = 9 : rtf.NewLine() : rtf.FontSize = 12 : rtf.Bold = True : rtf.Underline = True
        rtf.WriteString(i_chap.ToString("#0") & " - Détermination des coefficients de modèle γrd1 et γrd2") : rtf.FontSize = 9 : rtf.Bold = False : rtf.Underline = False : rtf.NewLine() : rtf.NewLine()
        rtf.WriteString("Les coefficients de modèle γrd1 et γrd2 sont établis suivant le tableau F.2.1 de l'annexe F de la NF P94-262.") : rtf.NewLine()
        rtf.WriteEndGroup()
        Select Case Type_Essai
            Case 1 'Pressio
                Call Determination_γrd1_Pressio(γrd1, rtf)
            Case 2 'Pénétro
                Call Determination_γrd1_Penetro(γrd1, rtf)
            Case Else 'erreur - sortie du programme
                msg = "Erreur logicielle - la variable type_essai n'a pas été définie à 1 ou 2 - Type_Essai = " & Type_Essai.ToString("#")
                MessageBox.Show(msg, "Private Sub Portance_Mode_de_Terrain", MessageBoxButtons.OK, MessageBoxIcon.Error)
                Exit Sub
        End Select
        rtf.WriteStartGroup() 'Ecriture dans la note de calcul
        rtf.FontSize = 12 : rtf.FontSize = 9
        γrd2 = 1.1
        rtf.WriteString(" ► γrd2 = " & γrd2.ToString("#0.00")) : rtf.NewLine()
        rtf.WriteString(" ► valeur du produit γrd1.γrd2 = " & (γrd1 * γrd2).ToString("#0.000")) : rtf.NewLine()
        '
        '-- valeurs des Résistances caractéristiques
        i_chap += 1 : rtf.NewLine() : rtf.FontSize = 12 : rtf.Bold = True : rtf.Underline = True
        rtf.WriteString(i_chap.ToString("#0") & "  - Valeurs  caractéristiques de résistance de pointe Rbk et de résistance de frottement axial Rsk pour pieu isolé") : rtf.Bold = False : rtf.Underline = False : rtf.NewLine()
        rtf.FontSize = 9 : rtf.NewLine()
        Rbk = Rb / (γrd1 * γrd2)
        Rsk = Rs / (γrd1 * γrd2)
        rtf.WriteString("      → Rbk = " & Rbk.ToString("#0.000") & " MN (valeur caractéristique de la résistance de pointe = Rb / (γrd1.γrd2) )") : rtf.NewLine()
        rtf.WriteString("      → Rsk = " & Rsk.ToString("#0.000") & " MN (valeur caractéristique de résistance de frottement axial = Rs / (γrd1.γrd2) )") : rtf.NewLine()
        '
        '-- Résistances de calcul à l'ELU
        i_chap += 1 : rtf.NewLine() : rtf.FontSize = 12 : rtf.Bold = True : rtf.Underline = True
        rtf.WriteString(i_chap.ToString("#0") & "  - Dimensionnement de la capacité portante pour un pieu") : rtf.Bold = False : rtf.Underline = False : rtf.NewLine()
        rtf.FontSize = 9 : rtf.NewLine()
        rtf.FontSize = 10 : rtf.Underline = True : rtf.WriteString(i_chap.ToString("#0") & "  - 1 Charge et résistance de calcul à l'ELU GEO") : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine() : rtf.NewLine()
        rtf.WriteString("Les valeurs de portance limite se décomposent de la manière suivante: ") : rtf.NewLine()
        rtf.WriteString("   ► ELU - Situation durable ou transitoire :") : rtf.NewLine()
        rtf.WriteString("      → Coefficient partiel pour la résistance de pointe γb = 1.1") : rtf.NewLine()
        rtf.WriteString("      → Coefficient partiel pour la résistance de frottement axial pour un pieu en compression γs = 1.1") : rtf.NewLine()
        γb = 1.1 : γs = 1.1
        Rcd = Rbk / γb + Rsk / γs 'calcul de la portance limite à l'ELU
        rtf.WriteString("      → Résistance de calcul de la portance du terrain Rcd = ") : rtf.Bold = True : rtf.Underline = True : rtf.WriteString(Rcd.ToString("#0.000")) : rtf.Bold = False : rtf.Underline = False : rtf.WriteString(" MN.") : rtf.NewLine()
        rtf.WriteString("   ► ELU - Situation accidentelle :") : rtf.NewLine()
        rtf.WriteString("      → Coefficient partiel pour la résistance de pointe γb = 1.0") : rtf.NewLine()
        rtf.WriteString("      → Coefficient partiel pour la résistance de frottement axial pour un pieu en compression γs = 1.0") : rtf.NewLine()
        γb = 1 : γs = 1
        Rcd = Rbk / γb + Rsk / γs 'calcul de la portance limite à l'ELU
        rtf.WriteString("      → Résistance de calcul de la portance du terrain Rcd = ") : rtf.Bold = True : rtf.Underline = True : rtf.WriteString(Rcd.ToString("#0.000")) : rtf.Bold = False : rtf.Underline = False : rtf.WriteString(" MN.") : rtf.NewLine()
        rtf.WriteString("   ► ELU - Sismique :") : rtf.NewLine()
        rtf.WriteString("      → Coefficient partiel γt = 1.1 (art. 1.(11)) soit γb = γs = 1.1") : rtf.NewLine()
        γb = 1.1 : γs = 1.1
        Rcd = Rbk / γb + Rsk / γs 'calcul de la portance limite à l'ELU
        rtf.WriteString("      → Résistance de calcul de la portance du terrain Rcd = ") : rtf.Bold = True : rtf.Underline = True : rtf.WriteString(Rcd.ToString("#0.000")) : rtf.Bold = False : rtf.Underline = False : rtf.WriteString(" MN.") : rtf.NewLine()
        '
        '-- Résistances de calcul à l'ELS
        rtf.FontSize = 9 : rtf.NewLine()
        rtf.FontSize = 10 : rtf.Underline = True : rtf.WriteString(i_chap.ToString("#0") & "  - 3 Charge et résistance de calcul à l'ELS GEO") : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine() : rtf.NewLine()
        rtf.WriteString("La valeur de calcul Fd transmise à l'ELS par le pieu au terrain doit rester inférieure à Rccrd, valeur de calcul de la charge de calcul de fluage à la compression, avec : ") : rtf.NewLine()
        rtf.WriteString("  - ELS Caractéristique: Rccrd = Rccrk/γcrCar  avec") : rtf.NewLine()
        rtf.WriteString("      →  Rccrk: valeur caractéristique de la résistance de fluage à la compression") : rtf.NewLine()
        rtf.WriteString("      →  γcrCar: Facteur partiel à l'ELS caractéristique.") : rtf.NewLine()
        rtf.WriteString("  - ELS Quasi-Permanent: Rccrd = Rccrk/γcrQP    avec") : rtf.NewLine()
        rtf.WriteString("      →  Rccrk: valeur caractéristique de la résistance de fluage à la compression") : rtf.NewLine()
        rtf.WriteString("      →  γcrQP: Facteur partiel à l'ELS Quasi-Permanent.") : rtf.NewLine()
        rtf.WriteString("► calcul de Rccrk :") : rtf.NewLine()
        rtf.WriteString("      → Rbk = " & Rbk.ToString("#0.000") & " MN (valeur caractéristique de la résistance de pointe)") : rtf.NewLine()
        rtf.WriteString("      → Rsk = " & Rsk.ToString("#0.000") & " MN (valeur caractéristique de frottement axial)") : rtf.NewLine()
        Select Case Pieux.Classe
            Case 1, 2, 8 'pieux sans refoulement du sol
                Rccrk = 0.5 * Rbk + 0.7 * Rsk 'pieux sans refoulement du sol
                rtf.WriteString("      → pieux sans refoulement du sol: valeur de Rccrk suivant équation 14.2.2.1 à partir des valeurs Rbk et Rsk.") : rtf.NewLine()
            Case 3, 4, 5, 6, 7 'pieux avec refoulement du sol
                Rccrk = 0.7 * Rbk + 0.7 * Rsk 'pieux avec refoulement du sol
                rtf.WriteString("      → pieux avec refoulement du sol: valeur de Rccrk suivant équation 14.2.2.3 à partir des valeurs Rbk et Rsk.") : rtf.NewLine()
        End Select
        γcrCar = 0.9 : γcrQP = 1.1
        RcCar = Rccrk / γcrCar 'ELS Caractéristique (ou rare)
        RcQP = Rccrk / γcrQP 'ELS Quasi-Permanent
        rtf.WriteString("      → Rccrk = " & Rccrk.ToString("#0.000") & " MN.") : rtf.NewLine()
        rtf.WriteString("► ELS Caractéristique :") : rtf.NewLine()
        rtf.WriteString("      → Facteur partiel de résistance γcrCar = 0.9") : rtf.NewLine()
        rtf.WriteString("      → Résistance de calcul de fluage à la compression du terrain Rccrd = ") : rtf.Bold = True : rtf.Underline = True : rtf.WriteString(RcCar.ToString("#0.000")) : rtf.Bold = False : rtf.Underline = False : rtf.WriteString(" MN (= Rccrk/γcrCar).") : rtf.NewLine()
        rtf.WriteString("► ELS Quasi-Permanent :") : rtf.NewLine()
        rtf.WriteString("      → Facteur partiel de résistance γcrQP = 1.1") : rtf.NewLine()
        rtf.WriteString("      → Résistance de calcul de fluage à la compression du terrain Rccrd = ") : rtf.Bold = True : rtf.Underline = True : rtf.WriteString(RcQP.ToString("#0.000")) : rtf.Bold = False : rtf.Underline = False : rtf.WriteString(" MN (= Rccrk/γcrQP).") : rtf.NewLine()
        rtf.NewLine()

        rtf.WriteEndGroup()
    End Sub

    ''' <summary>Calcul de la portance d'un pieu par la procédure Pieu Modèle - essais pressiométriques ou pénétrométriques</summary>
    ''' <param name="i_chap">n° de tête de chapitre pour le chapitrage de la note de calcul</param>
    ''' <param name="Type_Essai">= 1 si essai Pressiométrique // = 2 si essai Pénétrométrique</param>
    ''' <param name="Rb">Résistance de pointe, en MPa</param>
    ''' <param name="Rbk">Résistance de pointe caractéristique, en MPa</param>
    ''' <param name="Rs">Résistance de frottement le long du pieu, en MPa</param>
    ''' <param name="Rsk">Résistance de frottement caractéristique le long du pieu, en MPa</param> 
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    Private Sub Portance_Pieu_Modele(ByRef i_chap As Integer, ByVal Type_Essai As Integer, ByVal Rb() As Double, ByVal Rs() As Double, ByRef Rbk As Double, ByRef Rsk As Double, ByRef rtf As To_Rtf.RtfAnsiTextWriter)
        Dim Avertissement As Boolean
        Dim msg As String = String.Empty
        Dim Rcmin, RcTot, Rsmin, Rstot, Rbtot, Rcmoy, Rsmoy, Rbmoy, S, Rcd, Rck, Rccrk, RcCar, RcQP As Double
        Dim ξ3, ξi3, ξ4, ξi4, γrd1, γt, γcrCar, γcrQP As Double
        Dim RcImin, RsImin, Sref As Integer
        Dim Ntotal As Integer 'nombre total d'essai que ce soit en essais pressiométriques ou pénétrométriques
        Select Case Type_Essai
            Case 1 'pressiométrique - Pieu Modèle
                Ntotal = SondagesPressio.Count
            Case 2 'Pénétrométrique - Pieu Modèle
                Ntotal = SondagePenetro.Count
        End Select

        '--> Détermination des valeurs moyennes de Portance
        Rcmin = 1000000 : RcTot = 0 : Rsmin = 1000000 : Rstot = 0 : Rbtot = 0
        For i = 0 To Ntotal - 1 '.count = Ntotal
            If Rcmin > Rb(i) + Rs(i) Then Rcmin = Rb(i) + Rs(i) : RcImin = i
            RcTot += Rb(i) + Rs(i)
            If Rsmin > Rs(i) Then Rsmin = Rs(i) : RsImin = i
            Rstot += Rs(i)
            Rbtot += Rb(i)
        Next
        Rcmoy = RcTot / (Ntotal) : Rsmoy = Rstot / (Ntotal) : Rbmoy = Rbtot / (Ntotal)

        'Ecriture dans la note de calcul 
        i_chap += 1
        rtf.WriteStartGroup() : rtf.FontSize = 12 : rtf.FontSize = 9 : rtf.NewLine() : rtf.FontSize = 12 : rtf.Bold = True : rtf.Underline = True
        rtf.WriteString(i_chap.ToString("#0") & " - Détermination des valeurs moyennes de Portance ") : rtf.Bold = False : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine() : rtf.NewLine()
        rtf.WriteString("   - Rbmoy = " & Rbmoy.ToString("#0.000") & " MN - résistance de pointe (Rbmoy)") : rtf.NewLine()
        rtf.WriteString("   - Rsmoy = " & Rsmoy.ToString("#0.000") & " MN - résistance par frottement (Rsmoy)") : rtf.NewLine()
        rtf.WriteString("   - Rcmoy = " & Rcmoy.ToString("#0.000") & " MN - résistance combinée (Rcmoy)") : rtf.NewLine() : rtf.NewLine()

        '_______________________
        'Détermination de ξ3,ξ4
        i_chap += 1
        rtf.FontSize = 12 : rtf.Bold = True : rtf.Underline = True
        rtf.WriteString(i_chap.ToString("#0") & " - Détermination des facteurs de corrélation ξ3 et ξ4") : rtf.Underline = False : rtf.FontSize = 9 : rtf.Bold = False : rtf.NewLine() : rtf.NewLine()

        Dim ξii3() As Double = {1.4, 1.35, 1.33, 1.31, 1.29, 1.27, 1.25}
        Dim ξii4() As Double = {1.4, 1.27, 1.23, 1.2, 1.15, 1.12, 1.08}
        Select Case Ntotal'.Count
            Case 1 To 5
                ξi3 = ξii3(Ntotal - 1) : ξi4 = ξii4(Ntotal - 1)
            Case 6
                ξi3 = ξii3(5) : ξi4 = ξii4(5)'par mesure conservatoire comme indiquée dans le guide du CEREMA
            Case 7 To 9
                ξi3 = ξii3(5) : ξi4 = ξii4(5) 'par mesure conservatoire comme indiquée dans le guide du CEREMA
            Case Else
                ξi3 = ξii3(6) : ξi4 = ξii4(5)
        End Select
        Sref = 2500 'suivant E.2(2)
        rtf.WriteString("Les facteurs de corrélation ξ3 et ξ4 sont déterminés suivant l'équation E(2.1) de l'annexe E de la NF P94-262.") : rtf.NewLine()
        Avertissement = False
        With Aff
            If .SurfInvestGeotechLongueur / .SurfInvestGeotechLargeur > 2 Then
                msg = "Facteurs de corrélation ξ3 et ξ4: le rapport Longueur/largeur de la zone d'investigation géotechnique est supérieure à 2. La largeur est insuffisante (= " & .SurfInvestGeotechLargeur.ToString("#0.00") &
                    " m) et a été modifiée pour correspondre à la moitié de la longueur "
                Aff.msg_Avertiss.Add(msg)
                .SurfInvestGeotechLargeur = .SurfInvestGeotechLongueur / 2
                Avertissement = True
            End If
            S = .SurfInvestGeotechLongueur * .SurfInvestGeotechLargeur
            If S < 100 Then
                msg = "Facteurs de corrélation ξ3 et ξ4: la surface de la zone d'investigation géotechnique est inférieure à 100 m² (= " & S.ToString("#0.00") & " m²) et a été modifiée pour être portée à 100 m²."
                Aff.msg_Avertiss.Add(msg)
                S = 100
                Avertissement = True
            End If
        End With

        ξ3 = 1 + (ξi3 - 1) * (S / Sref) ^ 0.5
        ξ4 = 1 + (ξi4 - 1) * (S / Sref) ^ 0.5
        '-- écriture de la note de calcul de ξ3,ξ4
        Select Case Type_Essai
            Case 1 'pressiométrique - Pieu Modèle
                rtf.WriteString("N = " & Ntotal.ToString("#0") & " - Nombre de sondages pressiométriques") : rtf.NewLine()
            Case 2 'pénétrométrique - Pieu Modèle
                rtf.WriteString("N = " & Ntotal.ToString("#0") & " - Nombre de sondages pénétrométriques") : rtf.NewLine()
        End Select
        rtf.WriteString("Sref = " & Sref.ToString("#0") & " m² - surface de référence") : rtf.NewLine()
        rtf.WriteString("S = " & S.ToString("#0") & " m² - surface de la zone d'investigation géotechnique")
        If Avertissement = True Then rtf.WriteString(" (surface corrigée: voir § Avertissement en fin de note de calcul).")
        rtf.NewLine()
        rtf.WriteString(" ► ξ3 :") : rtf.NewLine()
        rtf.WriteString("ξ'3 (N) = " & ξi3.ToString("#0.000") & " Suivant tableaux C2.4.1 et C2.4.2") : rtf.NewLine()
        rtf.WriteString("ξ3 = " & ξ3.ToString("#0.000") & " Facteur de corrélation ξ3 ") : rtf.NewLine()
        rtf.WriteString(" ► ξ4 :") : rtf.NewLine()
        rtf.WriteString("ξ'4 (N) = " & ξi4.ToString("#0.000") & " Détermination des facteurs de corrélation ξ3 et ξ4 suivant article E2 de l'annexe E de la NF P94-262") : rtf.NewLine()
        rtf.WriteString("ξ4 = " & ξ4.ToString("#0.000") & " Facteur de corrélation ξ4 ") : rtf.NewLine() : rtf.NewLine()


        ' --> détermination de γrd1
        i_chap += 1
        rtf.FontSize = 12 : rtf.Bold = True : rtf.Underline = True
        rtf.WriteString(i_chap.ToString("#0") & " - Détermination du coefficient de modèle γrd1 ") : rtf.Underline = False : rtf.Bold = False : rtf.FontSize = 9 : rtf.NewLine() : rtf.NewLine()
        Select Case Type_Essai
            Case 1 'pressiométrique - Pieu Modèle
                rtf.WriteString("Le coefficient γrd1 est déterminé suivant le tableau F.2.1 de l'annexe F de la NF P94-262") : rtf.NewLine() : rtf.NewLine()
            Case 2 'pénétrométrique - Pieu Modèle
                rtf.WriteString("Le coefficient γrd1 est déterminé suivant le tableau G.2.1 de l'annexe G de la NF P94-262") : rtf.NewLine() : rtf.NewLine()
        End Select
        rtf.WriteEndGroup()
        Select Case Type_Essai
            Case 1 'pressiométrique - Pieu Modèle
                Call Determination_γrd1_Pressio(γrd1, rtf)
            Case 2 'pénétrométrique - Pieu Modèle
                Call Determination_γrd1_Penetro(γrd1, rtf)
        End Select
        ' --> Détermination de la valeur de la portance caractéristique combinée Rck
        i_chap += 1
        rtf.WriteStartGroup()
        rtf.FontSize = 12 : rtf.FontSize = 9 : rtf.NewLine() : rtf.FontSize = 12 : rtf.Bold = True : rtf.Underline = True
        rtf.WriteString(i_chap.ToString("#0") & " - Détermination de la valeur de la portance caractéristique combinée Rck") : rtf.Underline = False : rtf.Bold = False : rtf.FontSize = 9 : rtf.NewLine() : rtf.NewLine()
        rtf.WriteString(" La valeur de la portance caractéristique combinée Rck = Rbk + Rsk (valeur caractéristique de portance + valeur caractéristique de résistance par frottement).") : rtf.NewLine()
        rtf.WriteString(" Cette dernière est déterminée à partir de l'équation (9.2.3.1) avec :") : rtf.NewLine()
        rtf.WriteString("   - Rcmoy = " & Rcmoy.ToString("#0.000") & " MN.") : rtf.NewLine()
        rtf.WriteString("   - Rcmin = " & Rcmin.ToString("#0.000") & " MN.") : rtf.NewLine()
        Rck = Min(Rcmoy / ξ3, Rcmin / ξ4)
        rtf.WriteString("Soit une valeur Min(Rcmoy / ξ3, Rcmin / ξ4) = " & Rck.ToString("#0.000") & " MN.") : rtf.NewLine()
        Rck = Rck / γrd1
        Rbk = (Rbmoy / Rcmoy) * Rck : Rsk = (Rsmoy / Rcmoy) * Rck '--> Nécessaire au calcul à l'ELS et pour le calcul du bloc en effet de groupe si ce dernier a été demandé
        rtf.WriteString("Pour une valeur Rck = ") : rtf.Bold = True : rtf.Underline = True : rtf.WriteString(Rck.ToString("#0.000")) : rtf.Bold = False : rtf.Underline = False
        rtf.WriteString(" MN   (= Min(Rcmoy/ξ3, Rcmin/ξ4) / γrd1 =  Min(" & (Rcmoy / ξ3).ToString("#0.000") & ", " & (Rcmin / ξ4).ToString("#0.000") & ")/" & γrd1.ToString("#0.00") & ")") : rtf.NewLine()
        '
        ' --> Valeurs de calcul ELU
        '
        i_chap += 1 : rtf.NewLine() : rtf.FontSize = 12 : rtf.Bold = True : rtf.Underline = True
        rtf.WriteString(i_chap.ToString("#0") & "  - Valeurs de portance limite pour un pieu en compression") : rtf.Bold = False : rtf.Underline = False : rtf.NewLine()
        rtf.FontSize = 9 : rtf.NewLine()
        rtf.FontSize = 10 : rtf.Underline = True : rtf.WriteString(i_chap.ToString("#0") & "  - 1 Charge et résistance de calcul à l'ELU GEO") : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine()
        γt = 1.1
        Rcd = Rck / γt 'calcul de la portance limite à l'ELU - Situation durable ou transitoire
        rtf.WriteString("   ► ELU - Situation durable ou transitoire :") : rtf.NewLine()
        rtf.WriteString("      → Facteur partiel total/combiné γt = 1.1") : rtf.NewLine()
        rtf.WriteString("      → Résistance de calcul de la portance du terrain Rcd = " & Rcd.ToString("#0.000") & " MN.") : rtf.NewLine()
        γt = 1
        Rcd = Rck / γt 'calcul de la portance limite à l'ELU - Situation accidentelle
        rtf.WriteString("   ► ELU - Situation accidentelle :") : rtf.NewLine()
        rtf.WriteString("      → Facteur partiel total/combiné γt = 1.0") : rtf.NewLine()
        rtf.WriteString("      → Résistance de calcul de la portance du terrain Rcd = " & Rcd.ToString("#0.000") & " MN.") : rtf.NewLine()
        rtf.WriteString("   ► ELU - Sismique :") : rtf.NewLine()
        rtf.WriteString("      → Coefficient partiel γt = 1.1 (art. 1.(11))") : rtf.NewLine()
        γt = 1.1
        Rcd = Rck / γt 'calcul de la portance limite à l'ELU - Situation sismique
        rtf.WriteString("      → Résistance de calcul de la portance du terrain Rcd = " & Rcd.ToString("#0.000") & " MN.") : rtf.NewLine()
        '
        '-- Résistances de calcul à l'ELS
        '  
        rtf.FontSize = 9 : rtf.NewLine()
        rtf.FontSize = 10 : rtf.Underline = True : rtf.WriteString(i_chap.ToString("#0") & "  - 2 Charge et résistance de calcul à l'ELS") : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine()
        rtf.WriteString("La valeur de calcul Fd transmise à l'ELS par le pieu au terrain doit rester inférieure à Rccrd, valeur de calcul de la charge de calcul de fluage à la compression, avec : ") : rtf.NewLine()
        Select Case Pieux.Classe
            Case 1, 2, 8 'pieux sans refoulement du sol
                Rccrk = 0.5 * Rbk + 0.7 * Rsk 'calcul de la résistance de fluage en compression
                rtf.WriteString("      → pieux sans refoulement du sol: valeur de Rccrk suivant équation 14.2.2.1 ce qui impose de calculer Rbk et Rsk") : rtf.NewLine()
                rtf.WriteString("      → Rbk = " & Rbk.ToString("#0.000") & " MN (valeur caractéristique de la résistance de pointe)") : rtf.NewLine()
                rtf.WriteString("      → Rsk = " & Rsk.ToString("#0.000") & " MN (valeur caractéristique de frottement axial)") : rtf.NewLine()
            Case 3, 4, 5, 6, 7 'pieux avec refoulement du sol
                Rccrk = 0.7 * Rck   'calcul de la résistance de fluage en compression
                rtf.WriteString("      → pieux avec refoulement du sol: valeur de Rccrk suivant équation 14.2.2.3, ce qui permet de calculer directement depuis la valeur Rck.") : rtf.NewLine()
        End Select

        γcrCar = 0.9 : γcrQP = 1.1
        RcCar = Rccrk / γcrCar 'ELS Caractéristique (ou rare)
        RcQP = Rccrk / γcrQP 'ELS Quasi-Permanent
        rtf.WriteString("      → Rccrk = " & Rccrk.ToString("#0.000") & " MN.") : rtf.NewLine()
        rtf.WriteString("   ► ELS Caractéristique :") : rtf.NewLine()
        rtf.WriteString("      → Facteur partiel de résistance γcrCar = 0.9") : rtf.NewLine()
        rtf.WriteString("      → Résistance de calcul de fluage à la compression du terrain Rccrd = " & RcCar.ToString("#0.000") & " MN (= Rccrk/γcrCar).") : rtf.NewLine()
        rtf.WriteString("   ► ELS Quasi-Permanent :") : rtf.NewLine()
        rtf.WriteString("      → Facteur partiel de résistance γcrQP = 1.1") : rtf.NewLine()
        rtf.WriteString("      → Résistance de calcul de fluage à la compression du terrain Rccrd = " & RcQP.ToString("#0.000") & " MN (= Rccrk/γcrQP).") : rtf.NewLine()
        rtf.WriteEndGroup()
    End Sub

#Region "Effet de groupe"
    ''' <summary>Calcul de l'effet de groupe suivant l'annexe J</summary>
    ''' <param name="i_chap">n° de tête de chapitre</param>
    ''' <param name="Rbk">Résistance de pointe caractéristique, en MPa</param>
    ''' <param name="Rsk">Résistance de frottement caractéristique, en MPa</param>
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    Private Sub Effet_de_Groupe(ByRef i_chap As Integer, ByVal Rbk As Double, ByVal Rsk As Double, ByRef rtf As To_Rtf.RtfAnsiTextWriter)
        Dim γb, γs, γcrCar, γcrQP As Double
        Dim Cdx, Cdy, Ce, Cex, Cey, Rbd, Rsd, Rgd, RcgCar, RcgQP As Double
        Dim Npieux As Integer
        i_chap += 1
        rtf.WriteStartGroup() 'Ecriture dans la note de calcul
        rtf.FontSize = 12 : rtf.FontSize = 9 : rtf.FontSize = 12 : rtf.Bold = True : rtf.Underline = True
        rtf.WriteString(i_chap.ToString("#0") & " - Effet de groupe") : rtf.FontSize = 9 : rtf.Bold = False : rtf.NewLine() : rtf.NewLine()
        rtf.FontSize = 10 : rtf.WriteString(i_chap.ToString("#0") & "  - 1  Effet de groupe lié au rapprochement des pieux") : rtf.FontSize = 9 : rtf.NewLine() : rtf.NewLine()
        rtf.WriteString(i_chap.ToString("#0") & "  - 1-1 Détermination du coefficient d'efficacité Ce") : rtf.Underline = False : rtf.NewLine() : rtf.NewLine()
        With Pieux
            If .ef_Gr_my = 0 Then
                'une seule ligne de pieux
                Npieux = .ef_Gr_nx
                rtf.WriteString("La fondation comporte une seule ligne de pieux avec un nombre total de pieux égal à " & Npieux.ToString("#")) : rtf.NewLine() : rtf.NewLine()
                Cdx = 1 - ((1 / 4) * (1 + (.ef_Gr_dx / .Bmin)))
                Ce = 1 - Cdx * (2 - (1 / .ef_Gr_mx + 1 / .ef_Gr_nx))
                rtf.WriteString("Coefficient d'efficacité : Ce = " & Ce.ToString("#0.0") & " (Cd = " & Cdx.ToString("#0.000") & ")") : rtf.NewLine()
            Else
                'plusieurs lignes de pieux
                Npieux = .ef_Gr_nx * .ef_Gr_mx
                rtf.WriteString("La fondation comporte plusieurs ligne de pieux avec un nombre total de pieux égal à " & Npieux.ToString("#")) : rtf.NewLine() : rtf.NewLine()
                Cdx = 1 - ((1 / 4) * (1 + (.ef_Gr_dx / .Bmin)))
                Cex = 1 - Cdx * (2 - ((1 / .ef_Gr_mx) + (1 / .ef_Gr_nx)))
                Cdy = 1 - ((1 / 4) * (1 + (.ef_Gr_dy / .Bmin)))
                Cey = 1 - Cdy * (2 - ((1 / .ef_Gr_my) + (1 / .ef_Gr_ny)))
                If Cex > Cey Then Ce = Cey Else Ce = Cex
                rtf.Underline = True : rtf.WriteString("Coefficient d'efficacité :") : rtf.Underline = False : rtf.NewLine()
                rtf.WriteString("  - Coefficient d'efficacité suivant X: Cex = " & Cex.ToString("#0.000") & " (Cd = " & Cdx.ToString("#0.000") & ")") : rtf.NewLine()
                rtf.WriteString("  - Coefficient d'efficacité suivant Y: Cey = " & Cex.ToString("#0.000") & " (Cd = " & Cdy.ToString("#0.000") & ")") : rtf.NewLine()
                rtf.WriteString("  - Coefficient d'efficacité retenu: Ce = " & Ce.ToString("#0.000")) : rtf.NewLine()
            End If
            rtf.NewLine()
            rtf.Underline = True : rtf.WriteString(i_chap.ToString("#0") & "  - 1-2 Charge et résistance de calcul à l'ELU GEO pour la résistance globale Rgd") : rtf.Underline = False : rtf.NewLine() : rtf.NewLine()
            rtf.WriteString("Les valeurs de portance limite se décomposent de la manière suivante: ") : rtf.NewLine()
            rtf.WriteString("   ► ELU - Valeurs communes :") : rtf.NewLine()
            rtf.WriteString("      → Rbk = " & Rbk.ToString("#0.000") & " MN (valeur caractéristique de la résistance de pointe)") : rtf.NewLine()
            rtf.WriteString("      → Rsk = " & Rsk.ToString("#0.000") & " MN (valeur caractéristique de frottement axial)") : rtf.NewLine()
            rtf.WriteString("   ► ELU - Situation durable ou transitoire :") : rtf.NewLine()
            rtf.WriteString("      → Coefficient partiel pour la résistance de pointe γb = 1.1") : rtf.NewLine()
            rtf.WriteString("      → Coefficient partiel pour la résistance de frottement axial pour un pieu en compression γs = 1.1") : rtf.NewLine()
            γb = 1.1 : γs = 1.1
            Rbd = Rbk / γb : Rsd = Rsk / γs 'calcul de la portance limite à l'ELU
            Rgd = Npieux * (Rbd + Ce * Rsd)
            rtf.WriteString("      → Résistance globale de calcul de la portance du terrain Rgd = ") : rtf.Bold = True : rtf.Underline = True : rtf.WriteString(Rgd.ToString("#0.000")) : rtf.Bold = False : rtf.Underline = False : rtf.WriteString(" MN.") : rtf.NewLine()
            rtf.WriteString("   ► ELU - Situation accidentelle :") : rtf.NewLine()
            rtf.WriteString("      → Coefficient partiel pour la résistance de pointe γb = 1.0") : rtf.NewLine()
            rtf.WriteString("      → Coefficient partiel pour la résistance de frottement axial pour un pieu en compression γs = 1.0") : rtf.NewLine()
            γb = 1 : γs = 1
            Rbd = Rbk / γb : Rsd = Rsk / γs 'calcul de la portance limite à l'ELU
            Rgd = Npieux * (Rbd + Ce * Rsd)
            rtf.WriteString("      → Résistance globale de calcul de la portance du terrain Rgd = ") : rtf.Bold = True : rtf.Underline = True : rtf.WriteString(Rgd.ToString("#0.000")) : rtf.Bold = False : rtf.Underline = False : rtf.WriteString(" MN.") : rtf.NewLine()
            rtf.WriteString("   ► ELU - Sismique :") : rtf.NewLine()
            rtf.WriteString("      → Coefficient partiel γt = 1.1 (art. 1.(11)) soit γb = γs = 1.1") : rtf.NewLine()
            γb = 1.1 : γs = 1.1
            Rbd = Rbk / γb : Rsd = Rsk / γs 'calcul de la portance limite à l'ELU
            Rgd = Npieux * (Rbd + Ce * Rsd)
            rtf.WriteString("      → Résistance globale de calcul de la portance du terrain Rgd = ") : rtf.Bold = True : rtf.Underline = True : rtf.WriteString(Rgd.ToString("#0.000")) : rtf.Bold = False : rtf.Underline = False : rtf.WriteString(" MN.") : rtf.NewLine()
            '
            '-- Résistances de calcul à l'ELS
            rtf.NewLine()
            rtf.Underline = True : rtf.WriteString(i_chap.ToString("#0") & "  - 1-3 Charge et résistance de calcul à l'ELS GEO") : rtf.Underline = False : rtf.NewLine() : rtf.NewLine()
            rtf.WriteString("La valeur de calcul globale Fgd transmise à l'ELS par les pieux au terrain doit rester inférieure à Rgcrd, valeur de calcul de la charge de calcul de fluage à la compression, avec : ") : rtf.NewLine()
            rtf.WriteString("   ► ELS - Valeurs communes :") : rtf.NewLine()
            rtf.WriteString("      → Rbk = " & Rbk.ToString("#0.000") & " MN (valeur caractéristique de la résistance de pointe)") : rtf.NewLine()
            rtf.WriteString("      → Rsk = " & Rsk.ToString("#0.000") & " MN (valeur caractéristique de frottement axial)") : rtf.NewLine()
            Select Case Pieux.Classe
                Case 1, 2, 8 'pieux sans refoulement du sol
                    Rgd = 0.5 * Rbk + Ce * 0.7 * Rsk 'pieux sans refoulement du sol
                    rtf.WriteString("      → pieux sans refoulement du sol: valeur de Rccrk suivant équation 14.2.2.1 à partir des valeurs Rbk et Rsk.") : rtf.NewLine()
                Case 3, 4, 5, 6, 7 'pieux avec refoulement du sol
                    Rgd = 0.7 * Rbk + Ce * 0.7 * Rsk 'pieux avec refoulement du sol
                    rtf.WriteString("      → pieux avec refoulement du sol: valeur de Rccrk suivant équation 14.2.2.3 à partir des valeurs Rbk et Rsk.") : rtf.NewLine()
            End Select
            γcrCar = 0.9 : γcrQP = 1.1
            RcgCar = Npieux * Rgd / γcrCar 'ELS Caractéristique (ou rare)
            RcgQP = Npieux * Rgd / γcrQP 'ELS Quasi-Permanent
            rtf.WriteString("► ELS Caractéristique :") : rtf.NewLine()
            rtf.WriteString("      → Facteur partiel de résistance γcrCar = 0.9") : rtf.NewLine()
            rtf.WriteString("      → Résistance de calcul de fluage à la compression du terrain Rcgcrd = ") : rtf.Bold = True : rtf.Underline = True : rtf.WriteString(RcgCar.ToString("#0.000")) : rtf.Bold = False : rtf.Underline = False : rtf.WriteString(" MN (= Rccrk/γcrCar).") : rtf.NewLine()
            rtf.WriteString("► ELS Quasi-Permanent :") : rtf.NewLine()
            rtf.WriteString("      → Facteur partiel de résistance γcrQP = 1.1") : rtf.NewLine()
            rtf.WriteString("      → Résistance de calcul de fluage à la compression du terrain Rcgcrd = ") : rtf.Bold = True : rtf.Underline = True : rtf.WriteString(RcgQP.ToString("#0.000")) : rtf.Bold = False : rtf.Underline = False : rtf.WriteString(" MN (= Rccrk/γcrQP).") : rtf.NewLine()
            rtf.NewLine()
            rtf.WriteEndGroup()

        End With
    End Sub

    ''' <summary>Calcul de l'effet de groupe suivant l'annexe J.3 - Comportement du bloc</summary>
    ''' <param name="i_chap">n° de tête de chapitre</param>
    ''' <param name="Def">hauteur de l'encastrement effectif suivant Annexe F ou G - essais pressiométriques ou pénétrométriques, en m</param>
    ''' <param name="ple_qce">Pression limite nette équivalente suivant Annexe F - essais pressiométriques ou Résistance à la pénétration équivalente suivant Annexe G - essais pénétrométriques, en MPa</param>
    ''' <param name="Defi">hauteur de l'encastrement effectif suivant Annexe F ou G - essais pressiométriques ou pénétrométriques, en m, POUR CHAQUE SONDAGE</param>
    ''' <param name="ple_qcei">Pression limite nette équivalente suivant Annexe F - essais pressiométriques ou Résistance à la pénétration équivalente suivant Annexe G - essais pénétrométriques, en MPa, POUR CHAQUE SONDAGE</param>
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    Private Sub Effet_de_Groupe_Bloc(ByRef i_chap As Integer, ByRef rtf As To_Rtf.RtfAnsiTextWriter, Optional ByVal Def As Double = 0, Optional ByVal ple_qce As Double = 0, Optional ByVal Defi() As Double = Nothing,
                                     Optional ByVal ple_qcei() As Double = Nothing)
        Dim binf, De, Demin, DeMax, hD, B, bx, by, pl_basePieu As Double
        Dim ind1, ind2 As Integer
        Dim ʃpl_dz As Double
        Dim Implemente As Boolean = True

        'calcul de la borne inférieure de l'intégrale pour le calcul de l'encastrement effectif Def
        '-------------------------------- 
        hD = Min(10 * Pieux.Bmin, Pieux.D) 'Condition du CEREMA
        binf = Pieux.D - hD
        If binf < 0.1 Then
            '--> De = Def car borne inférieure identique
            Select Case Aff.ModeleCalcul
                Case 1 'Modele terrain + val car
                    De = Def
                Case 2 'modele terrain + sondage 5m
                    De = Def
                Case 3 'Pressio + Pieu modèle
                    Demin = Defi(0) : DeMax = Defi(0)
                    For i = 1 To SondagesPressio.Count - 1
                        Demin = Min(Demin, Defi(i)) : DeMax = Max(DeMax, Defi(i))
                    Next
                Case 4 'Penetro + Modèle de terrain
                    De = Def
                Case 5 'Penetro + Pieu modèle
                    Demin = Defi(0) : DeMax = Defi(0)
                    For i = 2 To SondagePenetro.Count
                        Demin = Min(Demin, Defi(i)) : DeMax = Max(DeMax, Defi(i))
                    Next
            End Select
        Else
            Select Case Aff.ModeleCalcul
                Case 1 'Modele terrain + val car
                    With SondageModele.Lithologie
                        Dim j As Integer
                        ind1 = 0
                        'calcul de l'intégration sur la dernière couche (la plus profonde)
                        For j = .Count To 1 Step -1 'les indices augmentent avec la profondeur
                            If Pieux.D > .Item(j - 1).Ztoit AndAlso Pieux.D < .Item(j - 1).Zbase Then
                                Select Case SondageModele.Plmoyen
                                    Case True 'les Pl renseignées sont des Pression Limites moyennes
                                        ʃpl_dz = PressionLimiteNette(.Item(j - 1).Pl, (.Item(j - 1).Ztoit + Pieux.D) / 2) * (Pieux.D - .Item(j - 1).Ztoit)
                                    Case False 'les Pl renseignées sont des Pression Limites nettes
                                        ʃpl_dz = .Item(j - 1).Pl * (Pieux.D - .Item(j - 1).Ztoit)
                                End Select
                                Exit For
                            End If
                        Next
                        'calcul de l'intégration sur les couches intermédiaires
                        j -= 1
                        If j > 0 Then 'dans le cas ou il n'y aurait qu'une seule couche de terrain
                            Do
                                Select Case SondageModele.Plmoyen
                                    Case True 'les Pl renseignées sont des Pression Limites moyennes
                                        ʃpl_dz += PressionLimiteNette(.Item(j - 1).Pl, (.Item(j - 1).Ztoit + .Item(j - 1).Zbase) / 2) * (.Item(j - 1).Zbase - .Item(j - 1).Ztoit)
                                    Case False 'les Pl renseignées sont des Pression Limites nettes
                                        ʃpl_dz += .Item(j - 1).Pl * (.Item(j - 1).Zbase - .Item(j - 1).Ztoit)
                                End Select
                                j -= 1
                                If j = 0 Then Exit Do
                            Loop While binf >= .Item(j - 1).Ztoit
                        End If
                        'calcul de l'intégration sur la première couche
                        Select Case SondageModele.Plmoyen
                            Case True 'les Pl renseignées sont des Pression Limites moyennes
                                If PressionLimiteNette(.Item(0).Pl, (.Item(0).Zbase)) > 0 Then ʃpl_dz += PressionLimiteNette(.Item(0).Pl, (.Item(0).Zbase) / 2) * .Item(0).Zbase
                            Case False 'les Pl renseignées sont des Pression Limites nettes
                                ʃpl_dz += .Item(0).Pl * .Item(0).Zbase
                        End Select
                    End With
                    De = ʃpl_dz / ple_qce
                Case 2 'modele terrain + sondage 5m
                    With SondageModele.MesurePressio
                        'Détermination de la Pl limite nette au niveau de la base du pieu
                        For j = 1 To .Count
                            If Pieux.D < .Item(j - 1).Z Then
                                ind2 = j - 1 'index de la 1ière valeur de pression limite au delà de Pieux.D
                                If ind2 > 0.1 Then ind1 = ind2 - 1 'index de la 1ière valeur de pression limite au deça de Pieux.D sinon ind1=ind2=0
                                'calcul de la pression limite sur le dernier tronçon
                                pl_basePieu = .Item(ind1).Pl + ((.Item(ind2).Pl - .Item(ind1).Pl) / (.Item(ind2).Z - .Item(ind1).Z)) * (Pieux.D - .Item(ind1).Z)
                                Exit For
                            End If
                        Next
                        ʃpl_dz = 0
                        'calcul de l'intégration sur l'ensemble des tronçons sauf le tronçon final
                        For i = 0 To ind2 - 1
                            ʃpl_dz += (.Item(i + 1).Z - .Item(i).Z) * (.Item(i + 1).Pl + .Item(i).Pl) / 2
                        Next
                        'Ajout de l'intégration sur le tronçon final 
                        ʃpl_dz += (Pieux.D - .Item(ind1).Z) * (pl_basePieu + .Item(ind1).Pl) / 2 'calcul de l'intégration sur le dernier tronçon
                    End With
                    De = ʃpl_dz / ple_qce
                Case 3 'Pressio + Pieu modèle
                    Dim pl_dzk, pl3_4 As Double
                    Dim ind3, ind4, j As Integer
                    For i = 0 To SondagesPressio.Count - 1
                        pl_dzk = 0 : pl3_4 = 0 : ind3 = 0 : ind4 = 0
                        With SondagesPressio.Item(i).MesurePressio
                            pl_dzk = .Item(0).Z * .Item(0).Pl / 2 'calcul de l'intégration sur le 1ier tronçon en considérant qu'à la surface pl(0) = 0 soit un triangle entre la surface et la 1ière mesure
                            For j = 1 To .Count
                                If Pieux.D < .Item(j - 1).Z Then
                                    ind4 = j - 1 'index de la 1ière valeur de pression limite au delà de Zinf2
                                    If ind4 > 0.1 Then ind3 = ind4 - 1 'index de la 1ière valeur de pression limite au deça de Zinf2
                                    'calcul de la pression limite sur le dernier tronçon
                                    pl3_4 = .Item(ind3).Pl + ((.Item(ind4).Pl - .Item(ind3).Pl) / (.Item(ind4).Z - .Item(ind3).Z)) * (Pieux.D - .Item(ind3).Z)
                                    Exit For
                                End If
                            Next
                            'calcul de l'intégration sur les tronçons intermédiaires et final
                            If 0 < ind3 - 1 Then
                                For j = 0 To ind3 - 1
                                    pl_dzk += (.Item(j + 1).Z - .Item(j).Z) * (.Item(j + 1).Pl + .Item(j).Pl) / 2
                                Next
                            End If
                            pl_dzk += (Pieux.D - .Item(ind3).Z) * (pl3_4 + .Item(ind3).Pl) / 2 'calcul de l'intégration sur le dernier tronçon
                        End With
                        Defi(i) = pl_dzk / ple_qcei(i)
                    Next
                    Demin = Defi(0) : DeMax = Defi(0)
                    For i = 1 To SondagesPressio.Count - 1
                        Demin = Min(Demin, Defi(i)) : DeMax = Max(DeMax, Defi(i))
                    Next
                Case 4 'Penetro + Modèle de terrain
                    Dim qc_dzk, qc1_2, qc3_4, qci, qci1 As Double
                    qc_dzk = 0
                    With SondagePenetro.Item(0).MesurePenetro
                        For j = 1 To SondagePenetro.Item(0).MesurePenetro.Count
                            qc1_2 = .Item(j - 1).a * 0 + .Item(j - 1).b
                            If Pieux.D < .Item(j - 1).Zb Then
                                'Zinf1 et Zinf2 dans le même tronçon soit 0 et Pieux.D.En fait, une couche unique avec un seul qc
                                qc3_4 = .Item(j - 1).a * Pieux.D + .Item(j - 1).b
                                qc_dzk = (Pieux.D - 0) * (qc1_2 + qc3_4) / 2
                                Exit For
                            Else
                                'calcul de  qc_dzk sur le 1ier tronçon
                                qci = .Item(j - 1).a * .Item(j - 1).Zb + .Item(j - 1).b
                                qc_dzk = (.Item(j - 1).Zb - 0) * (qc1_2 + qci) / 2 'valeur de qc_dz sur le 1ier tronçon
                                'calcul de  qc_dzk sur les autres tronçons
                                j += 1
                                Do
                                    If Pieux.D < .Item(j - 1).Zb Then
                                        qc3_4 = .Item(j - 1).a * Pieux.D + .Item(j - 1).b
                                        qci = .Item(j - 1).a * .Item(j - 1).Zh + .Item(j - 1).b
                                        qc_dzk += (Pieux.D - .Item(j - 1).Zh) * (qci + qc3_4) / 2
                                        Exit For
                                    Else
                                        'calcul de  qc_dzk sur le tronçon intermédiaire
                                        qci = .Item(j - 1).a * .Item(j - 1).Zh + .Item(j - 1).b
                                        qci1 = .Item(j - 1).a * .Item(j - 1).Zb + .Item(j - 1).b
                                        qc_dzk += (.Item(j - 1).Zb - .Item(j - 1).Zh) * (qci + qci1) / 2
                                        j += 1
                                    End If
                                Loop While j <= SondagePenetro.Item(0).MesurePenetro.Count
                            End If
                        Next
                    End With
                    De = qc_dzk / ple_qce
                Case 5 'Penetro + Pieu modèle
                    Dim qc_dzk, qc1_2, qc3_4, qci, qci1 As Double
                    For i = 0 To SondagePenetro.Count - 1
                        qc_dzk = 0
                        With SondagePenetro.Item(i).MesurePenetro
                            For j = 1 To SondagePenetro.Item(i).MesurePenetro.Count
                                qc1_2 = .Item(j - 1).a * 0 + .Item(j - 1).b
                                If Pieux.D < .Item(j - 1).Zb Then
                                    'Zinf1 et Zinf2 dans le même tronçon soit 0 et Pieux.D.En fait, une couche unique avec un seul qc
                                    qc3_4 = .Item(j - 1).a * Pieux.D + .Item(j - 1).b
                                    qc_dzk = (Pieux.D - 0) * (qc1_2 + qc3_4) / 2
                                    Exit For
                                Else
                                    'calcul de  qc_dzk sur le 1ier tronçon
                                    qci = .Item(j - 1).a * .Item(j - 1).Zb + .Item(j - 1).b
                                    qc_dzk = (.Item(j - 1).Zb - 0) * (qc1_2 + qci) / 2 'valeur de qc_dz sur le 1ier tronçon
                                    'calcul de  qc_dzk sur les autres tronçons
                                    j += 1
                                    Do
                                        If Pieux.D < .Item(j - 1).Zb Then
                                            qc3_4 = .Item(j - 1).a * Pieux.D + .Item(j - 1).b
                                            qci = .Item(j - 1).a * .Item(j - 1).Zh + .Item(j - 1).b
                                            qc_dzk += (Pieux.D - .Item(j - 1).Zh) * (qci + qc3_4) / 2
                                            Exit For
                                        Else
                                            'calcul de  qc_dzk sur le tronçon intermédiaire
                                            qci = .Item(j - 1).a * .Item(j - 1).Zh + .Item(j - 1).b
                                            qci1 = .Item(j - 1).a * .Item(j - 1).Zb + .Item(j - 1).b
                                            qc_dzk += (.Item(j - 1).Zb - .Item(j - 1).Zh) * (qci + qci1) / 2
                                            j += 1
                                        End If
                                    Loop While j <= SondagePenetro.Item(i).MesurePenetro.Count
                                End If
                            Next
                        End With
                        Defi(i) = qc_dzk / ple_qcei(i)
                    Next
                    Demin = Defi(0) : DeMax = Defi(0)
                    For i = 1 To SondagePenetro.Count - 1
                        Demin = Min(Demin, Defi(i)) : DeMax = Max(DeMax, Defi(i))
                    Next
            End Select

        End If

        'Vérification de l'effet de groupe sur le comportement du bloc
        rtf.WriteStartGroup() 'Ecriture dans la note de calcul
        rtf.FontSize = 12 : rtf.FontSize = 10 : rtf.Underline = True : rtf.WriteString(i_chap.ToString("#0") & "  - 2  Effet de groupe lié au comportement du bloc") : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine() : rtf.NewLine()
        Select Case Aff.ModeleCalcul
            Case 1, 2  'Pressiométrique - Modele terrain + val car'modele terrain + sondage 5m
                rtf.WriteString("ple  = " & ple_qce.ToString("#0.00") & " MPa - Pression limite nette équivalente") : rtf.NewLine()
                rtf.WriteString("De  = " & De.ToString("#0.00") & " m - Hauteur d'encastrement équivalente (définition suivant annexe D de la NF P94.262)") : rtf.NewLine()
            Case 4 'Penetro + Modèle de terrain
                rtf.WriteString("qce  = " & ple_qce.ToString("#0.00") & " MPa - Résistance à la pénétration équivalente") : rtf.NewLine()
                rtf.WriteString("De  = " & De.ToString("#0.00") & " m - Hauteur d'encastrement équivalente (définition suivant annexe D de la NF P94.262)") : rtf.NewLine()
            Case 3 'Pressio + Pieu modèle
                rtf.WriteString("ple variable, de " & ple_qcei(0).ToString("#0.00") & " MPa à " & ple_qcei(ple_qcei.Length - 1).ToString("#0.00") & " MPa - Pression limite nette équivalente") : rtf.NewLine()
                rtf.WriteString("De variable, compris entre De min = " & Demin.ToString("#0.00") & " m et De Max = " & DeMax.ToString("#0.00") & " m - Hauteur d'encastrement équivalente (définition suivant annexe D de la NF P94.262)") : rtf.NewLine()
                If Demin / B > 5 Then
                    De = Demin
                ElseIf Demin / B > 1.5 And DeMax / B < 5 Then
                    De = Demin
                ElseIf DeMax / B < 1.5 Then
                    De = DeMax
                Else
                    rtf.WriteString(" Attention, l'effet de groupe du bloc se répartit sur 2 cas, le cas inférieur qui s'affiche ci-dessous ET le cas supérieur avec un rapport De/B sur la borne supérieure (1,5 ou 5).") : rtf.NewLine()
                    De = Demin
                End If
            Case 5  'Penetro + Pieu modèle
                rtf.WriteString("qce variable, de " & ple_qcei(0).ToString("#0.00") & " MPa à " & ple_qcei(ple_qcei.Length - 1).ToString("#0.00") & " MPa - Résistance à la pénétration équivalente") : rtf.NewLine()
                rtf.WriteString("De variable, compris entre De min = " & Demin.ToString("#0.00") & " m et De Max = " & DeMax.ToString("#0.00") & " m - Hauteur d'encastrement équivalente (définition suivant annexe D de la NF P94.262)") : rtf.NewLine()
                If Demin / B > 5 Then
                    De = Demin
                ElseIf Demin / B > 1.5 And DeMax / B < 5 Then
                    De = Demin
                ElseIf DeMax / B < 1.5 Then
                    De = DeMax
                Else
                    rtf.WriteString(" Attention, l'effet de groupe du bloc se répartit sur 2 cas, le cas inférieur qui s'affiche ci-dessous ET le cas supérieur avec un rapport De/B sur la borne supérieure (1,5 ou 5).") : rtf.NewLine()
                    De = Demin
                End If
        End Select

        'Appel à une routine pour déterminer les différentes valeurs de bx, by et B fonction de la géométrie du pieu
        Call Effet_de_Groupe_Geometrie(bx, by, B, Implemente)
        rtf.WriteString("B  = " & B.ToString("#0.00") & " m - Plus petite largeur de la fondation (définition suivant annexe D de la NF P94.262)") : rtf.NewLine() : rtf.NewLine()

        'Classification de la fondation:
        rtf.Underline = True : rtf.WriteString("Classification de la fondation: ") : rtf.Underline = False : rtf.NewLine()
        If De / B > 5 Then
            rtf.WriteString("De/B > 5 (= " & (De / B).ToString("#0.00") & ") - la portance du groupe de fondation Rg peut être évaluée comme une fondation profonde (Cf. annexe D §J.3(2)).") : rtf.NewLine()
            If Implemente = True Then
                rtf.WriteString("Assimilée à une fondation composée d'un bloc monolithique unique de dimension bx = " & bx.ToString("#0.00") & " x by = " & by.ToString("#0.00") & "m sur une profondeur de " & Pieux.D.ToString("#0.00") & " m.") : rtf.NewLine()
            Else
                rtf.WriteString("Calcul non implémenté.") : rtf.NewLine()
            End If
        ElseIf De / B > 1.5 Then
            rtf.WriteString("5 > De/B > 1.5 (= " & (De / B).ToString("#0.00") & ") - la portance du groupe de fondation Rg peut être évaluée comme une fondation semi-profonde (Cf. annexe D §J.3(2)).") : rtf.NewLine()
            If Implemente = True Then
                rtf.WriteString("Fondation semi-profonde de dimension bx = " & bx.ToString("#0.00") & " x by = " & by.ToString("#0.00") & "m sur une profondeur de " & Pieux.D.ToString("#0.00") & " m.") : rtf.NewLine()
                rtf.WriteString("La vérification de ce type de fondation est à réaliser suivant le cadre de la NF P94-261 et n'est pas implémentée dans cette version logicielle.") : rtf.NewLine()
            Else
                rtf.WriteString("Calcul non implémenté.") : rtf.NewLine()
            End If

        Else
            rtf.WriteString("De/B < 1.5 (= " & (De / B).ToString("#0.00") & ") - la portance du groupe de fondation Rg peut être évaluée comme une fondation superficielle (Cf. annexe D §J.3(2)).") : rtf.NewLine()
            If Implemente = True Then
                rtf.WriteString("Fondation superficielle de dimension bx = " & bx.ToString("#0.00") & " x by = " & by.ToString("#0.00") & "m sur une profondeur de " & Pieux.D.ToString("#0.00") & " m.") : rtf.NewLine()
                rtf.WriteString("La vérification de ce type de fondation est à réaliser suivant le cadre de la NF P94-261 et n'est pas implémentée dans cette version logicielle.") : rtf.NewLine()
            Else
                rtf.WriteString("Calcul non implémenté.") : rtf.NewLine()
            End If

        End If
        rtf.NewLine()
        rtf.WriteEndGroup()
    End Sub
    ''' <summary>Calcul de la plus petite largeur B suivant l'annexe D - Comportement du bloc</summary>
    ''' <param name="bx">dimension du bloc dans le sens X</param>
    ''' <param name="by">dimension du bloc dans le sens Y</param>
    ''' <param name="B">plus petite largeur de la fondation assimilée à un bloc en raison de l'effet de groupe</param> 
    ''' <param name="Implemente">= FALSE si le calcul n'a pas été implémenté</param>
    Private Sub Effet_de_Groupe_Geometrie(ByRef bx As Double, ByRef by As Double, ByRef B As Double, ByRef Implemente As Boolean)
        With Pieux
            Select Case .Categorie
                Case 1, 2, 5
                    Select Case .Geom
                        Case 1 'circulaire
                            Call Effet_de_Groupe_Geom_Circulaire(bx, by, B)
                        Case 2 'rectangulaire
                            Call Effet_de_Groupe_Geom_Rectangulaire(bx, by, B)
                        Case 3 'rectangulaire arrondi
                            .Geom = 3
                            Call Effet_de_Groupe_Geom_Rectangulaire(bx, by, B)
                    End Select
                Case 3, 4, 6, 11, 17 To 20 'circulaire uniquement
                    Call Effet_de_Groupe_Geom_Circulaire(bx, by, B)
                Case 7 'Vissé moulé = Fût avec hélice ordinaire ou  épaisse
                    Call Effet_de_Groupe_Geom_Circulaire(bx, by, B)
                Case 8 'Vissé tubé
                    Call Effet_de_Groupe_Geom_Circulaire(bx, by, B)
                Case 9 'Battu béton préfabriqué et Battu béton précontraint
                    Select Case .Geom
                        Case 1 'circulaire
                            Call Effet_de_Groupe_Geom_Circulaire(bx, by, B)
                        Case 2 'rectangulaire
                            Call Effet_de_Groupe_Geom_Rectangulaire(bx, by, B)
                    End Select
                Case 10 'pieux métallique battus enrobés
                    Call Effet_de_Groupe_Geom_Circulaire(bx, by, B)
                Case 12, 13 'pieux battus caisson acier fermé (BAF) ou battus acier ouvert (BAO)
                    Call Effet_de_Groupe_Geom_Circulaire(bx, by, B)
                Case 14, 15 'pieux métallique profilé H, et H injecté
                    B = .Bmin
                    Implemente = False
                Case 16 'palplanche
                    B = .Bmin
                    Implemente = False
            End Select
        End With
    End Sub

    ''' <summary>Calcul de la plus petite largeur B suivant l'annexe D dans le cadre de pieux de géométrie circulaire ou assimilés - Comportement du bloc</summary>
    ''' <param name="bx">dimension du bloc dans le sens X</param>
    ''' <param name="by">dimension du bloc dans le sens Y</param>
    ''' <param name="B">plus petite largeur de la fondation assimilée à un bloc en raison de l'effet de groupe</param> 
    Private Sub Effet_de_Groupe_Geom_Circulaire(ByRef bx As Double, ByRef by As Double, ByRef B As Double)
        With Pieux
            If .ef_Gr_my = 0 Then
                'une seule ligne de pieux
                bx = ((.ef_Gr_nx - 1) * .ef_Gr_dx) + .Bmin
                by = .Bmin
                B = .Bmin
            Else
                'plusieurs lignes de pieux
                bx = ((.ef_Gr_nx - 1) * .ef_Gr_dx) + .Bmin
                by = ((.ef_Gr_ny - 1) * .ef_Gr_dy) + .Bmin
                B = Min(bx, by)
            End If
        End With
    End Sub

    ''' <summary>Calcul de la plus petite largeur B suivant l'annexe D dans le cadre de pieux de géométrie rectangulaire ou assimilés - Comportement du bloc</summary>
    ''' <param name="bx">dimension du bloc dans le sens X</param>
    ''' <param name="by">dimension du bloc dans le sens Y</param>
    ''' <param name="B">plus petite largeur de la fondation assimilée à un bloc en raison de l'effet de groupe</param> 
    Private Sub Effet_de_Groupe_Geom_Rectangulaire(ByRef bx As Double, ByRef by As Double, ByRef B As Double)
        With Pieux
            If .ef_Gr_my = 0 Then
                'une seule ligne de pieux
                bx = ((.ef_Gr_nx - 1) * .ef_Gr_dx) + .W
                by = .L
                B = Min(bx, by)
            Else
                'plusieurs lignes de pieux
                bx = ((.ef_Gr_nx - 1) * .ef_Gr_dx) + .W
                by = ((.ef_Gr_ny - 1) * .ef_Gr_dy) + .L
                B = Min(bx, by)
            End If
        End With
    End Sub
#End Region

    ''' <summary>Evaluation tassement suivant §L.2 essais pressiométriques</summary>
    ''' <param name="i_chap">n° de tête de chapitre</param>
    ''' <param name="rtf">flux d'écriture pour la note de calcul</param>
    Private Sub Evaluation_tassement(ByRef i_chap As Integer, ByRef rtf As To_Rtf.RtfAnsiTextWriter)
        Dim Scri, Scrv As Double
        Scri = 2 * Pieux.Bmin / 100
        Scrv = Scri
        rtf.WriteStartGroup() : rtf.NewParagraph()
        rtf.FontSize = 12 : rtf.Bold = True : i_chap += 1
        rtf.Underline = True : rtf.WriteString(i_chap.ToString("#") & " - Evaluation des tassements") : rtf.Bold = False : rtf.Underline = False : rtf.FontSize = 9 : rtf.NewLine() : rtf.NewLine()
        rtf.WriteString("L'évaluation des tassements des pieux est réalisée conformément aux dispositions du §L.2(3) de la NF P94-262, avec :") : rtf.NewLine()
        rtf.WriteString("  - Scri = " & (Scri * 1000).ToString("#0.0") & " mm, Scri représentant le tassement du pieu sous la charge de fluage Rcr, supposée de courte durée d'utilisation.") : rtf.NewLine()
        rtf.WriteString("  - Scrv = " & (Scrv * 1000).ToString("#0.0") & " mm, Scrv représentant le tassement du pieu sous la charge de fluage Rcr, supposée de longue durée d'utilisation.") : rtf.NewLine()
        If Pieux.EffetGroupe = True Then rtf.NewLine() : rtf.WriteString("Effet de groupe: l'évaluation du tassement du groupe de fondation n'est pas implémentée dans cette version logicielle.") : rtf.NewLine()
        rtf.WriteEndGroup()
    End Sub

    Private Sub Poubelle()
        'pl1_2 = Sondage.Pl.ElementAt(ind1).Value + ((Sondage.Pl.ElementAt(ind2).Value - Sondage.Pl.ElementAt(ind1).Value) / (Sondage.Pl.ElementAt(ind2).Key - Sondage.Pl.ElementAt(ind1).Key)) * (zinf1 - Sondage.Pl.ElementAt(ind1).Key)
        'pl3_4 = Sondage.Pl.ElementAt(ind3).Value + ((Sondage.Pl.ElementAt(ind4).Value - Sondage.Pl.ElementAt(ind3).Value) / (Sondage.Pl.ElementAt(ind4).Key - Sondage.Pl.ElementAt(ind3).Key)) * (zinf2 - Sondage.Pl.ElementAt(ind3).Key)
        'pl_dz = (Sondage.Pl.ElementAt(ind2).Key - zinf1) * (pl1_2 + Sondage.Pl.ElementAt(ind2).Value) / 2
        'For i = ind2 To ind3 - 1
        '    pl_dz += (Sondage.Pl.ElementAt(i + 1).Key - Sondage.Pl.ElementAt(i).Key) * (Sondage.Pl.ElementAt(i + 1).Value + Sondage.Pl.ElementAt(i).Value) / 2
        'Next
        'pl_dz += (zinf2 - Sondage.Pl.ElementAt(ind3).Key) * (pl3_4 + Sondage.Pl.ElementAt(ind3).Value) / 2 'calcul de l'intégration sur le dernier tronçon
        ''--> test sur l'homogénéité de la couche porteuse
        'msg = "La couche porteuse est considérée comme homogène si la pression limite maximale mesurée dans cette couche n'excède pas deux fois la pression limite minimale (Note 1 - §F4.2.(3) de la NF P94-262 - 2013)."
        'Aff.msg_Avertiss.Add(msg)
        'ple = pl_dz / (b + 3 * a)
        ''
        ''calcul de l'encastrement effectif
        ''-------------------------------- 
        'hD = Min(10 * Pieux.Bmin, Pieux.D)
        'zinf1 = Pieux.D - hD
        'ind1 = 0 : ind2 = 0 : ind3 = 0 : ind4 = 0 : pl_dz = 0
        'If zinf1 > 0.1 Then
        '    For Each kvp As KeyValuePair(Of Double, Double) In Sondage.Pl
        '        If zinf1 < kvp.Key Then
        '            ind2 = Sondage.Pl.IndexOfKey(kvp.Key) 'index de la 1ière valeur de pression limite au delà de Zinf1
        '            If ind2 > 0.1 Then
        '                ind1 = ind2 - 1 'index de la 1ière valeur de pression limite au deça de Zinf2
        '                pl1_2 = Sondage.Pl.ElementAt(ind1).Value + ((Sondage.Pl.ElementAt(ind2).Value - Sondage.Pl.ElementAt(ind1).Value) / (Sondage.Pl.ElementAt(ind2).Key - Sondage.Pl.ElementAt(ind1).Key)) * (zinf1 - Sondage.Pl.ElementAt(ind1).Key)
        '            Else
        '                pl1_2 = Sondage.Pl.ElementAt(ind2).Value * zinf1 / Sondage.Pl.ElementAt(ind2).Key
        '            End If
        '            Exit For
        '        End If
        '    Next kvp
        '    pl_dz = (Sondage.Pl.ElementAt(ind2).Key - zinf1) * (pl1_2 + Sondage.Pl.ElementAt(ind2).Value) / 2 'calcul de l'intégration sur le 1ier tronçon
        'Else
        '    pl_dz = Sondage.Pl.ElementAt(ind2).Key * Sondage.Pl.ElementAt(ind2).Value / 2 'calcul de l'intégration sur le 1ier tronçon
        'End If
        'zinf2 = Pieux.D
        'For Each kvp As KeyValuePair(Of Double, Double) In Sondage.Pl
        '    If zinf2 < kvp.Key Then
        '        ind4 = Sondage.Pl.IndexOfKey(kvp.Key) 'index de la 1ière valeur de pression limite au delà de Zinf2
        '        If ind4 > 0.1 Then ind3 = ind4 - 1 'index de la 1ière valeur de pression limite au deça de Zinf2
        '        'calcul de la pression limite sur le dernier tronçon
        '        pl3_4 = Sondage.Pl.ElementAt(ind3).Value + ((Sondage.Pl.ElementAt(ind4).Value - Sondage.Pl.ElementAt(ind3).Value) / (Sondage.Pl.ElementAt(ind4).Key - Sondage.Pl.ElementAt(ind3).Key)) * (zinf2 - Sondage.Pl.ElementAt(ind3).Key)
        '        Exit For
        '    End If
        'Next kvp
        ''calcul de l'intégration sur les tronçons intermédiaires et final
        'If ind2 < ind3 - 1 Then
        '    For i = ind2 To ind3 - 1
        '        pl_dz += (Sondage.Pl.ElementAt(i + 1).Key - Sondage.Pl.ElementAt(i).Key) * (Sondage.Pl.ElementAt(i + 1).Value + Sondage.Pl.ElementAt(i).Value) / 2
        '    Next
        'End If
        'pl_dz += (zinf2 - Sondage.Pl.ElementAt(ind3).Key) * (pl3_4 + Sondage.Pl.ElementAt(ind3).Value) / 2 'calcul de l'intégration sur le dernier tronçon
        'Def = pl_dz / ple
        'rtf.WriteString("Hauteur d'encastrement effective Def (définition suivant annexe F §F.4.2(4) de la NF P94.262) = " & Def.ToString("#0.00") & " m.") : rtf.NewLine()
        'If zinf1 < 0.1 Then
        '    'De = Def suivant annexe D de la NF P94.262
        '    rtf.WriteString("Hauteur d'encastrement équivalente De (définition suivant annexe D de la NF P94.262) = Def suivant annexe D de la NF P94.262 ") : rtf.NewLine()
        '    If Def / Pieux.Bmin > 5 Then
        '        rtf.WriteString("De/B > 5 (= " & (Def / Pieux.Bmin).ToString("#0.00") & ") - la fondation est dite profonde suivant la définition de l'annexe D") : rtf.NewLine()
        '    ElseIf Def / Pieux.Bmin > 1.5 Then
        '        rtf.WriteString("De/B > 1.5 (= " & (Def / Pieux.Bmin).ToString("#0.00") & ") - la fondation est dite semi-profonde suivant la définition de l'annexe D") : rtf.NewLine()
        '    Else
        '        rtf.WriteString("De/B < 1.5 (= " & (Def / Pieux.Bmin).ToString("#0.00") & ") - la fondation est dite superficielle suivant la définition de l'annexe D") : rtf.NewLine()
        '    End If
        'End If
        ''détermination de kpMax
        ''détermination de l'index de la couche de sol correspondante
        'For Each kvp As KeyValuePair(Of Double, Integer) In Sondage.Categorie
        '    If zinf2 < kvp.Key Then
        '        ind1 = Sondage.Categorie.IndexOfKey(kvp.Key) 'index de la 1ière valeur de Zinf en dessous de Zinf2
        '        Exit For
        '    End If
        'Next kvp
        ''détermination de kpmax
        'Call KpMax_Determination(Sondage.Categorie.ElementAt(ind1).Value, kpMax)
        ''détermination de kp
        'rtf.WriteString("Valeur du rapport Def/B = " & (Def / Pieux.Bmin).ToString("#0.00") & " ")
        'If Def / Pieux.Bmin >= 5 Then
        '    Kp = kpMax
        '    rtf.WriteString(" ≥ 5 - Kp = kpMax soit " & kpMax.ToString("#0.00") & " ") : rtf.NewLine()
        'Else
        '    Kp = 1 + (kpMax - 1) * (Def / Pieux.Bmin) / 5
        '    rtf.WriteString(" < 5 - Kp = " & Kp.ToString("#0.00") & " suivant équation du §F.4.2(4) de la NF P94.262. ") : rtf.NewLine()
        'End If
        ''Calcul de la résistance de pointe de la fondation profonde
        'qb = Kp * ple
        'Rb = Pieux.Ab * qb
        ''
        ''calcul de la résistance de frottement axial Rs
        ''-----------------------------------------------
        'Dim c, qs(Sondage.Pl.Count), qs_D, ʃqs, αpieu_sol As Double
        ''calcul de qs(z) pour toutes les valeurs mesurées de pl*
        'ind1 = 0
        'For i = 0 To Sondage.Categorie.Count - 1
        '    For j = ind1 To Sondage.Pl.Count - 1

        '        Select Case i
        '            Case Sondage.Categorie.Count - 1  'dernière couche
        '                Call αpieu_sol_Pressiometrique(Sondage.Categorie.ElementAt(i).Value, αpieu_sol)
        '                If αpieu_sol = 1000 Then
        '                    If Pieux.Categorie = 17 Or Pieux.Categorie = 18 Then
        '                        rtf.WriteString("Pour les pieux et micropieux de cat_égorie 17 et 18, il convient de considerer les valeurs de frottement axial unitaire des techniques de pieux ou micropieux les plus proches sur le plan " &
        '                            "de la technologie (note (c) du tableau F.5.2.1 de la NF P94.262).") : rtf.NewLine()
        '                    End If
        '                End If
        '                Call Coef_a_b_c_fsol(Sondage.Categorie.ElementAt(i).Value, a, b, c)
        '                qs(j) = αpieu_sol * (a * Sondage.Pl.ElementAt(j).Value + b) * (1 - E ^ (-c * Sondage.Pl.ElementAt(j).Value))
        '                Call Val_maximale_FrottementAxialUnitaire(Sondage.Categorie.ElementAt(i).Value, qs(j), rtf)
        '            Case Else   '1ière couche et couches intermédiaires
        '                If Sondage.Pl.ElementAt(j).Key <= Sondage.Categorie.ElementAt(i).Key Then 'z de la mesure de pl* < z de la catégorisation de la couche de sol
        '                    Call αpieu_sol_Pressiometrique(Sondage.Categorie.ElementAt(i).Value, αpieu_sol)
        '                    If αpieu_sol = 1000 Then
        '                        If Pieux.Categorie = 17 Or Pieux.Categorie = 18 Then
        '                            rtf.WriteString("Pour les pieux et micropieux de cat_égorie 17 et 18, il convient de considerer les valeurs de frottement axial unitaire des techniques de pieux ou micropieux les plus proches sur le plan " &
        '                                "de la technologie (note (c) du tableau F.5.2.1 de la NF P94.262).") : rtf.NewLine()
        '                        End If
        '                    End If
        '                    Call Coef_a_b_c_fsol(Sondage.Categorie.ElementAt(i).Value, a, b, c)
        '                    qs(j) = αpieu_sol * (a * Sondage.Pl.ElementAt(j).Value + b) * (1 - E ^ (-c * Sondage.Pl.ElementAt(j).Value))
        '                    Call Val_maximale_FrottementAxialUnitaire(Sondage.Categorie.ElementAt(i).Value, qs(j), rtf)
        '                Else
        '                    ind1 = j
        '                    Exit For  'passage à la catégorie suivante en conservant le même indice
        '                End If
        '        End Select
        '    Next
        'Next
        ''calcul de l'intégration de qs(z) sur la longueur de fondation D
        'For Each kvp As KeyValuePair(Of Double, Double) In Sondage.Pl
        '    If Pieux.D < kvp.Key Then
        '        ind2 = Sondage.Pl.IndexOfKey(kvp.Key) 'index de la 1ière valeur de pression limite au delà de D
        '        If ind2 > 0.1 Then ind1 = ind2 - 1 'index de la 1ière valeur de pression limite au deça de Zinf2
        '        'calcul de la pression limite sur le dernier tronçon
        '        qs_D = qs(ind1) + ((qs(ind2) - qs(ind1)) / (Sondage.Pl.ElementAt(ind2).Key - Sondage.Pl.ElementAt(ind1).Key)) * (Pieux.D - Sondage.Pl.ElementAt(ind1).Key)
        '        Exit For
        '    End If
        'Next kvp
        'ʃqs = Sondage.Pl.ElementAt(0).Key * qs(0) / 2
        'For i = 0 To ind1 - 1
        '    ʃqs += (Sondage.Pl.ElementAt(i + 1).Key - Sondage.Pl.ElementAt(i).Key) * (qs(i + 1) + qs(i)) / 2
        'Next
        'ʃqs += (Pieux.D - Sondage.Pl.ElementAt(ind3).Key) * (qs_D + qs(ind1)) / 2 'calcul de l'intégration sur le dernier tronçon
        'Rs = Pieux.Ps * ʃqs
    End Sub
End Module
